package com.gtis.archive.web.admin;

import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.service.impl.OriginalServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2014/8/18.
 */
public class TbywAction extends BaseModelAction<Object> {

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private OriginalService originalService;

    public String getTab(){
        return "og" ;
    }

    @Override
    public String execute() throws Exception {
        return "syn_og";
    }


    public String syncOg(){
        Map<String,Object> map = new HashMap<String,Object>() ;
        int size = archiveService.findAllArchiveSize() ;
        try {
            originalService.batchSyncOriginal(size);
        }catch (Exception e){
            e.printStackTrace();
        }
        map.put("size",size) ;
        return renderJson(map) ;
    }

    public String syncOgPercent(){
        Map<String,Object> map = new HashMap<String,Object>() ;
        java.text.DecimalFormat df =new java.text.DecimalFormat("#.0000");
        df.setRoundingMode(RoundingMode.HALF_UP);
        String f1 = df.format(originalService.batchSyncOriginalPercent());
        map.put("percent",Float.parseFloat(f1)) ;
        return renderJson(map) ;
    }
}
