package com.gtis.archive.web.admin;

import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.CheckLog;
import com.gtis.archive.service.*;
import com.gtis.plat.service.SysUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 2014/8/6.
 */
public class CheckAction extends BaseModelAction<Object> {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private AjhRangeService ajhRangeService;

    @Autowired
    private OriginalService originalService;

    @Autowired
    private ArchiveService archiveService;

    @Autowired
    private RecordAjhRangeService recordAjhRangeService;

    @Autowired
    private CheckLogService checkLogService ;

    private List<CheckLog> list = new ArrayList<CheckLog>() ;

    private CheckLog checkLog ;

    private Date startTime ;

    private Date endTime ;

    public List<CheckLog> getList() {
        return list;
    }

    public void setList(List<CheckLog> list) {
        this.list = list;
    }

    public CheckLog getCheckLog() {
        return checkLog;
    }

    public void setCheckLog(CheckLog checkLog) {
        this.checkLog = checkLog;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Override
    public String execute() throws Exception {
        return super.execute();
    }

    public String showCheckLog(){
        list = checkLogService.findAllCheckLog() ;
        return "log" ;
    }

    public String getTab(){
        return "log" ;
    }

    public String searchCheckLog(){
        try {
            list = checkLogService.findCheckLog(checkLog,startTime,endTime) ;
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return "log" ;
    }

}
