package com.gtis.archive.web;

import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.Metadata;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Restrictions;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:wanglei@gtis.com.cn">wanglei</a>
 * @version V1.0, 2010-11-9
 */
public class MetadataEntityAction extends BaseEntityAction<Metadata> {
    private String archiveId;

    private String state;

    public String getState() {
        if(StringUtils.isBlank(state))
            return "";
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getArchiveId() {
        return archiveId;
    }

    public void prepare() {
        entity = entityService.query(Metadata.class, Restrictions.eq("archiveId", archiveId));
        if (entity == null) {
            entity = new Metadata();
        }
    }
}
