package com.gtis.archive.web;

import com.gtis.archive.Constants;
import com.gtis.archive.Switch;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Loan;
import com.gtis.archive.entity.LoanCart;
import com.gtis.archive.service.LoanService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.*;

import java.lang.reflect.InvocationTargetException;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:wanggang@gtis.com.cn">WangGang</a>
 * @version V1.0, 2010-11-9
 */
public class LoanEntityAction extends BaseEntityAction<Loan> {

    @Autowired
    private SysUserService userService;

    @Autowired
    private LoanService loanService;

    @Autowired
    private EntityService entityService;

    private String archiveId;

    private String type;

    private String state;

    public String getState() {
        if(StringUtils.isBlank(state))
            return "";
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }


    public String save() throws Exception {
        return renderJs(new Runner() {
            public void run() {
                String[] archiveIds = StringUtils.split(entity.getArchiveId(), ",");
                String[] loanIds=new String[archiveIds.length];
                UserInfo userInfo = SessionUtil.getCurrentUser();
                String entityName="";
                try {
                    entityName=PropertyUtils.getProperty(entity,"type").toString();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                for (int i=0;i<archiveIds.length;i++) {
                    try {
                        Loan loan = entity.clone();
                        loan.setArchiveId(StringUtils.trim(archiveIds[i]));
                        if(EnvHolder.isEnable(Switch.DWDM)) loan.setDwdm(getDwdm());
                        loan.setPch(loan.getJyr()+loan.getJyrq());
                        loan.setUserId(userInfo.getId());
                        loan.setJc(String.valueOf(archiveIds.length));
                        if(StringUtils.isNotBlank(entityName)){
                            if(entityName.indexOf("_jn")!=-1){
                                Document document= entityService.load(entityName,loan.getArchiveId());
                                loan.setSxh(document.getSxh());
                                if(document.getArchive()!=null||document.getArchiveId()!=null){
                                    Archive archive= document.getArchive()==null?
                                            (Archive) entityService.load(Archive.class, document.getArchiveId()):
                                            document.getArchive();
                                    if(archive!=null){
                                        loan.setDh(archive.getDh());
                                        loan.setAjh(String.valueOf(archive.getAjh()));
                                        loan.setMlh(archive.getMlh());
                                    }
                                }
                                loan.setTm(document.getTm());
                            }else{

                                if(!entityName.equals("ythsw")&&!entityName.equals("ythfw")&&!entityName.equals("ythnw")){
                                    Archive arvhice=entityService.load(entityName,loan.getArchiveId());
                                    if(arvhice!=null){
                                        loan.setDh(arvhice.getDh());
                                        loan.setTm(arvhice.getTm());
                                        loan.setAjh(String.valueOf(arvhice.getAjh()));
                                        loan.setMlh(arvhice.getMlh());
                                    }
                                }
                            }
                            loan.setType(entityName);
                        }else{
                            if(StringUtils.isNotBlank(entity.getLoanCartId())){
                                String[] loanCartIds=StringUtils.split(entity.getLoanCartId(), ",");
                                String loanCartId= loanCartIds[i].trim();
                                LoanCart loanCart=entityService.load(LoanCart.class,loanCartId);
                                loan.setDh(loanCart.getDh());
                                loan.setTm(loanCart.getTm());
                                loan.setType(loanCart.getArchiveType());
                                loan.setMlh(loanCart.getMlh());
                                loan.setAjh(loanCart.getAjh());
                                loan.setSxh(loanCart.getSxh());
                            }
                        }
                        entityService.save(loan);
                        loanIds[i]=loan.getId();
                    } catch (CloneNotSupportedException ignored) {
                    }
                }
                if(entity.isBackNow())
                    returnLoan(loanIds);
                if(EnvHolder.isEnable(Switch.JIANGYIN)){
                    String[] loanCartIds=StringUtils.split(entity.getLoanCartId(), ",");
                    for(String id:loanCartIds){
                        loanService.removeFromCart(entityService.load(LoanCart.class,id.trim()));
                    }
                }
            }
        }, "保存成功", null, getJsCallBack());
    }

    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

    @Override
    public void prepare() {
        entity = StringUtils.isBlank(id) ? entityService.<Loan>newInstance(modelName) : entityService.<Loan>load(modelName, id);
        if(StringUtils.isNotBlank(archiveId)){
            try {
                PropertyUtils.setProperty(entity,"jc",String.valueOf(archiveId.split(",").length));
                PropertyUtils.setProperty(entity,"type",type);
                if(EnvHolder.isEnable(Switch.JIANGYIN)){
                    PropertyUtils.setProperty(entity,"gly",SessionUtil.getCurrentUser().getUsername());
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    //归还
    public String returnLoan(String[] ids) {
        for (String id : ids) {
            if (StringUtils.isBlank(id))
                continue;
            Loan loan = entityService.load(Loan.class, id);
            loan.setState(1);
            entityService.save(loan);
        }
        return null;
    }

    public String getArchiveId() {
        return archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
