package com.gtis.archive.web;

import com.gtis.archive.Switch;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Loan;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.CriteriaCallback;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:wanggang@gtis.com.cn">WangGang</a>
 * @version V1.0, 2010-11-9
 */
public class LoanAction extends BaseModelAction<Loan> {
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SysUserService userService;

    private String type;

    public void setType(String type) {
        this.type = type;
    }

    //归还档案
    public String returnLoan() {
        for (String id : ids) {
            if (StringUtils.isBlank(id))
                continue;
            Loan loan = entityService.load(Loan.class, id);
            loan.setState(1);
            entityService.save(loan);
        }
        return null;
    }

    @Override
    protected Page<Loan> searchEntity(final List<Criterion> criterions, final List<Order> orders) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if ("return".equals(type)) {
            criterions.add(Restrictions.eq("state", 1));
        } else if ("exceed".equals(type)) {
            criterions.add(Restrictions.sqlRestriction("jyrq+jyqx<?", new Date(), StandardBasicTypes.DATE));
            criterions.add(Restrictions.eq("state", 0));
        } else {
            criterions.add(Restrictions.eq("state", 0));
        }
        if (query != null) {
            criterions.add(Restrictions.or(Restrictions.like("arc.tm", "%" + query + "%"), Restrictions.like("arc.dh", "%" + query + "%")));
        }
        if(EnvHolder.isEnable(Switch.DWDM) && !SessionUtil.getCurrentUser().isAdmin())
        {
            criterions.add(Restrictions.or(Restrictions.isNull("dwdm"),Restrictions.eq("dwdm",getDwdm())));
        }
        criterions.add(Restrictions.or(Restrictions.isNull("userId"),Restrictions.eq("userId",userInfo.getId())));
        return entityService.search(Loan.class,criterions,orders,start,limit);
//        return entityService.search(new CriteriaCallback() {
//            public Criteria create(Session session) {
//                return session.createCriteria(Loan.class).createAlias("archive", "arc");
//            }
//        }, criterions, orders, start, limit);
    }

    @Override
    protected String[] getQueryFields() {
        return null;
    }

    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

    @Override
    public String execute() throws Exception {
        if (!securityService.isPermitted("sys", "loan")) {
            throw new NoPermissionException("没有权限访问借阅管理");
        }
        return super.execute();
    }

}
