package com.gtis.archive.service.impl;

import com.gtis.archive.core.EntityService;
import com.gtis.archive.entity.CheckLog;
import com.gtis.archive.service.CheckLogService;
import com.gtis.support.hibernate.HibernateTemplate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.OrderBy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;

/**
 * Created by Administrator on 2014/8/1.
 */
@Service
public class CheckLogServiceImpl  extends HibernateTemplate<CheckLog, String> implements CheckLogService {

    @Autowired
    private EntityService entityService;

    /**
     * 保存互查日志信息
     * @param checkLog
     * @return
     */
    @Transactional
    public CheckLog saveCheckLog(CheckLog checkLog) {
        save(checkLog) ;
        return null ;
    }

    @Transactional
    @OrderBy(value = "createAt ASC")
    public List<CheckLog> findAllCheckLog() {
        String hql = "from CheckLog checkLog ORDER BY checkLog.createAt DESC" ;
        Object[] objects = {} ;
        return find(hql, objects);
    }

   /* @Transactional
    public List<CheckLog> findCheckLog(CheckLog checkLog, Date startTime, Date endTime) {
        String hql = null ;
        Object[] objects = null ;

        if(startTime!=null && endTime!=null){
            hql = "from CheckLog checkLog  where checkLog.createAt between ? and ? " +
                    "OR(checkLog.userName=? AND checkLog.qlr like ? AND checkLog.tm like ? AND checkLog.qzh like ? AND checkLog.mlh like ? AND checkLog.ajh like ?)" +
                    "ORDER BY checkLog.createAt DESC" ;
            objects = new Object[]{startTime, endTime, checkLog.getUserName(), checkLog.getQlr(), checkLog.getTm(), checkLog.getQzh(), checkLog.getMlh(), checkLog.getAjh() } ;

        }else if(startTime!=null && endTime==null){
            hql = "from CheckLog checkLog  where checkLog.createAt >= ?" +
                    "OR(checkLog.userName=? AND checkLog.qlr like ? AND checkLog.tm like ? AND checkLog.qzh like ? AND checkLog.mlh like ? AND checkLog.ajh like ?)" +
                    "ORDER BY checkLog.createAt DESC" ;
            objects = new Object[]{startTime, checkLog.getUserName(), checkLog.getQlr(), checkLog.getTm(), checkLog.getQzh(), checkLog.getMlh(), checkLog.getAjh() } ;

        }else if(startTime==null && endTime!=null){
            hql = "from CheckLog checkLog  where checkLog.createAt <= ? " +
                    "OR(checkLog.userName=? AND checkLog.qlr like ? OR checkLog.tm like ? AND checkLog.qzh like ? AND checkLog.mlh like ? AND checkLog.ajh like ?)" +
                    "ORDER BY checkLog.createAt DESC" ;
            objects = new Object[]{endTime, checkLog.getUserName(), checkLog.getQlr(), checkLog.getTm(), checkLog.getQzh(), checkLog.getMlh(), checkLog.getAjh() } ;

        }else if(startTime==null && endTime==null) {
            if ("".equals(checkLog.getUserName()) && "".equals(checkLog.getQlr()) && "".equals(checkLog.getTm()) &&
                    "".equals(checkLog.getQzh()) && "".equals(checkLog.getMlh()) && "".equals(checkLog.getAjh())) {
                hql = "from CheckLog checkLog ORDER BY checkLog.createAt DESC";
                objects = new Object[]{};
            } else {
                hql = "from CheckLog checkLog  where checkLog.userName like % ? % AND checkLog.qlr like % ? % AND checkLog.tm like % ? % AND checkLog.qzh like % ? % AND checkLog.mlh like % ? % AND checkLog.ajh like % ? %" +
                        "ORDER BY checkLog.createAt DESC";
                objects = new Object[]{checkLog.getUserName(), checkLog.getQlr(), checkLog.getTm(), checkLog.getQzh(), checkLog.getMlh(), checkLog.getAjh()};
            }
        }
        return find(hql, objects);
    }*/

    /**
     *  以下方法实现了多条件查询时动态sql的生成
     * @param checkLog
     * @param startTime
     * @param endTime
     * @return
     * @throws ClassNotFoundException
     * @throws NoSuchMethodException
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    @Transactional
    public List<CheckLog> findCheckLog(CheckLog checkLog, Date startTime, Date endTime) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class check = Class.forName("com.gtis.archive.entity.CheckLog") ;
        Field[] fields = CheckLog.class.getDeclaredFields() ;

        String hql = "from CheckLog checkLog  where 1=1" ;
        Map<String, Object> map = new HashMap<String, Object>() ;

        Method method = null ;
        String fieldName = null ;

        // 采用反射取到的所有属性进行分析是否有值（既有条件的）进行sql的生成
        for(Field field : fields){
            fieldName = field.getName() ;
            //这几个属性是不作为条件的
            if("isGeneric".equalsIgnoreCase(fieldName) || "modelName".equalsIgnoreCase(fieldName) || "createAt".equalsIgnoreCase(fieldName) || "archiveId".equals(fieldName) || "id".equals(fieldName)){
               continue;
            }
            method = check.getMethod("get"+change(fieldName),null) ;
            String value = (String)method.invoke(checkLog,null) ;
            if(!("".equalsIgnoreCase(value))){
                hql+= " AND checkLog."+fieldName+" like :"+fieldName ;
                map.put(fieldName, value) ;
            }
        }

        //对时间范围的几种判断生成几种情况的sql
        if(startTime!=null && endTime!=null){
            hql += " AND (checkLog.createAt between :startTime and :endTime) ORDER BY checkLog.createAt DESC" ;

        }else if(startTime!=null && endTime==null){
            hql += " AND checkLog.createAt >= :startTime ORDER BY checkLog.createAt DESC" ;

        }else if(startTime==null && endTime!=null){
            hql += " AND checkLog.createAt <= :endTime ORDER BY checkLog.createAt DESC" ;

        }else{
            hql += " ORDER BY checkLog.createAt DESC" ;
        }

        Session session = getSessionFactory().getCurrentSession() ;
        session.beginTransaction() ;
        Query query = session.createQuery(hql) ;
        Set<String> set = map.keySet() ;

        Iterator<String> iterator = set.iterator() ;
        while(iterator.hasNext()){
            String key = iterator.next() ;
            query.setParameter(key ,"%"+map.get(key)+"%") ;
        }

        if(startTime!=null && endTime!=null){
            query.setParameter("startTime", startTime) ;
            query.setParameter("endTime", endTime) ;
        }else if(startTime!=null && endTime==null){
            query.setParameter("startTime", startTime) ;
        }else if(startTime==null && endTime!=null){
            query.setParameter("endTime", endTime) ;
        }

        List<CheckLog> lists = query.list() ;

        session.getTransaction().commit();

        return lists;
    }

    /**
     * @param src
     *            源字符串
     * @return 字符串，将src的第一个字母转换为大写，src为空时返回null
     */
    public static String change(String src) {
        if (src != null) {
            StringBuffer sb = new StringBuffer(src);
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            return sb.toString();
        } else {
            return null;
        }
    }

}
