package com.gtis.archive.service;

import com.gtis.archive.entity.DownloadLog;
import com.gtis.archive.entity.Original;
import com.gtis.archive.entity.OriginalPermission;
import com.gtis.common.Page;

import java.util.List;

/**
 * 原文权限管理接口.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-5-12
 */
public interface OriginalPermissionService {
    /**
     * 是否启用了原文权限
     *
     * @return 是否启用原文权限
     */
    public boolean isOriginalPermissionEnable();

    /**
     * 检查是否有权限访问原文
     *
     * @param originalId 原文id
     * @return 是否有权限
     */
    boolean hasOriginalPermission(String originalId);

    /**
     * 保存原文权限
     *
     * @param originalPermission 原文权限
     * @return 原文权限
     */
    OriginalPermission saveOriginalPermission(OriginalPermission originalPermission);

    /**
     * 删除原文权限
     *
     * @param id 原文权限id
     */
    void removeOriginalPermission(String id);

    /**
     * 获取原文权限列表
     *
     * @param originalId 原文权限id
     * @return 原文权限列表
     */
    List<OriginalPermission> getOriginalPermissions(String originalId);

    /**
     * 检索原文权限
     *
     * @param name  关键字
     * @param start 分页页码
     * @param limit 分页大小
     * @return 原文权限列表
     */
    Page<OriginalPermission> searchOriginalPermission(String name, int start, int limit);

    /**
     * 检索原文权限
     *
     * @param ownerId 所有者
     * @param name    关键字
     * @param start   分页页码
     * @param limit   分页大小
     * @return 原文权限列表
     */
    Page<Original> searchOriginal(String ownerId, String name, int start, int limit);
}
