package com.gtis.archive.core.cache;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-11-5
 */
@SuppressWarnings("unchecked")
public class EhCacheWapper implements Cache {
    public static final String SEPARATOR = "^";

    private Ehcache cache;

    private static String toKey(Serializable... keys) {
        return StringUtils.join(keys, SEPARATOR);
    }

    public EhCacheWapper(Ehcache cache) {
        this.cache = cache;
    }

    public <T> T get(Serializable... keys) {
        Element element = cache.get(keys.length > 1 ? toKey(keys) : keys[0]);
        if (element != null) {
            return (T) element.getObjectValue();
        }
        return null;
    }

    public <T> T getKey(Serializable key) {
        Element element = cache.get(key);
        return (T)element.getKey();
    }

    public <T> List<T> getKeys() {
        return cache.getKeys();
    }

    public void remove(String... keys) {
        cache.remove(toKey(keys));
    }

    public void put(Object obj) {
        try {
            put(BeanUtils.getSimpleProperty(obj, "id"), obj);
        } catch (Exception e) {
            throw new RuntimeException("error to cache obj[" + obj + "],error:[" + e + "]");
        }
    }

    public void put(Object key, Object obj) {
        cache.put(new Element(key, obj));
    }

    public void put(Object obj, String... keys) {
        cache.put(new Element((toKey(keys)), obj));
    }

    public void removeAll() {
        cache.removeAll();
    }
}
