package com.gtis.archive.web;

import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Original;
import com.gtis.archive.service.PrintService;
import com.gtis.web.SessionUtil;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.Map;

/**
 * 打印服务请求
 * Created by zhayuwen on 2015/12/12.
 */
public class PrintAction extends BaseModelAction<Original> {

    @Autowired
    private PrintService printService;

    /**
     * 获取打印类型
     */
    private Integer type ;

    /**
     * 打印参数 id
     */
    private String id;

    /**
     * 打印参数 hh
     */
    private String hh;

    /**
     * 模板存在字典的主键id
     */
    private String tplId;

    /**
     * 打印配置表的主键id
     */
    private String pId;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHh() {
        return hh;
    }

    public void setHh(String hh) {
        this.hh = hh;
    }

    public String getTplId() {
        return tplId;
    }

    public void setTplId(String tplId) {
        this.tplId = tplId;
    }

    public String getpId() {
        return pId;
    }

    public void setPId(String pId) {
        this.pId = pId;
    }

    /**
     * 获取打印配置信息
     */
    public void getPrintConfig(){
        String userid = SessionUtil.getCurrentUserId();
        Map params = new HashMap();
        params.put("op", "write");
        if(type==0){
            params.put("id", id);
        }else if(type == 1 || type == 2){
            params.put("hh", hh);
        }

        renderJson(printService.getUserPrintTpl(userid, type, params));
    }

    /**
     *  获取模板配置列表上的数据
     */
    public void getTplModelConfigDatas(){
        renderJson(printService.getTplDatas(type, SessionUtil.getCurrentUserId()));
    }

    /**
     * 获取用户的配置数据
     */
    public void getUserTplConfigDatas(){
        renderJson(printService.getUserTplDatas(type, SessionUtil.getCurrentUserId()));
    }

    /**
     * 移除模板
     */
    public void removeTpl(){
        printService.removeUserTpl(pId);
    }

    /**
     * 添加模板
     */
    public void addTpl(){
        printService.addTpl(type, tplId);
    }
}
