package com.gtis.archive.web;


import com.alibaba.fastjson.JSONArray;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Original;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.OriginalService;
import com.opensymphony.xwork2.Action;

import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * Created by user on 2015-12-10.
 */
public class MdAction extends BaseModelAction<Original> {
    private String ownerId;
    private String tbtojson;
    private String modelName;

    @Autowired
    private OriginalService originalService;
    @Autowired
    private DictService dictService;
    @Autowired
    private ArchiveService archiveService;

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getTbtojson() {
        return tbtojson;
    }

    public void setTbtojson(String tbtojson) {
        this.tbtojson = tbtojson;
    }

    @Override
    public String getModelName() {
        return modelName;
    }

    @Override
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Override
    public String execute() {
        return Action.SUCCESS;
    }

    /**
     * 获取修改卷内列表
     *
     * @return
     */
    public Map<String, Original> getOglist() {
        Map<String, Original> ogmap = new HashMap<String, Original>();
        List<Original> originals = originalService.getOriginallist(ownerId);
        for (Original original : originals) {
            ogmap.put(original.getName(), original);
        }
        return ogmap;
    }

    /**
     * 获取字典
     *
     * @return
     */
    public Map getMaterialFields() {
        Map dictmap = new HashMap();
        List<Item> dictList = null;
        try {
            dictList = dictService.getItems("materialName");
        } catch (Exception e) {
            logger.error("字典获取错误，检查‘materialName’字典是否存在！");
        }
        for (Item item : dictList) {
            dictmap.put(item.getName(), item);
        }
        return dictmap;
    }

    /**
     * 保存原文
     *
     * @return
     */
    public String save() {
        List oglist = JSONArray.parseArray(tbtojson);

        for (int i = 0; i < oglist.size(); i++) {
            Map ogmap = (Map) oglist.get(i);
            Original original = originalService.getOriginal(String.valueOf(ogmap.get("id")));
            try {
                String val = String.valueOf(ogmap.get("材料名称数字"));
                Map dictmap = archiveService.getDictforsave();
                String tm = dictmap.get(val).toString();
                original.setName(String.valueOf(ogmap.get("文件显示名称")));
                original.setMaterialNumber(String.valueOf(ogmap.get("材料名称数字")));
                original.setMaterialName(tm);
                original.setZys(Integer.parseInt(String.valueOf(ogmap.get("总页数"))));
                original.setSzy(String.valueOf(ogmap.get("所在页")));
                original.setFjlx(String.valueOf(ogmap.get("附件类型")));
                originalService.saveOriginal(original);
            } catch (NumberFormatException e) {
                logger.error("保存出错，请检查数据！" + e.toString());
                return "保存出错，请检查数据！";
            }
        }

        TreeSet<String> set = new TreeSet();
        for (int m = 0; m < oglist.size(); m++) {
            Map setmap = (Map) oglist.get(m);
            set.add(String.valueOf(setmap.get("材料名称数字")));
        }

        List<List> fzlist = new ArrayList();
        for (String str : set) {
            List list = new ArrayList();
            for (int l = 0; l < oglist.size(); l++) {
                Map map = (Map) oglist.get(l);
                if (String.valueOf(map.get("材料名称数字")).equals(str)) {
                    list.add(oglist.get(l));
                }
            }
            fzlist.add(list);
        }

        int docsize = 1;
        try {
            List listd = archiveService.getArchiveDocuments(modelName, ownerId);
            if (listd.size() == 0) {
                docsize = 0;
            }
        } catch (Exception e) {
            logger.error("检查卷内模型是否存在！");
        }

        if (docsize == 0) {
            archiveService.saveDoc(modelName,ownerId,fzlist);
        } else {
            List<Document> Documentlist = archiveService.getArchiveDocuments(modelName, ownerId);
//            List<Map> listmap = new ArrayList<Map>();
            String[] strings=new String[Documentlist.size()];
            for(int x=0;x<Documentlist.size();x++){
                strings[x]=Documentlist.get(x).getId();
            }

            updateDoc(strings,fzlist);
        }
        renderJson("保存成功！");
        return null;
    }

    /**
     * 修改卷内信息
     * @param strings
     * @param list
     */
    public void updateDoc(String[] strings,List<List> list){
        archiveService.removeDocument(modelName,strings);
        archiveService.saveDoc(modelName,ownerId,list);
    }
}
