package com.gtis.archive.service.impl;

import com.gtis.archive.entity.Note;
import com.gtis.archive.service.NoteService;
import com.gtis.support.hibernate.HibernateDao;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by zhayuwen on 2015/12/15.
 */
@Service
public class NoteServiceImpl extends HibernateDao implements NoteService {
    @Transactional
    @Override
    public Note getNoteByArchiveId(String archiveId) {
        String hql = "from Note n where n.archiveId =:archiveId";
        Map map = new HashMap();
        map.put("archiveId", archiveId);
        List<Note> notes = find(hql,map);
        if(notes.size()>0){
            return notes.get(0);
        }
        return null;
    }

    @Override
    public void saveOrUpdateNote(Note note) {
        getSession().flush();
        getSession().saveOrUpdate(note);
    }

    /**
     * 批量删除备考表
     * @param ids
     */
    @Override
    public void removeNotes(String[] ids) {
        for(String id :ids){
            getSession().delete(getNoteByArchiveId(id));
        }
    }
}
