package com.gtis.archive.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.gtis.archive.Constants;
import com.gtis.archive.core.EntityService;
import com.gtis.archive.core.Model;
import com.gtis.archive.core.ModelService;
import com.gtis.archive.core.dict.DictService;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.support.hibernate.UUIDHexGenerator;
import com.gtis.archive.entity.*;
import com.gtis.archive.service.*;
import com.gtis.archive.service.invoke.ArchiveReceiveSecivce;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.support.hibernate.HibernateDao;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-10-26
 */
public class ArchiveServiceImpl extends HibernateDao implements ArchiveService {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveServiceImpl.class);

    @Autowired
    private EntityService entityService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private SysUserService userService;
    @Autowired
    private DictService dictService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ArchiveReceiveSecivce archiveReceiveSecivce;   //不动产相关接口的实现service
    @Autowired
    private NoteService noteService;
    @Autowired
    private RecordAjhRangeService recordAjhRangeService;

    private boolean dwdmEnable = false;
    private boolean jiangyinEnable = false;

    public void setDwdmEnable(boolean dwdmEnable) {
        this.dwdmEnable = dwdmEnable;
    }

    public void setJiangyinEnable(boolean jiangyinEnable){
        this.jiangyinEnable = jiangyinEnable;
    }

    public Archive getArchive(String modelName, String id) {
        return entityService.load(Document.toArchiveModelName(modelName), id);
    }

    public Document getDocument(String modelName, String id) {
        return entityService.load(Archive.toDocumentModelName(modelName), id);
    }

    public Archive getSimpleArchive(String id) {
        return (Archive) getSession().createSQLQuery("select t.*,0 clazz_ from t_archive t where t.id=?").addEntity(Archive.class).setParameter(0, id).uniqueResult();
        //return entityService.load(Archive.class,id);
    }

    public Document getSimpleDocument(String id) {
        return (Document) getSession().createSQLQuery("select t.*,0 clazz_ from t_document t where t.id=?").addEntity(Document.class).setParameter(0, id).uniqueResult();
        //return entityService.load(Document.class,id);
    }

    public Archive getDocumentArchive(String modelName, String documentId) {
        return getArchive(modelName, getDocument(modelName, documentId).getId());
    }

    public Archive getDocumentArchive(Document document) {
        return getArchive(document.getModelName(), document.getArchiveId());
    }

    public List<Document> getArchiveDocuments(String modelName, String archiveId) {
        List<Order> orders = new ArrayList<Order>(2);
        orders.add(Order.asc("sxh"));
        orders.add(Order.asc("id"));
        return entityService.<Document>search(Archive.toDocumentModelName(modelName), Collections.singletonList(Restrictions.eq("archiveId", archiveId)), orders, 0, Page.ALL).getItems();
    }

    public List<Document> getArchiveDocuments(Archive archive) {
        return getArchiveDocuments(archive.getModelName(), archive.getId());
    }

    public Model getArchiveModel(String modelName) {
        return modelService.getModel(Document.toArchiveModelName(modelName));
    }

    public Model getDocumentModel(String modelName) {
        return modelService.getModel(Archive.toDocumentModelName(modelName));
    }

    public Archive newArchive(String modelName) {
        return (Archive) entityService.newInstance(Document.toArchiveModelName(modelName));
    }

    public Document newDocument(String modelName) {
        return (Document) entityService.newInstance(Archive.toDocumentModelName(modelName));
    }

    @Transactional
    public void removeArchive(String modelName, String[] ids) {
        for (String id : ids) {
            List<Document> docs = getArchiveDocuments(modelName, id);
            String[] dids = new String[docs.size()];
            for (int i = 0, size = docs.size(); i < size; i++) {
                dids[i] = docs.get(i).getId();
            }
            removeDocument(modelName, dids);
            List<Original> ogs = originalService.getOriginals(id);
            String[] oids = new String[ogs.size()];
            for (int i = 0, size = ogs.size(); i < size; i++) {
                oids[i] = ogs.get(i).getId();
            }
            originalService.removeOriginal(oids);
        }
        entityService.remove(modelName, ids);
        logger.debug("remove archive [{}] ids [{}]", modelName, ids);
    }

    @Transactional
    public void removeDocument(String modelName, String[] ids) {
        for (String id : ids) {
            List<Original> ogs = originalService.getOriginals(id);
            String[] oids = new String[ogs.size()];
            for (int i = 0, size = ogs.size(); i < size; i++) {
                oids[i] = ogs.get(i).getId();
            }
            originalService.removeOriginal(oids);
        }
        entityService.remove(Archive.toDocumentModelName(modelName), ids);
        logger.debug("remove document [{}] ids [{}]", modelName, ids);
    }

    @Transactional
    public Archive saveArchive(Archive archive) {
        if (dwdmEnable) {
            if(StringUtils.isBlank(archive.getDwdm()))
                archive.setDwdm(getDwdm());
            if(jiangyinEnable) setQzhByDwdm(archive);
        }
        if (StringUtils.isEmpty(archive.getId())) {
            archive.setId(UUIDHexGenerator.generate());
        }
        return entityService.save(archive);
    }

    @Transactional
    public Document saveDocument(Document document) {
        if(dwdmEnable){
            document.setDwdm(getDwdm());
        }
        return entityService.save(document);
    }

    public Page<Archive> searchArchive(String modelName, List<? extends Criterion> criterions, List<Order> orders, int start, int limit) {
        List<Criterion> list = new ArrayList<Criterion>(criterions);

        if (dwdmEnable && !SessionUtil.getCurrentUser().isAdmin() && !hasPermissionToViewAllArchive()) {
//            if(EnvHolder.isEnable(Switch.JIANGYIN)){
//                try{
//                    boolean hasPrimDwdm= PropertyUtils.getProperty(newArchive(modelName),"primdwdm")==null;
//                    list.add(Restrictions.or(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", getDwdm())),Restrictions.eq("primdwdm",getDwdm())));
//                }catch (Exception ex){
//                    list.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", getDwdm())));
//                }
//            }else{
//                  list.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", getDwdm())));
//            }

            list.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", getDwdm())));
        }
        return entityService.search(modelName, list, orders == null ? Collections.singletonList(Order.desc("id")) : orders, start, limit);
    }

    public Page<Document> searchDocument(String modelName, List<? extends Criterion> criterions, List<Order> orders, int start, int limit) {
        List<Criterion> list = new ArrayList<Criterion>(criterions);
        if(dwdmEnable && !SessionUtil.getCurrentUser().isAdmin()){
            list.add(Restrictions.or(Restrictions.isNull("dwdm"),Restrictions.eq("dwdm",getDwdm())));
        }
        return entityService.search(Archive.toDocumentModelName(modelName), list, orders == null ? Collections.singletonList(Order.desc("id")) : orders, start, limit);
    }

    public int getArchiveCount(String modelName, List<? extends Criterion> criterions) {
        return entityService.getCount(modelName, criterions);
    }

    public Page<Archive> searchArchive(String modelName, List<? extends Criterion> criterions, List<Order> orders, String dwdm, int start, int limit) {
        List<Criterion> list = new ArrayList<Criterion>(criterions);
        list.add(Restrictions.or(Restrictions.isNull("dwdm"), Restrictions.eq("dwdm", dwdm)));
        return entityService.search(modelName, list, orders == null ? Collections.singletonList(Order.desc("id")) : orders, start, limit);
    }

    /**
     * 根据架号、排号、盒号获取案卷集合
     * @param jh
     * @param ph
     * @param hh
     * @param start
     * @param limit
     * @return
     */
    public Page<Archive> searchArchive(String jh, String ph, String hh, int start, int limit) {
        List<Criterion> criterions = new ArrayList<Criterion>();

        try {
            criterions.add(Restrictions.eq("jh", jh));
            criterions.add(Restrictions.eq("ph", ph));
            criterions.add(Restrictions.eq("hh", hh));
            return entityService.search(Archive.class, criterions, Collections.singletonList(Order.asc("createdAt")), start, limit);
        } catch (Exception e) {
            logger.error("获取电子档案号惊现异常：{}", e.toString());
            return null;
        }
    }

    @Override
    public List<Object> searchArchiveList(String modelName, List<? extends Criterion> criterions, List<Order> orders, int start, int limit) {
        List<Criterion> list = new ArrayList<Criterion>(criterions);
        return entityService.search(modelName, list, orders == null ? Collections.singletonList(Order.desc("id")) : orders, start, limit).getItems();
    }

    @Override
    public String flhjs(String flhjs,String modelName){
        String hql="select flh from Archive where flh like :flhcx and modelName= :modelName group by flh order by flh ";
        List<Object> list = null;
        Map map = new HashMap();
        String flhcs="%"+flhjs+"%";
        map.put("flhcx",flhcs);
        map.put("modelName",modelName);
        try {
            list = find(hql, map);
        } catch (Exception e) {
            e.printStackTrace();
        }
        StringBuffer flhsz=new StringBuffer();
        for(int i=0;i<list.size();i++){
            try {
                flhsz.append(list.get(i).toString());
                flhsz.append(";  ");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        String flhtj =flhsz.toString();
      return flhtj;
    }

    @Override
    public Archive getArchiveBySlh(String slh) {
        if(Struts2Utils.isNull(slh)){
            return null;
        }
        String hql = "FROM Archive t WHERE t.slh=:SLH";
        Archive archive = null;
        Map map = new HashMap();
        map.put("SLH", slh);
        try {
            archive = (Archive) createQuery(hql, map).uniqueResult();
        } catch (Exception e) {
            logger.error("请确定是否存在重复的slh【"+slh+"】档案，异常信息：{}", e.toString());
        }
        return archive;
    }

    @Override
    public Page<Archive> getPreOrAfterArchiveInfo(String slh, String type, int start, int limit) {
        List<String> results = new ArrayList<String>();
        Page<Archive> archivePage = null;
        try {
            if ("pre".equals(type)) {
                results.addAll(archiveReceiveSecivce.beforeSlh(slh));
                logger.info("查询上一手档案数量:{}", results.size());
            } else if ("after".equals(type)) {
                results.addAll(archiveReceiveSecivce.afterSlh(slh));
                logger.info("查询上一手档案数量:{}", results.size());
            }
        } catch (Exception e) {
            logger.error("查询上一手或者下一手的信息出现异常:{}", e.toString());
        }

        if(results.size()>0) {
            List<Criterion> criterions = new ArrayList<Criterion>();
            criterions.add(Restrictions.in("slh", results));
            archivePage = search(Archive.class, criterions, null, start, limit);
            logger.info("上下手查询到档案数量为:{}", Struts2Utils.isNull(archivePage)?0:archivePage.getItems().size());
        }

        if(Struts2Utils.isNull(archivePage)){
            archivePage = new Page<Archive>();
        }

        return archivePage;
    }

    private String getDwdm() {
        String dwdm = (String) Struts2Utils.getSessionAttribute("__dwdm");
        if (dwdm == null) {
            dwdm = userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", dwdm);
        }
        return dwdm;
    }

    /**
     * 判断是否可以看到所有档案
     * @return
     */
    private boolean isViewAllArchive(){
        try {
            List<Item> dicts = dictService.getItems(Constants.VIEW_ALL_ARCHIVE);
            String currentDwdm = getDwdm();

            for(Item item : dicts){
                if(item.getName().equals(currentDwdm)){
                    return  true;
                }
            }
        }catch (Exception ex){
            logger.error(ex.getMessage());
//            ex.printStackTrace();
        }
        return false;
    }

    /**
     * 检查是否有权限查看所有的档案
     * @return
     */
    private boolean hasPermissionToViewAllArchive(){
        boolean flag = false;
        flag = permissionService.hasPermission("sys", "viewAllArchive");
        return flag;
    }

    /**
     * 可选功能：根据单位代码设置全宗号，其对应关系由字典表中qzhdwdm决定
     * @param archive
     */
    private void setQzhByDwdm(Archive archive){
        if(StringUtils.isBlank(archive.getDwdm())) return;
        String dwdm = archive.getDwdm();
        try{
            List<Item> items = dictService.getItems(Constants.QZH_DWDM);
            for(Item item:items){
                if(dwdm.equals(item.getName())){
                    archive.setQzh(item.getValue());
                    break;
                }
            }
        }catch(Exception ex){
            logger.info("未配置[{}]单位代码全宗号字典项",Constants.QZH_DWDM);
        }

    }

    /**
     * 查询案卷号获取档案号后六位
     * @param ajhtodah
     * @return
     */
    @Override
    public String getdzdah(int ajhtodah){
        String tmpdah= String.valueOf(ajhtodah);
        int j = tmpdah.length();
        StringBuffer addzero= new StringBuffer();
        for(int i = 0;i<(6-j);i++){
            addzero.append("0");
        }
        addzero.append(tmpdah);
        String ajhid = addzero.toString();
        return ajhid;
    }

    /**
     * 添加保存卷内信息
     *
     * @param list
     */
    public void saveDoc(String modelName,String ownerId,List<List> list) {
        int yh = 0;
        for (int i = 0; i < list.size(); i++) {
            Map map = (Map) list.get(i).get(0);
            String val = String.valueOf(map.get("材料名称数字"));
            Map dictmap = getDictforsave();
            String tm = "";
            if(!Struts2Utils.isNull(dictmap.get(val))) {
                tm = dictmap.get(val).toString();
            }
            Document document = null;
            if (modelName .equals("Archive")) {
                document = new Document();
                document.setModelName("Document");
            } else {
                try {
                    document = entityService.newInstance(modelName + "_jn");
                } catch (Exception e) {
                    logger.error("检查卷内模型是否存在");
                }
                document.setModelName(modelName + "_jn");
            }
            document.setTm(tm);
            document.setSxh(i + 1);
            document.setArchiveId(ownerId);
            document.setModelName(modelName + "_jn");
            if (list.get(i).size() > 1) {
                document.setYh(String.valueOf(yh + 1) + "-" + String.valueOf(yh + list.get(i).size()));
            } else {
                document.setYh(String.valueOf(yh + 1));
            }
            try {
                entityService.save(document);
            } catch (Exception e) {
                logger.error("保存失败！");
            }
            yh += list.get(i).size();
        }
    }


    /**
     * 字典转换
     *
     * @return
     */
    public Map getDictforsave() {
        Map dictmap = new HashMap();
        List<Item> dictList = null;
        try {
            dictList = dictService.getItems("materialName");
        } catch (Exception e) {
            logger.error("字典获取错误，检查‘materialName’字典是否存在！");
        }
        for (Item item : dictList) {
            dictmap.put(item.getValue(), item.getName());
        }
        return dictmap;
    }


    /**
     * id转为用户名展示
     * @param page
     * @return
     */
    public Page<Archive> getNameByid(Page<Archive> page){
        for(int i =0;i<page.getItems().size();i++) {
            String sqrid = page.getItems().get(i).getSqr();
            String rkrid = page.getItems().get(i).getRkr();
            String sjrid = page.getItems().get(i).getSjr();
            String fjrid = page.getItems().get(i).getFjr();
            String jcrid = page.getItems().get(i).getJcr();
            String smrid = page.getItems().get(i).getSmr();
            String sqr = getUserNamebyId(sqrid);
            String rkr = getUserNamebyId(rkrid);
            String sjr = getUserNamebyId(sjrid);
            String fjr = getUserNamebyId(fjrid);
            String jcr = getUserNamebyId(jcrid);
            String smr = getUserNamebyId(smrid);
            page.getItems().get(i).setSqr(sqr);
            page.getItems().get(i).setRkr(rkr);
            page.getItems().get(i).setSjr(sjr);
            page.getItems().get(i).setFjr(fjr);
            page.getItems().get(i).setJcr(jcr);
            page.getItems().get(i).setSmr(smr);
        }
        return page;

    }

    /**
     * id转换名称
     * @param userId
     * @return
     */
    public String getUserNamebyId(String userId){
        PfUserVo user = userService.getUserVo(userId);
        if(!Struts2Utils.isNull(user)){
            return user.getUserName();
        }else{
            return "";
        }
    }

    /**
     * 材料名称数字转换
     * @param jh （架号）
     * @param ph （排号）
     * @param hh （盒号）
     * @param flh （材料类别）
     * @param dzdah （电子档案号）
     * @param das （档案数）
     * @return
     */
    @Override
    public boolean saveArchiveInfo(String jh, String ph, String hh, String flh, String dzdah, String das) {
        if (jh == null || jh == "" || jh.isEmpty() ||
                ph == null || ph == "" || ph.isEmpty() ||
                hh == null || hh == "" || hh.isEmpty() ||
                flh == null || flh == "" || flh.isEmpty() ||
                dzdah == null || dzdah == "" || dzdah.isEmpty() ||
                das == null || das == "" || das.isEmpty()) {
            return false;
        }

        try {
            String sSQL = "FROM Archive WHERE flh = '"+ flh +"' AND dzdah IS NOT NULL AND jh IS NULL AND ph IS NULL AND hh IS NULL ORDER BY createdAt ASC";
            Map map = new HashMap();
            List list =  find(sSQL,map);
            if(list.size() == 0){
                return false;
            }

            int iDas = Integer.parseInt(das);
            for(int i = 0; i < list.size(); i++){
                Archive archive = (Archive)list.get(i);
                if(archive.getDzdah() == null || archive.getDzdah().isEmpty()){
                    continue;
                }

                if(archive.getDzdah().equals(dzdah)){
                    int iCnt = iDas < list.size() ? iDas : list.size();
                    for(int j = 0; j < iCnt; j++){
                        archive = (Archive)list.get(i + j);
                        saveArchiveListInfo(jh, ph, hh, archive);
                    }
                    break;
                }
            }

            return true;
        } catch (Exception e) {
            logger.error(e.toString());
            return false;
        }
    }

    /**
     * 根据架号、排号、盒号获取案卷集合
     * @param jh 架号
     * @param ph 排号
     * @param hh 盒号
     * @return 案卷集合
     */
    @Override
    public List getArchive(String jh, String ph, String hh) {
        if (jh == null || jh.isEmpty() || ph == null || ph.isEmpty() || hh == null || hh.isEmpty()) {
            return null;
        }

        try {
            String sSQL = "FROM Archive WHERE jh = '" + jh + "' AND ph = '"+ ph +"' AND hh = '"+ hh +"' ORDER BY createdAt ASC";
            Map map = new HashMap();
            List list = find(sSQL, map);
            if (list.size() == 0) {
                return null;
            }

            return list;
        } catch (Exception e) {
            logger.error(e.toString());
            return null;
        }
    }

    /**
     * 保存案卷卷内信息
     * @param jh （架号）
     * @param ph （排号）
     * @param hh （盒号）
     * @param archive （案卷）
     * @return （true or false）
     */
    public boolean saveArchiveListInfo(String jh, String ph, String hh, Archive archive) {
        try {
            archive.setJh(jh);
            archive.setPh(ph);
            archive.setHh(hh);
            saveArchive(archive);
            return true;
        } catch (Exception e) {
            logger.error(e.toString());
            return false;
        }
    }

    @Transactional
    public Map backToBdcdj(String[] ids, String info, String modelName) {
        Map map = new HashMap();
        List msg = new ArrayList();
        String thr = SessionUtil.getCurrentUser().getUsername();
        try {
            for(String id : ids){
                Archive archive = getArchive(modelName, id);
                RecordAjhRange recordAjhRange = new RecordAjhRange();
                recordAjhRange.setAjh(archive.getAjh());
                recordAjhRange.setMlh(archive.getMlh());
                recordAjhRange.setDwdm(archive.getDwdm());
                recordAjhRange.setModelName(archive.getModelName());
                recordAjhRange.setBgqx(archive.getBgqx());
                recordAjhRange.setDzdah(archive.getDzdah());
                recordAjhRangeService.saveRecordAjh(recordAjhRange);

                Map data = new HashMap();
                data.put("thyy", info);
                data.put("thr", thr);
                data.put("slh", archive.getSlh());
                data.put("jjsfcg", 2);     //是否交接成功，退回为2， 接口约定不变的数字
                msg.add(data);
            }

            archiveReceiveSecivce.receive(JSONArray.toJSONString(msg));
            removeArchive(modelName, ids);
            noteService.removeNotes(ids);
            map.put("success", true);
        } catch (Exception e) {
            map.put("success",false);
            logger.error("退回材料出错：{}", e.toString());
            throw new RuntimeException(e.toString());
        }

        return map;
    }
}
