package com.gtis.archive.service;

import com.gtis.archive.entity.PrintConfig;

import java.util.List;
import java.util.Map;

/**
 * 海门打印管理部分业务
 * Created by zhayuwen on 2015/12/12.
 */
public interface PrintService {
    /**
     * 获取用户的配置模板信息
     * @param userid
     * @param type
     * @param params  模板参数
     * @return
     */
    Map getUserPrintTpl(String userid, Integer type, Map params);

    /**
     * 获取类型下的配置模板信息
     * @param type
     * @param userId
     * @return
     */
    Map getTplDatas(int type, String userId);

    /**
     * 获取用户的tpl数据
     * @param type
     * @param userId
     * @return
     */
    Map getUserTplDatas(int type, String userId);

    /**
     * 添加模板
     * @param type
     * @param tplId
     * @return
     */
    Map addTpl(int type, String tplId);

    /**
     * 移除用户模板
     * @param tplPk
     * @return
     */
    Map removeUserTpl(String tplPk);
}
