package com.gtis.archive.service;

import com.gtis.archive.entity.Loan;
import com.gtis.common.Page;
import org.hibernate.criterion.Criterion;

import java.util.List;

/**
 * .借阅管理
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 12-9-3 上午10:58
 */
public interface LoanService<T> {

    /**
     * 添加到借阅车
     *
     * @param entity
     */
    public void addToCart(T entity);

    /**
     * 移出借阅车
     *
     * @param entity
     */
    public void removeFromCart(T entity);

    /**
     * 删除借阅车中记录
     *
     * @param ids
     */
    public void removeFromeCart(String[] ids);

    /**
     * 借阅
     *
     * @param entities
     * @deprecated
     */
    public void doLoan(Loan[] entities);

    /**
     * 借阅
     *
     * @param loanCarts
     * @param loan
     */
    public void doLoan(List<T> loanCarts, Loan loan);

    /**
     * 获取借阅车内所有内容
     *
     * @param start
     * @param limit
     * @param criterions
     * @return
     */
    public Page<T> getPages(int start, int limit, List<? extends Criterion> criterions);


    /**
     * 获取所有记录条数
     *
     * @return
     */
    public int count(List<? extends Criterion> criterions);

    /**
     * 通过id查询借阅记录
     * @param id
     * @return
     */
    public Loan findLoanById(String id);

}
