package com.gtis.archive.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * 打印配置表
 * Created by ibm on 2015/12/12.
 */
@Entity
@Table(name = "t_print_config")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PrintConfig {
    public static final String MODEL_NAME = PrintConfig.class.getSimpleName();

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 关联模板设置人的id
     */
    @Column
    private String userid;

    /**
     * 关联的模板id，配置在字典【printTplMgr】当中的字典项的主键
     */
    @Column
    private String tplId;

    /**
     * 打印模板的类型
     * 0：卷内目录类型的，  1：盒脊类（因为纸张的问题可能产生的多个模板的配置）
     * 2: 盒内目录
     */
    private Integer type;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getTplId() {
        return tplId;
    }

    public void setTplId(String tplId) {
        this.tplId = tplId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
