package com.gtis.archive.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 *   交接单管联档案信息
 *  * <p/>
 *   不动产系统归档过来的交接单对应的档案信息
 * <p/>
 * <p/>
 * Generated 2015-12-9 by Model Code Generater 1.0
 * <p/>
 *
 * @author <a href="mailto:izywam@gmail.com">zhayuwen</a>
 */
@Entity
@Table(name = "t_material_archive")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class MaterialArchive {
    public static final String MODEL_NAME = MaterialArchive.class.getSimpleName();

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String maId;

    /**
     * 受理号
     */
    @Column
    private String slh;

    /**
     * 不动产项目主键
     */
    private String proid;

    /**
     * 新档案号
     */
    @Column
    private String xdah;

    /**
     * 登记类型名称 | 业务登记类型
     */
    @Column
    private String ywdjlx;

    /**
     * 房屋地址 | 坐落
     */
    @Column
    private String zl;

    /**
     * 申请人
     */
    @Column
    private String sqr;

    /**
     * 不动产单元描述
     */
    private String bdcdyh;

    /**
     * 不动产单元号,多个用、隔开
     */
    private String bdcdyhs;

    /**
     * 状态
     */
    @Column
    private String zt;

    /**
     * 归档类型
     */
    private String gdlx;

    /**
     * 产权证号
     */
    private String cqzh;

    /**
     * 备注
     */
    @Column
    private String bz;

    @ManyToOne(cascade = CascadeType.ALL,fetch = FetchType.LAZY)
    @JoinColumn(name = "material_id")
    private Material material;

    /**
     * 数据未归档时候有效
     */
    private Boolean enabled = true;

    public String getMaId() {
        return maId;
    }

    public void setMaId(String maId) {
        this.maId = maId;
    }

    public String getSlh() {
        return slh;
    }

    public void setSlh(String slh) {
        this.slh = slh;
    }

    public String getXdah() {
        return xdah;
    }

    public void setXdah(String xdah) {
        this.xdah = xdah;
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public String getYwdjlx() {
        return ywdjlx;
    }

    public void setYwdjlx(String ywdjlx) {
        this.ywdjlx = ywdjlx;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getBdcdyhs() {
        return bdcdyhs;
    }

    public void setBdcdyhs(String bdcdyhs) {
        this.bdcdyhs = bdcdyhs;
    }

    public String getGdlx() {
        return gdlx;
    }

    public void setGdlx(String gdlx) {
        this.gdlx = gdlx;
    }

    public String getSqr() {
        return sqr;
    }

    public void setSqr(String sqr) {
        this.sqr = sqr;
    }

    public String getZt() {
        return zt;
    }

    public void setZt(String zt) {
        this.zt = zt;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public Material getMaterial() {
        return material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getCqzh() {
        return cqzh;
    }

    public void setCqzh(String cqzh) {
        this.cqzh = cqzh;
    }
}
