package com.gtis.archive.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;
import java.util.Set;

/**
 * 交接单
 *  * <p/>
 *   不动产系统归档过来的交接单数据
 * <p/>
 * <p/>
 * Generated 2015-12-9 by Model Code Generater 1.0
 * <p/>
 *
 * @author <a href="mailto:izywam@gmail.com">zhayuwen</a>
 */
@Entity
@Table(name = "t_material")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Material  {
    public static final String MODEL_NAME = Material.class.getSimpleName();

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = "com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length = 32)
    private String id;

    /**
     * 交接单号
     */
    @Column
    private String jjdbh;

    /**
     * 交接单类型
     */
    @Column
    private String jjdlx;

    /**
     * 转发人 | 交件人
     */
    @Column
    private String jjr;

    /**
     * 转发时间 | 交件时间
     */
    @Column
    private Date jjrq;

    /**
     * 转发科室
     */
    @Column
    private String zfks;

    /**
     * 接收人 | 收件人
     */
    @Column
    private String sjr;

    /**
     * 接收时间
     */
    @Column
    private Date jsrq;

    /**
     * 接收科室
     */
    @Column
    private String jsks;

    /**
     * 交接单状态
     */
    @Column
    private String jjdzt;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "material",fetch = FetchType.LAZY)
    private Set<MaterialArchive> materialArchives;

    /**
     * 数据未归档时候有效
     */
    private Boolean enabled = true;

    public Material(){

    }

    public String getId() {
        return id;
    }

    public void setId(String Id) {
        this.id = Id;
    }

    public String getJjdbh() {
        return jjdbh;
    }

    public void setJjdbh(String jjdbh) {
        this.jjdbh = jjdbh;
    }

    public String getJjdlx() {
        return jjdlx;
    }

    public void setJjdlx(String jjdlx) {
        this.jjdlx = jjdlx;
    }

    public Date getJjrq() {
        return jjrq;
    }

    public void setJjrq(Date jjrq) {
        this.jjrq = jjrq;
    }

    public String getSjr() {
        return sjr;
    }

    public void setSjr(String sjr) {
        this.sjr = sjr;
    }

    public String getZfks() {
        return zfks;
    }

    public void setZfks(String zfks) {
        this.zfks = zfks;
    }

    public String getJjr() {
        return jjr;
    }

    public void setJjr(String jjr) {
        this.jjr = jjr;
    }

    public Date getJsrq() {
        return jsrq;
    }

    public void setJsrq(Date jsrq) {
        this.jsrq = jsrq;
    }

    public String getJsks() {
        return jsks;
    }

    public void setJsks(String jsks) {
        this.jsks = jsks;
    }

    public String getJjdzt() {
        return jjdzt;
    }

    public void setJjdzt(String jjdzt) {
        this.jjdzt = jjdzt;
    }

    public Set<MaterialArchive> getMaterialArchives() {
        return materialArchives;
    }

    public void setMaterialArchives(Set<MaterialArchive> materialArchives) {
        this.materialArchives = materialArchives;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }
}
