package com.gtis.archive.entity;

import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;
import java.util.Date;

/**
 * 档案
 * <p/>
 * Generated 2010-08-13 13:15:25 by Model Code Generater 1.0
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 */
@Entity
@Table(name = "t_archive")
@Inheritance(strategy = InheritanceType.JOINED)
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Archive {
    public static final String MODEL_NAME = Archive.class.getSimpleName();
    public static final String DOCUMENT_SUFFIX = "_jn";
    public static final int STATE_WGD = 0;
    public static final int STATE_YGD = 1;

    @Id
    @Column(length = 32)
    private String id;

    /**
     * 模型名
     */
    @Column(length = 10)
    private String modelName = getClass().getSimpleName();

    /**
     * 档号
     */
    @Column(length = 100)
    private String dh;

    /**
     * 单位代码
     */
    @Column(length = 100, nullable = true)
    private String dwdm;

    /**
     * 全宗号
     */
    @Column(length = 100, nullable = true)
    private String qzh;

    /**
     * 目录号
     */
    @Column(length = 100)
    private String mlh;

    /**
     * 案卷号
     */
    @Column
    private Integer ajh;

    /**
     * 电子档案号
     */
    @Column
    private String dzdah;

    /**
     * 题名
     */
    @Column(length = 1000)
    private String tm;

    /**
     * 分类号
     */
    @Column(length = 100)
    private String flh;

    /**
     * 年度
     */
    @Column(length = 10)
    private String nd;

    /**
     * 起日期
     */
    private Date qrq;

    /**
     * 止日期
     */
    private Date zrq;

    /**
     * 件数
     */
    @Column
    private Integer js;

    /**
     * 页数
     */
    @Column
    private Integer ys;

    /**
     * 保管期限
     */
    @Column(length = 10, nullable = false)
    private String bgqx;

    /**
     * 密级
     */
    @Column(length = 10, nullable = true)
    private String mj;

    /**
     * 箱号
     */
    @Column(length = 100)
    private String xh;

    /**
     * 存放位置
     */
    @Column(length = 100)
    private String cfwz;

    /**
     * 备注
     */
    @Column(length = 1000)
    private String bz;

    /**
     * 归档时间
     */
    private Date gdsj;

    /**
     * 资源序号
     */
    @Column(length = 100)
    private String resourceId;

    /**
     * 状态，已归档，未归档
     */
    @Column
    private int state;

    /**
     * 文本格式的起日期
     */
    private String sqrq;


    /**
     * 文本格式的止日期
     */
    private String szrq;

    /**
     * 是否存在原文
     */
    @Transient
    private Boolean hasOriginal;

    /**
     * 房间号
     */
    @Column(length = 100)
    private String roomId;

    /**
     * 三维档案：柜号
     */
    @Column(length = 100)
    private String cabinetSno;

    /**
     * 三维档案：柜左右面
     */
    @Column(length = 10)
    private Integer sideId;

    /**
     * 三维档案： 格号
     */
    @Column(length = 10)
    private Integer cellId;

    /**
     * 三维档案盒号
     */
    @Column(length = 10)
    private Integer boxId;

    /**
     * 档案架号
     */
    @Column
    private String jh;

    /**
     * 档案排号
     */
    @Column
    private String ph;

    /**
     * 盒号
     */
    @Column
    private String hh;

    /**
     * 扫描人
     */
    @Column
    private String smr;

    /**
     * 入库人
     */
    @Column
    private String rkr;

    /**
     * 入库时间
     */
    @Column
    private Date rksj;

    /**
     * 入库状态
     */
    @Column
    private String rkzt;

    /**
     * 检查人
     */
    private String jcr;

    /**
     * 检查时间
     */
    private Date jcsj;

    /**
     * 检查状态
     */
    private String jczt;

    /**
     * 复检人
     */
    private String fjr;

    /**
     * 复检时间
     */
    private Date fjsj;


    /**
     * 申请人
     */
    private String sqr;

    /**
     * 原电子档案号
     */
    private String ydzdah;

    /**
     * 房屋位置
     */
    private String zl;

    /**
     * 产权证号
     */
    private String cqzh;

    /**
     * 接件编号
     */
    private String jjdbh;

    /**
     * 接收人 | 收件人
     */
    @Column
    private String sjr;

    /**
     * 接收时间
     */
    @Column
    private Date jsrq;

    /**
     * 不动产单元描述
     */
    private String bdcdyh;

    /**
     * 不动产单元号,多个用、隔开
     */
    private String bdcdyhs;

    /**
     * 受理号
     */
    @Column
    private String slh;

    /**
     * 不动产项目主键
     */
    private String proid;

    /**
     * 登记类型名称 | 业务登记类型
     */
    @Column
    private String ywdjlx;

    /**
     * 创建时间 | 建档时间
     */
    private Date createdAt = new Date();

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        if (StringUtils.isNotEmpty(modelName))
            this.modelName = modelName;
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    public String getDwdm() {
        return dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getQzh() {
        return qzh;
    }

    public void setQzh(String qzh) {
        this.qzh = qzh;
    }

    public String getMlh() {
        return mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public Integer getAjh() {
        return ajh;
    }

    public void setAjh(Integer ajh) {
        this.ajh = ajh;
    }

    public String getDzdah() {
        return dzdah;
    }

    public void setDzdah(String dzdah) {
        this.dzdah = dzdah;
    }

    public String getTm() {
        return tm;
    }

    public void setTm(String tm) {
        this.tm = tm;
    }

    public String getFlh() {
        return flh;
    }

    public void setFlh(String flh) {
        this.flh = flh;
    }

    public String getNd() {
        return nd;
    }

    public void setNd(String nd) {
        this.nd = nd;
    }

    public Date getQrq() {
        return qrq;
    }

    public void setQrq(Date qrq) {
        this.qrq = qrq;
    }

    public Date getZrq() {
        return zrq;
    }

    public void setZrq(Date zrq) {
        this.zrq = zrq;
    }

    public Integer getJs() {
        return js;
    }

    public void setJs(Integer js) {
        this.js = js;
    }

    public Integer getYs() {
        return ys;
    }

    public void setYs(Integer ys) {
        this.ys = ys;
    }

    public String getBgqx() {
        return bgqx;
    }

    public void setBgqx(String bgqx) {
        this.bgqx = StringUtils.trim(bgqx);
    }

    public String getMj() {
        return mj;
    }

    public void setMj(String mj) {
        this.mj = StringUtils.trim(mj);
    }

    public String getXh() {
        return xh;
    }

    public void setXh(String xh) {
        this.xh = xh;
    }

    public String getCfwz() {
        return cfwz;
    }

    public void setCfwz(String cfwz) {
        this.cfwz = cfwz;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public Date getGdsj() {
        return gdsj;
    }

    public void setGdsj(Date gdsj) {
        this.gdsj = gdsj;
    }

    public String getResourceId() {
        return resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public int getState() {
        return state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getSqrq() {
        return sqrq;
    }

    public void setSqrq(String sqrq) {
        this.sqrq = sqrq;
    }

    public String getSzrq() {
        return szrq;
    }

    public void setSzrq(String szrq) {
        this.szrq = szrq;
    }

    public Boolean getHasOriginal() {
        return hasOriginal;
    }

    public void setHasOriginal(Boolean hasOriginal) {
        this.hasOriginal = hasOriginal;
    }

    public String getRoomId() {
        return roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public String getCabinetSno() {
        return cabinetSno;
    }

    public void setCabinetSno(String cabinetSno) {
        this.cabinetSno = cabinetSno;
    }

    public Integer getSideId() {
        return sideId;
    }

    public void setSideId(Integer sideId) {
        this.sideId = sideId;
    }

    public Integer getCellId() {
        return cellId;
    }

    public void setCellId(Integer cellId) {
        this.cellId = cellId;
    }

    public Integer getBoxId() {
        return boxId;
    }

    public void setBoxId(Integer boxId) {
        this.boxId = boxId;
    }

    public Date getFjsj() {
        return fjsj;
    }

    public void setFjsj(Date fjsj) {
        this.fjsj = fjsj;
    }

    public String getPh() {
        return ph;
    }

    public void setPh(String ph) {
        this.ph = ph;
    }

    public String getHh() {
        return hh;
    }

    public void setHh(String hh) {
        this.hh = hh;
    }

    public String getSmr() {
        return smr;
    }

    public void setSmr(String smr) {
        this.smr = smr;
    }

    public String getRkr() {
        return rkr;
    }

    public void setRkr(String rkr) {
        this.rkr = rkr;
    }

    public Date getRksj() {
        return rksj;
    }

    public void setRksj(Date rksj) {
        this.rksj = rksj;
    }

    public String getRkzt() {
        return rkzt;
    }

    public void setRkzt(String rkzt) {
        this.rkzt = rkzt;
    }

    public String getJcr() {
        return jcr;
    }

    public void setJcr(String jcr) {
        this.jcr = jcr;
    }

    public Date getJcsj() {
        return jcsj;
    }

    public void setJcsj(Date jcsj) {
        this.jcsj = jcsj;
    }

    public String getJczt() {
        return jczt;
    }

    public void setJczt(String jczt) {
        this.jczt = jczt;
    }

    public String getFjr() {
        return fjr;
    }

    public void setFjr(String fjr) {
        this.fjr = fjr;
    }

    public String getJh() {
        return jh;
    }

    public void setJh(String jh) {
        this.jh = jh;
    }

    public String getSqr() {
        return sqr;
    }

    public void setSqr(String sqr) {
        this.sqr = sqr;
    }

    public String getYdzdah() {
        return ydzdah;
    }

    public void setYdzdah(String ydzdah) {
        this.ydzdah = ydzdah;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getCqzh() {
        return cqzh;
    }

    public void setCqzh(String cqzh) {
        this.cqzh = cqzh;
    }

    public String getJjdbh() {
        return jjdbh;
    }

    public void setJjdbh(String jjdbh) {
        this.jjdbh = jjdbh;
    }

    public String getSjr() {
        return sjr;
    }

    public void setSjr(String sjr) {
        this.sjr = sjr;
    }

    public Date getJsrq() {
        return jsrq;
    }

    public void setJsrq(Date jsrq) {
        this.jsrq = jsrq;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getBdcdyhs() {
        return bdcdyhs;
    }

    public void setBdcdyhs(String bdcdyhs) {
        this.bdcdyhs = bdcdyhs;
    }

    public String getSlh() {
        return slh;
    }

    public void setSlh(String slh) {
        this.slh = slh;
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public String getYwdjlx() {
        return ywdjlx;
    }

    public void setYwdjlx(String ywdjlx) {
        this.ywdjlx = ywdjlx;
    }

    public Date getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public static boolean isArchiveModelName(String modelName) {
        return !modelName.endsWith(Archive.DOCUMENT_SUFFIX) && !Document.MODEL_NAME.endsWith(modelName);
    }

    public static String toDocumentModelName(String archiveModelName) {
        if (archiveModelName.endsWith(Archive.DOCUMENT_SUFFIX)) {
            return archiveModelName;
        } else if (Archive.MODEL_NAME.equals(archiveModelName) || Document.MODEL_NAME.equals(archiveModelName)) {
            return Document.MODEL_NAME;
        } else {
            return archiveModelName + Archive.DOCUMENT_SUFFIX;
        }
    }
}