<#macro html title="" import="">
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <title>${title}</title>
    <#list import?split(",") as lib>
        <#switch lib>
            <#case "base">
                <@script name="js/base.js"/>
                <@style name="css/base.css"/>
                <#break/>
            <#case "superfish">
                    <@script name="js/jquery.superfish.min.js"/><!-- header上的导航栏插件 -->
                <#break/>
            <#case "main">
                <@script name="js/main.js"/>
                <@style name="css/main.css"/>
                <@style name="css/plugins.css"/>
                <#break/>
            <#case "admin">
                <@script name="js/admin.js"/>
                <@style name="css/admin.css"/>
                <@script name="js/datePicker/WdatePicker.js"/>
            <#--<@script name="js/codepress/codepress.js"/>-->
                <#break/>
            <#case "jquery">
                <@script name="js/jquery.js"/>
                <#break/>
            <#case "form">
                <@style name="css/validation.css"/>
                <@script name="js/validation.js"/>
                <@script name="js/datePicker/WdatePicker.js"/>
                <#break/>
            <#case "ext">
                <@style name="js/ext/resources/css/ext-all.css"/>
                <@style name="js/ext/resources/css/xtheme-gray.css"/>
                <@script name="js/ext/ext-base.js"/>
                <@script name="js/ext/ext-all.js"/>
                <@script name="js/ext/ext-lang-zh_CN.js"/>
                <script language="javascript">Ext.BLANK_IMAGE_URL = "${base}/js/ext/resources/images/default/s.gif";</script>
        </#switch>
    </#list>
</head>
<body>
    <#nested/>
</body>
</html>
</#macro>

<#macro print>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <@style name="css/print.css"/>
</head>
<body>
<object id="webPrint" height="0" width="0" classid="clsid:DC2A3C42-24DC-4FD6-836A-A2E8594ABC15"
        codebase="ocx/ReYoPrint.CAB#version=2009,1215,0,858"></object>
<script type="text/javascript">
    if (!webPrint.defaultPrinterName) {
        document.write('<div style="margin:10px;font-size:16px;"><a href="ocx/ReYoPrint.zip">未找到打印控件，请下载安装</a></div>');
    }
</script>
    <#nested/>
</body>
</html>
</#macro>

<#macro export>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
</head>
<body>
<script type="text/javascript">
</script>
    <#nested/>
</body>
</html>
</#macro>

<#macro main title="国图档案管理系统" import="">
    <@html title=title import="${import},base,main,superfish">
    <div id="container">
        <#if !hideBanner?? || !hideBanner>
            <div id="header" class="clearfix header${ctx.hasEnv('xian.enable')?string(' header-xian','')}">
            <#--<#if a3d??>-->
            <#--<div id="top-mode">-->
            <#--<a href="index.action" class="btn mode-normal<#if !a3d> active</#if>"></a>-->
            <#--<a href="index!a3d.action" class="btn mode-3d<#if a3d> active</#if>"></a>-->
            <#--<#if a3d><a href="3d/index.jsp" class="max" target="_blank">最大化</a></#if>-->
            <#--</div>-->
            <#--</#if>-->

                <ul id="sfnav" class="sf-menu">
                    <li class="root">
                        <a href="index.action">首页</a>
                    </li>
                    <#if a3d??>
                        <li class="root">
                            <a href="#">查看模式</a>
                            <ul>
                                <li>
                                    <a href="index.action">普通模式</a>
                                </li>
                                <li>
                                    <a href="index!a3d.action">3D模式</a>
                                </li>
                                <#if a3d>
                                    <li>
                                        <a href="3d/index.jsp">最大化</a>
                                    </li>
                                </#if>
                            </ul>
                        </li>
                    </#if>
                    <li class="root">
                        <a href="#">管理配置</a>
                        <ul>
                            <#if ctx.isAdmin()>
                                <li><a href="admin/model.action">业务设置</a></li>
                                <li><a href="admin/tree.action">分类管理</a></li>
                                <li><a href="admin/permission.action">权限管理</a></li>
                                <#if !ctx.hasEnv('jiangyin.enable')>
                                    <li><a href="admin/ajh.action">目录号分配</a></li>
                                </#if>
                                <li><a href="loan.action">借阅管理</a></li>
                                <#if ctx.hasEnv('jurong.enable')||ctx.hasEnv('jiangyin.enable')>
                                    <li><a href="#" onclick="setFr3()">打印模版设置</a></li>
                                </#if>
                            <#else>
                                <#if sysPerms??>
                                    <#if sysPerms['loan']??>
                                        <li><a href="loan.action">借阅管理</a></li>
                                    </#if>
                                    <#if sysPerms['ajhManage']??>
                                        <li><a href="admin/ajh.action">目录号分配</a></li>
                                    </#if>
                                    <#if sysPerms['mlhManage']??>
                                        <li><a href="admin/mlh.action">目录号管理</a></li>
                                    </#if>
                                </#if>
                                <#if ctx.hasEnv('jurong.enable')||ctx.hasEnv('jiangyin.enable')>
                                    <li><a href="#" onclick="setFr3()">打印模版设置</a></li>
                                </#if>
                            </#if>
                            <#if ctx.hasEnv('jiangyin.enable')>
                                <li><a href="/tddj/queryTDZ.action">土地证查询</a></li>
                                <li><a href="generic.action">档案管理</a></li>
                            </#if>
                        </ul>
                    </li>
                    <#if ctx.hasEnv('huCha.enable')>
                        <li class="root">
                            <a href="#">档案互查</a>
                            <ul>
                                <#if abs??>
                                    <#list abs as ab>
                                        <#if ab.name??>
                                            <li><a href="scrutiny.action?dwdm=${ab.value}&itemId=${ab.itemId}"
                                                   target="_blank">${ab.name}</a></li>
                                        </#if>
                                    </#list>
                                <#else>
                                    <li><a href="#">尚未配置互查单位，请联系管理员</a></li>
                                </#if>

                            </ul>
                        </li>
                    </#if>
                    <#if sysPerms??>
                        <#if sysPerms['statistics']??>
                            <li class="root">
                                <a href="#">档案统计</a>
                                <ul>
                                    <#if ctx.hasEnv("jiangyin.enable")>
                                        <li><a href="report.action?type=loan_static" target="_blank">欠档情况统计</a></li>
                                        <li><a href="report.action?type=jiangyin_lytj" target="_blank">档案利用情况统计</a></li>
                                        <li><a href="report.action?type=jiangyin_static" target="_blank">存档情况统计</a></li>
                                    <#--<li><a href="report.action?type=jiangyin_static_bymo" target="_blank">月度情况统计</a></li>-->
                                    <#else >
                                        <li><a href="report.action?type=static">档案统计</a></li>
                                    </#if>
                                </ul>
                            </li>
                        </#if>
                    </#if>
                    <#if ctx.hasEnv('jurong.enable')>
                        <li class="root">
                            <a href="#">打印模版设置</a>
                            <ul>
                                <li><a href="#" onclick="localPrint()">本地打印模版</a></li>
                                <li><a href="#" onclick="serverPrint()">服务器打印模版</a></li>
                            </ul>
                        </li>
                    </#if>
                <#--<li class="root">-->
                <#--<a href="#">当前用户：${userName}</a>-->
                <#--</li>-->
                    <li class="root">
                        <a href="#">当前用户:${userName!}</a>
                        <ul>
                            <li><a href="#" onclick="passwordManager()">修改密码</a></li>
                            <li><a href="logout.action">注销</a></li>
                        </ul>
                    </li>
                <#--<li class="root">-->
                <#--<a href="logout.action">注销</a>-->
                <#--</li>-->
                </ul>
            <#--<div id="top-menu">-->
            <#--<a href="index.action">首页</a> | <a href="logout.action">注销</a>-->
            <#--</div>-->
            </div>
        <#else>
            <div class="header-hide"><a href="index.action">首页</a></div>
        </#if>

        <div id="tbody">
            <br/>
            <#nested/>
            <br/>
        </div>

        <div id="footer">&copy;2010 档案管理系统</div>
    </div>
    <script type="text/javascript">

        function setFr3() {
            var localFr3 = new Ext.form.Radio({
                boxLabel:'本地打印模版',
                inputValue:'local',
                checked:window.localStorage.printType == "Local" ? true : false,
                listeners:{
                    'check':function () {
                        if (localFr3.getValue()) {
                            serverFr3.setValue(false);
                            localFr3.setValue(true);
                        }
                    }
                }
            });
            var serverFr3 = new Ext.form.Radio({
                boxLabel:'服务器打印模版',
                inputValue:'server',
                checked:window.localStorage.printType == "Server" ? true : false,
                listeners:{
                    'check':function () {
                        if (serverFr3.getValue()) {
                            localFr3.setValue(false);
                            serverFr3.setValue(true);
                        }
                    }
                }
            });

            var selectTpl = new Ext.Panel({
                labelWidth:90,
                frame:true,
                border:false,
                buttonAlign:'center',
                labelAlign:'center',
                bodyStyle:'padding:5px',
                items:[
                    {
                        xtype:'radiogroup',
                        fieldLabel:'打印模版类型',
                        id:'typeRadio',
                        items:[
                            localFr3, serverFr3
                        ]
                    }
                ],
                buttons:[
                    {
                        text:'选择本地模版路径',
                        handler:function () {
                            if (serverFr3.getValue() || !localFr3.getValue()) return;
                            try {
                                debugger;
                                var Message = "请选择本地模版所在文件夹"; //选择框提示信息
                                var Shell = new ActiveXObject("Shell.Application");
                                var Folder = Shell.BrowseForFolder(0, Message, 0); //起始目录为：桌面
                                if (Folder != null) {
                                    debugger;
                                    Folder = Folder.items();
                                    Folder = Folder.item();
                                    Folder = Folder.Path;
                                    if (Folder.charAt(Folder.length - 1) != "\\") {
                                        Folder = Folder + "\\";
                                    }
                                    window.localStorage.localPath = Folder;
                                }
                            }
                            catch (e) {
                                if (e.message == "ActiveXObject is not defined") {
                                    alert("请使用IE内核的浏览器，建议IE8+");
                                } else if (e.message == "没有权限") {
                                    alert("没有权限,请修改当前浏览器安全设置");
                                } else {
                                    alert(e.message)
                                }
                            }
                        }
                    },
                    {
                        text:'确定',
                        handler:function () {
                            if (localFr3.getValue()) {
                                window.localStorage.printType = "Local";
                            } else if (serverFr3.getValue()) {
                                window.localStorage.printType = "Server";
                            }
                            pWin.close();

                        }
                    }
                ]
            });


            var pWin = new Ext.Window({
                title:'设置打印模版',
                closable:true,
                modal:true,
                width:350,
                layout:'auto',
                border:false,
                resizable:false,
                items:selectTpl
            });
            pWin.show();

        }

        function passwordManager() {
            debugger;
            var passWordPanel=new Ext.Panel({
                labelWidth:250,
                frame:true,
                border:false,
                bodyStyle:'padding:5px',
                html:'<table border="0"><tr><th>原密码:</th><td><input id="oldPassword" type="password" /></td></tr><tr><th>新密码:</th><td><input id="newPassword" type="password" /></td></tr><tr><th>确认新密码:</th><td><input id="confirmation" type="password" /></td></tr><div id="mssg" style="display:none"></div></table>',
                buttons:[
                    {
                        text:'确定',
                        handler:function () {
                            var newPd=$("#newPassword").val();
                            var newPdC=$("#confirmation").val();
                            var oldPd=$("#oldPassword").val();
                            if(newPd!=newPdC){
                                $("#mssg").html("两次输入的新密码不一样，请确认!");
                                $("#mssg").css("display","block");
                            }else if(newPd==""){
                                $("#mssg").html("新密码不可为空!");
                                $("#mssg").css("display","block");
                            }else{
                                $("#mssg").css("display","none");
                                Ext.Ajax.request({
                                    url:'archive!changePassword.action',
                                    params:{oldPassWord:oldPd,passWord:newPd},
                                    success:function (r) {
                                        debugger;
                                        var key = Ext.decode(r.responseText);
                                        if(key.result!="success"){
                                            $("#mssg").html(key.mssg);
                                            $("#mssg").css("display","block");
                                        }else{
                                            $("#mssg").html(key.mssg);
                                            $("#mssg").css("display","block");
                                            setTimeout(function(){
                                                window.location.href='logout.action';
                                            },1000);

//                                            window.open('logout.action');
//                                            location.href="logout.action";
                                            //注销当前登录
                                        }

                                    }
                                });
                            }
                        }
                    },
                    {
                        text:'关闭',
                        handler:function () {
                            pWin.close();
                        }
                    }
                ]
            });
            var pWin = new Ext.Window({
                title:'修改密码',
                closable:true,
                modal:true,
                width:250,
                layout:'auto',
                border:false,
                resizable:false,
                items:passWordPanel
            });
            pWin.show();
        }

    </script>
    </@html>
</#macro>

<#macro check title="国图档案管理系统互查" import="">
    <@html title=title import="${import},base,main">
    <div id="container">
        <div id="header" class="clearfix header">
            <div id="top-mode">
            </div>
        </div>
        <div id="tbody">
            <br/>
            <#nested/>
            <br/>
        </div>

        <div id="footer">&copy;2010 档案管理系统</div>
    </div>
    </@html>
</#macro>

<#macro admin title="国图档案管理系统管理工具" import="">
    <@html title=title import="jquery,base,admin,${import}">
    <div id="container">
        <div id="header" class="clearfix">
            <div id="top-menu">
                <a href="${base}/index.action">首页</a> | <a href="${base}/logout.action">注销</a>
            </div>
        </div>
        <div id="tbody">
            <table cellpadding="0" cellspacing="0" style="width:100%;">
                <tr>
                    <td id="side-menu">
                        <ul>
                            <#if ctx.isAdmin()>
                                <li${(tab??&&tab=='model')?string(' class="current"','')}><a
                                        href="${base}/admin/model.action" class="icon1">业务管理</a></li>
                                <li${(tab??&&tab=='dict')?string(' class="current"','')}><a
                                        href="${base}/admin/dict.action" class="icon2">字典管理</a></li>
                                <li${(tab??&&tab=='tree')?string(' class="current"','')}><a
                                        href="${base}/admin/tree.action">分类管理</a></li>
                                <li${(tab??&&tab=='permission')?string(' class="current"','')}><a
                                        href="${base}/admin/permission.action">权限管理</a></li>
                            </#if>
                            <li${(tab??&&tab=='ajh')?string(' class="current"','')}><a
                                    href="${base}/admin/ajh.action"><#if ctx.hasEnv('jiangyin.enable')>目录号分配<#else >
                                案卷号管理</#if></a></li>
                            <#if ctx.hasEnv('mlhManager.enable')>
                                <li${(tab??&&tab=='mlh')?string(' class="current"','')}><a
                                        href="${base}/admin/mlh.action">目录号管理</a></li>
                            </#if>
                            <#if ctx.isAdmin()>
                                <li${(tab??&&tab=='props')?string(' class="current"','')}><a
                                        href="${base}/admin/props.action">变量管理</a></li>
                                <li><a href="${ctx.env['solr.url']}/console.do" target="_blank">索引管理</a></li>
                                <li${(tab??&&tab=='system')?string(' class="current"','')}><a
                                        href="${base}/admin/system.action">系统设置</a></li>
                                <#if ctx.hasEnv('xian.enable')>
                                    <li${(tab??&&tab=='og')?string(' class="current"','')}>
                                    <li${(tab??&&tab=='sq')?string(' class="current"','')}><a
                                            href="${base}/admin/xian/sq.action">授权列表</a></li>
                                    <li${(tab??&&tab=='dl')?string(' class="current"','')}><a
                                            href="${base}/admin/xian/dl.action">操作日志</a></li>
                                    <li${(tab??&&tab=='kybg')?string(' class="current"','')}><a
                                            href="${base}/admin/xian/kybg.action">可研报告管理</a></li>
                                    <li${(tab??&&tab=='kgda')?string(' class="current"','')}><a
                                            href="${base}/admin/xian/kgda.action">控规档案管理</a></li></#if>
                            </#if>
                        </ul>
                    </td>
                    <td id="content"><#nested/></td>
                </tr>
            </table>
        </div>
        <div id="footer">&copy;2010 国图档案管理系统</div>
    </div>
    </@html>
</#macro>

<#macro form title="" import="">
    <@html title=title import="base,jquery,form,ext,${import}">
        <#nested/>
    <script type="text/javascript">
        var ss = '${state}';
        $(function () {
            debugger;
            $("form").validationEngine();
            if (parent.onResize)
                parent.onResize(document.documentElement.scrollWidth, document.documentElement.scrollHeight);
            if (ss == "2") {
                $("#f-qzh").attr("readonly", "readonly");
                $("#f-ajh").attr("readonly", "readonly");
                $("#f-mlh").attr("readonly", "readonly");
                $("#f-bgqx").attr("readonly", "readonly");
                $("#f-bgqx").attr("disabled", "true");
            }
        });
        function doSubmit() {
            $("form").submit();
        }
        function getArchiveId() {
            return $("form")[0].id.value;
        }

        function backNow() {
            $("#loan-entity_BackNow").val(true);
        }

        function reSetWh() {
            var fwlx = $("#f-fwlx").val();
            var nd = $("#f-nd").val();
            $("#f-wh").val(fwlx + "【" + nd + "】");
            var modelName = $("#generic-entity_modelName").val();
            Ext.Ajax.request({
                url:'generic-entity!getValue.action',
                params:{modelName:modelName, fwlx:fwlx},
                success:function (rp) {
                    var info = rp.responseText;
                    $("#f-djh").val(info);
                }
            });
        }

        function reSetAjh() {
            debugger;
            var currentMlh = $("#archive-entity_currentMlh").val();
            var mlh = $("#archive-entity_mlh").val();
            if (mlh == currentMlh) {
                $("#f-ajh").val($("#archive-entity_currentAjh").val());
                return;
            }

            var modelName = $("#archive-entity_modelName").val();
            var id = $("#archive-entity_id").val();
            Ext.Ajax.request({
                url:'archive-entity!reSetAjh.action',
                params:{mlh:mlh, modelName:modelName, id:id},
                success:function (rp) {
                    debugger;
                    var info = rp.responseText.substr(1, rp.responseText.length - 2).split(",");
                    var tmp = info[0];
                    var bgqx = info[3];
                    $("#f-ajh").val(tmp);
                    $("#archive-entity_ajhRange_id").val(info[1]);
                    $("#archive-entity_ajhRange_currentValue").val(info[2]);
                    $("#f-bgqx").val(bgqx);

                }
            });
        }

        function reSetMlh(bgqx) {
            debugger;
            if (!bgqx)
                return;
            var currentMlh = $("#archive-entity_currentMlh").val();
            var currentAjh = $("#archive-entity_currentAjh").val();
            var mlh = $("#archive-entity_mlh").val();
//        if(mlh==currentMlh){
//            $("#f-ajh").val($("#archive-entity_currentAjh").val());
//            return ;
//        }

            var modelName = $("#archive-entity_modelName").val();
            var id = $("#archive-entity_id").val();
            Ext.Ajax.request({
                url:'archive-entity!reSetMlh.action',
                params:{mlh:mlh, modelName:modelName, id:id, bgqx:bgqx},
                success:function (rp) {
                    debugger;
                    var info = rp.responseText.substr(1, rp.responseText.length - 2).split(",");
                    if (info.length != 4) {
                        alert(info[0]);
                    } else {
                        if (info[3] == currentMlh) {
                            $("#f-mlh").val(currentMlh);
                            $("#f-ajh").val(currentAjh);
                        } else {
                            var tmp = info[0];
                            var mlh = info[3];
                            $("#f-ajh").val(tmp);
                            $("#archive-entity_ajhRange_id").val(info[1]);
                            $("#archive-entity_ajhRange_currentValue").val(info[2]);
                            $("#f-mlh").val(mlh);
                        }

                    }
                }
            });
        }


        function changeValue(a, b) {
            var id = "#f-" + b;
            $(id).val(a);
        }

        function selectChange(a, b) {
            var selectId = "#" + b;
            var textId = "#" + a;
            $(textId).val($(selectId).val());
        }
    </script>
    </@html>
</#macro>

<#macro script name>
<script src="${base}/${name}" type="text/javascript"></script>
</#macro>

<#macro style name>
<link href="${base}/${name}" type="text/css" media="screen" rel="stylesheet"/>
</#macro>