<@layout.admin import="form,ext">
<@layout.style name="js/ext/ux/treegrid.css"/>
<@layout.script name="js/ext/ux/TreeGridSorter.js"/>
<@layout.script name="js/ext/ux/TreeGridColumnResizer.js"/>
<@layout.script name="js/ext/ux/TreeGridNodeUI.js"/>
<@layout.script name="js/ext/ux/TreeGridLoader.js"/>
<@layout.script name="js/ext/ux/TreeGridColumns.js"/>
 <@layout.script name="js/ext/ux/TreeGrid.js"/>
<@s.form action="item!edit"><#if item.id??><@s.hidden name="item.id"/></#if><@s.hidden name="dictName"/>
    <#if msg?? && msg='existed'><div class="errMsg">保存失败，${item.name!}已存在</div></#if>
    <#if msg?? && msg='successed'><div class="tipMsg">保存成功</div></#if>
<div class="list-title"><#if item.id??>编辑<#else>新建</#if>项&nbsp;&nbsp;<@s.submit value="保 存"/>&nbsp;<input type="button" value="返 回" onclick="location.href='item.action?dictName=${dictName}';"/></div>
<table class="form-table">
    <tr>
        <th>名称</th>
        <td><@s.textfield name="item.name" size="50" cssClass="validate[required]"/></td>
    </tr>
    <tr>
        <th>值</th>
        <td><@s.textfield name="item.value" size="50"/></td>
    </tr>
        <tr>
        <th>顺序号</th>
        <td><@s.textfield name="item.orderNumber" size="50"  cssClass="validate[onlyInteger]"/></td>
    </tr>
        <tr>
        <th>备注</th>
        <td><@s.textfield name="item.remark" readonly="${isCheck?string}" size="50"/></td>
        <#if isCheck>
            <td><input type="button" value="设置互查业务权限" onclick="showEditTree()"/></td>
        </#if>
    </tr>
    <tr>
        <th>父条目序号</th>
        <td><@s.textfield name="item.parentId" readonly="${IsCheck?string}" size="50"/></td>
    </tr>
</table>
</@s.form>
<textarea id="permission-tpl" style="display:none;">
    <div style="padding:3px;">
        <tpl for="data">
            <input type="checkbox" onchange="checkChange(this.checked,this.name)" name="{name}" class="perm-box" <tpl if="checked"> checked="checked"</tpl>
            >{text}&nbsp;
        </tpl>
    </div>
</textarea>
<script type="text/javascript">

    $(function() {
        $("#item").validationEngine();
    });
    /**
     * 互查配置
     */
   <#if isCheck>
    var checked=initChecked();
    var json=${treeJson};
    var treeGrid;
    function showEditTree(){
        treeGrid =new Ext.ux.tree.TreeGrid({
            enableSort:false,
            forceFit:true,
            width:700,
            columns:[
                {
                    header: '分类',
                    dataIndex: 'text',
                    width:700 * 0.4
                },
                {
                    header: '权限',
                    dataIndex: 'data',
                    width:700 * 0.55,
                    tpl:Ext.XTemplate.from('permission-tpl')
                }
            ],
            root:new Ext.tree.AsyncTreeNode({
                id:'rootNode',
                text: '根分类',
                iconCls:'root',
                children:json
            })
        });
        var ogWin = new Ext.Window({
            title:'互查业务权限配置',
            closable:false,
            modal:true,
            width:710,
            height:500,
            layout:'fit',
            border:false,
            resizable:false,
            buttons:[
                {
                    text:'保存',
                    handler:function () {
                     //将权限写到remark中
                     var str="{\"items\": [";
                     for(var i=0;i<checked.length;i++){
                           var item;
                           var id=checked[i].split("_")[0];
                           var perm=checked[i].split("_")[1];
                           item="{\"id\":\""+id+"\",\"perm\":\""+perm+"\"}";
                           str+=item;
                           if(i!=checked.length-1)
                               str+=","
                     }
                            str+="]}";
                     if(str=="{\"items\": []}"){
                          $("#item_item_remark").val("");
                     }else{
                          $("#item_item_remark").val(str);
                     }
                     ogWin.close();
                    }
                },
                {
                    text:'关闭',
                    handler:function () {
                        checked=initChecked();
                        ogWin.close();
                    }
                }
            ],
            items:treeGrid
        });
        ogWin.show();
    }
   </#if>
    /**
     * 权限变化时
     * @param a
     * @param b
     */
    function checkChange(a,b){
        if(a){
            if(getArrayIndex(checked,b)==-1)
                checked.push(b);
        }else{
            if(getArrayIndex(checked,b)!=-1)
                checked.splice(getArrayIndex(checked,b),1);
        }
    }

    function getArrayIndex(a,b){
        for(var i=0;i< a.length;i++){
             if(b==a[i])
                return i;
        }
        return -1;
    }

    function initChecked(){
        debugger;
        var remark=$("#item_item_remark").val();
        if(remark==""){
            return [];
        }else{
            var jsonObject=Ext.decode(remark);
            var array=jsonObject.items;
            var temp=[];
            for(var i=0;i<array.length;i++){
                temp.push(array[i].id+"_"+array[i].perm);
            }
            return temp;
        }
    }
</script>
</@layout.admin>