/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.gtis.archive.core.web.BaseEntityAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.service.ArchiveService;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DocEntityAction
extends BaseEntityAction<Document> {
    @Autowired
    private ArchiveService archiveService;
    private String archiveId;
    private String state;
    private String insertId;

    public String getState() {
        if (StringUtils.isBlank((String)this.state)) {
            return "";
        }
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void prepare() {
        if (StringUtils.isBlank((String)this.id)) {
            this.entity = this.archiveService.newDocument(this.modelName);
            String cid = (String)this.session.get("currentDId");
            Document lastDocument = null;
            Document insertedDocument = null;
            if (cid != null) {
                lastDocument = this.archiveService.getDocument(this.modelName, cid);
            }
            if (this.insertId != null) {
                insertedDocument = this.archiveService.getDocument(this.modelName, this.insertId);
            }
            if (lastDocument != null) {
                try {
                    PropertyUtils.copyProperties((Object)this.entity, (Object)lastDocument);
                    ((Document)this.entity).setSxh(Integer.valueOf(((Document)this.entity).getSxh() + 1));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                ((Document)this.entity).setId(null);
            }
            if (insertedDocument != null && insertedDocument.getSxh() != null) {
                ((Document)this.entity).setSxh(insertedDocument.getSxh());
            }
        } else {
            this.entity = this.archiveService.getDocument(this.modelName, this.id);
            if (this.archiveId == null) {
                this.archiveId = ((Document)this.entity).getArchiveId();
            }
        }
        if (this.entity != null && this.archiveId != null) {
            try {
                Archive archive = this.archiveService.getArchive(this.modelName, this.archiveId);
                ((Document)this.entity).setArchive(archive);
            }
            catch (Exception ex) {
                this.logger.debug(ex.toString());
            }
        }
    }

    protected void preSave() {
    }

    protected void doSave(Document entity) {
        this.archiveService.saveDocument(entity);
        if (StringUtils.isNotBlank((String)this.insertId)) {
            List documentList = this.archiveService.getArchiveDocuments(this.modelName, this.archiveId, entity.getSxh().intValue(), entity.getId());
            for (Document document : documentList) {
                document.setSxh(Integer.valueOf(document.getSxh() + 1));
                this.archiveService.saveDocument(document);
            }
        }
    }

    protected String getJsCallBack() {
        return "onDocumentComplete";
    }

    protected void afterSave() {
        this.session.put("currentDId", ((Document)this.entity).getId());
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getInsertId() {
        return this.insertId;
    }

    public void setInsertId(String insertId) {
        this.insertId = insertId;
    }
}

