/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.gtis.archive.Constants;
import com.gtis.archive.core.dict.Item;
import com.gtis.archive.core.environment.EnvHolder;
import com.gtis.archive.core.ex.ModelNotFoundException;
import com.gtis.archive.core.ex.NoPermissionException;
import com.gtis.archive.core.ex.TemplateNotFoundException;
import com.gtis.archive.core.web.BaseModelAction;
import com.gtis.archive.entity.Archive;
import com.gtis.archive.entity.Document;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.ArchiveService;
import com.gtis.archive.service.ExtTreeService;
import com.gtis.archive.service.OriginalService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import com.gtis.archive.util.Struts2Utils;
import com.gtis.common.Page;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

public class DocAction
extends BaseModelAction<Document> {
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ExtTreeService treeService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private OriginalService originalService;
    @Autowired
    private SysUserService userService;
    private String treeId;
    private String type;
    private String archiveId;
    private String linkField;
    private List<Map> dataTpl;
    private Map docArchive;

    public void setModelName(String modelName) {
        super.setModelName(Archive.toDocumentModelName((String)modelName));
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public String getType() {
        return this.type;
    }

    public String getPermJson() {
        List operations = this.dictService.getItems("operationPerm");
        HashMap<String, Boolean> perm = new HashMap<String, Boolean>();
        for (Item item : operations) {
            if (!this.securityService.isPermitted(this.treeId, item.getName())) continue;
            perm.put(item.getName(), true);
        }
        return JSON.toJSONString(perm);
    }

    public List<Map<String, Object>> getTree() {
        return this.treeService.getTree(null, new String[]{"model"});
    }

    public String execute() throws Exception {
        Document doc;
        if (StringUtils.isNotEmpty((String)this.modelName)) {
            Resource res = this.resourceService.findChildResource(null, Document.toArchiveModelName((String)this.modelName), new String[]{"model"});
            if (res != null) {
                this.treeId = res.getId();
                if (!this.securityService.isPermitted(this.treeId, "view")) {
                    throw new NoPermissionException(this.modelName);
                }
            } else {
                throw new ModelNotFoundException(this.modelName);
            }
        }
        this.modelService.getModel(this.modelName);
        String id = this.getId();
        if (id != null && (doc = this.archiveService.getDocument(this.modelName, id)) != null) {
            this.type = doc.getArchiveId() == null ? "wlj" : "ylj";
        }
        return "success";
    }

    protected Page<Document> searchEntity(List<Criterion> criterions, List<Order> orders) {
        if (StringUtils.isNotEmpty((String)this.archiveId)) {
            if (EnvHolder.isEnable((String)"jiangyin.enable")) {
                List documents;
                criterions.clear();
                criterions.add((Criterion)Restrictions.eq((String)"archiveId", (Object)this.archiveId));
                if (EnvHolder.isEnable((String)"dwdm.enable") && !SessionUtil.getCurrentUser().isAdmin()) {
                    criterions.add((Criterion)Restrictions.eq((String)"dwdm", (Object)this.getDwdm()));
                }
                if ((documents = this.entityService.search(Archive.toDocumentModelName((String)this.modelName), criterions, orders, 0, -1).getItems()).size() > 0) {
                    ((Document)documents.get(0)).setArchive(this.archiveService.getArchive(this.modelName, this.archiveId));
                }
                return new Page(documents);
            }
            return new Page(this.entityService.search(Archive.toDocumentModelName((String)this.modelName), Collections.singletonList(Restrictions.eq((String)"archiveId", (Object)this.archiveId)), orders, 0, -1).getItems());
        }
        if (EnvHolder.isEnable((String)"jiangyin.enable")) {
            if (EnvHolder.isEnable((String)"dwdm.enable") && !SessionUtil.getCurrentUser().isAdmin()) {
                criterions.add((Criterion)Restrictions.eq((String)"dwdm", (Object)this.getDwdm()));
            }
            Page page = super.searchEntity(criterions, orders);
            for (Document document : page.getItems()) {
                if (StringUtils.isNotBlank((String)document.getArchiveId())) {
                    document.setArchive(this.archiveService.getArchive(this.modelName, document.getArchiveId()));
                }
                document.setHasOriginal(Boolean.valueOf(this.originalService.hasOriginal(document.getId())));
            }
            return page;
        }
        return super.searchEntity(criterions, orders);
    }

    protected List<Criterion> createCriterions(ArrayList<Criterion> criterions) {
        if (this.type == null || !this.type.equals("all")) {
            criterions.add("ylj".equals(this.type) ? Restrictions.isNotNull((String)"archiveId") : Restrictions.isNull((String)"archiveId"));
        }
        return super.createCriterions(criterions);
    }

    protected List<Order> createOrders(ArrayList<Order> orders) {
        List superOrders = super.createOrders(orders);
        if (superOrders.size() > 0) {
            return superOrders;
        }
        if (StringUtils.isNotEmpty((String)this.archiveId)) {
            orders.add(Order.desc((String)"sxh"));
        }
        orders.add(Order.desc((String)"id"));
        return super.createOrders(orders);
    }

    public Map getDocArchive() {
        try {
            if (this.docArchive == null) {
                this.docArchive = JSON.parseObject((String)JSON.toJSONString((Object)this.archiveService.getArchive(this.modelName, this.archiveId), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                this.docArchive.remove("id");
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.toString());
        }
        return this.docArchive;
    }

    public String getLinkField() {
        if (this.linkField == null) {
            try {
                this.linkField = this.archiveService.getDocumentModel(this.modelName).getTemplate("linkField");
            }
            catch (ModelNotFoundException ex) {
            }
            catch (TemplateNotFoundException ex) {
                this.linkField = "tm";
            }
        }
        return this.linkField;
    }

    public String insertDocumnets() {
        if (this.dataTpl == null) {
            try {
                this.dataTpl = JSON.parseArray((String)this.archiveService.getDocumentModel(this.modelName).getTemplate("dataTpl"), Map.class);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.archiveId != null && this.dataTpl != null) {
            int currentSxh = this.archiveService.getArchiveDocumentLastSxh(Document.toArchiveModelName((String)this.modelName), this.archiveId);
            for (Map map : this.dataTpl) {
                Document document = this.archiveService.newDocument(Document.toArchiveModelName((String)this.modelName));
                for (Map.Entry entry : map.entrySet()) {
                    try {
                        Map.Entry pro = entry;
                        if ("rq".equals(pro.getKey().toString())) {
                            PropertyUtils.setProperty((Object)document, (String)pro.getKey().toString(), (Object)Constants.DATE_FORMAT.parse(pro.getValue().toString()));
                            continue;
                        }
                        PropertyUtils.setProperty((Object)document, (String)pro.getKey().toString(), pro.getValue());
                    }
                    catch (Exception ex) {}
                }
                document.setSxh(Integer.valueOf(currentSxh + this.dataTpl.indexOf(map) + 1));
                document.setDwdm(this.getDwdm());
                document.setArchiveId(this.archiveId);
                this.archiveService.saveDocument(document);
            }
            this.renderJson((Object)"success");
        } else {
            this.renderJson((Object)"failed");
        }
        return null;
    }

    private String getDwdm() {
        String dwdm = (String)Struts2Utils.getSessionAttribute((String)"__dwdm");
        if (dwdm == null) {
            dwdm = this.userService.getUserRegionCode(SessionUtil.getCurrentUserId());
            Struts2Utils.getSession().setAttribute("__dwdm", (Object)dwdm);
        }
        return dwdm;
    }
}

