/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.service.impl;

import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.PermissionService;
import com.gtis.archive.service.ResourceService;
import com.gtis.archive.service.SecurityService;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SecurityServiceImpl
implements SecurityService {
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private PermissionService permissionService;

    public boolean isPermitted(String permissionString) {
        String[] arr = StringUtils.split((String)permissionString, (String)":");
        if (arr.length < 2) {
            return false;
        }
        String[] names = StringUtils.split((String)arr[0], (String)".");
        String[] operations = StringUtils.split((String)arr[0], (String)",");
        if (names.length == 0 || operations.length == 0) {
            return false;
        }
        Resource res = this.resourceService.getResource(null, names);
        for (String op : operations) {
            if (this.permissionService.hasPermission(res.getId(), op)) continue;
            return false;
        }
        return true;
    }

    public boolean isPermitted(String resourceId, String operation) {
        while (resourceId != null) {
            if (this.permissionService.hasPermission(resourceId, operation)) {
                return true;
            }
            Resource res = this.resourceService.getResource(resourceId, new String[0]);
            if (res == null) {
                return false;
            }
            resourceId = res.getParentId();
        }
        return false;
    }

    public Set<String> getReadableRoleIds(String resourceId) {
        HashSet<String> set = new HashSet<String>();
        while (resourceId != null) {
            set.addAll(this.permissionService.getReadableRoleIds(resourceId));
            resourceId = this.resourceService.getResource(resourceId, new String[0]).getParentId();
        }
        return set;
    }
}

