/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.service.impl;

import com.gtis.archive.core.cache.Cache;
import com.gtis.archive.entity.Resource;
import com.gtis.archive.service.ResourceService;
import com.gtis.support.hibernate.HibernateTemplate;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.HibernateTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class ResourceServiceImpl
extends HibernateTemplate<Resource, String>
implements ResourceService {
    private Cache cache;
    @Autowired
    private HibernateTransactionManager transactionManager;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public List<Resource> getChildrenResource(String parentId, String ... name) {
        Resource res = this.getResource(parentId, name);
        if (res == null) {
            return Collections.emptyList();
        }
        return this.internalGetChildResources(res.getId());
    }

    public List<Resource> getChildrenResourceRecursively(String id, String ... name) {
        List children = this.getChildrenResource(id, new String[0]);
        for (Resource rs : children) {
            if (rs.getChildren() != null) continue;
            this.getChildrenResourceRecursively(rs.getId(), new String[0]);
        }
        return children;
    }

    public Resource getResource(String id, String ... name) {
        Resource res;
        Resource resource = res = id != null ? this.internalGetResource(id) : null;
        if (name == null) {
            return res;
        }
        for (String n : name) {
            res = this.internalGetChildResource(id, n);
            if (res != null) continue;
            return null;
        }
        this.getSession().evict((Object)res);
        return res;
    }

    public Resource findChildResource(String id, String targetName, String ... name) {
        Resource res = this.getResource(id, name);
        if (res != null) {
            return this.internalfindChildResource(res.getId(), targetName);
        }
        return null;
    }

    private Resource internalfindChildResource(String id, String targetName) {
        List list = this.internalGetChildResources(id);
        for (Resource res : list) {
            if (!res.getName().equals(targetName)) continue;
            return res;
        }
        for (Resource res : list) {
            Resource res1 = this.internalfindChildResource(res.getId(), targetName);
            if (res1 == null) continue;
            return res1;
        }
        return null;
    }

    @Transactional
    public void removeResource(String id) {
        List children = this.getChildrenResource(id, new String[0]);
        for (Resource rs : children) {
            this.removeResource(rs.getId());
            this.cache.remove(new String[]{rs.getId()});
        }
        Resource res = this.getResource(id, new String[0]);
        this.delete((Serializable)((Object)id));
        this.cache.remove(new String[]{id});
        if (res.getParentId() != null) {
            this.getResource(res.getParentId(), new String[0]).setChildren(null);
        }
    }

    @Transactional
    public Resource saveResource(Resource resource) {
        this.save((Object)resource);
        if (resource.getParentId() != null) {
            this.getResource(resource.getParentId(), new String[0]).setChildren(null);
        }
        return resource;
    }

    private Resource internalGetChildResource(String parentId, String name) {
        List children;
        Resource res = this.internalGetResource(parentId);
        List list = children = res == null ? null : res.getChildren();
        if (children != null) {
            for (Resource r : children) {
                if (!r.getName().equals(name)) continue;
                return r;
            }
        } else {
            if (parentId == null && (res = (Resource)this.cache.get(new Serializable[]{name})) != null) {
                return res;
            }
            children = this.createCriteria(new Criterion[]{parentId == null ? Restrictions.isNull((String)"parentId") : Restrictions.eq((String)"parentId", (Object)parentId), Restrictions.eq((String)"name", (Object)name)}).addOrder(Order.desc((String)"orderNumber")).list();
            if (children.size() > 0) {
                res = (Resource)children.get(0);
                this.cache.put((Object)res);
                if (parentId == null) {
                    this.cache.put((Object)name, (Object)res);
                }
                return res;
            }
        }
        return null;
    }

    private Resource internalGetResource(String id) {
        if (id == null) {
            return null;
        }
        Resource res = (Resource)this.cache.get(new Serializable[]{id});
        if (res == null && (res = (Resource)this.get((Serializable)((Object)id))) != null) {
            this.getSession().evict((Object)res);
            this.cache.put((Object)res);
        }
        return res;
    }

    private List<Resource> internalGetChildResources(String parentId) {
        Resource res = this.internalGetResource(parentId);
        if (res != null) {
            List children = res.getChildren();
            if (children != null) {
                return children;
            }
            children = this.createCriteria(new Criterion[]{Restrictions.eq((String)"parentId", (Object)parentId)}).addOrder(Order.desc((String)"orderNumber")).list();
            res.setChildren(children);
            for (Resource res1 : children) {
                this.cache.put((Object)res1);
            }
            return children;
        }
        return null;
    }

    public synchronized void init() {
        block5: {
            Resource resource = this.getResource(null, new String[]{"model"});
            if (resource != null) {
                return;
            }
            TransactionStatus status = null;
            try {
                status = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
                resource = new Resource();
                resource.setName("model");
                resource.setTitle("\u6a21\u578b\u6839\u8282\u70b9");
                this.save((Object)resource);
                this.transactionManager.commit(status);
            }
            catch (TransactionException ex) {
                this.logger.error(ex.getLocalizedMessage());
                if (status == null) break block5;
                try {
                    this.transactionManager.rollback(status);
                }
                catch (TransactionException e) {
                    // empty catch block
                }
            }
        }
    }
}

