/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.service.impl;

import com.gtis.search.EntityIndexProvider;
import com.gtis.search.Index;
import com.gtis.search.IndexManager;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ArchiveIndexListener
implements PostInsertEventListener,
PostDeleteEventListener,
PostUpdateEventListener,
BeanPostProcessor {
    private static final long serialVersionUID = 5859744034324984631L;
    @Autowired
    private EntityIndexProvider indexProvider;
    @Autowired
    private IndexManager indexManager;

    public Object postProcessBeforeInitialization(Object bean, String s) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String s) throws BeansException {
        if (bean instanceof EntityIndexProvider) {
            this.indexProvider = (EntityIndexProvider)bean;
        } else if (bean instanceof IndexManager) {
            this.indexManager = (IndexManager)bean;
        }
        return bean;
    }

    public void onPostDelete(PostDeleteEvent event) {
        Index index = this.indexProvider.toIndex(event.getEntity());
        if (index != null) {
            this.indexManager.remove(new String[]{index.getId()});
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        this.doUpdate(event.getEntity());
    }

    public void onPostUpdate(PostUpdateEvent event) {
        this.doUpdate(event.getEntity());
    }

    private void doUpdate(Object entity) {
        Index index = this.indexProvider.toIndex(entity);
        if (index != null) {
            this.indexManager.update(new Index[]{index});
        }
    }
}

