/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.gtis.archive.entity.Original;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="t_original_permission")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class OriginalPermission {
    @Id
    @GeneratedValue(generator="sort-uuid")
    @GenericGenerator(name="sort-uuid", strategy="com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length=32)
    private String id;
    @Column(length=100, nullable=false)
    private String userId;
    @Column(length=100)
    private String userName;
    @Column(length=100)
    private String authorizer;
    @Column(length=100, nullable=false)
    private String originalId;
    private Date createTime;
    private Date expireTime;
    @Column(length=100, nullable=false)
    private String operation;
    @ManyToOne
    @JoinColumn(name="originalId", insertable=false, updatable=false)
    private Original original;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAuthorizer() {
        return this.authorizer;
    }

    public void setAuthorizer(String authorizer) {
        this.authorizer = authorizer;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    @JSONField(format="yyyy-MM-dd")
    public Date getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public Original getOriginal() {
        return this.original;
    }

    public void setOriginal(Original original) {
        this.original = original;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OriginalPermission)) {
            return false;
        }
        OriginalPermission p = (OriginalPermission)obj;
        return this.userId != null && this.userId.equals(p.getUserId()) && this.operation != null && this.operation.equals(p.getOperation()) && this.originalId != null && this.originalId.equals(p.getOriginalId());
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.userId.hashCode();
        hash = hash * 31 + this.originalId.hashCode();
        hash = hash * 31 + this.operation.hashCode();
        return hash;
    }

    public String toString() {
        return "[" + this.userId + "," + this.originalId + "," + this.operation + "]";
    }
}

