/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.entity;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="t_original")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Original {
    public static final String MODEL_NAME = Original.class.getSimpleName();
    public static final String[] IMAGE_POSTFIX = new String[]{"gif", "bmp", "jpg", "jpeg", "png"};
    public static final String[] THUMB_POSTFIX = new String[]{"gif", "bmp", "jpg", "jpeg", "png", "psd", "dwg", "tif"};
    public static final String[] X_OFFICE_POSTFIX = new String[]{"docx", "xlsx", "pptx"};
    public static final String[] PDF_POSTFX = new String[]{"pdf"};
    @Id
    @GeneratedValue(generator="sort-uuid")
    @GenericGenerator(name="sort-uuid", strategy="com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length=32)
    private String id;
    @Column(length=1000)
    private String name;
    @Column(length=1000, nullable=false)
    private String path;
    @Column(nullable=false)
    private long fileSize;
    @Column(length=4000)
    private String fullText;
    @Column
    private Date updateTime;
    @Column(length=32, nullable=false)
    private String ownerId;
    @Column(length=10)
    private String ownerModelName;
    @Column(length=10)
    private String status;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JSONField(serialize=false)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFullText() {
        return this.fullText;
    }

    public void setFullText(String fullText) {
        this.fullText = fullText;
    }

    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerModelName() {
        return this.ownerModelName;
    }

    public void setOwnerModelName(String ownerModelName) {
        this.ownerModelName = ownerModelName;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isImage() {
        String postfix = this.getExtension();
        for (String s : IMAGE_POSTFIX) {
            if (!s.equals(postfix)) continue;
            return true;
        }
        return false;
    }

    public boolean isXOffice() {
        String postfix = this.getExtension();
        for (String s : X_OFFICE_POSTFIX) {
            if (!s.equals(postfix)) continue;
            return true;
        }
        return false;
    }

    public boolean isPDF() {
        String postfix = this.getExtension();
        for (String s : PDF_POSTFX) {
            if (!s.equals(postfix)) continue;
            return true;
        }
        return false;
    }

    public String getExtension() {
        int index = this.getName().lastIndexOf(46);
        return index > -1 ? this.getName().substring(index + 1).toLowerCase() : "";
    }

    public String getOFFICEContentType(String extension) {
        if (extension != "") {
            if (extension.contains("doc")) {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
            if (extension.contains("xls")) {
                return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            }
            if (extension.contains("ppt")) {
                return "application/vnd.ms-powerpoint";
            }
        }
        return "application/vnd.openxmlformats";
    }

    public boolean canMakeThumb() {
        String postfix = this.getExtension();
        for (String s : THUMB_POSTFIX) {
            if (!s.equals(postfix)) continue;
            return true;
        }
        return false;
    }
}

