/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="t_ajh_range")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class AjhRange {
    @Id
    @GeneratedValue(generator="sort-uuid")
    @GenericGenerator(name="sort-uuid", strategy="com.gtis.archive.core.support.hibernate.UUIDHexGenerator")
    @Column(length=32)
    private String id;
    @Column(length=100, nullable=false)
    private String modelName;
    @Column(length=100)
    private String dwdm;
    @Column(length=10)
    private String year;
    @Column(length=100, nullable=false)
    private String mlh;
    @Column(nullable=false)
    private int minValue;
    @Column
    private Integer maxValue;
    @Column(nullable=false)
    private int currentValue;
    @Column
    private Integer orderNumber;
    @Column
    private String bgqx;

    public int getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(int currentValue) {
        this.currentValue = currentValue;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public String getMlh() {
        return this.mlh;
    }

    public void setMlh(String mlh) {
        this.mlh = mlh;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getDwdm() {
        return this.dwdm;
    }

    public void setDwdm(String dwdm) {
        this.dwdm = dwdm;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public Integer getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(Integer orderNumber) {
        this.orderNumber = orderNumber;
    }

    public int getNextValue() {
        return this.currentValue + 1;
    }

    public int getRemainCount() {
        if (this.maxValue == null) {
            return -1;
        }
        if (this.maxValue <= this.currentValue) {
            return 0;
        }
        return this.maxValue - this.currentValue;
    }

    public boolean hasExhausted() {
        return this.maxValue != null && this.maxValue <= this.currentValue;
    }

    public void increaseCurrentValue() {
        ++this.currentValue;
    }

    public String getBgqx() {
        return this.bgqx;
    }

    public void setBgqx(String bgqx) {
        this.bgqx = bgqx;
    }
}

