/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.archive.core.support.hibernate;

import com.gtis.archive.core.support.hibernate.ReloadableLocalSessionFactoryBean;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.TypeHelper;
import org.hibernate.classic.Session;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.stat.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadableSessionFactory
implements SessionFactory {
    private static final long serialVersionUID = 1590291600523676145L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SessionFactory sessionFactory;
    private ReloadableLocalSessionFactoryBean fb;

    public ReloadableSessionFactory(SessionFactory sessionFactory, ReloadableLocalSessionFactoryBean reloadableLocalSessionFactoryBean) {
        this.sessionFactory = sessionFactory;
        this.fb = reloadableLocalSessionFactoryBean;
    }

    public Reference getReference() throws NamingException {
        return this.sessionFactory.getReference();
    }

    public Session openSession(Connection connection) {
        return this.sessionFactory.openSession(connection);
    }

    public Session openSession(Interceptor sessionLocalInterceptor) throws HibernateException {
        return this.sessionFactory.openSession(sessionLocalInterceptor);
    }

    public Session openSession(Connection connection, Interceptor sessionLocalInterceptor) {
        return this.sessionFactory.openSession(connection, sessionLocalInterceptor);
    }

    public Session openSession() throws HibernateException {
        return this.sessionFactory.openSession();
    }

    public Session getCurrentSession() throws HibernateException {
        return this.sessionFactory.getCurrentSession();
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.sessionFactory.getClassMetadata(persistentClass);
    }

    public ClassMetadata getClassMetadata(String entityName) throws HibernateException {
        return this.sessionFactory.getClassMetadata(entityName);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return this.sessionFactory.getCollectionMetadata(roleName);
    }

    public Map<String, ClassMetadata> getAllClassMetadata() throws HibernateException {
        return this.sessionFactory.getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return this.sessionFactory.getAllCollectionMetadata();
    }

    public Statistics getStatistics() {
        return this.sessionFactory.getStatistics();
    }

    public void close() throws HibernateException {
        this.sessionFactory.close();
    }

    public boolean isClosed() {
        return this.sessionFactory.isClosed();
    }

    public Cache getCache() {
        return this.sessionFactory.getCache();
    }

    public void evict(Class persistentClass) throws HibernateException {
        this.sessionFactory.evict(persistentClass);
    }

    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.sessionFactory.evict(persistentClass, id);
    }

    public void evictEntity(String entityName) throws HibernateException {
        this.sessionFactory.evictEntity(entityName);
    }

    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        this.sessionFactory.evictEntity(entityName, id);
    }

    public void evictCollection(String roleName) throws HibernateException {
        this.sessionFactory.evictCollection(roleName);
    }

    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.sessionFactory.evictCollection(roleName, id);
    }

    public void evictQueries() throws HibernateException {
        this.sessionFactory.evictQueries();
    }

    public void evictQueries(String cacheRegion) throws HibernateException {
        this.sessionFactory.evictQueries(cacheRegion);
    }

    public StatelessSession openStatelessSession() {
        return this.sessionFactory.openStatelessSession();
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return this.sessionFactory.openStatelessSession(connection);
    }

    public Set getDefinedFilterNames() {
        return this.sessionFactory.getDefinedFilterNames();
    }

    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return this.sessionFactory.getFilterDefinition(filterName);
    }

    public boolean containsFetchProfileDefinition(String name) {
        return this.sessionFactory.containsFetchProfileDefinition(name);
    }

    public TypeHelper getTypeHelper() {
        return this.sessionFactory.getTypeHelper();
    }

    public synchronized void reload() {
        SessionFactory newSessionFactory = null;
        try {
            newSessionFactory = this.fb.rebuildSessionFactory();
        }
        catch (Exception e) {
            this.logger.error("reload hibernate error", (Throwable)e);
            throw new RuntimeException("reload hibernate error:{}", e);
        }
        finally {
            SessionFactory oldSessionFactory = this.sessionFactory;
            if (newSessionFactory != null) {
                this.sessionFactory = newSessionFactory;
                this.logger.info("reload hibernate successed:{}", (Object)this.sessionFactory.getAllClassMetadata());
                try {
                    oldSessionFactory.close();
                }
                catch (HibernateException e) {
                    this.logger.error("close hibernate error", (Throwable)e);
                }
            }
        }
    }
}

