/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.monitoring;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import dagger.producers.monitoring.ProducerMonitor;
import dagger.producers.monitoring.ProducerTimingRecorder;
import java.util.concurrent.TimeUnit;

final class TimingProducerMonitor
extends ProducerMonitor {
    private final ProducerTimingRecorder recorder;
    private final Stopwatch stopwatch;
    private final Stopwatch componentStopwatch;
    private long startNanos = -1L;

    TimingProducerMonitor(ProducerTimingRecorder recorder, Ticker ticker, Stopwatch componentStopwatch) {
        this.recorder = recorder;
        this.stopwatch = Stopwatch.createUnstarted((Ticker)ticker);
        this.componentStopwatch = componentStopwatch;
    }

    @Override
    public void methodStarting() {
        this.startNanos = this.componentStopwatch.elapsed(TimeUnit.NANOSECONDS);
        this.stopwatch.start();
    }

    @Override
    public void methodFinished() {
        long durationNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        this.recorder.recordMethod(this.startNanos, durationNanos);
    }

    @Override
    public void succeeded(Object o) {
        long latencyNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        this.recorder.recordSuccess(latencyNanos);
    }

    @Override
    public void failed(Throwable t) {
        if (this.stopwatch.isRunning()) {
            long latencyNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            this.recorder.recordFailure(t, latencyNanos);
        } else {
            this.recorder.recordSkip(t);
        }
    }
}

