
FR.ESTrans = {
    getFSRoles : function() {
        return this.ajax({
            url : FR.servletURL + "?op=fs_set&cmd=auth_getallrolefores"
        });
    },

    getFSRoleAuth : function(role) {
        var task;
        var url = FR.servletURL + "?op=fs_set&cmd=";
        if (role.postid != null || role.departmentid != null) {
            url += "auth_getjes"
        } else {
            url += "auth_getses"
        }
        return this.ajax({
            data : {id : role.id},
            url : url
        });
    },

    getPlatFormRoles: function() {
        var roles;
        FR.ajax({
            url:FR.servletURL,
            type:"POST",
            data:{"op":"excel_submit","cmd":"get_pl_roles","_":new Date().getTime()},
            dataType:"json",
            async: false,
            complete: function(res, status) {
                if (status == 'success') {
                    roles = FR.jsonDecode(res.responseText);
                } else {
                    FR.Msg.toast("AnalysisData Error!");
                }
            }
        });
        return roles;
    },

    setFSRoles : function(allRole) {
        var success = true;
        for (var i=0; i<allRole.length; i++) {
            var role = allRole[i];
            var task = role.esTask;
            var oldArr = role.esTask_backup_ids;
            var newArr = [];
            for (var k=0; k<task.length; k++) {
                newArr.push(task[k].id);
            }
            var privilege = this.checkPrivilegeArray(oldArr, newArr);
            if (!privilege.add || !privilege.remove) {
                continue;
            }
            for (var k=0; k<privilege.add.length; k++) {
                privilege.add[k] = '2' + privilege.add[k];
            }
            for (var k=0; k<privilege.remove.length; k++) {
                privilege.remove[k] = '2' + privilege.remove[k];
            }
            var result = this.setFSRoleAuth(role, privilege);
            if (result === false) {
                success = false;
            }
        }
        return success;
    },

    setFSRoleAuth: function(role, reportPrivilege) {
        var s = true;
        var url = FR.servletURL + "?op=fs_set&cmd=";
        if (role.postid != null || role.departmentid != null) {
            url += "auth_addjes"
        } else {
            url += "auth_addses"
        }
        this.ajax({
            returnString : true,
            data : {
                role : role,
                reports_add : reportPrivilege.add ? reportPrivilege.add : [],
                reports_remove : reportPrivilege.remove ? reportPrivilege.remove : []
            },
            url : url
        });
        return s;
    },

    setPlatFormRoles: function(allRole, roles_bak) {
//        var success = true;
//        FR.ajax({
//            url:FR.servletURL + "?op=excel_submit&cmd=set_pl_roles",
//            data:{auth_role:FR.jsonEncode(allRole)},
//            async : false,
//            complete : function(res, status) {
//                if (status != 'success') {
//                    success = false;
//                }
//            }
//        })
//        return success;
        var success = true;
        var cur_role_names = $.map(allRole, function(role) {
            return role.roleName;
        });
        // ȿǷнɫɾ
        for (var i=0; i<roles_bak.length; i++) {
            if (cur_role_names.indexOf(roles_bak[i]) === -1) {
                var result = this.setPlatFromRoleAuth({roleName: roles_bak[i]}, {}, 2);
                if (result === false) {
                    success = false;
                }
            }
        }
        // 洦ӵĽɫ޸˵Ľɫ ɫбпܱ޸
        for (var i=0; i<allRole.length; i++) {
            var role = allRole[i];
            var task = role.esTask;
            var state = 0;
            var privilege;
            if (!role.esTask_backup_item) {
                state = 1;
                privilege = {};
                privilege.add = $.map(role.esTask, function(task) {
                    return task.reportpath;
                });
            } else {
                var oldArr = $.map(role.esTask_backup_item, function(task) {
                    return task.id;
                });
                var newArr = [];
                for (var k=0; k<task.length; k++) {
                    newArr.push(task[k].id);
                }
                privilege = this.checkPrivilegeArray(oldArr, newArr);
                if (!privilege.add || !privilege.remove) {
                    continue;
                }
                privilege.add = $.map($.grep(role.esTask, function(task) {
                    return (privilege.add).indexOf(task.id) !== -1;
                }), function(task) {
                    return task.reportpath;
                })
                privilege.remove = $.map($.grep(role.esTask_backup_item, function(task) {
                    return (privilege.remove).indexOf(task.id) !== -1;
                }), function(task) {
                    return task.reportpath;
                })
            }
            var result = this.setPlatFromRoleAuth(role, privilege, state);
            if (result === false) {
                success = false;
            }
        }
        return success;
    },

    setPlatFromRoleAuth: function(role, reportPrivilege, state) {
        // state : 0 change 1 add 2 delete
        var success = true;
        FR.ajax({
            url:FR.servletURL + "?op=excel_submit&cmd=set_pl_role",
            data: {
                roleName: role.roleName,
                newRoleName: role.value,
                reports_add : reportPrivilege && reportPrivilege.add ? reportPrivilege.add : [],
                reports_remove : reportPrivilege && reportPrivilege.remove ? reportPrivilege.remove : [],
                state: state
            },
            async : false,
            complete : function(res, status) {
                if (status != 'success') {
                    success = false;
                }
            }
        })
        return success;
    },

    ajax : function(config) {
        if (config.key != null && this.cache(config.key) != null) {
            return this.cache(config.key);
        }
        config.data = FR.cjkEncodeDO(config.data);
        var self = this, returnData;
        $.ajax({
            url : config.url,
            async : false,
            data : config.data,
            type : config.type ? config.type : 'POST',
            beforeSend : config.beforeSend,
            error : config.error,
            complete : function(res, status) {
                try {
                    returnData = config.returnString ? res.responseText : FR.jsonDecode(res.responseText);
                } catch(Error) {
                    FR.Msg.toast("AnalysisData Error!");
                }

                if (config.key && returnData) {
                    self.cache(config.key, returnData);
                }
            }
        });
        return returnData;
    },

    checkPrivilegeArray : function(baseArray, newArray) {
   		var result = {};
   		if (baseArray && newArray) {
   			var add = result.add = [];
   			var remove = result.remove = [];
   			baseArray = baseArray.sort();
   			newArray = newArray.sort();

   			var bi = 0, ni = 0;
   			var cr = 0;
   			for (; bi < baseArray.length && ni < newArray.length; bi++) {
   				cr = baseArray[bi] - newArray[ni];
   				while (cr > 0) {
   					add[add.length] = newArray[ni];
   					ni ++;
   					if (ni >= newArray.length) {
   						break;
   					}
   					cr = baseArray[bi] - newArray[ni];
   				}
   				if (ni >= newArray.length) {
   					break;
   				}
   				if (cr === 0) {
   					ni ++;
   				} else {
   					remove[remove.length] = baseArray[bi];
   				}
   			}

   			for (; bi < baseArray.length; bi++) {
   				remove[remove.length] = baseArray[bi];
   			}
   			for (; ni < newArray.length; ni++) {
   				add[add.length] = newArray[ni];
   			}
   			// һ
   			if ((add.length - remove.length) != (newArray.length - baseArray.length)) {
   				throw "checkPrivilegeArray error!";
   			}
   		}

   		return result;
   	}
}