//view.js
;
$.extend(FR.ViewPane.prototype, function () {
    var P = {
        isLoadingPage:-1,
        selectedIndex:-1,

        /*
         * alex:ʼContentPane
         */
        initContentPane:function () {
            //alex:write.css
            FR.$defaultImport('/com/fr/view/web/css/view.css', 'css');
            if (this.options.writeCss) {
                $.each(this.options.writeCss, function (i, item) {
                    FR.$import(item, 'css');
                });
            }

            //FR.$import('css/write.css', 'css');
            var tabPane = this.$contentPane.data("TabPane");
            var self = this;
            if (tabPane) {//jamesTabPane
                //jamesTabPanetabchange¼
                tabPane.on(FR.Events.TABCHANGE, function (tabPane, tabIndex) {
                	self.selectedIndex = tabIndex;
                    self.fireEvent(FR.Events.TABCHANGE, tabPane, tabIndex);
                });
                //jamesǰFormPanetabchange¼ִtabchange
                this.on(FR.Events.TABCHANGE, function (tabPane, tabIndex) {
                    if (self.delay) {
                        return;
                    }
                    self.selectedIndex = tabIndex;
                    var lgp = self.lgps[tabIndex];
                    if (lgp.reloaded === true) {
                        lgp.loadLGPPane(true);
                        lgp.reloaded = false;
                    } else if (lgp.loaded === false) {
                        lgp.loadLGPPane();
                    } else {
                    	$(window).resize();
                        // Carlôܲ
                        self.curLGP = lgp;
                    }

                    self.selectedIndex = lgp.idx;
                });

                var tabs = tabPane.options.tabs;//jamesȡtabsĸ
                this.lgps = [];
                for (var i = 0, count = tabs.length; i < count; i++) {
                    this.lgps[i] = new FR.ALGP({idx:i, $container:$(tabs[i].content), viewPane:this, selectMethod:this.selectMethod});
                }

                //tabPane.invisible();
            } else {
                this.lgps = [new FR.ALGP({idx:0, $container:this.$contentPane, viewPane:this, selectMethod:this.selectMethod})];
            }
        },

        /*
         * ʼContentPane
         */
        loadContentPane:function () {
        	
            var tabPane = this.$contentPane.data("TabPane");
            if (tabPane) {
                tabPane.visible();
            }

            if (this.lgps == null || this.lgps.length === 0) {
                return;
            }
            $.each(this.lgps, function (idx, lgp) {
                lgp.loaded = false;
            });
            if (this.curLGP == null) {
                // ҳ滹ûʼ лڶsheet ٵѯťҳ Ҫloadڶsheet
                if (this.selectedIndex > 0) {
                    this.curLGP = this.lgps[this.selectedIndex];
                } else {
                    this.curLGP = this.lgps[0];
                    this.selectedIndex = 0;
                }
            }
            this.delay = false;
            this.curLGP.loadLGPPane();
        },

        // carl:sheetreload  fec:reloadҪһʼselectĸ
        reloadCurLGPPane:function (fec) {
            if (this.lgps == null || this.lgps.length === 0) {
                return;
            }
            if (this.curLGP == null) {
                return;
            }
            this.curLGP.loaded = false;
            if (fec) {
                this.curLGP.fec = fec;
            }
            this.curLGP.loadLGPPane();
        },

        pageSetup:function () {
            this.showPageSetupDialog({sessionID:this.currentSessionID, reportIndex:this.curLGP.idx});
        },
        printReportServer:function () {
            FR.showIframeDialog({
                title:FR.i18nText("ReportServerP-Print[Server]"),
                width:540,
                height:300,
                url:FR.servletURL + "?op=fr_dialog&cmd=read_print_server_dialog&sessionID=" + this.currentSessionID + "&pn=" + this.currentPageIndex
            });
        },
        emailReport:function () {
            if (this.fireEvent(FR.Events.BEMAIL) === false) {
                return;
            }
            var self = this;
            FR.showEmailDialog({sessionID:this.currentSessionID, onFinish : function(){
                self.fireEvent(FR.Events.AEMAIL);
            }});
        },
        pdfPrint:function (isPopup) {
            if (this.fireEvent(FR.Events.BPDFPRINT) === false) {
                return;
            }
            if ($.browser.msie) {
                FR.doPDFPrint(this.currentSessionID, isPopup);
            } else {
                // jamespdfPrintҪformat=pdfPrintʶΪǴӡ״̬
                window.location = FR.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=pdf&isPDFPrint=true&extype=ori";
                this.fireEvent(FR.Events.APDFPRINT);
            }
        },
        appletPrint:function () {
            FR.doAppletPrint(this.currentSessionID);
        },
        flashPrint:function () {
            FR.doFlashPrint(this.currentSessionID, this.currentPageIndex);
        },
        exportReportToPDF:function (extype) {
            if (this.fireEvent(FR.Events.BTOPDF) === false) {
                return;
            }
            window.location = FR.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=pdf&extype=" + extype;
            this.fireEvent(FR.Events.ATOPDF);
        },
        exportReportToImage:function (extype) {
            if (this.fireEvent(FR.Events.BTOIMAGE) === false) {
                return;
            }
            window.location = FR.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=image&extype=" + extype;
            this.fireEvent(FR.Events.ATOIMAGE);
        },
        exportReportToExcel:function (extype) {
            if (this.fireEvent(FR.Events.BTOEXCEL) === false) {
                return;
            }
            // carl:Ūʾ
            if (extype == 'ldpage') {
                FR.Msg.alert(FR.i18nText("Tooltips"), FR.i18nText("Export-Excel-LargeData-Page-Info"));
            }
            window.location = FR.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=excel&extype=" + extype;
            this.fireEvent(FR.Events.ATOEXCEL);
        },
        exportReportToWord:function () {
            if (this.fireEvent(FR.Events.BTOWORD) === false) {
                return;
            }
            window.location = FR.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=word";
            this.fireEvent(FR.Events.ATOWORD);
        },
        exportReportToHtml:function () {
            if (this.fireEvent(FR.Events.BTOHTML) === false) {
                return;
            }
            window.location = FR.servletURL + "?op=export&sessionID=" + this.currentSessionID + "&format=html";
            this.fireEvent(FR.Events.ATOHTML);
        },
        printPreview:function () {
            window.open(FR.servletURL + "?op=print_preview&cmd=pw_init_page&__pi__=false&__singlesheet__=true&reportIndex=" + this.curLGP.idx + "&sessionID=" + this.currentSessionID, "_blank", "Scrollbar=yes,Resizable=yes,fullscreean=yes");
        },

        // alex:frozen
        frozen:function (column, row) {
            this.curLGP.frozen(column, row);
        },

        SetPrinterOffset:function () {
            FR.showIframeDialog({
                title:FR.i18nText("SetPrinterOffset"),
                width:420,
                height:300,
                url:FR.servletURL + "?op=printer_offset&cmd=pt_open&sessionID=" + this.currentSessionID
            });
        }
    };

    return P;
}());

FR.TreeNode = {
    initNode:function (el) {
        var $el = $(el);

        var treenode = this.createTreeNode($el.parent(), $el.text());

        treenode.treeNodeClick();
    },

    createTreeNode:function ($dom, text) {
        var $wapper = $dom;
		if (!$dom.attr("tree")) {
			try {
				if ($.browser.msie && parseInt($.browser.version) <= 8) {
					$dom.click();
				}
			} catch(e) {
			}
			$dom = $dom.parent();
		}
        var editorConfig = FR.jsonDecode($dom.attr('tree'));
        editorConfig.width = $dom.attr("width");
        editorConfig.height = $dom.attr("height");
		editorConfig.text = text;
		
        $wapper.html("");
		$editor = $("<div/>").appendTo($wapper);
        editorConfig.renderEl = $editor;
        if (editorConfig.jspath) {
            var arr = editorConfig.jspath.split(";");
            $.each(arr, function (i, item) {
                FR.$import(item, "js");
            });
        }
        if (editorConfig.csspath) {
            var arr = editorConfig.csspath.split(";");
            $.each(arr, function (i, item) {
                FR.$import(item, "css");
            });
        }

        var editorEl = FR.createWidget(editorConfig);

        return editorEl;
    }
};

/*
 * alex:FormLoGicalPane
 */
FR.ALGP = function (config) {
    config = config || {};
    this.initialConfig = config;
    $.extend(this, config);

    this.loaded = false;
};

FR.extend(FR.ALGP, FR.OB, function () {
    //default IE
    var tadjst = -1, ladjst = -1, wadjst = 3, hadjst = 3, etadjst = 0, eladjst = 1, ewadjst = -1, ehadjst = +2;
    if ($.browser.mozilla || $.browser.opera) {//firefox or opera
        tadjst = -2, ladjst = -2, wadjst = -3, hadjst = -3, etadjst = 0, eladjst = 0, ewadjst = -1, ehadjst = +1;
    } else if ($.browser.safari || $.browser.chrome) {//for safari and chrome
        tadjst = -1, ladjst = -1, wadjst = -3, hadjst = -3, etadjst = 0, eladjst = 0, ewadjst = +1, ehadjst = +3;
    }
    var UP = 1, DOWN = 2, LEFT = 3, RIGHT = 4, EE = FR.keyCode;// KeyCodeд
    function isCell(dom) {
        var $dom = $(dom);
        return $dom.is('td') && $dom.attr('id') && $dom.attr('id').match(/^[A-Z]+\d+-\d+-\d+$/);
    }

    return {
        /**
         * $container, content actually be added, which is a jQuery Object, the contentPane or the selected tab of the TabPane
         */
        $container:null,
        /**
         * writePane:FR.WritePane this lgp belongs to
         */
        viewPane:null,
        /*
         * idx in writePane
         */
        idx:0,

        keyevent:null,

        viewArray:{},
        /*
         * Panel
         */
        loadLGPPane:function (recal) {
            if (this.viewPane.isLoadingPage == this.idx) {
                return;
            }

            this.viewPane.fireEvent(FR.Events.STARTLOAD, this);
            this.viewPane.isLoadingPage = this.idx;

            // alex:ǿinnerHTMLΪַ,jQuery.html()empty(),ܷʱ
            // ͻˢ·ȹ˰
//	    	this.$container[0].innerHTML = "";
            var ps = {op:"fr_view", cmd:"view_content", sessionID:this.viewPane.currentSessionID, reportIndex:this.idx, iid:Math.random()};
            if (recal) {
                ps.recal = 'true';
            }
            this.$container.__load__({
                url:FR.servletURL,
                timeout:600000,
                // richerһ⻺Ӱ
                params:ps,
                callback:function (el, success, res, options) {
                    if (success) {
                        this.initLGPComponent();
                    } else {
                        //ɹĻ,ҲҪѱϢдҳ
                        this.$container.html(res.responseText);
                    }

                    this.viewPane.curLGP = this;

                    //fire formPaneafterload¼,thisΪȥ
                    this.viewPane.fireEvent(FR.Events.AFTERLOAD, this);

                    // alex:this.$containerΪǰformPane.ContentContainer
                    this.viewPane.$currentContentContainer = this.$container;

                    this.viewPane.isLoadingPage = -1;

                    if (FR.isMobileApp() && !FR.isMobileAppNoZoom()) {
                        if(isPoly !== "true") {
                            $(".sheet-container", this.$container).outerWidth();
                            $(".sheet-container", this.$container).css({
                                width:$(".sheet-container", this.$container).children().width(),
                                height:$(".sheet-container", this.$container).children().height()
                            });

                            //new iScroll(this.$container[0]);
                            var contentContainer = $('.content-container');
                            contentContainer.css('position', 'relative');

                            var $sheetContainer = $(".sheet-container", this.$container);
                            contentContainer.width($sheetContainer.width());
                            contentContainer.height($sheetContainer.height());
                            contentContainer.css('overflow', 'hidden');
                        }
                    } else if (FR.isMobileBrowser() && !FR.isMobileBrowserNoZoom()) {
                        FR.MobileTools.largeWidth($('.x-table', this.$container).width());
                    }

//                    if (FR.isMobile()) {
//                        var $fc = this.$sheet_container.children(":first"), my = this;
//                        var recal = function () {
//                            my.$sheet_container.css({width:$fc.width(), height:$fc.height()});
//                            //new iScroll(my.$container[0]);
//                        }
//                        recal();
//                        this.viewPane.on("refresh", function () {
//                            recal();
//                        })
//                    }
                    delete this.loaded;
                }.createDelegate(this)
            });
        },

        /*
         * ʼLGPComponent
         */
        initLGPComponent:function () {
            this.$sheet_container = $('.sheet-container', this.$container);

            var config = {
                type:"fr_form",
                selector:'td[widget]'
            };
            this.form = this.$sheet_container.asComponent(config);

            this.$scrollable = this.$container; // ùΪ$container
            var $center = $('.frozen-center', this.$container);
            // richer:жŰlayout
            if ($center.length > 0) {
                FR.layoutFrozen(this.$sheet_container, this.$sheet_container.offset().top);
                //wei : bug5374
                this.$container.css({
                    overflow:'hidden'
                });
                // alex:겼ֺһdoLayout
                this.$scrollable = $center;

                if ($.browser.msie && parseInt($.browser.version) < 8) {
                    var initCell = function (element, ano_row_ranges) {
                        var row_ranges = [];
                        row_ranges[0] = 0;
                        var $trs = element.find('tbody:eq(0)').children();
                        var $tr;
                        var row_size = row_ranges.length;
                        $.each($trs, function (idx, tr) {
                            $tr = $(tr);
                            if (ano_row_ranges) {
                                var h = ano_row_ranges[idx + row_size] - ano_row_ranges[idx + row_size - 1];
                                if (tr.offsetHeight != h) {
                                    $tr.css("height", parseInt($tr.css("height")) + h - tr.offsetHeight);
                                }
                            } else {
                                row_ranges[idx + row_size] = row_ranges[idx + row_size - 1] + tr.offsetHeight;
                            }
                        });
                        return row_ranges;
                    };

                    var f_corner = $('.frozen-corner', this.$container);
                    if (f_corner.length > 0) {
                        var row_ranges = initCell($('.frozen-north', this.$container));
                        initCell(f_corner, row_ranges);
                    }

                    var row_ranges = initCell($center);
                    initCell($('.frozen-west', this.$container), row_ranges);
                }
            }
            var self = this;

            this.$table = $('.x-table', this.$container);
            // denny: tableID, ʶԪΨһԡ
            this.tableID = this.$table.attr("id");
            this.$fD = {};
            this.$fD.ftop = $('.fDtop', this.$container);
            this.$fD.fleft = $('.fDleft', this.$container);
            this.$fD.fbottom = $('.fDbottom', this.$container);
            this.$fD.fright = $('.fDright', this.$container);
            this.$fD.fdot = $('.fDdot', this.$container);

            this.table_width = this.$table.find("colgroup:eq(0)").children().length;
            this.table_height = this.$table.find('tbody:eq(0)').children().length;

            // Ϊ$sheet¼
            // alex:ѡеĳӽ༭״̬,ԭmousedown¼,$editorComponent.focus
            if (!FR.isMobileApp()) {
	            this.$sheet_container.click(function (e) {
	                self.getSelectTDCellFromMouseEvent(e);
	            });
	            
	            this.contextMenu = this.createContextMenu();
	            this.contextMenu.containerPane = this;
	            this.contextMenu.reset();
	            this.menuExpand = null;
	            this.fiArray = null;//ѯť, ʼʱɸѡҼ˵,Ȼϴεɸѡ˵
	
	            // carl:û趨Ҫѡĸ
	            if (this.fec) {
	                self.selectTDCell(this.getTDCell(this.fec));
	            }
            }
//            else {
//                this.$container.css("padding-top", "25px");
//            }
            
            if (FR.isMobileBrowser() && !FR.isMobileBrowserNoZoom()) {
            	FR.MobileTools.largeWidth($('.x-table', this.$sheet_container).width());
            }
        },

        getSelectTDCellFromMouseEvent:function (e) {
            var src = e.target;
            var secell;
            // ܵ˸ڲʲôĬѡ

            if (!isCell(src)) {
                var $td = $(src).parents('td:eq(0)')
                if ($td.length > 0 && isCell($td[0])) {
                    secell = $td[0];
                }
            } else {
                secell = src;
            }
            if (secell) {
                this.selectTDCell(secell);
            }
            if (this.contextMenu) {
                if ($(src).parents('.fr-ui-core-menu:eq(0)').length <= 0) {
                    this.contextMenu.close();
                }
            }
        },

        createContextMenu:function () {
            return {
                minWidth:220,
                cur_fi:null,
                containerPane:null,
                container:null,
                submenus:[],
                cItems:[],

                reset:function () {
                    this.container = null;
                    this.submenus = [];
                    this.cItems = [];
                    this.cur_fi = null;
                },

                init:function (lgp) {
              		if ($('.fr-ui-core-menu').length > 0) {
	 					$('.fr-ui-core-menu').remove();
					}
					
                    this.container = $("<div class='fr-ui-core-menu view-menu'>")
                        .css('display', 'none').css("z-index", 10).appendTo(lgp.$sheet_container);

                    var self = this;
                    var menu = [];
                    var submenu = [];
                    submenu[0] = {iconSrc:"css:x-emb-ascend", showIconSrc:true, showTextSrc:true,
                        src:FR.i18nText("Sort-Ascending") + ' ', handler:function () {
                        lgp.sort(0, 0);
                        self.close();
                    }};
                    submenu[1] = {iconSrc:"css:x-emb-descend", showIconSrc:true, showTextSrc:true,
                        src:FR.i18nText("Sort-Descending") + ' ', handler:function () {
                        lgp.sort(1, 0);
                        self.close();
                    }};
                    menu[0] = {iconSrc:"css:x-emb-sort", showIconSrc:true, showTextSrc:true,
                        src:FR.i18nText("Sort") + "(" + FR.i18nText("PageSetup-Portrait") + ") ", handler:function () {
                    }};
                    menu[0].submenu = submenu;

                    this.addItem(menu[0]);

                    submenu = [];
                    submenu[0] = {iconSrc:"css:x-emb-ascend", showIconSrc:true, showTextSrc:true,
                        src:FR.i18nText("Sort-Ascending") + ' ', handler:function () {
                        lgp.sort(0, 1);
                        self.close();
                    }};
                    submenu[1] = {iconSrc:"css:x-emb-descend", showIconSrc:true, showTextSrc:true,
                        src:FR.i18nText("Sort-Descending") + ' ', handler:function () {
                        lgp.sort(1, 1);
                        self.close();
                    }};
                    menu[1] = {iconSrc:"css:x-emb-sort", showIconSrc:true, showTextSrc:true,
                        src:FR.i18nText("Sort") + "(" + FR.i18nText("PageSetup-Landscape") + ") ", handler:function () {
                    }};
                    menu[1].submenu = submenu;

                    this.addItem(menu[1]);

                    menu[2] = {iconSrc:"css:x-emb-filter", showIconSrc:true, showTextSrc:true,
                        src:FR.i18nText("Selection-Filter"), handler:function () {
                        lgp.popFilterPane(self.cur_fi);
                        self.close();
                    }};

                    this.addItem(menu[2]);

                    menu[3] = {showTextSrc:true, src:FR.i18nText("Clear") + FR.i18nText("Selection-Filter"), handler:function () {
                        self.containerPane.doFilter(false, true);
                        self.close();
                    }};
                    this.addItem(menu[3]);
//                    this.addItem({type : 'seq'});

                    menu[4] = {iconSrc:"css:x-emb-filter", showIconSrc:true, showTextSrc:true,
                        src:FR.i18nText("List-Filter"), handler:function (e) {
                        self.showList();

                        e.preventDefault();
                        e.stopPropagation();
                        return false;
                    }};
                    this.addItem(menu[4]);
                    $('<div class="menu-down"></div>').appendTo(this.cItems[4]);

                    this.listPane = $('<div>').addClass('menu-listpane').css('display', 'none').appendTo(this.container);
                    this.flPane = $('<div>').css("overflow-y", "auto").appendTo(this.listPane);
                    var buttonok = $('<div>').css({position:'relative', left:110}).appendTo(this.listPane);
                    var listener = {};
                    listener.eventName = FR.Events.CLICK;
                    listener.action = function () {
                        self.containerPane.doFilter(true);
                    };
                    config = {
                        type:"button",
                        name:'flok',
                        tablable:true,
                        text:FR.i18nText("OK"),
                        listeners:[listener]
                    };
                    buttonok.asComponent(config);

                    this.container.width(this.minWidth);
                    this.container.children("div").width(this.minWidth - 8);
                },

                showList:function () {
                    if (this.cur_fi) {
                        var fi = this.cur_fi;
                        // TODO carl: find out why?
                        // ҳ֮lpָdivڵ㲻ˣٴμصʱ¼Ӧ
//        			if (!this.lpArray) {
//        				this.lpArray = {};
//        			}
//        			var lp = this.lpArray[fi.cef];
//        			
//        			if (!lp) {
//        				lp = this.createViewListPane(fi.items);
//        				this.lpArray[fi.cef] = lp;
//        			}

                        var loc = FR.cellStr2ColumnRow(fi.cef);
                        var self = this;
                        var result;
                        FR.ajax({
                            async:false,
                            type:'POST',
                            url:FR.servletURL,
                            data:{
                                op:'fr_view',
                                cmd:'view_get_filter_item',
                                sessionID:self.containerPane.viewPane.currentSessionID,
                                col:loc.col,
                                row:loc.row,
                                reportIndex:self.containerPane.idx
                            },
                            complete:function (res, status) {
                                var text = res.responseText;
                                var ro = FR.jsonDecode(text);
                                if (ro.error) {
                                    FR.Msg.toast(ro.error);
                                } else {
                                    result = ro;
                                }
                            }
                        });

                        if (result != null && result.items != null) {
                            lp = this.createViewListPane(result.items);
                        } else {
                            lp = this.createViewListPane(fi.items);
                        }
                        lp.filter(result.fitems);
                        this.curLP = lp;

                        this.flPane.html('');
                        this.flPane.append(lp.pane);
                        if (lp.elArray.length > 10) {
                            this.flPane.height(200);
                        } else {
                            this.flPane.height(lp.elArray.length * 22);
                        }
                        this.listPane.css('display', 'block');
                        var top = parseInt(this.container.css('top'));
                        if (this.containerPane.$scrollable != this.containerPane.$container) {
                            if (top + this.container.height() > this.containerPane.$sheet_container.height()) {
                                this.container.css({top:top - this.listPane.height() - 10});
                            }
                        } else {
                            if (top + this.container.height() - this.containerPane.$scrollable.scrollTop() > this.containerPane.$container.height()) {
                                this.container.css({top:top - this.listPane.height() - 10});
                            }
                        }
                    }
                },

                addItem:function (menu) {
                    var self = this;
                    var $item = $("<div style='width:80px'>").appendTo(this.container);

                    if (menu.type === "sep") {
                        $item.addClass("menu-sep").html("'&nbsp;'");
                    } else {
                        $item.addClass("view-menu-item")
                            .click(function (e, item) {
                                menu.handler.call(this, e, item);
                            });
                        self.bindMenuItemEvent($item, menu);
                        var $menu_text = $('<div class="menu-text"></div>').html(menu.src).appendTo($item);
                        var text_width = $menu_text.position().left * 2 + $menu_text.width();
                        if (this.minWidth < text_width) {
                            this.minWidth = text_width;
                        }
                        var icon = menu.iconSrc ? menu.iconSrc.replace("css:", "") : "";
                        if (icon) {
                            $('<div class="menu-icon"></div>').addClass(icon).appendTo($item);
                        }
                        if (menu.submenu) {
                            $('<div class="menu-rightarrow"></div>').appendTo($item);	// has sub menu
                        }
                        if ($.support.boxModel === true) {
                            var height = $item.height() || 22;
                            $item.height(height - ($item.outerHeight() - $item.height()));
                        }
                    }

                    this.cItems[this.cItems.length] = $item;
                },

                bindMenuItemEvent:function ($item, menu) {
                    var self = this;
                    var showMenuFunc = function () {
                            self.closeSub();
                            $item.siblings().each(function () {
                                $(this).removeClass('menu-active');
                            });
                            $item.addClass('menu-active');
                            if (menu.submenu) {
                                if ($.isArray(menu.submenu)) {
                                    if (!$item.$submenu) {
                                        var config = {
                                            destroyOnClose:false,
                                            minWidth:120,
                                            items:menu.submenu
                                        };
                                        $item.$submenu = new FR.frMenu(config);
                                        self.submenus[self.submenus.length] = $item.$submenu;
                                        // TODO Carlĵط̫..
                                        $item.$submenu.$menuRoot.removeClass('menu').addClass('view-menu');
                                        $.each($item.$submenu.children(), function (idx, it) {
                                            it.removeClass('menu-item').addClass('view-menu-item');
                                        });
                                    }
                                    var left = $item.offset().left + $item.outerWidth() - 2;
                                    if (left + $item.$submenu.$menuRoot.outerWidth() > $(window.document).width()) {
                                        left = $item.offset().left - $item.$submenu.$menuRoot.outerWidth() + 2;
                                    }
                                    $item.$submenu.position(left, $item.offset().top - 3);
                                    $item.$submenu.show();
                                }
                            }
                        };
                    $item.hover(
                        showMenuFunc,
                        function (e) {
                            $item.removeClass('menu-active');
                            if ($item.$submenu) {
                                if (e.pageX >= parseInt($item.$submenu.$menuRoot.css('left'))) {
                                    $item.addClass('menu-active');
                                } else {
                                    $item.$submenu.close();
                                }

                            }
                        }
                    );
                    $item.click(showMenuFunc);
                },

                show:function (lgp, ast, at, l, t, cef) {
                    if (!this.container) {
                        this.init(lgp);
                    }

                    if (lgp.menuExpand.attr('conv') == 'true') {
                        l -= 168;
                    }

                    this.listPane.css('display', 'none');

                    var items = this.cItems;
                    var il = 0;
                    //ӸҪĽӿ
                    if (contentPane.hideSort) {
                        items[0].hide();
                        items[1].hide();
                    } else if (ast === 0) {
                        items[0].show();
                        items[1].hide();
                        il += 1;
                    } else if (ast === 1) {
                        items[0].hide();
                        items[1].show();
                        il += 1;
                    } else if (ast === 2) {
                        items[0].show();
                        items[1].show();
                        il += 2;
                    }

                    // ֶͨΣɸѡ
                    if (at <= 2) {
                        items[2].show();
                        il += 1;

                        lgp.$sheet_container.__loading__(true, false, {left:l, top:t});
                        if (cef) {
                            var fi;
                            if (!lgp.fiArray) {
                                lgp.fiArray = {};
                                fi = null;
                            } else {
                                fi = lgp.fiArray[cef];
                            }
                            if (!fi) {
                                fi = {};
                                var loc = FR.cellStr2ColumnRow(cef);
                                FR.ajax({
                                    async:false,
                                    type:'POST',
                                    url:FR.servletURL,
                                    data:{
                                        op:'fr_view',
                                        cmd:'view_get_filter_info',
                                        sessionID:lgp.viewPane.currentSessionID,
                                        col:loc.col,
                                        row:loc.row,
                                        reportIndex:lgp.idx
                                    },
                                    complete:function (res, status) {
                                        var text = res.responseText;
                                        var ro = FR.jsonDecode(text);
                                        if (ro.error) {
                                            FR.Msg.toast(ro.error);
                                        } else {
                                            // {islist, items, fitems, compare, loc}
                                            fi = ro;
                                        }
                                    }
                                });
                                lgp.fiArray[cef] = fi;
                                fi.cef = cef;
                            }
                            if (fi.islist) {
                                items[4].show();
                                il += 1;
                            } else {
                                items[4].hide();
                            }

                            if (fi.compare) {
                                items[3].show();
                                il += 1;
                            } else {
                                items[3].hide();
                            }

                            this.cur_fi = fi;
                        } else {
                            this.cur_fi = null;
                            FR.Msg.toast('Unknown Error.');
                        }
                        lgp.$sheet_container.__loading__(false);
                        // ֶֻ
                    } else {
                        items[2].hide();
                        items[3].hide();
                        items[4].hide();
                    }

                    if (lgp.$scrollable != lgp.$container) {
                        if (t + il * 22 + 4 > lgp.$sheet_container.height()) {
                            t -= il * 22 - 10;
                        }
                    } else {
                        if (t + il * 22 + 4 - lgp.$scrollable.scrollTop() > lgp.$container.height()) {
                            t -= il * 22 - 10;
                        }
                    }
                    this.container.css({left:l, top:t});
                    this.container.css('display', 'block');
                },

                close:function () {
                    if (this.container) {
                        this.closeSub();
                        this.container.css('display', 'none');
                    }
                },

                closeSub:function () {
                    for (var i = 0; i < this.submenus.length; i++) {
                        this.submenus[i].close();
                    }
                },

                createViewListPane:function (items) {
                    var O = {
                        init:function (items) {
                            var $view = $("<div/>").addClass('x-combo-list-inner')
                                .css({width:'auto', overflow:'auto'});

                            items = items || [];

                            var h = items.length * 20;
                            $view.css('height', h).css('margin-left', 20);

                            this.elArray = [];
                            var self = this;

                            var sH = 18;
                            listener = {};
                            listener.eventName = FR.Events.STATECHANGE;
                            listener.action = function () {
                                self.checkLess();
                            };
                            $.each(items, function (idx, it) {
                                self.elArray[idx] = $('<div>').appendTo($view).height(sH)
                                    .attr("title", it.text)
                                    .addClass('fr-combo-list-item')
                                    .css('border', 0)
                                    .asComponent({type:'checkbox', text:it.text + ' (' + it.count + ')', value:true, listeners:[listener]});
                            });

                            this.pane = $view;
                        },

                        checkLess:function () {
                            if (this.less && this.less != null) {
                                this.less.setEnable(true);
                            }
                            this.less = null;
                            for (var i = 0; i < this.elArray.length; i++) {
                                if (this.elArray[i].selected()) {
                                    if (this.less == null) {
                                        this.less = this.elArray[i];
                                    } else {
                                        this.less = null;
                                        break;
                                    }
                                }
                            }
                            if (this.less != null) {
                                this.less.setEnable(false);
                            }
                        },

                        filter:function (filters) {
                            var self = this;
                            if (filters) {
                                $.each(filters, function (idx, it) {
                                    self.elArray[it].selected(false);
                                });
                            }
                        }
                    };

                    O.init(items);

                    return O;
                }
            }
        },

        popContextMenu:function () {
            var $cell = $(this.currentTDCell);
            var cef = $cell.attr('cef');
            if ($cell.attr("at") != null) {
                var at = parseInt($cell.attr("at"));
                if (at <= 0) {
                    return;
                }
                var ast = parseInt($cell.attr("ast"));
                if (ast >= 0 && ast <= 2) {
                    var left = parseInt(this.menuExpand.css('left'));
                    var top = parseInt(this.menuExpand.css('top'));
                    this.menuExpand.hide();
                    this.contextMenu.show(this, ast, at, left, top, cef);
                }
            }
        },

        sort:function (sort, dir) {
            var $cell = $(this.currentTDCell);
            var loc = FR.id2Location($cell.attr("id"));

            var o = {
                overlay_immediately:true,
                text:FR.i18nText("Sorting") + "..."
            };
            FR.showLoadingDialog(o);

            var self = this;

            FR.ajax({
                url:FR.servletURL,
                type:'POST',
                async:false,
                data:{
                    op:"fr_view",
                    cmd:"view_sort",
                    sessionID:this.viewPane.currentSessionID,
                    col:loc.col,
                    row:loc.row,
                    reportIndex:this.idx,
                    st:sort,
                    dir:dir
                },
                complete:function (res, status) {
                    var text = res.responseText;
                    if (text == 'success') {
                        self.viewPane.reloadCurLGPPane(self.currentTDCell != null ? FR.id2ColumnRow($(self.currentTDCell).attr('id')) : null);
                    } else {
                        FR.Msg.toast(FR.i18nText("Failed"));
                    }
                    FR.hideLoadingDialog();
                }
            });
        },

        popFilterPane:function (cur_fi) {
            var ro = cur_fi;
            if (!ro) {
                FR.Msg.toast('Unknown Error.');
                return;
            }

            if (!this.dialog) {
                this.filterPane = $("<div/>").css("width", 300).css("height", 'auto');
                this.formulaPane = this.filterFace.getContent().appendTo(this.filterPane);

                var self = this;
                var save_table = $('<table cellpadding="0" cellspacing="0" border="0" style="width:100%;height:100%"><colgroup><col width="260"/><col width="70"/><col width="70"/></colgroup></table>');
                tr = $('<tr>').appendTo(save_table);
                td = $('<td  colspan="3">').appendTo(tr);
                td.append(this.filterPane);

                tr = $('<tr>').appendTo(save_table);
                td = $('<td>').appendTo(tr);
                td = $('<td>').appendTo(tr);
                new FR.Button({
                    text:FR.i18nText("OK"),
                    width:60,
                    render:false,
                    renderEl:$("<div/>").appendTo(td),
                    handler:function () {
                        self.doFilter(false);
                        self.dialog.setVisible(false);
                    }
                });
                td = $('<td>').appendTo(tr);
                new FR.Button({
                    text:FR.i18nText("Cancel"),
                    width:60,
                    render:false,
                    renderEl:$("<div/>").appendTo(td),
                    handler:function () {
                        self.dialog.setVisible(false);
                    }
                });

                var o = {
                    title:FR.i18nText("Filter"),
                    width:450,
                    height:160,
                    contentHtml:save_table
                };

                this.dialog = new FR.Dialog(o);
            }

            this.filterFace.popCompare(ro.compare);

            this.dialog.setVisible(true);
        },

        doFilter:function (islist, clearCompare) {
            var $cell = $(this.currentTDCell);
            var cef = $cell.attr('cef');
            var ro = this.fiArray[cef];
            var loc = FR.cellStr2ColumnRow(cef);
            if (!ro) {
                FR.Msg.toast('Unknown Error.');
                return;
            }

            if (clearCompare) {
                this.transInfo(false, loc, null);
                ro.compare = null;
                return;
            }

            if (islist) {
                var filter = [];
                $.each(this.contextMenu.curLP.elArray, function (idx, it) {
                    if (!it.selected()) {
                        filter[filter.length] = idx;
                    }
                });
                ro.compare = null;
                this.transInfo(true, loc, FR.jsonEncode(filter));
            } else {
                var result = {};
                var compare = this.filterFace.createCompare();
                if (compare != null) {
                    result.compare = compare;
                }
                ro.compare = compare;
                this.transInfo(false, loc, FR.jsonEncode(result));
            }
        },

        transInfo:function (islist, loc, info) {
            var o = {
                overlay_immediately:true,
                text: FR.i18nText("Calculating") + "..."
            };
            FR.showLoadingDialog(o);

            var self = this;

            var postInfo = {
                op:"fr_view",
                cmd:"view_dofilter",
                sessionID:self.viewPane.currentSessionID,
                col:loc.col,
                row:loc.row,
                reportIndex:self.idx,
                islist:islist
            };
            if (info) {
                postInfo.info = info;
            }
            FR.ajax({
                url:FR.servletURL,
                type:'POST',
                async:false,
                data:postInfo,
                complete:function (res, status) {
                    var text = res.responseText;
                    var ro = FR.jsonDecode(text);
                    if (ro.error) {
                        FR.Msg.toast(ro.error);
                    }
//					else if (ro.portrait != null){
//						self.filterData(ro.portrait, ro.filteridxs, ro.rowcount, ro.colcount);
//					}
                    else if (ro.success === true) {
                        // Ӱsheetãһᶼ
                        if (ro.sidxs) {
                            $.each(ro.sidxs, function (idx, item) {
                                if (item != self.idx) {
                                    self.viewPane.lgps[item].reloaded = true;
                                }
                            });
                        }
                        self.viewPane.reloadCurLGPPane(self.currentTDCell != null ? FR.id2ColumnRow($(self.currentTDCell).attr('id')) : null);
                    }
                    else {
                        FR.Msg.toast("Unknown Exception!");
                    }
                    FR.hideLoadingDialog();
                }
            });
        },

        filterData:function (portrait, filteridxs, rowcount, colcount) {
            // 
            if (portrait) {
                if (!this.portrait_array) {
                    this.portrait_array = [];
                    for (var i = 0; i < this.portrait_array.length; i++) {
                        this.portrait_array[i] = 0;
                    }
                }

                var array = this.portrait_array;
                $.each(filteridxs, function (idx, it) {
                    array[it]++;
                });

                var self = this;
                $.each(array, function (idx, it) {
                    // ͷ
                    if (it === 1) {
                        array[idx] = 0;
                        self.hideOrShowRow(idx, true);
                        // 
                    } else if (it > 1) {
                        array[idx] = 1;
                        self.hideOrShowRow(idx, false);
                    }
                });
            } else {
                if (!this.landscape_array) {
                    this.landscape_array = [];
                    for (var i = 0; i < this.landscape_array.length; i++) {
                        this.landscape_array[i] = 0;
                    }
                }

                array = this.landscape_array;
                $.each(filteridxs, function (idx, it) {
                    array[it] += 2;
                });

                var self = this;
                $.each(array, function (idx, it) {
                    // ͷ
                    if (it === 1) {
                        array[idx] = 0;
                        self.hideOrShowColumn(idx, true, rowcount);
                        // 
                    } else if (it === 2) {
                        array[idx] = 1;
                        self.hideOrShowColumn(idx, false, rowcount);
                    } else if (it > 2) {
                        array[idx] = 1;
                    }
                });
            }
        },

        hideOrShowRow:function (idx, show) {
            var tr = $("tr#r-" + idx + "-" + this.idx);
            if (!tr) {
                return;
            }
            if (show) {
                tr.css("display", "");
                // ie
                if ($.browser.msie) {
                    var td;
                    $.each($("td", tr), function (index, item) {
                        $(item).css("display", "")
                    });
                }
            } else {
                tr.css("display", "none");
                // ie
                if ($.browser.msie) {
                    $.each($("td", tr), function (index, item) {
                        $(item).css("display", "none");
                    });
                }
            }
        },

        hideOrShowColumn:function (idx, show, rowcount) {
            var td;
            for (var j = 0; j < rowcount; j++) {
                td = $("td#" + FR.columnRow2CellStr({col:idx, row:j}) + "-" + this.idx + "-" + this.tableID);
                if (!td) {
                    continue;
                }
                if (show) {
                    td.css("display", "");
                } else {
                    td.css("display", "none");
                }
            }
        },

        filterFace:{
            _init:function () {
                this.content = $('<div/>').addClass('fr-adanaly-fileterface');
                this.content.append(this.createDesignTable());
            },

            getContent:function () {
                if (!this.content) {
                    this._init();
                }
                return this.content;
            },

            createDesignTable:function () {
                var table = $('<table/>').addClass('fr-adanaly-filterface-table');
                table.append(this.generateExplanTR());
                table.append(this.generateFilterTR());
                return table;
            },

            generateExplanTR:function () {
                return $('<tr/>')
                    .append($('<td/>').text(FR.i18nText("ConditionB-Operator") + ':'))
                    .append($('<td/>').text(FR.i18nText("Datatype") + ':'))
                    .append($('<td/>').text(FR.i18nText("ChartF-Values") + ':'))
                    .append($('<td/>'));
            },

            generateFilterTR:function () {
                return $('<tr/>')
                    .append($('<td/>').append(this.generateOPCombo()))
                    .append($('<td/>').append(this.generateTypeCombo()))
                    .append($('<td/>').append(this.valuePane.getContent()))
            },

            generateOPCombo:function () {
                var config = {
                    type:"combo",
                    width:120,
                    height:20,
                    popupWidth:120,
                    directEdit:false,
                    allowBlank:true,
                    mode:'local'
                };
                config.items = this.opData();
                var combo = $('<div/>');
                this.opCombo = combo.asComponent(config);
                return combo;
            },

            opData:function () {
                var item = [];
                item.push({text:FR.i18nText("ConditionB-equals"), value:0});
                item.push({text:FR.i18nText("ConditionB-does_not_equal_to"), value:1});
                item.push({text:FR.i18nText("ConditionB-is_greater_than"), value:2});
                item.push({text:FR.i18nText("ConditionB-is_greater_than_or_equal_to"), value:3});
                item.push({text:FR.i18nText("ConditionB-is_less_than"), value:4});
                item.push({text:FR.i18nText("ConditionB-is_less_than_or_equal_to"), value:5});
                item.push({text:FR.i18nText("ConditionB-begins_with"), value:6});
                item.push({text:FR.i18nText("ConditionB-does_not_begin_with"), value:7});
                item.push({text:FR.i18nText("ConditionB-ends_with"), value:8});
                item.push({text:FR.i18nText("ConditionB-does_not_end_with"), value:9});
                item.push({text:FR.i18nText("ConditionB-contains"), value:10});
                item.push({text:FR.i18nText("ConditionB-does_not_contain"), value:11});
                item.push({text:FR.i18nText("ConditionB-in"), value:12});
                item.push({text:FR.i18nText("ConditionB-does_not_in"), value:13});
                return item;
            },

            generateTypeCombo:function () {
                var listener = {};
                var self = this;
                listener.eventName = FR.Events.AFTEREDIT;
                listener.action = function () {
                    self.valuePane.showTypePane(self.typeCombo.getValue());
                };
                var config = {
                    type:"combo",
                    width:120,
                    height:20,
                    popupWidth:120,
                    directEdit:false,
                    allowBlank:true,
                    mode:'local',
                    listeners:[listener]
                };
                config.items = this.typeData();
                var combo = $('<div/>');
                this.typeCombo = combo.asComponent(config);
                return combo;
            },

            typeData:function () {
                var item = [];
                item.push({text:FR.i18nText("Parameter-String"), value:'string'});
                item.push({text:FR.i18nText("Number"), value:'number'});
                item.push({text:FR.i18nText("Date"), value:'date'});
                return item;
            },

            valuePane:{
                _init:function () {
                    this.content = $('<div/>');
                    this.content.append(this.generateText())
                        .append(this.generateNumber())
                        .append(this.generateDate());
                },

                getContent:function () {
                    if (!this.content) {
                        this._init();
                    }
                    return this.content;
                },

                generateText:function () {
                    var config = {type:"text"};
                    config.disabled = false;
                    var text = $('<div/>');
                    this.text = text.asComponent(config);
                    this.text.setVisible(false);
                    return text;
                },

                generateNumber:function () {
                    var config = {type:"number"};
                    config.disabled = false;
                    var number = $('<div/>');
                    this.number = number.asComponent(config);
                    this.number.setVisible(false);
                    return number;
                },

                generateDate:function () {
                    var config = {type:"datetime"};
                    config.directEdit = true;
                    var date = $('<div/>');
                    this.date = date.asComponent(config);
                    this.date.setVisible(false);
                    return date;
                },

                showTypePane:function (type) {
                    //b:0-string, 1-number, 2-date
                    if (type == "string") {
                        this.text.setVisible(true);
                        this.number.setVisible(false);
                        this.date.setVisible(false);
                    } else if (type == "number") {
                        this.text.setVisible(false);
                        this.number.setVisible(true);
                        this.date.setVisible(false);
                    } else if (type == "date") {
                        this.text.setVisible(false);
                        this.number.setVisible(false);
                        this.date.setVisible(true);
                    } else {
                        this.text.setVisible(false);
                        this.number.setVisible(false);
                        this.date.setVisible(false);
                    }
                },

                getValue:function () {
                    if (this.text.isVisible()) {
                        return this.text.getValue();
                    } else if (this.number.isVisible()) {
                        return this.number.getValue();
                    } else if (this.date.isVisible()) {
                        return this.date.getValue();
                    }
                },

                setTypeAndValue:function (type, value) {
                    this.showTypePane(type);
                    this.text.setValue('');
                    this.number.setValue('');
                    if (type == "string") {
                        this.text.setValue(value);
                    } else if (type == "number") {
                        this.number.setValue(value);
                    } else if (type == "date") {
                        this.date.setValue(value);
                    }
                },

                getType:function () {
                    if (this.text.isVisible()) {
                        return "string";
                    } else if (this.number.isVisible()) {
                        return "double";
                    } else if (this.date.isVisible()) {
                        return "date";
                    }
                }
            },

            popCompare:function (compare) {
                if (compare == null) {
                    this.opCombo.setValue('');
                    this.typeCombo.setValue('');
                    this.valuePane.setTypeAndValue('', null);
                } else {
                    if (compare.op != null) {
                        this.opCombo.setValue(compare.op);
                    } else {
                        this.opCombo.setValue(-1);
                    }
                    this.typeCombo.setValue(compare.type);
                    this.valuePane.setTypeAndValue(compare.type, compare.value);
                }
            },

            createCompare:function () {
                var compare = {};
                compare.op = this.opCombo.getValue();
                compare.type = this.valuePane.getType();
                //neil:ΪõFR.ajax, ߾Ͳdecode
                compare.value = this.valuePane.getValue();
                return compare;
            }
        },

        /*
         * һTDColumnRowString
         */
        cut2ColumnRowString:function (td) {
            if (td == null) {
                return null;
            }

            var iid = $(td).attr("id");
            return iid.substring(0, iid.length - ('-' + this.idx).length - ('-' + this.tableID).length)
        },

        /*
         * ѡdom tdCell,ҲǼӸڱ߿,tdCellȷĻʾΧ
         */
        selectTDCell:function (tdCell) {
            if (tdCell) {
                this.currentTDCell = tdCell;
                // ȡtr,safarichrometdtopȽңtrĻǱȽһµ
                var $cell = $(tdCell);
                var $tr = $cell.parent();
                var $table = $tr.parent().parent();
                var top = $tr[0].offsetTop + $table[0].offsetTop;
                var f_top = top + tadjst;
                var f_left = tdCell.offsetLeft + parseInt($table.css("left")) + ladjst;

                if (tdCell.offsetWidth <= 0 || tdCell.offsetHeight <= 0) {
                    return;
                }

                //alex:ע,fire viewPane.event,this.event
                this.viewPane.fireEvent("cellselect", this.currentTDCell);

                var f_width = tdCell.offsetWidth + wadjst + ($.browser.msie ? 0 : 6);
                var f_height = tdCell.offsetHeight + hadjst + +($.browser.msie ? 0 : 6);
                // carl:5
                this.$fD.ftop.css({top:f_top, left:f_left, width:f_width});
                this.$fD.fleft.css({top:f_top + 3, left:f_left, height:f_height - 6});
                this.$fD.fbottom.css({top:f_top + f_height - 3, left:f_left, width:f_width});
                this.$fD.fright.css({top:f_top + 3, left:f_left + f_width - 3, height:f_height - 6});
                this.$fD.fdot.css({top:f_top + f_height - 5, left:f_left + f_width - 5});


                // ҪfDoffsetParentcurrentTDCell.offsetParentͬ
                var $current_offset_c = $(this.currentTDCell).parents(".offset-c:eq(0)");
                if ($current_offset_c.length > 0) {
                    // carl:ʱ粻мûҪŶ
                    if (!$current_offset_c.hasClass("frozen-center")) {
                        this.expandmenu_no_scrollable = true;
                    } else {
                        this.expandmenu_no_scrollable = false;
                    }

                    var $last_offset_c = this.$fD.ftop.parents(".offset-c:eq(0)");
                    if ($last_offset_c.length <= 0 || $last_offset_c.attr("class") != $current_offset_c.attr("class")) {
                        // carl:ŪˣһŪȥһж
                        $current_offset_c.append(this.$fD.ftop);
                        $current_offset_c.append(this.$fD.fleft);
                        $current_offset_c.append(this.$fD.fbottom);
                        $current_offset_c.append(this.$fD.fright);
                        $current_offset_c.append(this.$fD.fdot);
                    }
                }

                var self = this;
                if (!this.menuExpand) {
                    this.menuExpand = $('<div/>').addClass('menu-expand').appendTo(this.$sheet_container).click(function (e) {
                        self.popContextMenu();
                        self.menuExpand.hide();

                        e.preventDefault();
                        e.stopPropagation();
                        return false;
                    });

                    if (this.$scrollable != this.$container) {
                        self.scroll_with_scrollbox = function (e) {
                            if (self.expandmenu_no_scrollable) {
                                return;
                            }

                            var st = self.$scrollable.scrollTop();
                            var sl = self.$scrollable.scrollLeft();
                            if (self.menuExpand.css('display') != 'none') {
                                var left = parseInt(self.menuExpand.css('left'));
                                var top = parseInt(self.menuExpand.css('top'));
                                top = top + self.st_mark - st;
                                left = left + self.sl_mark - sl;

                                if (self.menuExpandHide === true) {
                                    self.menuExpandHide = false;
                                    top += 9999;
                                }
                                var loffset = 2;
                                if (self.menuExpand.attr('conv') == 'true') {
                                    loffset += 16;
                                }
                                if (top + 2 < self.$scrollable[0].offsetTop || left + loffset < self.$scrollable[0].offsetLeft) {
                                    self.menuExpandHide = true;
                                    top -= 9999;
                                }
                                self.menuExpand.css({top:top, left:left});
                                self.st_mark = st;
                                self.sl_mark = sl;
                            }
                            var c = self.contextMenu.container;
                            if (c && c.css('display') != 'none') {
                                var left = parseInt(c.css('left'));
                                var top = parseInt(c.css('top'));
                                c.css({top:top + self.st_mark - st, left:left + self.sl_mark - sl});
                                self.st_mark = st;
                                self.sl_mark = sl;

                                self.contextMenu.closeSub();
                            }
                        };

                        this.$scrollable.bind('scroll', self.scroll_with_scrollbox);
                    }
                }

                var l = 0;
                var t = 0;
                if ($current_offset_c.length > 0) {
                    l += $current_offset_c[0].offsetLeft;
                    t += $current_offset_c[0].offsetTop;
                }

                var cef = $cell.attr('cef');
                if ($cell.attr("at") != null) {
                    var at = parseInt($cell.attr("at"));
                    if (at <= 0) {
                        this.menuExpand.hide();
                    } else {
                        var ast = parseInt($cell.attr("ast"));
                        if (ast >= 0 && ast <= 2) {
                            t = f_top + t;
                            l = f_left + f_width + l;

                            this.st_mark = this.$scrollable.scrollTop();
                            this.sl_mark = this.$scrollable.scrollLeft();
                            if (this.$scrollable != this.$container) {
                                t -= this.st_mark;
                                l -= this.sl_mark;
                                // жǷҪ
                                if (l + 180 > this.$sheet_container.width()) {
                                    l -= f_width + 16;
                                    this.menuExpand.attr('conv', 'true');
                                    this.menuExpand.removeClass('menu-expand');
                                    this.menuExpand.addClass('menu-expand-conv');
                                } else {
                                    this.menuExpand.attr('conv', 'false');
                                    this.menuExpand.removeClass('menu-expand-conv');
                                    this.menuExpand.addClass('menu-expand');
                                }
                            } else {
                                // жǷҪ
                                if (l - this.sl_mark + 180 > this.$container.width()) {
                                    l -= f_width + 16;
                                    this.menuExpand.attr('conv', 'true');
                                    this.menuExpand.removeClass('menu-expand');
                                    this.menuExpand.addClass('menu-expand-conv');
                                } else {
                                    this.menuExpand.attr('conv', 'false');
                                    this.menuExpand.removeClass('menu-expand-conv');
                                    this.menuExpand.addClass('menu-expand');
                                }
                            }


                            this.menuExpand.css({top:t, left:l});
                            this.menuExpandHide = false;
                            this.menuExpand.show();
                        } else {
                            this.menuExpand.hide();
                        }
                    }
                } else {
                    this.menuExpand.hide();
                }

//                if (FR.isMobile()) {
//
//                } else {
                    // alex:$scrollable
                    $(this.currentTDCell).__scroll2View__(this.$scrollable);
//                }
            }
        },
        /*
         * 
         * (1,1)
         * ({col:1, row:1})
         * ("B2")
         */
        _get$TDCell:function (col, row) {
            if (row != null) {
                col = {col:col, row:row};
            }
            if (typeof col == 'object') {
                col = FR.columnRow2CellStr(col);
            }

            // alex:̫,ȫȡȻȴthis.$tableȡҪ~~ TODO to find out why~
            // carlȫ֣ѵparameterPaneȥ
            // denny: tracker@953, ȫֱidЧʸߵԭǿֱgetElementById,Ҫ
            var cell = $('#' + col + "-" + this.idx + "-" + this.tableID);
            if (cell == null) {
                cell = $('td[position*=' + '\'' + col + "-" + this.idx + '\']', this.$table);
            }

            return cell;
        },

        getTDCell:function (col, row) { //alex:Դһ{col:1,row:2}"A1",ҲԴ1,2
            var $res = this._get$TDCell(col, row);
            if ($res != null && $res.length > 0) {
                return $res[0];
            }

            return null;
        },

        /**
         * ѡеĺڿ
         */
        hideSelectFrame: function() {
            this.$fD.ftop.css('display', 'none');
            this.$fD.fleft.css('display', 'none');
            this.$fD.fbottom.css('display', 'none');
            this.$fD.fright.css('display', 'none');
            this.$fD.fdot.css('display', 'none');
        }
    }
}());

function onBridgeReady(event) {
	contentPane.bridge = event.bridge;
	FR.MobileTools.doWaitingTODO();
}

//for ios
if(FR.isMobile()) {
	document.addEventListener('WebViewJavascriptBridgeReady', onBridgeReady, false);
};