if (window.FS == null) {
	window.FS = {};
}

FS.Process = {};

FS.TypeFunMap = (function() {
	var nameFunSpace = {};
	return {
		put : function(name, Function) {
			if (!nameFunSpace[name]) {
				nameFunSpace[name] = Function;
			}		
		},
		
		createProcessOb : function(properties) {
			var name = properties.type;
			if (name == null) {
				throw Error("Need Type!");
			}
			if (!nameFunSpace[name]) {
				throw Error("No Function typed" + name + "!");
			}
			return new nameFunSpace[name](properties);
		}
	};
})();

FS.getPosition = function(e) {
	if (e.offsetX) {
		return {
			x : e.offsetX,
			y : e.offsetY
		}
	} else if (e.layerX) {
		return {
			x : e.layerX,
			y : e.layerY
		}
	}
},


FS.ProcessColor = {
	activedPointColor : '#66FF66',
	
	forbiddenColor : 'red',
	
	borderStartColor : 'silver',
	
	borderStopColor : 'gray',
	
	normalBackground : '#FFFFE0',
	
	rectBackground : '#DAE4F1'
};

FS.ProcessMananger = (function() {
	var allprocess = {};
	var activeprocess = null;
	return {
		getActiveProcess : function() {
			if (activeprocess == null) {
				this.addProcess(new FS.ProcessDefine({}));
			}
			return activeprocess;
		},
		
		isRepeatName : function(name) {
			for (var i in allprocess) {
				if (i == name) {
					return true;
				}
			}
			return false;
		},
		
		addProcess : function(process) {
			allprocess[process.name] = process;
			activeprocess = process;
		},
		
		getProcessByName : function(name) {
			return allprocess[name];
		},
		
		clear : function() {
			allprocess = {};
			activeprocess = null;
		}
	};
})();

FS.ProcessPaintObject = function(properties) {
	this.properties = properties;
	this.init();
}

$.extend(FS.ProcessPaintObject.prototype, {
	init : function() {
		//do nothing
	},
	
	paint : function(processdefine) {
		//paint state
	}
});

FS.CanvasEvent = FR.extend(FS.ProcessPaintObject, {
	init : function() {
		//do nothing
	},
	
	setMouseOverOb : function(ob) {
		this.mouseOverOb = ob;
	},
	
	getMouseOverOb : function() {
		return this.mouseOverOb;
	},
	
	removeMouseOverOb : function() {
		this.mouseOverOb = null;
	},
	
	setMouseClickOb : function(ob) {
		this.mouseClickOb = ob;
	},
	
	getMouseClickOb : function() {
		return this.mouseClickOb;
	},
	
	removeMouseClickOb : function() {
		this.mouseClickOb = null;
	},
	
	setMouseDragOb : function(ob) {
		this.mouseDragOb = ob;
	},
	
	getMouseDragOb : function() {
		return this.mouseDragOb;
	},
	
	removeMouseDragOb : function() {
		this.mouseDragOb = null;
	},
	
	triggerMouseOver : function(e) {},
	
	triggerMouseOut : function(e) {},
	
	triggerMouseDown : function(e) {},
	
	triggerMouseUp : function(e) {},
	
	triggerKeyEvent : function(e) {},
	
	triggerDrag : function(e) {},
	
	triggerDrop : function(e) {}
});

FS.ProcessOb = FR.extend(FS.CanvasEvent, {
	init : function() {
		FS.ProcessOb.superclass.init.apply(this, arguments);
		this.parseJSON(this.properties);
	},
	
	setName : function(name) {
		this.name = name;
	},
	
	getName : function() {
		return this.name;
	},
	
	parseJSON : function(properties) {},
	
	toJSON : function() {}
});

FS.ProcessDefine = FR.extend(FS.ProcessOb, {
	init : function() {
		FS.ProcessDefine.superclass.init.apply(this, arguments);
		this._initCanvas();
		this.clearState();
		this.registerEvent();
		this.paint();
	},
	
	_initCanvas : function() {
		this.shapeContext = $('canvas#shape')[0].getContext("2d");
		this.stateContext = $('canvas#state')[0].getContext("2d");
	},
	
	//b:processdefine
	registerEvent : function() {
		this.clickedObj = null;
		this.dragObj = null;
		var alertCanvasContent = $('canvas#state'), self = this;
		alertCanvasContent.unbind();
		alertCanvasContent.mousemove(function(e) {
			self.triggerMouseOver(e);
		}).mouseout(function(e) {
			self.triggerMouseOut(e);
		}).mousedown(function(e) {
			self.triggerMouseDown(e);
		}).mouseup(function(e) {
			self.triggerMouseUp(e);
		}).mouseover(function(e) {
			alertCanvasContent.css('cursor', 'move');
			self.registerKeyEvent();
		});

	},
	
	/**
	 * b:drag in(start,task...drag in canvas)--ӦⲿcanvasʱΪdemoʱ
	 *   ͨƶûǰ¼
	 *   ƶקԺƶ
	 * */
	triggerMouseOver : function(e) {
		e.processdefine = this;
		if (this.getMouseOverOb() && !this.getMouseOverOb().triggerMouseOver(e)) {
			if (this.getMouseClickOb() == this.getMouseOverOb()) {
				this.removeMouseClickOb();
			}
			this.removeMouseOverOb();
		}
		if (!this.getMouseOverOb() && this.stateOb) {
			if (this.stateOb.triggerMouseOver(e)) {
				this.setMouseOverOb(this.stateOb);
			}
		}
		if (!this.getMouseOverOb()){
			for (var i = 0, len = this.tasks.length; i < len; i++) {
				if (this.tasks[i].triggerMouseOver(e)) {
					this.setMouseOverOb(this.tasks[i]);
					break;
				}
			}
		}	

		if (!this.getMouseOverOb()) {
			var transitions = this.getTransitions();
			for (var i = 0, len = transitions.length; i < len; i++) {
				if (transitions[i].triggerMouseOver(e)) {
					this.setMouseOverOb(transitions[i]);
					break;
				}	
			}			
		}	
		if (this.getMouseDragOb() != null) {
			this.getMouseDragOb().triggerDrag(e, this.getMouseOverOb());
		}
	},
	
	triggerMouseOut : function(e) {
		this.clickPoint = null;
		this.removeMouseOverOb();
		this.unregisterKeyEvent();
		if (this.getMouseDragOb()) {
			this.removeMouseClickOb();
			this.removeMouseDragOb();
			this.repaint();
		}	
	},
	
	triggerMouseDown : function(e) {
		this.clickPoint = FS.getPosition(e);
		e.processdefine = this;
		if (this.getMouseClickOb() && !this.getMouseClickOb().triggerMouseDown(e)) {
			this.removeMouseClickOb();
			this.removeMouseDragOb();
		} else {
			this.setMouseDragOb(this.getMouseClickOb());
		}
		if (!this.getMouseClickOb() && this.stateOb) {
			if (this.stateOb.triggerMouseDown(e)) {
				this.setMouseClickOb(this.stateOb);
				this.setMouseDragOb(this.stateOb);
			}
		}
		if (!this.getMouseClickOb()){
			for (var i = 0, len = this.tasks.length; i < len; i++) {
				if (this.tasks[i].triggerMouseDown(e)) {
					this.setMouseClickOb(this.tasks[i]);
					this.setMouseDragOb(this.tasks[i]);
					break;
				}
			}
		}	

		if (!this.getMouseClickOb()) {
			var transitions = this.getTransitions();
			for (var i = 0, len = transitions.length; i < len; i++) {
				if (transitions[i].triggerMouseDown(e)) {
					this.setMouseClickOb(transitions[i]);
					this.setMouseDragOb(transitions[i]);
					break;
				}	
			}			
		}
	},
	
	triggerMouseUp : function(e) {
		e.processdefine = this;
		if (this.getMouseDragOb() != null) {
			if (this.getMouseDragOb() != this.getMouseOverOb() && this.getMouseDragOb() != this.getMouseClickOb()) {
				this.getMouseDragOb().triggerDrop(e, this.getMouseOverOb());
			}
			
			this.removeMouseDragOb();
		}
		this.clickPoint = null;
		this.repaint();		
	},
	
	registerKeyEvent : function() {
		if (!this.keyEvent) {
			this.keyEvent = function(e) {
				this.triggerKeyEvent(e);
			}.createDelegate(this);
		}
		FR.Keys.reg(this.keyEvent);
	},
	
	unregisterKeyEvent : function() {
		if (this.keyEvent) {
			FR.Keys.unreg(this.keyEvent);
		}		
	},
	
	triggerKeyEvent : function(e) {
		e.processdefine = this;
		if (this.stateOb && this.stateOb.triggerKeyEvent(e)) {
			this.clearFore();
			this.repaint();			
		}
	},
	
	triggerDrag : function(e) {
		//do nothing
	},
	
	triggerDrop : function(e) {
		//do nothing
	},
	
	addTask : function(task) {
		if (this.tasks == null) {
			this.tasks = [];
		}
		this.tasks.push(task);
	},
	
	removeTask : function(task) {
		this.tasks.remove(task);
		this.removeRelativeTransition(task.getName());
	},
	
	removeRelativeTransition : function(name) {
		for (var i = 0, len = this.tasks.length; i < len; i++) {
			var transitions = this.tasks[i].transitions;
			if (!transitions || transitions.length == 0) {
				continue;
			}
			for (var j = 0, jen = transitions.length; j < jen; j++) {
				if (transitions[j].getToTaskName() == name) {
					this.tasks[i].removeTransition(transitions[i]);
				}
			}
		}
	},
	
	getTask : function(name) {
		for (var i = 0, len = this.tasks.length; i < len; i++) {
			if (this.tasks[i].getName() == name) {
				return this.tasks[i];
			}
		}
	},
	
	createNotRepeatName4Task : function(name) {
		if (name == null) {
			name = "mytask";
		}
		var repeat = false;
		for (var i = 0, len = this.tasks.length; i < len; i++) {
			if (this.tasks[i].getName() == name) {
				name = name + i;
				repeat = true;
				break;
			}
		}
		return repeat ? this.createNotRepeatName4Task(name) : name;
	},
	
	createNotRepeatName4Transition : function(name) {
		if (name == null) {
			name = "mytran";
		}
		var repeat = false, transitions = this.getTransitions();
		for (var i = 0, len = transitions.length; i < len; i++) {
			if (transitions[i].getName() == name) {
				name = name + i;
				repeat = true;
				break;
			}
		}
		return repeat ? this.createNotRepeatName4Transition(name) : name;
	},
	
	setTrigger : function(trigger) {
		this.trigger = trigger;
	},
	
	removeTrigger : function(trigger) {
		this.trigger = null;
	},
	
	getTransitions : function() {
		var transitions = [];
		for (var i = 0, len = this.tasks.length; i < len; i++) {
			Array.prototype.push.apply(transitions, this.tasks[i].transitions);
		}
		return transitions;
	},
	
	removeTransition : function(transition) {
		for (var i = 0, len = this.tasks.length; i < len; i++) {
			var transitions = this.tasks[i].transitions;
			if (transitions && transitions.length > 0) {
				for (var j = 0, jen = transitions.length; j < jen; j++) {
					if (transitions[j] == transition) {
						this.tasks[i].removeTransition(transition);
						return;
					}
				}
			}
		}
	},
	
	addParameter : function(parameter) {
		this.parameters.push(parameter);
	},
	
	setParameters : function(parameters) {
		this.parameters = parameters;
	},
	
	getParameters : function() {
		return this.parameters;
	},
	
	parseJSON : function(properties) {
		this.width = properties.width ? properties.width : 800;
		this.height = properties.hegith ? properties.height : 600;
		var tasks = properties.tasks;
		if (tasks) {
			for (var i = 0, len = tasks.length; i < len; i++) {
				this.addTask(FS.TypeFunMap.createProcessOb($.extend(tasks[i], {
					processDefine : this
				})));
			}
		}
		if (properties.trigger) {
			this.setTrigger(properties.trigger);
		}
		if (properties.name != null) {
			this.setName(properties.name);
		}
		if (properties.parameters) {
			this.setParameters(properties.parameters);
		} else {
			this.parameters = [];
		}
	},
		
	toJSON : function() {
		var processdefine = {};
		processdefine.name = this.getName();
		processdefine.parameters = this.getParameters();
		processdefine.trigger = this.getTrigger();
		processdefine.task = [];
		for (var i = 0, len = this.tasks.length; i < len; i++) {
			processdefine.task.push(this.tasks[i].toJSON());
		}
		return processdefine;
	},
	
	//b:Ȼtaskٻtransition
	paint : function() {
		this.clearState();
		
		if (this.tasks != null && this.tasks.length > 0) {
			for (var i = 0, len = this.tasks.length; i < len; i++) {
				this.tasks[i].paint(this);
			}
			var transitions = this.getTransitions();
			for (var i = 0, len = transitions.length; i < len; i++) {
				transitions[i].paint(this);
			}
		}
		if (this.stateOb) {
			this.stateOb.paintState(this);
		}
	},
	
	repaint : function() {
		this.paint();
	},
	
	clearState : function() {
		this.clearBack();
		this.clearFore();
	}, 
	
	clearBack : function() {
		this.shapeContext.clearRect(0, 0 , this.width, this.height);
	},
	
	clearFore : function() {	
		this.stateContext.clearRect(0, 0, this.width, this.height);
	},
	
	undo : function() {
		
	},
	
	redo : function() {
		
	}
});
FS.TypeFunMap.put("processdefine", FS.ProcessDefine);

//b:ʱСɱ䶯̶40ظ߿ֱ
FS.ProcessTask = FR.extend(FS.ProcessOb, {
	width : 40,
	
	init : function() {
		FS.ProcessTask.superclass.init.apply(this, arguments);
	},
	
	parseJSON : function(properties) {
		if (!properties.centerPoint) {
			throw Error("Task Need Position to be created!");
		} else {
			this.setCenterPoint(properties.centerPoint);
		}
		if (properties.name != null) {
			this.setName(properties.name);
		}
		if (properties.processDefine) {
			this.processDefine = properties.processDefine;
		}
		var transitions = properties.transitions;
		if (transitions) {
			for (var i = 0, len = transitions.length; i < len; i++) {
				this.addTransition(new FS.ProcessTransition($.extend(transitions[i], {
					fromTask : this
				})));
			}
		} else {
			this.transitions = [];
		}
		if (properties.joinmode) {
			this.setJoinMode(properties.joinmode);
		}
	},
	
	toJSON : function() {
		var task = {};
		task.name = this.getName();
		task.type = this.getType();
		task.centerPoint = this.getCenterPoint();
		task.transitions = [];
		for (var i = 0, len = this.transitions.length; i < len; i++) {
			task.transitions.push(this.transitions[i].toJSON());
		}
		return task;
	},
	
	removeSelf : function() {
		this.processDefine.removeTask(this);
	},
	
	copySelf : function() {
		var cp = this.getCenterPoint();
		this.processDefine.addTask(FS.TypeFunMap.createProcessOb({
			type : this.getType(),
			name : this.processDefine.createNotRepeatName4Task(this.getName()),
			processDefine : this.processDefine,
			centerPoint : {
				x : cp.x + 20,
				y : cp.y + 20
			}
			}));
	},
	
	getType : function() {
		return "formtask";
	},
	
	getBounds : function() {
		return {
			x : this.centerPoint.x - 20,
			y : this.centerPoint.y - 20,
			height : this.width,
			width : this.width
		};
	},
	
	getCenterPoint : function() {
		return this.centerPoint;
	},
	
	setCenterPoint : function(point) {
		this.centerPoint = point;
	},
	
	addTransition : function(transition) {
		if (!this.transitions) {
			this.transitions = [];
		}
		this.transitions.push(transition);
	},
	
	removeTransition : function(transition) {
		this.transitions.remove(transition);
	},
	
	removeTransitionByName : function(name) {
		for (var i = 0, len = this.transitions.length; i < len; i++) {
			if (this.transitions[i].getName() == name) {
				this.transitions.splice(i, 1);
				break;
			}
		}
	},
	
	setJoinMode : function(joinmode) {
		this.joinMode = joinmode;
	},
	
	getJoinMode : function() {
		return this.joinMode;
	},
	
	toJSONString : function() {
		
	},
	
	paint : function(processdefine) {
		this.drawName(processdefine);
	},
	
	drawName : function(processdefine) {
		if (!this.getName()) {
			return;
		}
		var ctx = processdefine.shapeContext;
		ctx.save();
		ctx.font = "11px" + ctx.font.split(/\d+px/)[1];
		var bounds = this.getBounds();
		ctx.translate(bounds.x + 4, bounds.y + 40 + 6 + 2);
		ctx.fillText(this.getName(), 0, 0, 100);	
		ctx.restore();		
	},
	
	paintState : function(processdefine) {
		processdefine.clearFore();
		var bounds = this.getBounds();
		processdefine.stateOb = new FS.TaskState({
			factory : this
		});
		processdefine.stateOb.paint(processdefine);		
	},
	
	drawSelectedRect : function(processdefine) {
		var ctx = processdefine.stateContext;
		ctx.save();
		ctx.lineWidth = 1;
		ctx.strokeStyle = '#5CF1FD';
		var bounds = this.getBounds();
		ctx.strokeRect(bounds.x - 2, bounds.y - 2, bounds.width + 4, bounds.height + 4);
		ctx.restore();
	},
	
	isInArea : function(point) {
		var bounds = this.getBounds();
		if (point.x >= bounds.x && point.x - bounds.width <= bounds.x && point.y >= bounds.y && point.y <= bounds.y + bounds.height) {
			return true;
		}
		return false;
	},
	
	triggerMouseOver : function(e) {
		if (this.isInArea(FS.getPosition(e))) {
			//do something later
			return true;
		}
		return false;
	},
	
	triggerMouseOut : function(e) {
		// do nothing
	},
	
	triggerMouseDown : function(e) {
		if (this.isInArea(FS.getPosition(e))) {
			this.paintState(e.processdefine);
			return true;
		}
		return false;
	},
	
	triggerMouseUp : function(e) {
		//processdefine deal
	},
	
	triggerKeyEvent : function(e) {
		
	},
	
	triggerDrag : function(e) {
		var point = this.getCenterPoint();
		if (e.processdefine.clickPoint) {
			point = e.processdefine.clickPoint;
		}
		var bounds = this.getBounds();
		var position = FS.getPosition(e);
		var rp = {
			x : position.x - point.x + bounds.x,
			y : position.y - point.y + bounds.y
		};
		var ctx = e.processdefine.stateContext;
		e.processdefine.clearFore();
		ctx.save();
		ctx.lineWidth = 1;
		ctx.strokeStyle = '#E2FC50';
		ctx.strokeRect(rp.x, rp.y, bounds.width, bounds.height);
		ctx.restore();			
	},
	
	triggerDrop : function(e) {
		var point = this.getCenterPoint();
		if (e.processdefine.clickPoint) {
			point = e.processdefine.clickPoint;
		}
		var bounds = this.getBounds();
		var position = FS.getPosition(e);
		var rp = {
			x : position.x - point.x + bounds.x + 20,
			y : position.y - point.y + bounds.y + 20
		};
		this.setCenterPoint(rp);
	}
});


FS.CircleTask = FR.extend(FS.ProcessTask, {
	init : function() {
		FS.CircleTask.superclass.init.apply(this, arguments);
	},
	
	
	isInArea : function(point) {
		var center = this.getCenterPoint();
		var xd = point.x - center.x, yd = point.y - center.y;
		return Math.sqrt(xd*xd + yd*yd) <= 20; 
	},
		
	paint : function(processdefine) {
		FS.CircleTask.superclass.paint.call(this, processdefine);
		var ctx = processdefine.shapeContext;
		ctx.save();
		ctx.beginPath();
		var point = this.getCenterPoint();
//		var gradient = ctx.createRadialGradient(point.x, point.y, 18, point.x, point.y, 20);
		var gradient = ctx.createLinearGradient(point.x - 20, point.y - 20, point.x + 20,  point.y - 20);
		gradient.addColorStop(0, 'silver');
		gradient.addColorStop(1, 'gray')

		ctx.strokeStyle = gradient;
		ctx.lineWidth = 2;
		ctx.fillStyle = FS.ProcessColor.normalBackground;
		ctx.arc(point.x, point.y, 18, 0, Math.PI*2, false);
		ctx.stroke();
		ctx.fill();
		
		ctx.closePath();
		ctx.restore();
	}
});

FS.RectangleTask = FR.extend(FS.ProcessTask, {
	init : function() {
		FS.RectangleTask.superclass.init.apply(this, arguments);
	},
	
	paint : function(processdefine) {
		FS.RectangleTask.superclass.paint.call(this, processdefine);
		var ctx = processdefine.shapeContext;
		ctx.save();
		ctx.beginPath();
		var bounds = this.getBounds();
		ctx.lineWidth = 2;
		var x = bounds.x + ctx.lineWidth, y = bounds.y + ctx.lineWidth, height = width = 40 - 2*ctx.lineWidth, arcHeight = arcWidth = 4;
		var gradient = ctx.createLinearGradient(x , y, x + 20, y);
		gradient.addColorStop(0, 'silver');
		gradient.addColorStop(1, 'gray')
		ctx.strokeStyle = gradient;

		ctx.moveTo(x, y + arcHeight);
		ctx.lineTo(x, y + height - arcHeight);
		ctx.quadraticCurveTo(x, y + height, x + arcWidth, y + height);
		ctx.lineTo(x + width - arcWidth, y + height);
		ctx.quadraticCurveTo(x + width, y + height, x + width, y + height - arcHeight);
		ctx.lineTo(x + width, y + arcHeight);
		ctx.quadraticCurveTo(x + width, y, x + width - arcWidth, y);
		ctx.lineTo(x + arcWidth, y);
		ctx.quadraticCurveTo(x, y, x, y + arcHeight);
		ctx.stroke();
		ctx.fillStyle = FS.ProcessColor.normalBackground;
		ctx.fill();
		ctx.closePath();
		ctx.restore();
	}
});

FS.StartTask = FR.extend(FS.CircleTask, {
	init : function() {
		FS.StartTask.superclass.init.apply(this, arguments);
	},
	
	copySelf : function() {
		//do nothing
	},
	
	getType : function() {
		return "starttask";
	},
	
	paint : function(processdefine) {
		FS.StartTask.superclass.paint.call(this, processdefine);
	}
});
FS.TypeFunMap.put("starttask", FS.StartTask);

FS.EndTask = FR.extend(FS.CircleTask, {
	init : function() {
		FS.EndTask.superclass.init.apply(this, arguments);
	},
	
	getType : function() {
		return "endtask";
	},
	
	paint : function(processdefine) {
		FS.EndTask.superclass.paint.call(this, processdefine);
	}
});
FS.TypeFunMap.put("endtask", FS.EndTask);

FS.FormTask = FR.extend(FS.RectangleTask, {
	init : function() {
		FS.FormTask.superclass.init.apply(this, arguments);
	},
	
	parseJSON : function(properties) {
		FS.FormTask.superclass.parseJSON.call(this, properties);
		if (properties.users) {
			this.setUsers(properties.users);
		}
		if (properties.parameters) {
			this.setParameters(properties.parameters);
		}
		if (properties.form) {
			this.setForm(properties.form);
		}
		if (properties.triggertransition) {
			this.setTriggerTransition(properties.triggertransition);
		}
	},
	
	toJSON : function() {
		var formtask = FS.FormTask.superclass.toJSON.apply(this, arguments);
		formtask.users = this.getUsers();
		formtask.form = this.getForm();
		formtask.parameters = this.getParameters();
		formtask.triggertransition = this.getTriggerTransition();
		return formtask;
	},
	
	setUsers : function(users) {
		this.users = users;
	},
	
	getUsers : function() {
		return this.users;
	},
		
	setParamters : function(parameters) {
		this.parameters = parameters;
	},
	
	getParameters : function() {
		return this.parameters;
	},
	
	setTriggerTransition : function(triggertransition) {
		this.triggertransition = triggertransition;
	},
	
	getTriggerTransition : function() {
		return this.triggertransition;
	},
	
	setForm : function(form) {
		this.form = form;
	},
	
	getForm : function() {
		return this.form;
	},
	
	getType : function() {
		return "formtask";
	},
	
	paint : function(processdefine) {
		FS.FormTask.superclass.paint.call(this, processdefine);
	}
});
FS.TypeFunMap.put("formtask", FS.FormTask);

FS.JavaTask = FR.extend(FS.RectangleTask, {
	init : function(properties) {
		FS.JavaTask.superclass.init.apply(this, arguments);
	},
	
	parseJSON : function(properties) {
		if (properties.className){
			this.setClassName(properties.className);
		}
	},
	
	toJSON : function() {
		var javatask = FS.JavaTask.superclass.toJSON.apply(this, arguments);
		javatask.className = this.getClassName();
		return javatask;
	},
	
	getClassName : function() {
		return this.className;
	},
	
	setClassName : function(name) {
		this.className = name;
	},
	
	getType : function() {
		return "javatask";
	},
	
	paint : function(processdefine) {
		FS.JavaTask.superclass.paint.call(this, processdefine);
	}
});
FS.TypeFunMap.put("javatask", FS.JavaTask);


FS.ProcessTransition = FR.extend(FS.ProcessOb, {
	init : function() {
		FS.ProcessTransition.superclass.init.apply(this, arguments);
		this.points = [];
	},
	
	parseJSON : function(properties) {
		if (properties.name) {
			this.setName(properties.name);
		}
		if (properties.points) {
			this.points = properties.points;
		}
		if (properties.fromTask) {
			this.setFromTask(properties.fromTask);
		}
		if (properties.toTask) {
			this.setToTaskName(properties.toTask);
		}
	},
	
	toJSON : function() {
		var transition = {};
		transition.name = this.getName();
		transition.fromTask = this.getFromTask().getName();
		transition.toTask = this.getToTask().getName();
		transition.points = this.points;
		return transition;
	},
	
	removeSelf : function() {
		this.fromTask.removeTransition(this);
	},
	
	copySelf : function() {
		//do nothing
	},
	
	setName : function(name) {
		this.name = name;
	},
	
	getName : function() {
		return this.name;
	},
	
	setFromTask : function(task) {
		this.fromTask = task;
	},
	
	getFromTask : function() {
		return this.fromTask;
	},
	
	removeFromTask : function() {
		this.fromTask.removeTransition(this);
		this.fromTask = null;
	},
	
	setToTaskName : function(name) {
		this.toTaskName = name;
	},
	
	setToTask : function(task) {
		this.toTask = task;
	},
	
	getToTask : function() {
		if (!this.toTask && this.toTaskName != null) {
			this.toTask = this.fromTask.processDefine.getTask(this.toTaskName);
		}
		return this.toTask;
	},
	
	getToTaskName : function() {
		if (this.toTaskName != null) {
			return this.toTaskName;
		}
		if (this.toTask) {
			return this.toTask.getName();
		}
	},
	
	removeToTask : function() {
		this.toTaskName = null;
		this.toTask = null;
	},
	
	getAllPoints : function() {
		var ap = [];
		if (this.fromTask) {
			ap.push(this.exeStartPoint());
		}
		Array.prototype.push.apply(ap, this.points);
		if (this.toTask) {
			ap.push(this.exeEndPoint());
		}
		return ap;
	},
	
	exeStartPoint : function() {
		if (!this.fromTask) {
			return;
		}
		var sp = this.fromTask.getCenterPoint();
		var ep = this.points[0];
		if (!ep) {
			ep = this.getToTask().getCenterPoint();
		}
		//b:ʽƵóresult
		var cross;
		if (this.fromTask instanceof FS.CircleTask) {
			cross = this.circleCross(sp, ep);
		} else if (this.fromTask instanceof FS.RectangleTask) {
			cross = this.rectangleCross(sp, ep);
		}
		return cross;
	},
	
	circleCross : function(sp, ep) {
		var x = 0, y = 0;
		var dep = 20/Math.sqrt((sp.y - ep.y)*(sp.y - ep.y)/((sp.x - ep.x)*(sp.x - ep.x)) + 1);
		if (ep.x <= sp.x && ep.y <= sp.y) {
			if (sp.x == ep.x) {
				x = sp.x;
				y = sp.y - 20;
			} else {
				x = sp.x - dep;
				y = sp.y - dep*(sp.y - ep.y)/(sp.x - ep.x);
			}
		} else if (ep.x >= sp.x && ep.y >= sp.y) {
			if (sp.x == ep.x) {
				x = sp.x;
				y = sp.y + 20;
			} else {
				x = sp.x + dep;
				y = sp.y + dep*(sp.y - ep.y)/(sp.x - ep.x);
			}
		} else if (ep.x < sp.x && ep.y > sp.y) {
			x = sp.x - dep;
			y = sp.y + dep*(ep.y - sp.y)/(sp.x - ep.x);
		} else if (ep.x > sp.x && ep.y < sp.y) {
			x = sp.x + dep;
			y = sp.y - dep*(sp.y - ep.y)/(ep.x - sp.x);
		}
		return {
			x : Math.round(x),
			y : Math.round(y)
		};
	},
	
	rectangleCross : function(sp, ep) {
		var x = 0, y = 0;
		if (ep.x <= sp.x && ep.y <= sp.y) {
			if (sp.x - ep.x >= sp.y - ep.y) {
				x = sp.x - 20;
				y = sp.y - 20*(sp.y - ep.y)/(sp.x - ep.x);
			} else {
				x = sp.x - 20*(sp.x - ep.x)/(sp.y - ep.y);
				y = sp.y - 20;
			}
		} else if (ep.x >= sp.x && ep.y >= sp.y) {
			if (ep.x - sp.x >= ep.y - sp.y) {
				x = sp.x + 20;
				y = sp.y + 20*(sp.y - ep.y)/(sp.x - ep.x);
			} else {
				x = sp.x + 20*(sp.x - ep.x)/(sp.y - ep.y);
				y = sp.y + 20;
			}
		} else if (ep.x < sp.x && ep.y > sp.y) {
			if (sp.x - ep.x >= ep.y - sp.y) {
				x = sp.x - 20;
				y = sp.y + 20*(ep.y - sp.y)/(sp.x - ep.x);
			} else {
				x = sp.x - 20*(sp.x - ep.x)/(ep.y - sp.y);
				y = sp.y + 20;
			}
		} else if (ep.x > sp.x && ep.y < sp.y) {
			if (ep.x - sp.x >= sp.y - ep.y) {
				x = sp.x + 20;
				y = sp.y - 20*(ep.y - sp.y)/(sp.x - ep.x);
			} else {
				x = sp.x + 20*(sp.x - ep.x)/(ep.y - sp.y);
				y = sp.y - 20;
			}	
		}
		return {
			x : Math.round(x),
			y : Math.round(y)
		};
	},
	
	exeEndPoint : function() {
		if (!this.getToTask()) {
			return;
		}

		var sp = this.points.length > 0 ? this.points[this.points.length - 1] : this.fromTask.getCenterPoint();
		var ep = this.toTask.getCenterPoint();
		var cross;
		if (this.toTask instanceof FS.CircleTask) {
			cross = this.circleCross(ep, sp);
		} else if (this.toTask instanceof FS.RectangleTask) {
			cross = this.rectangleCross(ep, sp);
		}
		return cross;
	},
	
	//b:ͷλ,ֱ36
	exeArrowPoints : function(sp, ep, dis, vis) {
		var x = 0, y = 0;
		if (!dis) {
			dis = 6;
		}
		//ep.x === sp.x isnan
		var dep = dis/Math.sqrt(1 + (ep.y - sp.y)*(ep.y - sp.y)/((ep.x - sp.x)*(ep.x - sp.x)));
		if (sp.x >= ep.x && sp.y >= ep.y) {
			if (sp.x == ep.x) {
				x = ep.x;
				y = ep.y + dis;
			} else {
				x = ep.x + dep;
				y = ep.y + (ep.y - sp.y)/(ep.x - sp.x)*dep;
			}

		} else if (sp.x <= ep.x && sp.y <= ep.y) {
			if (sp.x == ep.x) {
				x = ep.x;
				y = ep.y - dis;
			} else {
				x = ep.x - dep;
				y = ep.y - (ep.y - sp.y)/(ep.x - sp.x)*dep;
			}

		} else if (sp.x < ep.x && sp.y > ep.y) {
			x = ep.x - dep;
			y = ep.y + (sp.y - ep.y)/(ep.x - sp.x)*dep;
		} else if (sp.x > ep.x && sp.y < ep.y) {
			x = ep.x + dep;
			y = ep.y - (sp.y - ep.y)/(ep.x - sp.x)*dep;
		}

		return this.apexPoints({
			x : x,
			y : y
		}, ep, dis, vis);
	},
	
	apexPoints : function(cross, end, dis, vis) {
		if (!vis) {
			vis = 3;
		}
		if (cross.y == end.y) {
			return [{
				x : Math.round(cross.x),
				y : Math.round(cross.y + vis)
			}, {
				x : Math.round(cross.x),
				y : Math.round(cross.y - vis)
			}];
		}
		var c1 = (end.x*end.x + end.y*end.y - dis*dis - cross.x*cross.x - cross.y*cross.y)/(2*(end.y - cross.y)) - cross.y,
			c2 = (end.x - cross.x)/(end.y - cross.y);
		var a = c2*c2 + 1, b = -2*(cross.x + c1*c2), c = cross.x*cross.x + c1*c1 - vis*vis;
		var x1 = (-b + Math.sqrt(b*b - 4*a*c))/(2*a);
		var y1 = c1 + cross.y - c2*x1;
		var x2 = (-b - Math.sqrt(b*b - 4*a*c))/(2*a); 
		var y2 = c1 + cross.y - c2*x2;
		return [{
			x : Math.round(x1),
			y : Math.round(y1)
		}, {
			x : Math.round(x2),
			y : Math.round(y2)
		}];
	},
	
	paintArrow : function(ctx, sp, ep) {
		var points = this.exeArrowPoints(sp, ep);
		ctx.save();
		ctx.beginPath();
		ctx.moveTo(ep.x, ep.y);
		ctx.lineTo(points[0].x, points[0].y);
		ctx.lineTo(points[1].x, points[1].y);
		ctx.lineTo(ep.x, ep.y);
		ctx.fillStyle = 'purple';
		ctx.fill();
		ctx.closePath();
		ctx.restore()
	},
	
	getPoints : function() {
		return this.points;
	},
	
	setNormalPoint : function(index, point) {
		this.points[index] = point;
	},
	
	addStart : function(point) {
		this.removeFromTask();
		this.points.unshift(point);
	},
	
	addEnd : function(point) {
		if (this.toTask) {
			this.points.push(point);
		} else {
			this.points[this.points.length - 1] = point;
		}
		this.removeToTask();	
	},
	
	removeStart : function() {
		this.points.shift();
	},
	
	removeEnd : function() {
		this.points.pop();
	},
	
	//bĬ
	insertPoint : function() {
		var points = this.getAllPoints();
		var len = points.length;
		var point = {
			x : (points[len - 1].x + points[len - 2].x)/2,
			y : (points[len - 1].y + points[len - 2].y)/2
		};
		if (this.getToTask() != null) {
			this.points.push(point);
		} else {
			this.points = this.points.pop().push(point).push(points[len - 1]);
		}		
	},
	
	removeNormalPoint : function() {
		var points = this.getAllPoints();
		if (points.length < 3) {
			return;
		} else {
			this.points.pop();
		}
	},
	
	paint : function(processdefine) {
		var ctx = processdefine.shapeContext;
		ctx.save();
		ctx.lineWidth = 2;
		ctx.beginPath();
		var points = this.getAllPoints();
		var len = points.length;
		for (var i = 0; i < len; i++) {
			if (i == 0) {
				ctx.moveTo(points[0].x, points[0].y);
			} else {
				ctx.lineTo(points[i].x, points[i].y);
			}
		}
		ctx.stroke();
		ctx.closePath();
		ctx.restore();
		this.paintArrow(ctx, points[len - 2], points[len - 1]);
		this.drawName(ctx, points[0], points[1]);
	},
	
	drawName : function(ctx, sp, ep) {
		if (!this.getName()) {
			return;
		}
		var point = sp;
		
		ctx.save();
		ctx.font = "10px" + ctx.font.split(/\d+px/)[1];
		var pointRotate = this.calTextRotate(sp, ep);
		ctx.translate(pointRotate.point.x, pointRotate.point.y);
		ctx.rotate(pointRotate.radian);
		ctx.fillText(this.getName(), 0, 0, 100);
		
		ctx.restore();	
		ctx.restore();		
	},
	
	//b:5px
	calTextRotate : function(sp, ep) {
		var points = this.exeArrowPoints(ep, sp, 20, 8);
		var radian = 0, point = points[0];
		var tan = Math.abs((sp.y - ep.y)/(sp.x - ep.x));
		if(sp.x >= ep.x && sp.y >= ep.y) {
			point.y = point.y - 4;
			if (sp.x == ep.x) {
				radian = 1.5*Math.PI;
			} else {
				radian = Math.PI + Math.atan(tan);
			}
		} else if (sp.x <= ep.x && sp.y <= ep.y) {
			if (sp.x == ep.x) {
				radian = 0.5*Math.PI;
			} else {
				radian = Math.atan(tan);
			}
		
		} else if (sp.x > ep.x && sp.y < ep.y) {
			point = points[1];
			point.y = point.y - 4;
			radian = Math.PI - Math.atan(tan);
		} else if (sp.x < ep.x && sp.y > ep.y) {
			point = points[1];
			radian = 2*Math.PI - Math.atan(tan);
		}
		return {
			point : point,
			radian : radian
		};
	},
	
		
	calTextLength : function(ctx, text, fontsize, vertical) {
		var tm = ctx.measureText(text);
		if (!vertical) {
			return tm.width;
		} else {
			return Math.max(fontsize*text.length, tm.height*text.length);
		}
	},
	
	paintState : function(processdefine) {
		processdefine.stateOb = new FS.TransitionState({
			factory : this
		});
		processdefine.stateOb.paint(processdefine);		
	},
	
	
	isInArea : function(point) {
		var points = this.getAllPoints();
		for (var i = 0, len = points.length; i < len - 1; i++) {
			if (this.judgePoint(point, points[i], points[i + 1])) {
				return true;
			}
		}
		return false;
	},
	
	//b:Ǿȷж
	judgePoint : function(point, sp, ep) {	
		if (sp.x == ep.x && point.x > sp.x - 4 && point.x < sp.x + 4 && point.y >= Math.min(sp.y, ep.y) && point.y <= Math.max(sp.y, ep.y)) {
			return true;
		} else if (sp.y == ep.y && point.y > sp.y - 4 && point.y < sp.y + 4 && point.x >= Math.min(sp.x, ep.x) && point.x <= Math.max(sp.x, ep.x)) {
			return true;
		} else if (point.x < Math.min(sp.x, ep.x) || point.x > Math.max(sp.x, ep.x) || point.y < Math.min(sp.y, ep.y) || point.y > Math.max(sp.y, ep.y)) {
			return false;
		}
		if (ep.x == sp.x && (point.x == ep.x || point.x == ep.x + 1 || point.x == ep.x - 1)) {
			return true;
		}

		var slope = Math.abs(ep.y - sp.y) > Math.abs(ep.x - sp.x) ? Math.abs((ep.x - sp.x)/(ep.y - sp.y)) : Math.abs((ep.y - sp.y)/(ep.x - sp.x))
		var ns = Math.abs(ep.y - sp.y) > Math.abs(ep.x - sp.x) ? Math.abs((point.x - sp.x)/(point.y - sp.y)) : Math.abs((point.y - sp.y)/(point.x - sp.x));
		if (ns < slope + 0.3 && ns > slope - 0.3) {
			return true;
		} 
		return false;
	},
	
	triggerMouseOver : function(e) {
//		return this.isInArea(FS.getPosition(e));
	},
	
	triggerMouseOut : function(e) {
		//nothing
	},
	
	triggerMouseDown : function(e) {
		if (this.isInArea(FS.getPosition(e))) {
			this.paintState(e.processdefine);
			return true;
		}
		return false;
	},
	
	triggerMouseUp : function(e) {
		//nothing
	},
	
	triggerKeyEvent : function(e) {
		
	},
	
	triggerDrag : function(e) {
		//nothing now
	},
	
	triggerDrop : function(e) {
		
	}
});
FS.TypeFunMap.put("transition", FS.ProcessTransition);

FS.StateObject = FR.extend(FS.ProcessPaintObject, {
	init : function() {
		this.factory = this.properties.factory;
	},
	
	getFactory : function() {
		return this.factory;
	},
	
	triggerKeyEvent : function(e) {
		var code = e.keyCode;
		if (code == FR.keyCode.DELETE) {
			this.getFactory().removeSelf();
			e.processdefine.stateOb = null;
			return true;
		}
		//ctrl + c
		else if (e.ctrlKey && code == 67) {
			this.getFactory().copySelf();
			return true;
		}		
	}
});

//b:transition icon
FS.TaskState = FR.extend(FS.StateObject, {
	width : 20,
	
	init : function() {
		FS.TaskState.superclass.init.apply(this, arguments);
	},
	
	apex : function() {
		var bounds = this.getFactory().getBounds();
		return {x : bounds.x + bounds.width + 3, y : bounds.y + bounds.height + 3};
	},
	
	paint : function(processdefine) {
		var ctx = processdefine.stateContext;
		this.getFactory().drawSelectedRect(processdefine);

		var img = $('img#fs_taskstate');
		if (img.length == 0) {
			img = $('<img/>').attr({'id': 'fs_taskstate', 'src' : FR.servletURL + "?op=resource&resource=/com/fr/process/web/images/dragtransition.png"}).css('display', 'none').appendTo($('body'));
			var self = this;
			img[0].onload = function() {
				self.drawImage(ctx, this, 0.5);
			}
		} else {
			this.drawImage(ctx, img[0], 0.5);
		}		
	},
	
	paintState : function(processdefine) {
		this.paint(processdefine);
	},
	
	drawImage : function(ctx, image, alpha) {
		if (this.getFactory() instanceof FS.EndTask) {
			return;
		}
		ctx.save();
		ctx.globalAlpha = alpha;
		var apex = this.apex();
		ctx.drawImage(image, apex.x, apex.y, 20, 20);
		ctx.restore();
	},
	
	paintMoveState : function(processdefine) {
		this.drawImage(processdefine.stateContext, $('img#fs_taskstate')[0], 1);
	},
	
	isInArea : function(point) {
		var apex = this.apex();
		return point.x >= apex.x && point.x <= apex.x + 20 && point.y >= apex.y && point.y <= apex.y + 20;
	},
	
	triggerMouseOver : function(e) {
		var point = FS.getPosition(e);
		if (this.isInArea(point)) {
			this.paintMoveState(e.processdefine);
			return true;
		} else {
			this.drawImage(e.processdefine.stateContext, $('img#fs_taskstate')[0], 0.5);
			return false;
		}
	},
	
	triggerMouseOut : function(e) {
		//do not in area
	},
	
	triggerMouseDown : function(e) {
		return this.isInArea(FS.getPosition(e));
	},
	
	triggerMouseUp : function(e) {
		//do nothing
	},
	
	triggerDrag : function(e, overOb) {
		var ctx = e.processdefine.stateContext;
		
		var color = 'red';
		if (overOb instanceof FS.ProcessTask && overOb != this.getFactory()) {
			color = '#66FF66';
		}
		e.processdefine.clearFore();
		var position = FS.getPosition(e);
		this.drawCircle(ctx, {
			x : position.x + 8,
			y : position.y + 25
		}, color);
	},
	
	drawCircle : function(ctx, point, color) {
		ctx.save();
		ctx.beginPath();
		ctx.strokeStyle = color;
		ctx.arc(point.x, point.y, 5, 0, Math.PI*2, false);
		ctx.stroke();
		ctx.closePath();
		ctx.restore();
	},
	
	triggerDrop : function(e, dropOb) {
		var fromtask = this.getFactory();
		if (dropOb instanceof FS.ProcessTask && dropOb != fromtask) {
			fromtask.addTransition(new FS.ProcessTransition({
				name : fromtask.processDefine.createNotRepeatName4Transition(),
				fromTask : fromtask,
				toTask : dropOb.getName()
			}));
		}
	}
});

//b:points
FS.TransitionState = FR.extend(FS.StateObject, {
	pointRadius : 5,
	
	init : function() {
		FS.TransitionState.superclass.init.apply(this, arguments);
	},
	
	paint : function(processdefine) {
		processdefine.clearFore();
		var ctx = processdefine.stateContext;
		var points = this.getFactory().getAllPoints();
		ctx.save();
		ctx.fillStyle = FS.ProcessColor.activedPointColor;
		for (var i = 0, len = points.length; i < len; i++) {
			this.drawPoint(ctx, points[i]);
		}
		ctx.restore();
	},
	
	paintState : function(processdefine) {
		this.paint(processdefine);
	},
	
	drawPoint : function(ctx, point) {
		ctx.beginPath();
		ctx.arc(point.x, point.y, this.pointRadius, 0, Math.PI*2, false);
		ctx.fill();
		ctx.closePath();
	},
	
	isInArea : function(point) {
		var points = this.getFactory().getAllPoints();
		for (var i = 0,len = points.length; i < len; i++) {
			var xd = point.x - points[i].x, yd = point.y - points[i].y;
			if (Math.sqrt(xd*xd + yd*yd) <= this.pointRadius) {
				this.activeIndex = i;
				return true;
			}
		}
		return false;
	},
	
	triggerMouseOver : function(e) {
		return this.isInArea(FS.getPosition(e));
	},
	
	triggerMouseOut : function(e) {
		//nothing
	},
	
	triggerMouseDown : function(e) {
		return this.isInArea(FS.getPosition(e));
	},
	
	triggerMouseUp : function(e) {
		//nothing
	},
	
	triggerDrag : function(e, overOb) {
		e.processdefine.clearFore();
		var ctx = e.processdefine.stateContext;
		ctx.save();
		ctx.fillStyle = FS.ProcessColor.activedPointColor;
		var len = this.getFactory().getAllPoints().length;
		if ((this.activeIndex == 0 && !(overOb instanceof FS.ProcessTask)) || (this.activeIndex > 0 && this.activeIndex < len - 1 && overOb instanceof FS.ProcessTask)) {
			ctx.fillStyle = FS.ProcessColor.forbiddenColor;
		}
		ctx.beginPath();
		var position = FS.getPosition(e);
		ctx.arc(position.x, position.y, this.pointRadius, 0, Math.PI*2, false);
		ctx.fill();
		
		ctx.restore();
	},
	
	triggerDrop : function(e, overOb) {
		var transition = this.getFactory();
		var len = transition.getAllPoints().length;
		var point = FS.getPosition(e);
		if (this.activeIndex > 0 && this.activeIndex < len - 1) {
			if (overOb instanceof FS.ProcessTask) {
				return;
			} else {
				transition.setNormalPoint(this.activeIndex - 1, point);	
			}
		} else if (this.activeIndex == 0 || this.activeIndex == len - 1) {
			if (overOb instanceof FS.ProcessTask) {
				if (this.activeIndex == 0) {
					if (!transition.getFromTask()) {
						transition.removeStart();
					}				
					transition.setFromTask(overOb);
				} else {
					if (!transition.getToTask()) {
						transition.removeEnd();
					}
					transition.setToTask(overOb);
				}
			} else {
				if (this.activeIndex == len - 1) {
					transition.addEnd(point);
				}
			}
		}		
	},
	
	triggerKeyEvent : function(e) {
		var code = e.keyCode;
		if (code == FR.keyCode.DELETE) {
			this.getFactory().removeSelf();
			e.processdefine.stateOb = null;
			return true;
		} else if (code == 65) {
			this.getFactory().insertPoint();
			return true;
		} else if (code == 68) {
			this.getFactory().removeNormalPoint();
			return true;
		}
		
	},
});

