(function($){
    FR.QuickTab = FR.extend(FR.Widget, {
        _defaultConfig: function () {
            return $.extend(FR.QuickTab.superclass._defaultConfig.apply(this, arguments), {
                baseCls: 'fr-core-tab',
                headerHeight: 33,
                tabWidth: 130,
                width: 1366,
                height: 400,
                style: null,
                home: null,
                homeText : FR.i18nText("FS-Home_Page"),
                homeWidth: 76,
                separatorWidth: 1,
                maxDisplayCount: 7,
                tabs: [],
                tabsHasAdded: [],
                tabsNotAdded: [],
                operationBtnConfig: {width: 25, height: 25, top: 6, leftFix: 3},
                borderWidth: 1
            });
        },
        _init: function () {
            FR.QuickTab.superclass._init.apply(this, arguments);
            var opts = this.options, self = this;
            var defaultStyle = "black";
            $.each(["black", "lightblue", "darkblue"], function (i, item) {
                if (opts.style && item == opts.style.toLowerCase()) {
                    defaultStyle = opts.style.toLowerCase();
                }
            });
            opts.style = defaultStyle;
            FR.$defaultImport("/com/fr/fs/web/css/fs.tab.css", "css");
            FR.$defaultImport("/com/fr/fs/web/css/" + defaultStyle +"/fs.tab.css", "css");
            this.element.addClass(opts.baseCls);
            this.$tabHeader = $('<div>').addClass('fr-core-tab-header').css({
                top : 0,
                left : 0
            }).appendTo(this.element);
            this.$tabBody = $('<div>').addClass('fr-core-tab-body').css({
                top : opts.headerHeight,
                left : 0
            }).appendTo(this.element);
            // richie:TMDʲôǳɫƣôʵǺò
            if (opts.style == 'lightblue') {
                opts.separatorWidth = 0;
            }
            if (opts.home) {
                this.home = new FR.TabMainPage({
                    text : opts.homeText,
                    style : opts.style,
                    width : opts.homeWidth,
                    separatorWidth:opts.separatorWidth,
                    contentHtml: opts.contentHtml,
                    src : opts.src,
                    tabControlHeight: opts.headerHeight,
                    containerWidth: opts.width,
                    containerHeight: opts.height - opts.borderWidth,
                    onClick : function(){
                        self._doAllUnselect();
                    }
                });
                this.home.add2Container(this);
                this._showHome();
            }
            this.doResize({
                width: opts.width,
                height: opts.height
            });

        },
        _addOrModifyOperationButton: function (position) {
            var opts = this.options, self = this;
            if (this.operationBtn) {
                if (opts.tabs.length < opts.maxDisplayCount + 1) {
                    this.operationBtn.element.css({
                        left: position + opts.operationBtnConfig.leftFix
                    });
                }
            } else {
                this.operationBtn = new FR.OperationBtn({
                    style : opts.style,
                    onClick: function () {
                        var popup = new FR.TabPopup({
                            operationBtn : self.operationBtn,
                            tabs : opts.tabsNotAdded,
                            onCloseAll: function () {
                                self._removeAllTabs();
                                self._showHome();
                            },
                            onSelect: function (tab) {
                                var offset = opts.lastTab.element.position();
                                opts.lastTab.hideFromContainer(self);
                                opts.lastTab = tab;
                                tab.showFromContainer(self);
                                tab.element.css({
                                    left : offset.left
                                });
                                tab.doSelect();
                            }
                        });
                        popup.showAtElement($(this));
                    }
                });
                this.operationBtn.element.css({
                    position: 'absolute',
                    top: opts.operationBtnConfig.top,
                    left: position + opts.operationBtnConfig.leftFix,
                    width: opts.operationBtnConfig.width,
                    height: opts.operationBtnConfig.height
                }).appendTo(this.$tabHeader);
            }
        },
        _modifyOperationButtonWithAnimation : function(dis) {
            this.operationBtn.element.animate({
                left : '-=' + dis
            });
        },
        _removeOperationButton : function(){
            this.operationBtn.element.remove();
            this.operationBtn = null;
        },
        _showHome : function() {
            if (this.home) {
                this.home.showFromContainer();
            }
        },
        _hideHome : function() {
            if (this.home) {
                this.home.hideFromContainer();
            }
        },
        _doAllUnselect : function() {
            var opts = this.options;
            for (var i = 0; i < opts.tabs.length; i ++) {
                opts.tabs[i].doUnselect();
            }
        },
        addItem : function(item) {
            var opts = this.options;
            if(!item.contentHtml) {
            	item.contentHtml = item.contentEl;
            }
            var i = 0;
            for(;i < opts.tabsHasAdded.length; i++){
                if(this.compareItems(opts.tabsHasAdded[i].options.item, item)){
                	$.extend(true, opts.tabsHasAdded[i].options, item);
                	opts.tabsHasAdded[i].refresh(this);
                    break;
                }
            }
            if(i < opts.tabsHasAdded.length){
                opts.tabsHasAdded[i].doSelect();
                return true;
            }else{
                i = 0;
                for(;i < opts.tabsNotAdded.length; i++){
                    if(this.compareItems(opts.tabsNotAdded[i].options.item, item)){
                    	$.extend(true, opts.tabsNotAdded[i].options, item);
                    	opts.tabsNotAdded[i].refresh(this, item);
                        break;
                    }
                }
                if(i < opts.tabsNotAdded.length){
                    var tab = opts.tabsNotAdded[i];
                    var offset = opts.lastTab.element.position();
                    opts.lastTab.hideFromContainer(this);
                    opts.lastTab = tab;
                    tab.showFromContainer(this);
                    tab.element.css({
                        left : offset.left
                    });
                    tab.doSelect();
                    return true;
                }else{
                    this.addTab(item);
                }
            }
            return false;
        },
        addTab: function (item) {
            var opts = this.options, self = this;
            this._hideHome();
            var tab = new FR.TabComposite({
                item: item, //ڱȽȥ
                text: item.text || item.title,
                style : opts.style,
                contentHtml: item.contentHtml || item.contentEl,
                src : item.src,
                contentWidget: item.contentWidget,
                tabControlWidth: opts.tabWidth,
                tabSeparatorWidth: opts.separatorWidth,
                tabControlHeight: opts.headerHeight,
                containerWidth: opts.width,
                containerHeight: opts.height - opts.borderWidth,
                onResize:item.onResize,
                onClose: function (e) {
                    var need2Close = true;
                    if (item.need2Close && $.isFunction(item.need2Close)) {
                        need2Close = item.need2Close(this, e);
                    }
                    if (need2Close) {
                        if (this.isSelected()) {
                            self.closeActiveTab();
                        } else {
                            var left = this.element.offset().left;
                            this.removeFromContainer(self);
                            self._moveOtherTabsAfterCloseTab(left);
                            if(self.options.tabsHasAdded.length > 0){
                                self.options.lastTab = self.options.tabsHasAdded[self.options.tabsHasAdded.length - 1];
                            }
                        }
                    }
                },
                onSelect: function () {
                    self._hideHome();
                    var tabs = self.options.tabs;
                    for (var i = 0; i < tabs.length; i++) {
                        if (tabs[i] != this) {
                            tabs[i].doUnselect();
                        } else {
                            tabs[i].doSelect();
                        }
                    }
                    if($.browser.mozilla) {
                        var iframe = $('iframe', this.tabContent.element);
                        if (iframe.length > 0) {
                            var cw = iframe[0].contentWindow;
                            var contentContainer = $('#content-container', cw.document.body);
                            if (contentContainer.length > 0) {
                                contentContainer.css('overflow', 'hidden');
                                setTimeout(function () {
                                    contentContainer.css('overflow', 'auto');
                                }, 100);
                            }
                        }
                    }
                }
            });
            var left = opts.homeWidth + Math.min(opts.tabsHasAdded.length, opts.maxDisplayCount - 1) * (opts.tabWidth + opts.separatorWidth);
            tab.element.css({
                position: 'absolute',
                top: 0,
                left: left
            });
            if (opts.tabs.length + 1 > opts.maxDisplayCount) {
                opts.tabs.splice(opts.maxDisplayCount - 1, 0, tab);
                opts.lastTab.hideFromContainer(this);
                opts.lastTab = tab;
                tab.add2Container(this);
            } else {
                // ¼һұߵtab
                opts.tabs.push(tab);
                opts.lastTab = opts.tabs[opts.tabsHasAdded.length];
                tab.add2Container(this);
            }
            this._addOrModifyOperationButton(left + opts.tabWidth + opts.separatorWidth);
        },

        closeActiveTab: function () {
            var currentTab;
            var currentTabNum;
            for (var i = 0, len = this.options.tabsHasAdded.length; i < len; i++) {
                var cu = this.options.tabsHasAdded[i];
                if (cu.isSelected()) {
                    currentTab = cu;
                    currentTabNum = i;
                }
            }
            if (!currentTab) {
                return;
            }
            var left = currentTab.element.offset().left;
            currentTab.removeFromContainer(this);
            this._moveOtherTabsAfterCloseTab(left);
            if (this.options.tabsHasAdded.length > 0) {
                // رһǩҳ֮󣬼һǩҳûкһǩҳ򼤻ǰһǩҳ
                if (currentTabNum < this.options.tabsHasAdded.length) {
                    this.options.tabsHasAdded[currentTabNum].doSelect()
                } else {
                    this.options.tabsHasAdded[currentTabNum-1].doSelect()
                }
                this.options.lastTab = this.options.tabsHasAdded[this.options.tabsHasAdded.length - 1];
            }
        },

        _moveOtherTabsAfterCloseTab: function (left) {
            var opts = this.options, self = this;
            var fn = function() {
                if (opts.tabsHasAdded.length < opts.maxDisplayCount && opts.tabsNotAdded.length > 0) {
                    var tab = opts.tabsNotAdded[0];
                    tab.element.css({
                        left : opts.homeWidth + (opts.maxDisplayCount - 1)*(opts.tabWidth + opts.separatorWidth)
                    });
                    tab.showFromContainer(self);
                    tab.doUnselect();
                } else {
                    self._modifyOperationButtonWithAnimation(opts.tabWidth + opts.separatorWidth);
                }
            };
            for (var i = 0; i < opts.tabsHasAdded.length; i ++) {
                var newT = opts.tabsHasAdded[i];
                if (newT.element.offset().left > left) {
                    newT.element.animate({
                        left : '-=' + (opts.tabWidth + opts.separatorWidth)
                    }, 300);
                }
            }
            fn();

            if (opts.tabsHasAdded.length === 0) {
                this._removeOperationButton();
                this._showHome();
            }
        },

        _removeAllTabs : function() {
            var opts = this.options;
            for (var i = 0; i < opts.tabsHasAdded.length; i ++) {
                opts.tabsHasAdded[i].destroy();
            }
            opts.tabsHasAdded.clear();
            for (var j = 0; j < opts.tabsNotAdded.length; j ++) {
                opts.tabsNotAdded[j].destroy();
            }
            opts.tabsNotAdded.clear();
            opts.tabs.clear();
            this._removeOperationButton();
        },

        _calculateMaxCount : function() {
        	var opts = this.options;
        	var headerWidth = opts.width;
        	return parseInt((headerWidth - opts.homeWidth - opts.operationBtnConfig.width - 10)/(opts.tabWidth + opts.separatorWidth));
        },

        doResize: function (give) {
            var opts = this.options;
            if (give) {
                if (give.left) {
                    opts.left = give.left;
                }
                if (give.top) {
                    opts.top = give.top;
                }
                if (give.width) {
                    opts.width = give.width;
                }
                if (give.height) {
                    opts.height = give.height;
                }
            }
            if (opts.top) {
                this.element.css({top : opts.top});
            }
            if (opts.left) {
                this.element.css({left : opts.left});
            }
            this.element.css({
                width: opts.width,
                height: opts.height
            });
            var fixHeight = 0;
            if ($.support.boxModel) {
                fixHeight = this.$tabHeader.outerHeight() - this.$tabHeader.height();
            }
            this.$tabHeader.css({
                width: opts.width,
                height: opts.headerHeight - fixHeight
            });
            this.$tabBody.css({
                width: opts.width,
                height: opts.height - opts.headerHeight - opts.borderWidth
            });
            if(opts.home){
                this.home.tabContent.doResize({width : opts.width, height : opts.height - opts.headerHeight - opts.borderWidth});
            }
            for (var i = 0; i < opts.tabs.length; i ++) {
                opts.tabs[i].options.containerWidth = opts.width;
                opts.tabs[i].options.containerHeight = opts.height - opts.borderWidth;
                opts.tabs[i].tabContent.doResize({width : opts.width, height : opts.height - opts.headerHeight - opts.borderWidth});
            }
            //wei : doresizetabHeaderչʾtabӦtabҲҪ仯
            this._showOrHideTabOnResize();

        },

        _showOrHideTabOnResize : function() {
        	//weiһֱĻܿʱִ
        	var opts = this.options;
        	if (this.resizeid != null) {
				clearTimeout(this.resizeid);
				this.resizeid = null;
			}
			this.resizeid = setTimeout(function() {
					opts.maxDisplayCount = this._calculateMaxCount();
	            if((opts.tabsHasAdded.length < opts.maxDisplayCount) && opts.tabsNotAdded.length > 0) {
      				//ҪʾtabҪӽtabĿ
	      			var toShowLength = Math.min(opts.tabsNotAdded.length, opts.maxDisplayCount - opts.tabsHasAdded.length);
	      			//¼¹رհťҪƶľ
	      			var buttonLeft = 0;
	      			for(var i = 0; i < toShowLength; i ++) {
	      				var tab = opts.tabsNotAdded[0];
		                tab.element.css({
		                    left : opts.homeWidth + opts.tabsHasAdded.length*(opts.tabWidth + opts.separatorWidth)
		                });
		                tab.showFromContainer(this);
		                tab.doUnselect();
		                buttonLeft += (opts.tabWidth + opts.separatorWidth);
	      			}
	      			opts.lastTab = opts.tabsHasAdded[opts.tabsHasAdded.length - 1];
	      			this._modifyOperationButtonWithAnimation(0 - buttonLeft);
	            } else if(opts.tabsHasAdded.length > opts.maxDisplayCount) {
	            	//СҪѾʾtab±tabĿ
	            	var toHideLength = opts.tabsHasAdded.length - opts.maxDisplayCount;
	            	var buttonLeft = 0;
	            	for(var i = 0; i < toHideLength; i ++) {
	            		var tab = opts.lastTab;
	            		if(tab.isSelected()) {
	            			//ҪtabǰǴ򿪵ģͲߵtab
	            			if(opts.tabsHasAdded.length === 1) {
	            				//һˣʲô
	            				break ;
	            			} else {
	            				//ߵtab
	            				var tabNeedHide = opts.tabsHasAdded[opts.tabsHasAdded.length - 2];
	            				tabNeedHide.hideFromContainer(this);
	            				tab.element.css({
	            					left : "-=" + (opts.tabWidth + opts.separatorWidth)
	            				});
	            			}
	            		} else {
	            			tab.hideFromContainer(this);
		                    opts.lastTab = opts.tabsHasAdded[opts.tabsHasAdded.length - 1];
	            		}
	            		buttonLeft += (opts.tabWidth + opts.separatorWidth);
	            	}
	            	this._modifyOperationButtonWithAnimation(buttonLeft);
	            }
				this.resizeid = null;
			}.createDelegate(this), 200);
        },

        //Ƚ2JSONֵǷȣjqueryfunctionʱԱȣ˴FR.equals
        compareItems: function(v1, v2){
            if (FR.isNull(v1) || FR.isNull(v2)) {
                return v1 == undefined && v2 == undefined || v1 == null && v2 == null
            }
            if (v1 === v2) {
                return true;
            } else if ($.isArray(v1)) {
                if (v1.length == v2.length) {
                    for (var i = 0; i < v1.length; i++) {
                        if (!this.compareItems(v1[i], v2[i])) {
                            return false;
                        }
                    }
                } else {
                    return false;
                }
            } else if((v1 instanceof $ && v2 instanceof $) || ($.isFunction(v1) && $.isFunction(v2))){
                return true;
            } else if (typeof v1 == 'object') {
            	if(v1.title === v2.title) {
            		return true;
            	} else {
            		return false;
            	}
//                var lv1 = 0, lv2 = 0;
//                for (var i in v1) {
//                    lv1++;
//                }
//                for (var i in v2) {
//                    lv2++;
//                }
//                if (lv1 != lv2) {
//                    return false;
//                }
//                for (var a in v1) {
//                    if (!this.compareItems(v1[a], v2[a])) {
//                        return false;
//                    }
//                }
            } else {
                return v1 === v2
            }
            return true;
        },
        //ṩBI޸tabƵĽӿ
        reNameTab: function(originalName, newName) {
            var tabs = this.options.tabs;
            for(var i = 0, len = tabs.length; i < len; i ++) {
                if(tabs[i].options.text == originalName) {
                    tabs[i].reName(newName);
                    return ;
                }
            }
        }
    });
    $.shortcut('quicktab', FR.QuickTab);

    FR.TabMainPage = FR.extend(FR.Widget, {
        _defaultConfig: function () {
            return $.extend(FR.TabMainPage.superclass._defaultConfig.apply(this, arguments), {
                baseCls: 'fr-core-tab-main-page',
                text : '',
                btnWidth : 50,
                btnHeight : 25,
                btnTop : 5,
                btnLeft : 10,
                onClick : null
            });
        },

        _init: function () {
            FR.TabMainPage.superclass._init.apply(this, arguments);
            var opts = this.options, self = this;
            if(!opts.contentHtml && opts.src) {
            	opts.contentHtml = $('<iframe/>').css({height : '100%', width : '100%'});
            	opts.contentHtml.show();
            	opts.contentHtml.attr({frameborder : 0, src : encodeURI(opts.src)})
            }
            $('<div class="fr-core-tab-home"></div>').css({
                width: opts.btnWidth,
                height: opts.btnHeight,
                position: 'absolute',
                top: opts.btnTop,
                left: opts.btnLeft,
                lineHeight: opts.btnHeight + 'px',
                textAlign: 'center'
            }).text(opts.text).hover(function(){
                    $(this).addClass('fr-core-tab-home-hover');
                }, function(){
                    $(this).removeClass('fr-core-tab-home-hover');
                }).bind('click', function(){
                    if ($.isFunction(opts.onClick)) {
                        opts.onClick.apply();
                    }
                    self.showFromContainer();
                }).appendTo(this.element);
            var borderColor = opts.style == 'darkblue'?'#3C698E':'#5F5E5E';
            $('<div>').css({
                borderRight: opts.separatorWidth + 'px solid '+ borderColor,
                width: 0,
                height: opts.tabControlHeight,
                position: 'absolute',
                top: 0,
                left: opts.width - opts.separatorWidth
            }).appendTo(this.element);
            this.element.css({
                width : opts.width,
                height : opts.tabControlHeight
            });

            this.tabContent = new FR.Panel({
                contentHtml: opts.contentHtml,
                closed: true,
                doSize: true,
                noLoading : true,
                width: opts.containerWidth,
                height: opts.containerHeight - opts.tabControlHeight
            });
        },
        add2Container : function(container) {
            this.element.css({
                position : 'absolute',
                top : 0,
                left : 0
            }).appendTo(container.$tabHeader);
            this.tabContent.element.appendTo(container.$tabBody);
        },
        hideFromContainer : function() {
            this.tabContent.setVisible(false);
        },
        showFromContainer : function() {
            this.tabContent.setVisible(true);
        }
    });

    FR.OperationBtn = FR.extend(FR.Widget, {
        _defaultConfig: function () {
            return $.extend(FR.OperationBtn.superclass._defaultConfig.apply(this, arguments), {
                baseCls: 'fr-core-tab-control-more',
                width: 25,
                height: 25,
                onClick: null
            });
        },

        _init: function () {
            FR.OperationBtn.superclass._init.apply(this, arguments);
            var opts = this.options;
            this.element.hover(function () {
                $(this).addClass('fr-core-tab-control-more-hover');
            },function () {
                $(this).removeClass('fr-core-tab-control-more-hover');
            }).bind('click', function () {
                    if ($.isFunction(opts.onClick)) {
                        opts.onClick.apply(this);
                    }
                });
            this.element.css({
                width: opts.width,
                height: opts.height
            });
        }
    });

    FR.TabComposite = FR.extend(FR.Widget, {
        _defaultConfig: function () {
            return $.extend(FR.TabComposite.superclass._defaultConfig.apply(this, arguments), {
                baseCls: 'fr-core-tab-composite',
                tabControlWidth: 130,
                tabSeparatorWidth: 1,
                tabControlHeight: 33
            });
        },
        _init: function () {
            FR.TabComposite.superclass._init.apply(this, arguments);
            var opts = this.options;
            if(!opts.contentHtml && opts.src) {
            	opts.contentHtml = $('<iframe/>').css({height : '100%', width : '100%'})
            }
            this.tabControl = new FR.TabControl({
                text: opts.text,
                style : opts.style,
                width : opts.tabControlWidth,
                height : opts.tabControlHeight,
                composite: this,
                onClose: opts.onClose,
                onSelect: opts.onSelect
            });
            this.tabControl.element.css({
                position: 'absolute',
                top: 0,
                left: 0
            });
            this.element.append(this.tabControl.element);
            var borderColor = opts.style == 'darkblue'?'#3C698E':'#5F5E5E';
            var $sep = $('<div>').css({
                borderRight: opts.tabSeparatorWidth + 'px solid '+borderColor,
                width: 0,
                height: opts.tabControlHeight,
                position: 'absolute',
                top: 0,
                left: opts.tabControlWidth
            });
            this.element.append($sep);
            this.element.css({
                width: opts.tabControlWidth + opts.tabSeparatorWidth,
                height: opts.tabControlHeight
            });
            this.tabContent = new FR.Panel({
                contentHtml: opts.contentHtml,
                contentWidget: opts.contentWidget,
                closed: true,
                doSize: true,
                noLoading : true,
                width: opts.containerWidth,
                height: opts.containerHeight - opts.tabControlHeight,
                onResize:opts.onResize
            });
        },



       _execudeSrc : function (){
		 var opts = this.options;
		    if(opts.src && opts.contentHtml) {
		    	opts.contentHtml.show();
		    	opts.contentHtml.attr({frameborder : 0, src : encodeURI(opts.src)})
		    }
       },

       refresh:function(container) {
       		var opts = this.options;
       		this.tabContent.element.remove();
       		if(!opts.contentHtml && opts.src) {
            	opts.contentHtml = $('<iframe/>').css({height : '100%', width : '100%'})
            }
            this.tabContent = new FR.Panel({
                contentHtml: opts.contentHtml || opts.contentEl,
                contentWidget: opts.contentWidget,
                closed: true,
                doSize: true,
                noLoading : true,
                width: opts.containerWidth,
                height: opts.containerHeight - opts.tabControlHeight,
                onResize:opts.onResize
            });
            this.tabContent.element.appendTo(container.$tabBody);
            this.doSelect();
            this._execudeSrc();
       },

        add2Container: function (container) {
            container.options.tabsHasAdded.push(this);
            container.$tabHeader.append(this.element);
            container.$tabBody.append(this.tabContent.element);
            this.doSelect();
            this._execudeSrc();
        },
        removeFromContainer: function (container) {
            container.options.tabsHasAdded.remove(this);
            container.options.tabsNotAdded.remove(this);
            container.options.tabs.remove(this);
            this.element.remove();
            if($.browser.msie && $.browser.version == '8.0'){
                this.tabContent.element.find('iframe').attr('src','');
            }
            this.tabContent.element.remove();
        },
        hideFromContainer : function (container) {
            container.options.tabsHasAdded.remove(this);
            container.options.tabsNotAdded.push(this);
            this.element.hide();
            this.tabContent.setVisible(false);
        },
        showFromContainer : function (container) {
            container.options.tabsHasAdded.push(this);
            container.options.tabsNotAdded.remove(this);
            this.element.show();
            this.tabContent.setVisible(true);
        },

        isSelected : function() {
            return this.tabControl.isSelected();
        },

        doSelect: function () {
            this.tabControl.doSelect();
            this.tabContent.setVisible(true);
        },
        doUnselect: function () {
            this.tabControl.doUnselect();
            this.tabContent.setVisible(false);
        },
        destroy : function(){
            FR.TabComposite.superclass.destroy.apply(this, arguments);
            this.tabContent.destroy();
        },
        reName: function(newName) {
            this.tabControl.reName(newName);
            this.options.text = newName;
        }
    });

    FR.TabControl = FR.extend(FR.Widget, {
        _defaultConfig: function () {
            return $.extend(FR.TabControl.superclass._defaultConfig.apply(this, arguments), {
                baseCls: 'fr-core-tab-control',
                text: 'Tab',
                style: null,
                height: 33,
                width: 130,
                iconWidth: 23,
                leftSpaceWidth: 7, //Sean һǩߵľ
                onClose: null,
                onSelect: null,
                selected: false,
                topGap: 2
            });
        },
        _init: function () {
            FR.TabControl.superclass._init.apply(this, arguments);
            var opts = this.options, self = this;
            // richie:TMDʲôǳɫƣôʵǺò
            if (opts.style == 'lightblue') {
                opts.topGap = 0;
                opts.height = opts.height - 5;
            }
            this.element.addClass(opts.baseCls)
                .css({width: opts.width, height: opts.height})
                .hover(function () {
                    self._mouseEnter();

                },function () {
                    self._mouseExit();
                }).click(function () {
                    self.doSelect();
                });
            this.$text = $('<div>').addClass('fr-core-tab-control-text').css({
                width: opts.width - opts.iconWidth - opts.leftSpaceWidth,
                height: opts.height,
                lineHeight: opts.height + 'px'
            }).attr('title',opts.text).text(opts.text);
            this.$text.appendTo(this.element);
            this.$iconWrapper = $('<div>')
                .addClass('fr-core-tab-control-icon-wrapper')
                .css({width: opts.iconWidth, height: opts.height, cursor: 'pointer'});
            $('<div>').addClass('fr-core-tab-control-icon')
                .click(function (e) {
                    if ($.isFunction(opts.onClose)) {
                        opts.onClose.apply(opts.composite, $.makeArray(e));
                    }
                }).appendTo(this.$iconWrapper);
            this.$iconWrapper.appendTo(this.element);
            this.doResize({
                top: opts.topGap,
                left: opts.left,
                width: opts.width,
                height: opts.height
            });
        },

        _mouseEnter: function () {
            var opts = this.options;
            if (opts.selected) {
                return;
            }
            this.element.addClass('fr-core-tab-control-hover');
            opts.mouseEnter = true;
        },
        _mouseExit: function () {
            var opts = this.options;
            if (opts.selected) {
                return;
            }
            this.element.removeClass('fr-core-tab-control-hover');
            opts.mouseEnter = false;
        },

        isSelected : function() {
            return this.options.selected;
        },

        doSelect: function () {
            var opts = this.options;
            if (opts.selected === true) {
                return;
            }
            opts.selected = true;
            this.element.removeClass('fr-core-tab-control-hover');
            this.element.addClass('fr-core-tab-control-select');
            this.doResize({
                top: opts.topGap,
                left: opts.left,
                width: opts.width,
                height: opts.height
            }, false);
            if ($.isFunction(this.options.onSelect)) {
                this.options.onSelect.apply(this.options.composite);
            }
        },
        doUnselect: function () {
            var opts = this.options;
            if (!opts.selected) {
                return;
            }
            opts.selected = false;
            this.element.removeClass('fr-core-tab-control-select');
        },
        doResize: function (give) {
            var opts = this.options;

            if (give && arguments[1] !== false) {
                if (give.width) {
                    opts.width = give.width;
                }
                if (give.height) {
                    opts.height = give.height;
                }
            }
            if (give.left != null) {
                opts.left = give.left;
            }
            if (give.top != null) {
                opts.top = give.top;
            }
            this.element.css({
                left: opts.left,
                // richie:TMDʲôǳɫƣôʵǺò
                top: opts.top  + (opts.style == 'lightblue' ? 5 : 0)
            });

            this.fixWidth = 0;
            this.fixHeight = 0;
            if ($.support.boxModel === true) {
                this.fixWidth = this.element.outerWidth() - this.element.width();
                this.fixHeight = this.element.outerHeight() - this.element.height();
            } else {
                this.element.css({
                    width: opts.width,
                    height: opts.height
                });
            }
            var width = arguments[1] !== false ? opts.width : give.width - this.fixWidth;
            var height = arguments[1] !== false ? opts.height : give.height - this.fixHeight;
            height -= opts.top;
            this.element.css({
                width: width,
                height: height
            });
            this.$text.css({
                width: width - opts.iconWidth - opts.leftSpaceWidth,
                height: height,
                lineHeight: height + 'px'
            });
            this.$iconWrapper.css({
                width: opts.iconWidth,
                height: height
            });
        },
        reName: function(newName) {
            this.$text.attr('title',newName).text(newName)
            this.options.text = newName;
        }
    });

    FR.TabPopup = FR.extend(FR.Widget, {
        _defaultConfig: function () {
            return $.extend(FR.TabPopup.superclass._defaultConfig.apply(this, arguments), {
                baseCls: 'fr-core-tab-popup',
                width: 112,
                widthWhenHasScroll: 121,
                borderWidth: 1,
                itemHeight: 30,
                textHeight: 24,
                separatorHeight: 1,
                maxCount: 6,
                invisible: true,
                scrollWidth: 5,
                closeAllText: FR.i18nText("CloseAll"),
                onCloseAll: null,
                onSelect: null
            });
        },
        _init: function () {
            FR.TabPopup.superclass._init.apply(this, arguments);
            var opts = this.options, self = this;
            this.element.addClass(opts.baseCls);
            var width = opts.width - 2 * opts.borderWidth;
            var height = (opts.tabs.length + 1) * (opts.itemHeight + opts.separatorHeight) - opts.separatorHeight;
            if (opts.tabs.length > opts.maxCount) {
                width = opts.widthWhenHasScroll - 2 * opts.borderWidth;
                height = (opts.maxCount + 1) * opts.itemHeight;
                opts.willHasScroller = true;
            }

            var $close = this._createFullItem({
                top: 0,
                left: 0,
                width: width,
                height: opts.itemHeight
            }, opts.closeAllText, function () {
                if ($.isFunction(opts.onCloseAll)) {
                    opts.onCloseAll.apply(self);
                }
                self.destroy();
            });
            $close.appendTo(this.element);
            if (!opts.willHasScroller) {
                for (var i = 0; i < opts.tabs.length; i++) {
                    var top = (i + 1) * opts.itemHeight + i * opts.separatorHeight;
                    var tab = opts.tabs[i];
                    this._createFullSeparator({
                        top: top,
                        left: 0,
                        width: width
                    }).appendTo(this.element);
                    this._createFullItem({
                        top: top + opts.separatorHeight,
                        left: 0,
                        width: width,
                        height: opts.itemHeight
                    }, tab.options.text,function (t) {
                        if ($.isFunction(opts.onSelect)) {
                            opts.onSelect.apply(self, [t]);
                        }
                        self.destroy();
                    }, tab).appendTo(this.element);
                }
            } else {
                this.$center = $('<div class="fr-core-tab-more-center">').css({
                    width: width - 4,
                    height: height - opts.itemHeight,
                    position: 'absolute',
                    top: opts.itemHeight,
                    left: 2
                }).appendTo(this.element);
                var $items = $('<div class="fr-core-tab-more-center-scroll">').css({
                    width: width - 4,
                    height: opts.tabs.length * (opts.itemHeight + opts.separatorHeight)
                }).appendTo(this.$center);
                for (var i = 0; i < opts.tabs.length; i++) {
                    var tab = opts.tabs[i];
                    var top = i * opts.itemHeight + i * opts.separatorHeight;
                    this._createFullSeparator({
                        top: top,
                        left: 0,
                        width: width - opts.scrollWidth - 2 - 4
                    }).appendTo($items);
                    this._createFullItem({
                        top: top + opts.separatorHeight,
                        left: 0,
                        width: width - opts.scrollWidth - 2 - 4,
                        height: opts.itemHeight
                    }, tab.options.text,function (t) {
                        if ($.isFunction(opts.onSelect)) {
                            opts.onSelect.apply(self, [t]);
                        }
                        self.destroy();
                    }, tab).appendTo($items);
                }

            }
            $('body').bind('click', function(e){
                if (!$(e.target).isChildAndSelfOf(self.element) && !$(e.target).isChildAndSelfOf(opts.operationBtn.element)) {
                    self.destroy();
                }
            });
            this.element.bind('mouseleave', function(){
                self.destroy();
            });
            this.element.css({
                width: width,
                height: height
            });
        },

        _createFullItem: function (rect, text, hander, tab) {
            var showValue = FS.getShowText(text,94,12,'SimSun');
            return $('<div class="fr-core-tab-control-menu-item"></div>')
                .attr('title',text)
                .text(showValue)
                .css({
                position: 'absolute',
                cursor: 'default',
                top: rect.top,
                left: rect.left,
                width: rect.width,
                height: rect.height,
                lineHeight: rect.height + 'px',
                'white-space': 'nowrap'
            }).hover(function () {
                    $(this).addClass('fr-core-tab-control-menu-item-hover');
                    $(this).css({
                        top: parseInt(this.style.top) + 2,
                        left: parseInt(this.style.left) + 2,
                        width: parseInt(this.style.width) - 4,
                        height: parseInt(this.style.height) - 4,
                        lineHeight: parseInt(this.style.height) - 4 + 'px'
                    });
                },function () {
                    $(this).removeClass('fr-core-tab-control-menu-item-mouse-down');
                    $(this).removeClass('fr-core-tab-control-menu-item-hover');
                    $(this).css({
                        top: parseInt(this.style.top) - 2,
                        left: parseInt(this.style.left) - 2,
                        width: parseInt(this.style.width) + 4,
                        height: parseInt(this.style.height) + 4,
                        lineHeight: parseInt(this.style.height) + 4 + 'px'
                    });
                }).bind('mousedown',function () {
                    $(this).addClass('fr-core-tab-control-menu-item-mouse-down');
                }).bind('mouseup',function () {
                    $(this).removeClass('fr-core-tab-control-menu-item-mouse-down');
                }).bind('click', $.isFunction(hander) ? hander.createDelegate(this, [tab]) : null);
        },
        _createFullSeparator: function (rect) {
            return  $('<div class="fr-core-tab-control-menu-item-sep"></div>').css({
                position: 'absolute',
                top: rect.top,
                left: rect.left,
                width: rect.width,
                height: this.options.separatorHeight
            });
        },
        showAtElement: function (el) {
            var opts = this.options;
            this.setVisible(true);
            this.element.appendTo('body');
            if (el) {
                var offset = $(el).offset();
                var width = $(el).outerWidth();
                var height = $(el).outerHeight();
                this.element.css({
                    top: offset.top + height,
                    left: offset.left + width - (opts.willHasScroller ? opts.widthWhenHasScroll : opts.width),
                    'z-index': FR.widget.opts.zIndex++
                });
            }
            if (this.$center) {
                this.$center.jscroll({
                    W: opts.scrollWidth + 'px',
                    Btn: {btn: false},
                    Bg: {cls : 'fr-core-tab-popup-scroll'},
                    Bar: {
                        Bg: {cls : 'fr-core-tab-popup-scroll-bar'}
                    }});
            }
        },
        destroy: function () {
            FR.TabPopup.superclass.destroy.apply(this, arguments);
        }
    });
})(jQuery);