/*
 * Copyright (c) 2001-2014,FineReport Inc, All Rights Reserved.
 */

$(function() {
    /**
     * ε¼ƽ̨ùԱûҳ档
     */
    $.extend(FS.Trans, {
        setSystemManagerPW : function(username, pw, verifyNumber){
            var data = {
                userName : username,
                pw : pw
            }
            if (verifyNumber != undefined) {
                $.extend(data, {
                    verifyNumber : verifyNumber
                })
            }
            return FS.Trans.ajax({
                url : FR.servletURL + "?op=fs_load&cmd=setsystem_manager_pw",
                data : data
            })
        }
    }	);
    var south = $('#fs_bpage'), center = $('#fs_cpage');
    var border = new FR.BorderLayout({
        items : [{
            region : 'center',
            el : center
        }, {
            region : 'south',
            el : south
        }],
        renderEl : $('body')
    });
    var content = $('#syspasssetting');
    var pwPane = {};
    var $settingPane = createSettingPane().appendTo(content);
    var $showPane = createShowPane().appendTo(content);
    $settingPane.show();
    $showPane.hide();

    $(window).resize(function() {
        resize();
    });
    resize();
    function resize() {
        border.doLayout();
    }

    function createSettingPane () {
        var $table = $('<table/>').css('width','100%').addClass('fs_system_manager_pssetting');
        var $col = $('<colgroup/>').appendTo($table);
        $('<col/>').css('width','45%').appendTo($col);
        $('<col/>').css('width','55%').appendTo($col);
        var $tr = $('<tr/>').appendTo($table);
        var infoText = isSupportFS == "true"? FR.i18nText("FS-Admin_First_Set_FS")+"": FR.i18nText("FS-Admin_First_Set_Platform")+"" ;
        $('<td/>').addClass('fs_system_manager_title_fontsize')
            .attr('colspan', '2')
            .text(infoText)
            .appendTo($tr);
        $tr = $('<tr/>').appendTo($table);
        $('<td/>').text(FR.i18nText("Username")+'').addClass('fs_system_manager_name')
            .appendTo($tr);
        pwPane.userNameText = new FR.TextEditor({
            renderEl:$('<td/>').addClass('fs_system_manager_value').appendTo($tr),
            width:150,
            height:26
        })
        $tr = $('<tr/>').appendTo($table);
        $('<td/>').html('<span>'+FR.i18nText("Password")+""+'</span>').addClass('fs_system_manager_name')
            .appendTo($tr);
        pwPane.passwordText = new FR.TextEditor({
            renderEl:$('<td/>').addClass('fs_system_manager_value').appendTo($tr),
            width:150,
            height:26,
            passwordText:true
        })
        $tr = $('<tr/>').appendTo($table);
        $('<td/>').text(FR.i18nText("FS_Confirm_Password")+'').addClass('fs_system_manager_name')
            .appendTo($tr);
        pwPane.confirmPasswordText = new FR.TextEditor({
            renderEl:$('<td/>').addClass('fs_system_manager_value').appendTo($tr),
            width:150,
            height:26,
            passwordText:true
        })
        $tr = $('<tr/>').appendTo($table);
        pwPane.okButton = $('<input/>').attr('type','button').addClass('fs_system_pw_manager_ok')
            .appendTo($('<td/>').css({
                'padding-top':'25px',
                'text-align':'center'
            }).attr('colspan','2').appendTo($tr));
        pwPane.okButton.hover(function(e){
            $(this).switchClass('fs_system_pw_manager_ok_hover');
        }, function(e){
            $(this).switchClass('fs_system_pw_manager_ok');
        })
        pwPane.okButton.bind('mousedown', function(e){
            $(this).switchClass('fs_system_pw_manager_ok_click');
        }).bind('mouseup', function(e){
                $(this).switchClass('fs_system_pw_manager_ok');
            })
        pwPane.okButton.unbind('click').bind('click', function(e) {
            var userName = pwPane.userNameText.getValue();
            var passText = pwPane.passwordText.getValue();
            var confirmPassText = pwPane.confirmPasswordText.getValue();
            if (userName == undefined || userName === ""){
                FR.Msg.toast(FR.i18nText("Privilege-User_Can_Not_Be_Null"));
                return;
            }
            if (passText == undefined || passText === "") {
                FR.Msg.toast(FR.i18nText("Privilege-Password_Can_Not_Be_Null"));
                return;
            }
            if(passText !== confirmPassText) {
                FR.Msg.toast(FR.i18nText("Passwords_Not_Match"));
                return;
            }
            /**
             * grilԻԷģٺ
             */
            var hasSetPw = FS.Trans.setSystemManagerPW(FR.encrypt(userName, 'boys'), FR.encrypt(passText, 'grils'), pwPane.verifyNumber);
            if (hasSetPw && hasSetPw.state == "success") {
                $settingPane.hide();
                $showPane.show();
                if(pwPane.show_userName){
                    pwPane.show_userName.text(userName);
                }
                if(pwPane.show_password){
                    pwPane.show_password.text(passText);
                }
                pwPane.verifyNumber = hasSetPw.verifyNumber
            } else if (hasSetPw && hasSetPw.state == 'failed') {
                FR.Msg.toast(FR.i18nText("FS-Admin_Account_Has_Set"));
            } else {
                FR.Msg.toast(FR.i18nText("FS-Admin_Unknown_Error"));
            }
        })
        return $table;
    }

    function createShowPane() {
        var $table = $('<table/>').css('width','100%').addClass('fs_system_manager_pssetting');
        var $col = $('<colgroup/>').appendTo($table);
        $('<col/>').css('width','42%').appendTo($col);
        $('<col/>').css('width','58%').appendTo($col);
        var $tr = $('<tr/>').appendTo($table);
        $('<td/>').appendTo($tr);
        $('<td/>').addClass('fs_system_manager_showtitle_fontsize')
            .attr('colspan', '2')
            .text(FR.i18nText("FS-Admin_Account_Is")+'')
            .appendTo($tr);
        var $tr = $('<tr/>').appendTo($table);
        $tr.append($('<td/>').addClass('fs_system_manager_showpw_fontsize')
            .attr('colspan', '2')
            .append(createPWShowContentTable()));
        var $tr = $('<tr/>').appendTo($table);
        $('<td/>').appendTo($tr);
        var $tr = $('<tr/>').appendTo($table);
        var $td = $('<td/>').attr('colspan', '3').css({
            'text-align':'center',
            'padding-top' : '15px'
        }).appendTo($tr);
        createSubmitButtons($td);
        return $table;
    }

    function createSubmitButtons ($td) {
        if(isSupportFS != "true"){
            $('<input/>').addClass('fs_system_pw_manager_login_fr_platform')
                .attr('type','button')
                .click(function(e){
                    FR.doHyperlinkByPost(FR.buildServletUrl({op:'fr_auth', cmd:'ah_login'}), {
                        fr_username:FR.cjkEncode(pwPane.show_userName.text()),
                        fr_password:pwPane.show_password.text()}, '_self');
                }).appendTo($td);
        }else{
            $('<input/>').addClass('fs_system_pw_manager_login_fs')
                .attr('type','button')
                .click(function(e){
                    FR.ajax({
                        url : FR.servletURL + '?op=fs_load&cmd=login',
                        data : {
                            //FR.ajaxһcjkencodeġ
                            fsusername:pwPane.show_userName.text(),
                            fspassword:pwPane.show_password.text()
                        },
                        type : 'POST',
                        async : false,
                        error : function() {
                            FR.Msg.toast("Error!");
                        },
                        complete : function(res, status) {
                            if (res.responseText == "") {
                                FR.Msg.toast(FR.i18nText("Privilege-Authentication_failed")+"");
                                return;
                            }
                            var signResult = FR.jsonDecode(res.responseText);
                            if (signResult.fail) {
                                userError();
                            } else if (signResult.url) {
                                window.location.href = signResult.url;
                            }
                        }
                    });
                }).appendTo($td);
        }

        $('<input/>').addClass('fs_system_pw_manager_return')
            .attr('type','button')
            .click(function(e){
                $settingPane.show();
                $showPane.hide();
            })
            .appendTo($td)
        $('input', $td).each(function(idx, item){
            var originalClass = $(item).attr('class');
            $(item).hover(function(e){
                $(this).switchClass(originalClass + '_hover');
            }, function(e){
                $(this).switchClass(originalClass);
            })
            $(item).bind('mousedown', function(e){
                $(this).switchClass(originalClass + '_click')
            }).bind('mouseup', function(e){
                    $(this).switchClass(originalClass);
                })
        })
    }

    function createPWShowContentTable () {
        var $table =  $('<table/>').css('width', '100%');
        var $col = $('<colgroup/>').appendTo($table);
        $('<col/>').css('width','45%').appendTo($col);
        $('<col/>').css('width','5%').appendTo($col);
        $('<col/>').css('width','50%').appendTo($col);
        var $tr = $('<tr/>').appendTo($table);
        $('<td/>').appendTo($tr);
        $('<td/>').css('color','red')
            .attr('colspan', '2')
            .text(FR.i18nText("FS-Admin_Remember_Username_Password")+'')
            .appendTo($tr);
        var $tr = $('<tr/>').appendTo($table);
        $('<td/>').appendTo($tr);
        $('<td/>').text(FR.i18nText("Username")+'').appendTo($tr);
        pwPane.show_userName = $('<td/>').attr('id', 'fs_system_manager_user_name').text(pwPane.userNameText.getValue()).appendTo($tr);
        var $tr = $('<tr/>').appendTo($table);
        $('<td/>').appendTo($tr);
        $('<td/>').html('<span>'+FR.i18nText("Password")+""+'</span>').appendTo($tr);
        pwPane.show_password = $('<td/>').attr('id', 'fs_system_manager_user_pw').appendTo($tr);
        return $table;
    }

    var company = $('#fs_bpage > span').text();
    var year = ($.browser.msie ? 0 : 1900) + new Date().getYear();
    $('#fs_bpage > span').text("\u00A9 " + year + " " + company);
});