$(function() {
    var company = $('#fs_bpage').text();
    var year = ($.browser.msie && parseInt($.browser.version) < 9 ? 0 : 1900) + new Date().getYear();
    $('#fs_bpage').text("\u00A9 " + year + " " + company);

    var $loginTitle = $('<div style="font-size: 13px; font-weight: bold; line-height: 40px; text-align: center"></div>').text(FR.i18nText('FS-Login_Page'));
    var $userLabel = $('<div></div>').text(FR.i18nText('Username') + ":");
    var $passwordLabel = $('<div></div>').text(FR.i18nText('Password') + ":");
    var $errorMsgLabel = $('<div style="color: red"></div>');
    var loginTable = new FR.BorderLayout({
        renderEl : $('#loginform'),
        items : [
            {
                el : {type : 'border', items : [
                    {el : $('<div></div>'), region : 'north', height : 10},
                    {el : $loginTitle, region : 'center'},
                    {el : $('<div></div>'), region : 'south', height : 10}
                ]},
                region : 'north',
                height : 60
            },
            {
                el: {type: 'tablelayout', items: [
                    [
                        {el : $('<div></div>')},
                        {el : $userLabel},
                        {el : $('<div></div>')}
                    ],
                    // û
                    [
                        {el : $('<div></div>')},
                        {el: {
                            type: 'text',
                            widgetName : 'username',
                            width: 160,
                            height: 20,
                            allowBlank: false,
                            errorMsg: FR.i18nText('Privilege-User_Can_Not_Be_Null')
                        }},
                        {el : $('<div></div>')}
                    ],
                    [
                        {el : $('<div></div>')},
                        {el : $passwordLabel},
                        {el : $('<div></div>')}
                    ],
                    // 
                    [
                        {el : $('<div></div>')},
                        {el: {
                            type: 'text',
                            widgetName : 'password',
                            passwordText: true,
                            width: 160,
                            height: 20,
                            allowBlank: false,
                            errorMsg: FR.i18nText('Privilege-Password_Can_Not_Be_Null')
                        }},
                        {el : $('<div></div>')}
                    ],
                    // סѡ
                    [
                        {el : $('<div></div>')},
                        {el: {
                            type: 'checkbox',
                            widgetName : 'keep',
                            text: FR.i18nText('Privilege-Keep_Login_State')
                        }},
                        {el : $('<div></div>')}
                    ],
                    // ʾϢdiv
                    [
                        {el : $('<div></div>')},
                        {el : $errorMsgLabel},
                        {el : $('<div></div>')}
                    ]
                ],
                    columnSize: [5, 190, 'fill'],
                    rowSize: [15, 26, 15, 26, 26, 26],
                    vgap: 4},
                region : 'center'
            },
            {
                el: {
                    type : 'border',
                    items : [
                        {
                            el : {
                                type: 'horizontal',
                                alignment : 'right',
                                hgap : 10,
                                items: [
                                    {
                                        el : {
                                            type: 'button',
                                            text: FR.i18nText('Sign_In'),
                                            hotkeys: 'enter',
                                            handler: signIN
                                        },
                                        width:72
                                    }
                                ]
                            },
                            region:'center'
                        },
                        {
                            el : $('<div></div>'),
                            region :'south',
                            height : 6
                        }
                    ]
                },
                region : 'south',
                height : 30
            }
        ]
    });
    loginTable.doLayout();

    var user = loginTable.getWidgetByName('username');
    user.editComp.focus();

    var pw = loginTable.getWidgetByName('password');
    var keep = loginTable.getWidgetByName('keep');
	initBackgroundImage();

	
	/**
	 * ʼFSĵ¼ͼƬ
	 */
	function initBackgroundImage() {
		var self = this;
        var ran = new Date().getTime() + "" + (Math.random() * 1000);
		FR.ajax({
			url : FR.servletURL + "?op=fs_load&cmd=getLoginImageID&_ran="+ran,
			complete : function(res, status) {
				if(status == 'success') {
					var loginID = FR.jsonDecode(res.responseText);
					self.loginImgID = loginID.id;
					var url = FR.servletURL 
						+ ((self.loginImgID && self.loginImgID != 'null') ?('?op=fr_attach&cmd=ah_image&id='+self.loginImgID+'&isAdjust=false') :'?op=resource&resource=/com/fr/base/images/oem/signin.png');
			    	if($("#pbackground").length > 0) {
			    		$("#pbackground").css({
			    			background: 'url(' + url +') no-repeat'
			    		})
			    		if ($.browser.msie && $.browser.version == '6.0') {
			    			//wei : ie6FS½ҳ汳ͼƬ߶ֻʾ15px
			    			$('#pbackground').height(document.body.clientHeight);
			    		}
			    	}
				}
			}
		})
	}
		
	/**
	 * ¼
	 */
	function signIN() {
        if (!user.isValidate()) {
            $errorMsgLabel.text(user.errorMsg);
            return;
        }
        if (!pw.isValidate()) {
            $errorMsgLabel.text(pw.errorMsg);
            return;
        }
		FR.ajax({
			url : FR.servletURL + '?op=fs_load&cmd=login',
			data : genUser(),
			type : 'POST',
			async : false,
			error : function() {
				FR.Msg.toast("Error!");
			},
			complete : function(res, status) {
				if (res.responseText == "") {
					$errorMsgLabel.text(FR.i18nText("Privilege-Authentication_failed"));
					return;
				}
				var signResult = FR.jsonDecode(res.responseText);				
				if (signResult.fail) {
					userError();
				} else if (signResult.url) {
					window.location.href = signResult.url;
				}
			}
		});
	}
	
	//b:Ǽ
	/**
	 * ¼õû/룬Ƿ񱣳ֵ¼json
	 */
	function genUser() {
		return FR.cjkEncodeDO({
			fsusername : encodeURIComponent(user.getValue()),
			fspassword : encodeURIComponent(pw.getValue()),
			fsremember : keep.isSelected()
		});
	}
	
	/**
	 * ¼ʧʱִ
	 */
	function userError() {
		$errorMsgLabel.text(FR.i18nText("Privilege-Name_Not_Match_Password"));
	}
});