/**
 * Coder: Sean
 * Date: 14-4-29
 * Time: 12:31
 */
FS.USERMGR = {
    init: function (renderer) {
        FR.$defaultImport('/com/fr/fs/web/css/manager/fs_usermgr.css', 'css');
        this.preLoadData();
        this.createSetPane(renderer);
        this.user = new FS.LTabPane({
            width: '100%',
            height: '100%',
            style: 'blue',
            top: 15,
            left: 20,
            marginLeft: 40,
            items: [this.userModule()],
            renderEl: renderer
        })
    },
    /**
     * ûҳԤ
     */
    preLoadData: function(){
        var self = this;
        //ȡû֤ʽ
        this.loginAuthenticateType = FS.Trans.ajax({
            url: FR.servletURL + "?op=fs_load&cmd=loginAuthenticateType",
            returnString: true
        });
        //ȡݼͬݼϢ
        FR.ajax({
            url: FR.servletURL + '?op=fs_manager&cmd=fs_get_syncdatainfo',
            type: 'POST',
            async : false,
            complete : function(res) {
                self.syncdata = FR.jsonDecode(res.responseText);
            }
        });
        //Ƿͬݼ
        var state = FS.Trans.getTableDataSyncState();
        this.isSyncOn = (state.type === 1);
    },
    /**
     * жǷLDAP֤
     * @returns {boolean} ǷLDAP֤
     */
    isAuthLdap: function(){
        if(this.loginAuthenticateType == 'ldap'){
            return true;
        }else{
            return false;
        }
    },
    /**
     * жǷƽ̨֤ʽ
     * @returns {boolean}
     */
    isAuthDefault: function(){
        if(this.loginAuthenticateType == 'default'){
            return true;
        }else{
            return false;
        }
    },
    /**
     * 
     * @param anchor ̶dom
     */
    createSetPane: function (anchor) {
        var self = this;
        var $line = $('<div class="fs-usermgr-line"/>');
        var items = [
            [null,null,{el:$('<div/>')}],
            [
                //û֤ʽ
                null,
                {el: {type: 'llabel', value: FR.i18nText("Authentication")}},
                {el: {
                    type: 'radiogroup',
                    columnsInRow: 3,
                    widgetName: 'authModeRadioGroup',
                    width: 300,
                    value: 0,
                    items: [
                        {value: 0, text: FR.i18nText("Platform_Built-in_Authentification")},
                        {value: 1, text: FR.i18nText("LDAP_Authentification")},
                        {value: 2, text: FR.i18nText("Http_Authentification")}
                    ],
                    listeners: [
                        {eventName: FR.Events.AFTEREDIT,
                            action: function () {
                                var value = this.getValue();
                                if (value === 0) {
                                    floatPane.getWidgetByName("SETTABLE").setRowVisible([2, 3], false);
                                } else if (value === 1) {
                                    floatPane.getWidgetByName("SETTABLE").setRowVisible(2, true);
                                    floatPane.getWidgetByName("SETTABLE").setRowVisible(3, false);
                                } else if (value === 2){
                                    floatPane.getWidgetByName("SETTABLE").setRowVisible(2, false);
                                    floatPane.getWidgetByName("SETTABLE").setRowVisible(3, true);
                                }
                                floatPane.getWidgetByName("SETTABLE").doLayout();
                            }
                        }
                    ]
                }}
            ],
            [
                null,
                null,
                {el: {
                    widgetName: 'LDAPSETTABLE',
                    type: 'tablelayout',
                    rowSize: [21, 21, 21, 21, 21, 21, 21, 21],
                    columnSize: [110, 210],
                    vgap: 8,
                    items: [
                        [
                            {el: {type: 'llabel', value: '*URL'}},
                            {el: {type: 'text', widgetName: 'urlCombo', watermark: FR.i18nText("Example") + ':ldap://192.168.106.201:389'}}
                        ],
                        [
                            {el: {type: 'llabel', value: FR.i18nText("Retrieve_Location")}},
                            {el: {type: 'text', widgetName: 'locationText', watermark: FR.i18nText("Example") + 'DC=finereport'}}
                        ],
                        [
                            {el: {type: 'llabel', value: '*' + FR.i18nText("Authentication")}},
                            {el: {type: 'combo', widgetName: 'authmodCombo',
                                items: [
                                    {
                                        'text': 'simple',
                                        'value': 1
                                    },
                                    {
                                        'text': 'strong',
                                        'value': 2
                                    },
                                    {
                                        'text': 'none',
                                        'value': 3
                                    }
                                ]
                            }}
                        ],
                        [
                            {el: {type: 'llabel', value: '*' + FR.i18nText("Context")}},
                            {el: {type: 'combo', widgetName: 'contextCombo', items: [
                                {
                                    'text': 'com.sun.jndi.ldap.LdapCtxFactory',
                                    'value': 1
                                },
                                {
                                    'text': 'com.sun.jndi.ldap.connect.pool',
                                    'value': 2
                                }
                            ]
                            }}
                        ],
                        [
                            {el: {type: 'llabel', value: '*' + FR.i18nText("Referral")}},
                            {el: {type: 'combo', widgetName: 'ReferralCombo',
                                items: [
                                    {
                                        'text': 'follow',
                                        'value': 1
                                    },
                                    {
                                        'text': 'ignore',
                                        'value': 2
                                    },
                                    {
                                        'text': 'throw',
                                        'value': 3
                                    }
                                ]
                            }}
                        ],
                        [
                            {el: {type: 'llabel', value: FR.i18nText("Username_Suffix")}},
                            {el: {type: 'text', widgetName: 'suffixText', watermark: FR.i18nText("Example") + ':@finereport.com'}}
                        ],
                        [
                            {el: {type: 'llabel', value: FR.i18nText("Admin_Name")}},
                            {el: {type: 'text', widgetName: 'adminnameText'}}
                        ],
                        [
                            {el: {type: 'llabel', value: FR.i18nText("Admin_Password")}},
                            {el: {type: 'text', widgetName: 'adminpwdText', passwordText: true}}
                        ]
                    ]
                }}
            ],
            [null,null,{el:{type:'text',widgetName:'httpurlText',watermark:'Example: http://localhost/saa'}}],
            [
                null,
                {el: {type: 'llabel', value: FR.i18nText("User_Synchronized_DataSet"), verticalcenter: false}},
                {el:{
                    type: 'border',
                    items: [
                        {
                            region: 'west',
                            width: 240,
                            el: {
                                type: 'tablelayout',
                                widgetName: 'userAuthTablelayout',
                                columnSize: [100, 110],
                                rowSize: [21,21,21,21,21],
                                vgap: 8,
                                items: [
                                    [
                                        {el: {type: 'llabel', value: FR.i18nText("DS-Server_TableData")}},
                                        {el: {
                                            type: 'combo' ,
                                            widgetName:'tableDataCombo',
                                            widgetUrl:FR.servletURL+"?op=fs_manager&cmd=fs_get_servertabledata",
                                            listeners: [
                                                {
                                                    eventName: FR.Events.AFTEREDIT,
                                                    action: function () {
                                                        var ds = this.getValue();
                                                        self.rebuildDSWidgets(ds, this);
                                                    }
                                                }
                                            ]
                                        }}
                                    ],
                                    [
                                        {el: {type: 'llabel', value: FR.i18nText("Username")}},
                                        {el: {type: 'combo' ,widgetName:'usernameCombo', items:[]}}
                                    ],
                                    [
                                        {el: {type: 'llabel', value: FR.i18nText("Password")}},
                                        {el: {type: 'combo' ,widgetName:'passwordCombo', items:[]}}
                                    ],
                                    [
                                        {el: {type: 'llabel', value: FR.i18nText("Encryption_Mode")}},
                                        {el: {
                                            type: 'combo',
                                            widgetName: 'encryptionCombo',
                                            allowBlank: true,
                                            items: [
                                                {text: FR.i18nText("NoEncryption"), value: 0},
                                                {text: FR.i18nText("CustomEncryption"), value: 1},
                                                {text: FR.i18nText("MD5Encryption"), value: 2}
                                            ],
                                            listeners: [
                                                {
                                                    eventName: FR.Events.AFTEREDIT,
                                                    action: function () {
                                                        var val = this.getValue();
                                                        var table = this.getWidgetByName("userAuthTablelayout");
                                                        if (val === 1) {
                                                            table.getWidgetByName('customEncrypText').setVisible(true);
                                                        } else {
                                                            table.getWidgetByName('customEncrypText').setVisible(false);
                                                        }
                                                    }
                                                }
                                            ]
                                        }}
                                    ],
                                    [
                                        null,
                                        {el: {type: 'text' ,widgetName:'customEncrypText'}}
                                    ]
                                ]
                            }
                        },
                        {
                            region: 'center',
                            el: $('<div/>').append($line)
                        },
                        {
                            region: 'east',
                            width: 180,
                            el: {
                                type: 'tablelayout',
                                columnSize: [60, 110],
                                rowSize: [21,21,21,21],
                                vgap: 8,
                                items: [
                                    [
                                        {el: {type: 'llabel', value: FR.i18nText("FULLNAME")}},
                                        {el: {type: 'combo' ,widgetName:'fullnameCombo', items:[]}}
                                    ],
                                    [
                                        {el: {type: 'llabel', value: FR.i18nText("Role")}},
                                        {el: {type: 'combo' ,widgetName:'roleCombo', items:[]}}
                                    ],
                                    [
                                        {el: {type: 'llabel', value: FR.i18nText("email")}},
                                        {el: {type: 'combo' ,widgetName:'emailCombo', items:[]}}
                                    ],
                                    [
                                        {el: {type: 'llabel', value: FR.i18nText("MobilePhone")}},
                                        {el: {type: 'combo' ,widgetName:'mobilephoneCombo', items:[]}}
                                    ]
                                ]
                            }
                        }
                    ]
                }}
            ],[null,null,{el: $('<div/>')}]
        ];
        var floatPane = FR.createWidget({
            type: 'floatpane',
            anchor: anchor,
            contentHieght: 350,
            isDefaultShow: false,
            contentWidget: {
                type: 'confirm',
                fit: true,
                doSize: true,
                closeAfterAction: false,
                btnsAlignment: 'left',
                needSeparate: 8,
                onOK: function () {
                    var isSaveSuccess = true;
                    var authtype = floatPane.getWidgetByName("authModeRadioGroup").getValue();
                    switch (authtype){
                        case 0: authtype = "default";break;
                        case 1: authtype = "ldap";break;
                        default : authtype = "http";break;
                    }
                    FR.ajax({
                        url : FR.servletURL + "?op=fs_load&cmd=installLoginAuthenticateType",
                        data : { loginAuthenticateType : authtype},
                        async: false,
                        complete: function(res, status){
                            if(status == 'success'){
                                var re = FR.jsonDecode(res.responseText);
                                isSaveSuccess = re.success && isSaveSuccess;
                                if (isSaveSuccess) {
                                    var result = self.saveAuthConfig(authtype, floatPane);
                                    isSaveSuccess = result.success && isSaveSuccess;
                                }
                            }
                        }
                    });
                    //ͬݼñ
                    var syncOn = floatPane.getWidgetByName("tableDataCombo").getValue() ? true : false;
                    if(syncOn){
                        var data = self.getDSWidgetData(floatPane);
                        var syncRes = FS.Trans.saveTableDataSync(data);
                        isSaveSuccess = syncRes.success && isSaveSuccess;
                    }else{
                        var result = FS.Trans.closeTableDataSync();
                        isSaveSuccess = result.success && isSaveSuccess;
                    }
                    if(isSaveSuccess){
                        FS.userPane.signOut();
                    }else{
                        FR.Msg.toast(FR.i18nText("Failed"));
                    }
                },
                onCancel: function () {
                    self.popAuthSetData(floatPane);
                    self.popSyncSetData(floatPane);
                    floatPane.doSlide();
                },
                contentWidget: {
                    type: 'tablelayout',
                    scrolly: true,
                    widgetName: 'SETTABLE',
                    columnSize: [20, 110, 450],
                    rowSize: [0, 21, 230, 25, 170, 5],
                    vgap: 15,
                    items: items
                }
            }
        });
        this.popAuthSetData(floatPane);
        this.popSyncSetData(floatPane);
        floatPane.getWidgetByName("SETTABLE").doLayout();
        floatPane.doHide();
    },

    popAuthSetData: function(pw){
        if(this.isAuthDefault()){
            pw.getWidgetByName('authModeRadioGroup').setValue(0, true);
        }else if(this.isAuthLdap()){
            var ldapAttrs = FR.jsonDecode(FS.Trans.getLdapAttrs());
            pw.getWidgetByName('authModeRadioGroup').setValue(1, true);
            pw.getWidgetByName('urlCombo').setValue(ldapAttrs.ldapUrl);
            pw.getWidgetByName('locationText').setValue(ldapAttrs.ldapSearchBase);
            pw.getWidgetByName('authmodCombo').setValue(ldapAttrs.authentication);
            pw.getWidgetByName('contextCombo').setValue(ldapAttrs.contextFactory);
            pw.getWidgetByName('ReferralCombo').setValue(ldapAttrs.referral);
            pw.getWidgetByName('suffixText').setValue(ldapAttrs.principalSuffix);
            pw.getWidgetByName('adminnameText').setValue(ldapAttrs.ldapSystemName);
            pw.getWidgetByName('adminpwdText').setValue(ldapAttrs.ldapSystemPassword);
        }else{
            pw.getWidgetByName('authModeRadioGroup').setValue(2, true);
            FR.ajax({
                url: FR.servletURL+"?op=fs_set&cmd=sc_http_get",
                complete: function(res, status){
                    if(status == 'success'){
                        var http = FR.jsonDecode(res.responseText);
                        if(http.url){
                            pw.getWidgetByName('httpurlText').setValue(http.url);
                        }
                    }
                }
            })
        }
    },
    /**
     * 
     * @param {FR.Widget} pw 
     */
    popSyncSetData: function(pw){
        //ͬݼݡ
        var syncdata = this.syncdata;
        pw.getWidgetByName("customEncrypText").setVisible(false);
        if(this.isSyncOn){
            pw.getWidgetByName("tableDataCombo").setValue(syncdata.dsName);
            this.rebuildDSWidgets(syncdata.dsName, pw);
            if(syncdata.userName > -1){
                pw.getWidgetByName("usernameCombo").setValue(syncdata.userName);
            }
            if(syncdata.password > -1){
                pw.getWidgetByName("passwordCombo").setValue(syncdata.password);
            }
            if(syncdata.name > -1){
                pw.getWidgetByName("fullnameCombo").setValue(syncdata.name);
            }
            if(syncdata.role > -1){
                pw.getWidgetByName("roleCombo").setValue(syncdata.role);
            }
            if(syncdata.encrypt > -1){
                pw.getWidgetByName("encryptionCombo").setValue(syncdata.encrypt);
            }
            if(syncdata.email > -1){
                pw.getWidgetByName("emailCombo").setValue(syncdata.email);
            }
            if(syncdata.mobile > -1){
                pw.getWidgetByName("mobilephoneCombo").setValue(syncdata.mobile);
            }
            if(syncdata.encrypt === 1){
                pw.getWidgetByName("customEncrypText").setVisible(true);
                pw.getWidgetByName("customEncrypText").setValue(syncdata.myencrypt);
            }
        }
    },
    /**
     * ֤ʽ
     * @param {String} type û֤ʽ
     * @param {FR.Widget} pw 
     */
    saveAuthConfig: function(type, pw){
        var result = {success: true};
        if(type == "ldap") {
            result = FS.Trans.ajax({
                url : FR.servletURL + "?op=fs_load&cmd=installLdapAttrs",
                data : {
                    loginLdapUrl: pw.getWidgetByName('urlCombo').getValue(),
                    ldapSearchBase: pw.getWidgetByName('locationText').getValue(),
                    referral: pw.getWidgetByName('ReferralCombo').getText(),
                    authentication: pw.getWidgetByName('authmodCombo').getText(),
                    contextFactory: pw.getWidgetByName('contextCombo').getText(),
                    ldapPrincipalSuffix: pw.getWidgetByName('suffixText').getValue(),
                    ldapSystemName: pw.getWidgetByName('adminnameText').getText(),
                    ldapSystemPassword: pw.getWidgetByName('adminpwdText').getText()
                }
            });
        }else if(type == 'http'){
            result = FS.Trans.ajax({
                url : FR.servletURL + "?op=fs_set&cmd=sc_http_set",
                data : {
                    httpurl: pw.getWidgetByName('httpurlText').getValue()
                }
            });
        }
        return result;
    },
    /************û*************/
    userModule: function(){
        //ͬݼûϢ򲻼û
        var isSyncOn = this.isSyncOn;
        var config = {
            title: FR.i18nText("User_Management"),
            content: {
                type: 'quickgrid',
                page: true,
                autoPage: false,
                pageCount: 10,
                marginLeft: 10,
                marginRight: 10,
                widgetName: 'USERINFOGRID',
                async: !isSyncOn ? null:{
                    url: FR.servletURL + "?op=fs_set&cmd=auth_getalluserinfo",
                    data: {
                        startIdx: 0,
                        count: 10
                    }
                },
                onPageTurn: function(active, count, nav){
                    var async = this.options.async;
                    async.data = {
                        startIdx: (active-1) * count,
                        count: count
                    };
                    this.refresh();
                },
                onAsyncSuccess: function (res, status) {
                    var result = FR.jsonDecode(res);
                    this.options.items = result.users;
                    this.totalpages = Math.ceil(result.total/10);
                },
                columnsConfig: [
                    {
                        key: 'username',
                        value: FR.i18nText("Username"),
                        width: 160
                    },
                    {
                        key: 'realname',
                        value: FR.i18nText("FULLNAME"),
                        width: 130
                    },
                    {
                        key: 'role',
                        value: FR.i18nText("Role"),
                        width: 130
                    },
                    {
                        key: 'email',
                        value: FR.i18nText("email"),
                        width: 130
                    },
                    {
                        key: 'mobile',
                        value: FR.i18nText("MobilePhone"),
                        width: 130
                    }
                ]
            }
        };
        return config;
    },

    /**
     * ֻƽ̨֤ʱûֻû
     * @param username ûֶ
     * @param password ֶ
     * @returns {boolean} Ƿ
     */
    checkUserValid :function(username, password) {
        if(FR.isEmpty(username)) {
            FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("Privilege-User_Can_Not_Be_Null"));
            return false;
        }
        if(this.isAuthDefault() && FR.isEmpty(password)){
            FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("Privilege-Password_Can_Not_Be_Null"));
            return false;
        }
        return true;
    },

    /**
     * ȡݼпؼֵ
     * @param pw 
     * @returns {*}
     */
    getDSWidgetData: function(pw){
        var self = this;
        var username = pw.getWidgetByName("usernameCombo").getValue(),
            name = pw.getWidgetByName("fullnameCombo").getValue(),
            password = pw.getWidgetByName("passwordCombo").getValue(),
            role = pw.getWidgetByName("roleCombo").getValue(),
            mobile = pw.getWidgetByName("mobilephoneCombo").getValue(),
            email = pw.getWidgetByName("emailCombo").getValue();
        if(!this.checkUserValid(username,password)){
            return false;
        }
        var res = {
            dsName: pw.getWidgetByName("tableDataCombo").getValue(),
            userName: FR.isEmpty(username) ? -1 : username,
            name: FR.isEmpty(name) ? -1 : name,
            password: FR.isEmpty(password) ? -1 : password,
            role: FR.isEmpty(role) ? -1 : role,
            mobile: FR.isEmpty(mobile) ? -1 : mobile,
            email: FR.isEmpty(email) ? -1 : email,
            encrypt: pw.getWidgetByName("encryptionCombo").getValue()
        };
        if(res.encrypt === 1) {
            res.myencrypt = pw.getWidgetByName("customEncrypText").getValue();
        }
        if(!res.encrypt) {
            res.encrypt = 0;
        }
        return res;
    },
    /**
     * ÷ݼֶѡؼ
     * @param ds ݼ
     * @param pw 
     */
    rebuildDSWidgets: function(ds, pw){
        var cols = [];
        if(!FR.isEmpty(ds)){
            cols = FS.Tools.getColsByTableDataName(ds);
        }
        var widgetNames= ["usernameCombo", "passwordCombo", "fullnameCombo", "emailCombo",
            "mobilephoneCombo", "roleCombo"];
        for(var i= 0;i<6;i++){
            var widget = pw.getWidgetByName(widgetNames[i]);
            widget.options.renderEl = widget.element;
            widget.rebuild(cols);
        }
    }
};
