/**
 * Coder: Sean
 * Date: 13-11-6
 * Time: 12:02
 */
FS.PASSWORD = {
    init: function (renderer) {
        var items = [], actions = [];
        if (FS.config.isAdmin == "true") {
            items = [FS.adminPwdModule()];
        } else {
            items = [this._userInfoModule(), this._userPwdModule()];
            actions = [
                function () {
                var tabpane = this;
                FR.ajax({
                    url: FR.servletURL + "?op=fs_main&cmd=user_getinfo",
                    complete: function (res, status) {
                        if (status == 'success') {
                            var user = FR.jsonDecode(res.responseText);
                            tabpane.getWidgetByName("fullnameText").setValue(user.realname);
                            tabpane.getWidgetByName("emailText").setValue(user.email);
                            tabpane.getWidgetByName("MobilePhoneText").setValue(user.mobile);
                        }
                    }
                });
            }, FR.emptyFn()]
        }
        this.infoChange = new FS.LTabPane({
            width: '100%',
            height: '100%',
            items: items,
            style: 'blue',
            renderEl: renderer,
            marginLeft: 40,
            initAfterActions: actions
        });
    },
    createPwdCfg: function () {
        var cfgItems = [
            [
                {el: {type: 'llabel', value: FR.i18nText("FS_Old_Password")}},
                {el: {type: 'text', passwordText: true, widgetName: 'oldPwdText'}},
                null,
                {el: {type: 'llabel', widgetName: 'oldPwdError', levelStyle: 0, fontfamily: 'SimSun', invisible: true,
                    color: '#EB000B', fontsize: '13px', value: FR.i18nText("Old_Password_Error")}}
            ],
            [
                {el: {type: 'llabel', value: FR.i18nText("Enter_New_Password")}},
                {el: {type: 'text', passwordText: true, widgetName: 'newPwdText'}},
                null,
                {el: {type: 'llabel', widgetName: 'enterNewPwdError', levelStyle: 0, fontfamily: 'SimSun', invisible: true,
                    color: '#EB000B', fontsize: '13px', value: FR.i18nText("Please_Enter_Newpwd")}}
            ],
            [
                {el: {type: 'llabel', value: FR.i18nText("Verify_New_Password")}},
                {el: {type: 'text', passwordText: true, widgetName: 'verifyPwdText'}},
                null,
                {el: {type: 'llabel', widgetName: 'pwdNotMatchError', levelStyle: 0, fontfamily: 'SimSun', invisible: true,
                    color: '#EB000B', fontsize: '13px', value: FR.i18nText("Passwords_Not_Match")}}
            ]
        ];
        return cfgItems;
    },
    /*******************ûϢģ*******************/
    _userInfoModule: function () {
        var self = this;
        var userInfo = {
            title: FR.i18nText("My_Info"),
            content: {
                type: 'confirm',
                doSize: true,
                text4OK: FR.i18nText("Save"),
                text4Cancel: null,
                btnsAlignment: 'left',
                closeAfterAction: false,
                firstBtnMargin: 0,
                //޸ģȷϰťĵ¼
                onOK: function () {
                    self._userInfoSubmit();
                },
                onCancel: function () {
                },
                width: 500,
                height: 170,
                contentWidget: {
                    type: 'tablelayout',
                    widgetName: 'userInfoTablelayout',
                    columnSize: [92, 181, 6, 'fill'],
                    rowSize: [21, 21, 21],
                    vgap: 19,
                    items: [
                        [
                            {el: {type: 'llabel', value: FR.i18nText("FULLNAME")}},
                            {el: {type: 'text', widgetName: 'fullnameText', allowBlank: false}},
                            null,
                            {el: {type: 'llabel', widgetName: 'fullnameError', levelStyle: 0, fontfamily: 'SimSun', invisible: true,
                                color: '#EB000B', fontsize: '13px', value: FR.i18nText("Name_Can_Not_Be_Null")}}
                        ],
                        [
                            {el: {type: 'llabel', value: FR.i18nText("Email")}},
                            {el: {type: 'text', widgetName: 'emailText'}}
                        ],
                        [
                            {el: {type: 'llabel', value: FR.i18nText("MobilePhone")}},
                            {el: {type: 'text', widgetName: 'MobilePhoneText'}}
                        ]
                    ]
                }
            }
        };
        return userInfo;
    },
    /**
     * ύûϢ,ֻ
     * @private
     */
    _userInfoSubmit: function () {
        var fullnameText = this.infoChange.getWidgetByName("fullnameText"),
            error = this.infoChange.getWidgetByName("fullnameError");
        if (!fullnameText.checkValid()) {
            error.setVisible(true);
        } else {
            error.setVisible(false);
        }
        //ύûϢ
        FR.ajax({
            url: FR.servletURL + "?op=fs_main&cmd=user_saveinfo",
            data: {
                realname: fullnameText.getValue(),
                email: this.infoChange.getWidgetByName("emailText").getValue(),
                mobile: this.infoChange.getWidgetByName("MobilePhoneText").getValue()
            },
            complete: function (res, status) {
                if (status == 'success') {
                    var re = FR.jsonDecode(res.responseText);
                    if (re.success) {
                        FR.Msg.toast(FR.i18nText("Successfully"));
                    } else {
                        FR.Msg.toast(FR.i18nText("Failed"));
                    }
                }
            }
        });
    },
    /*******************޸ģ*******************/
    _userPwdModule: function () {
        var self = this;
        var userPwd = {
            title: FR.i18nText("FS-Password_Modify"),
            content: {
                type: 'confirm',
                doSize: true,
                text4OK: FR.i18nText("Save"),
                text4Cancel: null,
                btnsAlignment: 'left',
                closeAfterAction: false,
                firstBtnMargin: 0,
                //޸ģȷϰťĵ¼
                onOK: function () {
                    self._userPwdSubmit();
                },
                onCancel: function () {
                },
                width: 500,
                height: 170,
                contentWidget: {
                    type: 'tablelayout',
                    widgetName: 'userPwdTablelayout',
                    columnSize: [131, 122 , 6, 'fill'],
                    rowSize: [21, 21, 21],
                    vgap: 19,
                    items: self.createPwdCfg()
                }
            }
        };
        return userPwd;
    },
    _userPwdSubmit: function () {
        this._getUserPwdData();
        //ձϢ
        this._clearUserPwdErrorInfo();
        //жǷΪ
        var oldp = this.oldPwdText.getValue(),
            np = this.newPwdText.getValue();
        if (FR.isEmpty(np)) {
            this.enterNewPwdError.setVisible(true);
            return false;
        }
        //жǷһ
        if (np != this.verifyPwdText.getValue()) {
            this.pwdNotMatchError.setVisible(true);
            return false;
        }
        //ύ޸ĲжǷ޸ĳɹ
        var submitResult = FS.Trans.changePW({
            oldp: encodeURIComponent(oldp),
            np: encodeURIComponent(np)
        });
        if (submitResult.success) {
            FR.Msg.toast(FR.i18nText("Successfully"));
        } else {
            this.oldPwdError.setVisible(true);
            return false;
        }
        return true;
    },
    _getUserPwdData: function () {
        this.oldPwdText = this.infoChange.getWidgetByName('oldPwdText');
        this.verifyPwdText = this.infoChange.getWidgetByName('verifyPwdText');
        this.newPwdText = this.infoChange.getWidgetByName('newPwdText');
        //Ϣ
        this.oldPwdError = this.infoChange.getWidgetByName('oldPwdError');
        this.enterNewPwdError = this.infoChange.getWidgetByName('enterNewPwdError');
        this.pwdNotMatchError = this.infoChange.getWidgetByName('pwdNotMatchError');
    },
    _clearUserPwdErrorInfo: function () {
        this.oldPwdError.setVisible(false);
        this.enterNewPwdError.setVisible(false);
        this.pwdNotMatchError.setVisible(false);
    }
};