/**
 * Coder: Sean
 * Date: 13-10-19
 * Time: 4:08
 */

/**
 *  
 */
var Consts = {
	SERVERNAMEWD : "fs_mpview_server_name",
	SERVERADDRESSWD : "fs_mpview_server_address",
	UNAUTHPANELWD : "unauthPanel",
	AUTHPANELWD : "authPanel",
	MOVEBTNWD : "moveBtn",
	USERSELECTWD : "userSelect",
	MACADDRESSWD : "macAddress",
	ISMOBILEDEVBINDWD : "isMobileDevBind",
	PHONEFILEUPLOADWD : "phoneFileUpload",
	PADFILEUPLOADWD : "padFileUpload",
	PHONEIMGCLS : "fs_mpview_phoneimg",
	PADIMGCLS : "fs_mpview_padimg",
	QRIMGCLS : "fs_mpview_qrimg",
	UNAUTHPANELCONTENTCLS : "unauth_panel_content",
	AUTHPANELCONTENTCLS : "auth_panel_content"
};

/**
 * ƶƽ̨
 */
FS.MOBILEPLATE = FSMP = {
	
	/**
	 * ͼ
	 */
	View : {
		/**
		 * LTabPane
		 */
		createTabPane : function(render) {
			var self = this;
			var tabs = [this.basicTabConfig(), this.devBindTabConfig(), this.qrCodeTabConfig()];
			this.tabPane = new FS.LTabPane({
				width : '100%',
				height : '100%',
				vgap:21,
				items : tabs,
				renderEl : render,
				loadEveryTime : true,
				initAfterActions : [
					function() {
						
					}, function() {
						//豸
						var isMobileDevBind = FS.config.ismobilebinddev;
				        if(isMobileDevBind === "false") {
				        	self._getWidget(Consts.ISMOBILEDEVBINDWD).setValue(false, true);
				        } else {
				        	self._getWidget(Consts.ISMOBILEDEVBINDWD).setValue(true, true);
				        }
					}, function() {
						var qrServerName = FS.config.qrcodeServerName;
						var qrServerUrl = FS.config.qrcodeServerUrl;
						var qrImageId = FS.config.qrcodeImageID;
						self._getWidget(Consts.SERVERNAMEWD).setValue(qrServerName);
						self._getWidget(Consts.SERVERADDRESSWD).setValue(qrServerUrl);
						if(qrImageId) {
							var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + qrImageId + '&isAdjust=false');
							$("img." + Consts.QRIMGCLS).attr("src", url);	
						}
					}
				]
			});
		},
		
		/**
		 * 
		 */		
		basicTabConfig : function() {
			var self = this;
			return {
				title : FR.i18nText('APP_LAUNCHING'),
				content : {
					type : 'panel',
					doSize : true,
					width : 600,
					height : 435,
					type: 'confirm',
	                text4OK:FR.i18nText("Save_With_Whitespace"),
	                text4Cancel:null,
	                btnsAlignment: 'left',
	                closeAfterAction: false,
	                onOK : function() {
	                	var phoneid = self._getWidgetValue(Consts.PHONEFILEUPLOADWD).attach_id;
	                	var padid = self._getWidgetValue(Consts.PADFILEUPLOADWD).attach_id;
	                	FSMP.Control.saveMobileLaunchImage(phoneid, padid);
                        FR.Msg.toast(FR.i18nText("Successfully"));
	                },
					contentWidget : {
						type : 'absolute',
						items : [
								{
										x : 20,
										y : 5,
										height : 16,
										type : 'label',
										value : FR.i18nText('MobilePhone')
								},
								{
									x : 60,
									y : 5,
									el : $('<img/>').addClass(Consts.PHONEIMGCLS)
								},
								{
									x : 285,
									y : 79,
									type : 'multifile',
									widgetName : Consts.PHONEFILEUPLOADWD,
						 			maxlength : 1,
						 			accept : '.png.jpg.gif',
						 			tooltipText : FR.i18nText('UploadFileTip'),
						 			height : 32,
									width : 32,
									hideFileList : true,
									listeners : [
										{
											eventName : 'afteredit',
											action : function() {
						  		    			var attachid = this.getValue().attach_id;
						  		    			var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + attachid + '&isAdjust=false');
					  		    				$('.' + Consts.PHONEIMGCLS).attr('src', url);
					  		    				$('td', this.element).remove();
											}
										}
									]
								},
								{
									x  : 20,
									y : 222,
									type : 'label',
									height : 16,
									value : FR.i18nText('MobilePad')
								},
								{
									x  : 60,
									y : 222,
									el : $('<img/>').addClass(Consts.PADIMGCLS)
								},
								{
									x  : 285,
									y : 277,
									type : 'multifile',
									widgetName : Consts.PADFILEUPLOADWD,
						 			maxlength : 1,
						 			accept : '.png.jpg.gif',
						 			tooltipText :FR.i18nText('UploadFileTip'),
						 			height : 32,
									width : 32,
									hideFileList : true,
									listeners : [
										{
											eventName : 'afteredit',
											action : function() {
						  		    			var attachid = this.getValue().attach_id;
						  		    			var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + attachid + '&isAdjust=false');
					  		    				$('.' + Consts.PADIMGCLS).attr('src', url);
					  		    				$('td', this.element).remove();
											}
										}
									]	
								}
						]
					}
				}	
			};
		},
		
		/**
		 * 豸
		 */
		devBindTabConfig : function() {
			var self = this;
			return {
				title : FR.i18nText('Device_Bind'),
				content : {
					type : 'panel',
					doSize : true,
					width : 730,
					height : 480,
					closeAfterAction: false,
	                contentWidget : {
						type: 'absolute',
			            scrollable: true,
			            items: [
			                {
			                    type: 'llabel',
			                    value: FR.i18nText("Mobile_Dev_Binding"),
			                    x: 20,
			                    y: 5
			                },
			                {
			                    type: 'switch',
			                    widgetName:Consts.ISMOBILEDEVBINDWD,
			                    x: 120,
			                    y: 5,
			                    onTurnOff:function(){
			                    	self._hiedDevPanels();
			                    	FSMP.Control.closeDevBind();
			                    },
			                    onTurnOn:function(){
			                    	self._showDevPanels();
							        FSMP.Control.openDevBind();
			                    }
			                },
			                {
			                    type: 'panel',
			                    widgetName: Consts.UNAUTHPANELWD,
			                    title: FR.i18nText("Unauthorized_Devices"),
			                    border: true,
			                    doSize: true,
			                    height: 410,
			                    width: 300,
			                    x: 20,
			                    y: 65,
			                    contentHtml: $('<div class="' + Consts.UNAUTHPANELCONTENTCLS + '"/>')
			                },
			                {
			                    type: 'panel',
			                    title: FR.i18nText("Authorized_Devices"),
			                    widgetName: Consts.AUTHPANELWD,
			                    border: true,
			                    doSize: true,
			                    height: 410,
			                    width: 300,
			                    x: 420,
			                    y: 65,
			                    tools: [
			                        {
			                            //豸ť
			                            iconCls: 'fs-module-add-white',
                                        width: 24,
                                        height: 24,
			                            handler : function(){
		                                    //豸Ի
		                                    self.createDevDialog();
		                                }
									}
			                    ],
			                    contentHtml: $('<div class="' + Consts.AUTHPANELCONTENTCLS + '"/>')
			                },
			                {
			                    type: 'iconbutton',
			                    baseClass:'fs-mobile-dev-binding-move-right-icon',
			                    imgsrc: 'fs_mobile_dev_binding_move_right',
			                    width: 44,
			                    height: 24,
			                    widgetName:Consts.MOVEBTNWD,
			                    x: 358,
			                    y: 279,
			                    handler: function () {
			                    	var selectNode = self.unauthTableTree.getSelectedNodes()[0];
			                        if(!selectNode){
			                            return;
			                        }
			                    	if(selectNode.pId === "-1") {
			                    		//ûв
			                    		FSMP.Control.authorizeUser(selectNode);
			                            this.setEnable(false);
			                    		return ;
			                    	}
			                    	FSMP.Control.authorizeDevice(selectNode);
			                    }
			                }
			            ]	
					}
				}
			}
		},
		
		/**
		 * 豸Ի
		 */
		createDevDialog : function() {
			var addDevDialog = new FR.Dialog({
                title: FR.i18nText("Add_Device_With_Whitespace"),
                text4OK: FR.i18nText("OK"),
                text4Cancel: FR.i18nText("Cancel"),
                destroyOnClose: true,
                width: 280,
                height: 178,
                confirm: true,
                border: true,
                closable: true,
                onCancel: function () {
                },
                onOK: function () {
                    var username = addDevDialog.getWidgetByName(Consts.USERSELECTWD).getValue();
                    var macaddress = addDevDialog.getWidgetByName(Consts.MACADDRESSWD).getValue();
                    var devname = FR.i18nText("DevAddedByAdmin");
                    if(!username || !macaddress) {
                        FR.Msg.alert(FR.i18nText("Alert"), FR.i18nText("NeedUserNameAndMacAddress"));
                        return;
                    }
                    FSMP.Control.bindDev(username, devname, macaddress);
                },
                contentWidget: {
                    type: 'tablelayout',
                    top: 10,
                    items: [
                        [
                            {
                            	el : $('<div/>')
                            },
                            {
                            	el : {
                            		type : 'llabel', 
                            		textalign : 'right', 
                            		value : FR.i18nText("Select_Username")
                            	}
                            },
                            {
                            	el : $('<div/>')
                            },
                            {
                            	el : {
                            		type : 'combo', 
                            		widgetName : Consts.USERSELECTWD,
                            		widgetUrl : FR.servletURL + "?op=fs_set&cmd=auth_getallusers"
                            	}
                            }
                        ],
                        [
                            {
                            	el : $('<div/>')
                            },
                            {
                            	el : {
                            		type : 'llabel', 
                            		textalign : 'right', 
                            		value : FR.i18nText("Add_Mac_Address")
                            	}
                            },
                            {
                            	el : $('<div/>')
                            },
                            {
                            	el : {
                            		type : 'text', 
                            		widgetName : Consts.MACADDRESSWD
                            	}
                            }
                        ]
                    ],
                    columnSize: [20, 80, 10, 130],
                    rowSize: [21, 21],
                    vgap: 11
                }
            });
            addDevDialog.setVisible(true);
		},
		
		/**
		 * ά(Quick Response Code)
		 */
		qrCodeTabConfig : function() {
			var self = this;
			return {
				title : FR.i18nText('QRCode_Config'),
				content : {
					type : 'panel',
					doSize : true,
					width : 500,
					height : 200,
					contentWidget : {
						type : 'absolute',
						items : [
							{
								x : 20,
								y : 5,
								type : 'label',
								value : FR.i18nText('Server_Name'),
								width : 92,
								height : 16
							}, 
							{
								x : 20,
								y : 31,
								type : 'text',
								width : 290,
								height : 21	,
								widgetName : Consts.SERVERNAMEWD
							},
							{
								x : 20,
								y : 62,
								type : 'label',
								value : FR.i18nText('Server_Address'),
								width : 92,
								height : 16
							},
							{
								x : 20,
								y : 88,
								type : 'text',
								width : 290,
								height : 21,
								widgetName : Consts.SERVERADDRESSWD
							},
							{
								x : 352,
								y : 5,
								el : $('<img/>').addClass(Consts.QRIMGCLS)
							},
							{
								x : 110,
								y : 124,
								type : 'quickbutton',
								text : FR.i18nText('Create_QRCode'),
								width : 110,
								height : 33,
								handler : function() {
									var serverName = self._getWidgetValue(Consts.SERVERNAMEWD);
									var serverAddress = self._getWidgetValue(Consts.SERVERADDRESSWD);
									FSMP.Control.createQRCode(serverName, serverAddress);
								}
							}
						]
					}
				}
			}
		},
		
		/**
		 * View.tabPaneиݿؼƻȡؼֵ
		 * @param widgetName ؼ
		 * @private
		 */
		_getWidgetValue : function(widgetName) {
			return this.tabPane.getWidgetByName(widgetName).getValue();
		},
		
		/**
		 * View.tabPaneиݿؼƻȡؼ
		 * @param widgetName ؼ
		 * @private
		 */
		_getWidget : function(widgetName) {
			return this.tabPane.getWidgetByName(widgetName);
		},
		
		/**
		 * Ȩ&δȨ豸
		 * @private
		 */
		_hiedDevPanels : function() {
			this._getWidget(Consts.UNAUTHPANELWD).setVisible(false);
	        this._getWidget(Consts.AUTHPANELWD).setVisible(false);
	        this._getWidget(Consts.MOVEBTNWD).setVisible(false);				        	
		},
		
		/**
		 * ʾȨ&δȨ豸
		 * @private
		 */
		_showDevPanels : function() {
			this._getWidget(Consts.UNAUTHPANELWD).setVisible(true);
	        this._getWidget(Consts.AUTHPANELWD).setVisible(true);
	        this._getWidget(Consts.MOVEBTNWD).setVisible(true);
	        //ݼťſá
	        this._getWidget(Consts.MOVEBTNWD).setEnable(false);
	        $('.' + Consts.UNAUTHPANELCONTENTCLS).empty();
	        $('.' + Consts.AUTHPANELCONTENTCLS).empty();
	        //
	        this.unauthTableTree = new FS.TableTree(this._unauthTabletreeConfig());
	        this.authTableTree = new FS.TableTree(this._authTabletreeConfig());	
		},
		
		/*
		 * δȨ豸
		 * @private
		 */
		_unauthTabletreeConfig : function() {
            var self = this;
			var treeOnClick = function(event, treeId, treeNode){
                FSMP.View.tabPane.getWidgetByName(Consts.MOVEBTNWD).setEnable(true);
            };
			        
			var unauthTreeSetting = {
			    view: {
			        showIcon: false  //ʾÿڵǰICON
			    },
			    data: {
			        simpleData: {
			            enable: true,
			            idKey: "id",
			            pidKey: "pId",
			            rootPId: "-1"
			        }
			    },
			    callback: {
			        onClick: treeOnClick
			    }
			};
			return {
	            treeID: 'unauthTableTree',
	            height: '100%',
	            width: '100%',
	            fit: true,
	            setting: unauthTreeSetting,
	            alwaysShowTools:false,
	            itemHoverCls:'fs_tabletree_item_hover',
	            renderEl: $('.unauth_panel_content'),
	            tools: [
	                {
	                    iconCls: 'fs-module-delete-white',
	                    hoverCls: 'fs-module-delete-white-hover',
	                    //༭ť¼
	                    onToolClick: function (e) {
	                        var self2 = this;
	                        FR.Msg.confirm(FR.i18nText("Delete_Data"), FR.i18nText("sure_to_delete")+"", function(result) {
	                            if(result) {
	                                var nodeID = $(self2).data('nodeID');
	                                var selectNode = self.unauthTableTree.getNodeById(nodeID);
	                                if(!selectNode || selectNode.pId === "-1") {
	                                    //ɾû
	                                    FR.ajax({
	                                        url : FR.servletURL + '?op=fs_mobile_main&cmd=deletedev',
	                                        type : 'POST',
	                                        data : {
	                                            'username':selectNode.name,
	                                            'ispassed':false
	                                        },
	                                        complete : function() {
	                                            self.unauthTableTree.removeNode(selectNode);
	                                        }
	                                    });
	                                    return ;
	                                }
	                                FR.ajax({
	                                    url : FR.servletURL + '?op=fs_mobile_main&cmd=deletedev',
	                                    type : 'POST',
	                                    data : {
	                                        'username':selectNode.getParentNode().name,
	                                        'macaddress':selectNode.macaddress
	                                    },
	                                    complete : function() {
	                                        var parentNode = selectNode.getParentNode();
	                                        if(parentNode.children.length <= 1) {
	                                            //˵ɾ֮û¾û豸ˣֱӰûɾ
	                                            self.unauthTableTree.removeNode(parentNode);
	                                        } else {
	                                            self.unauthTableTree.removeNode(selectNode);
	                                        }
	                                    }
	                                });
	
	                                e.stopEvent();
	                            }
	                        });
	                    }
	                }
	            ]
			}
        },
        
        /**
         * Ȩ豸
         * @private
         */
        _authTabletreeConfig : function() {
        	var self = this;
        	var authTreeSetting = {
			    view: {
			        showIcon: false  //ʾÿڵǰICON
			    },
			    data: {
			        simpleData: {
			            enable: true,
			            idKey: "id",
			            pidKey: "pId",
			            rootPId: "-1"
			        }
			    }
			};
        	return {
	            treeID: 'authTableTree',
	            setting: authTreeSetting,
	            height: '100%',
	            width: '100%',
	            fit: true,
	            alwaysShowTools:false,
	            itemHoverCls:'fs_tabletree_item_hover',
	            renderEl: $('.auth_panel_content'),
	            tools: [
	                {
	                    iconCls: 'fs-module-delete-white',
	                    hoverCls: 'fs-module-delete-white-hover',
	                    //༭ť¼
	                    onToolClick: function (e) {
	                        var self2 = this;
	                        FR.Msg.confirm(FR.i18nText("Delete_Data"), FR.i18nText("sure_to_delete")+"", function(result) {
	                            if(result) {
	                                var nodeID = $(self2).data('nodeID');
	                                var selectNode = self.authTableTree.getNodeById(nodeID);
	                                if(!selectNode || selectNode.pId === "-1") {
	                                    //ɾû
	                                    FR.ajax({
	                                        url : FR.servletURL + '?op=fs_mobile_main&cmd=deletedev',
	                                        type : 'POST',
	                                        data : {
	                                            'username':selectNode.name,
	                                            'ispassed':true
	                                        },
	                                        complete : function() {
	                                            self.authTableTree.removeNode(selectNode);
	                                        }
	                                    });
	                                    return ;
	                                }
	                                FR.ajax({
	                                    url : FR.servletURL + '?op=fs_mobile_main&cmd=deletedev',
	                                    type : 'POST',
	                                    data : {
	                                        'username':selectNode.getParentNode().name,
	                                        'macaddress':selectNode.macaddress
	                                    },
	                                    complete : function() {
	                                        var parentNode = selectNode.getParentNode();
	                                        if(parentNode.children.length <= 1) {
	                                            //˵ɾ֮û¾û豸ˣֱӰûɾ
	                                            self.authTableTree.removeNode(parentNode);
	                                        } else {
	                                            self.authTableTree.removeNode(selectNode);
	                                        }
	                                    }
	                                });
	
	                                e.stopEvent();
	                            }
	                        });
	                    }
	                }
	            ]
        	}
        }
	},
	
	/**
	 * 
	 */
	Control : {
		
		/**
		 * ʼ
		 */
		initData : function() {
			FR.ajax({
				url : FR.servletURL + "?op=fs_mobile_main&cmd=initdata",
				type : "POST",
				complete : function(res, status) {
					if(status == "success") {
						var data = FR.jsonDecode(res.responseText);
						FS.config.qrcodeServerName = data.qrservername;
						FS.config.qrcodeServerUrl = data.qrserverurl;
						FS.config.qrcodeImageID = data.qrcodeid;
						if(data.phoneid) {
							var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + data.phoneid + '&isAdjust=false');
							$("img." + Consts.PHONEIMGCLS).attr("src", url);	
						} else {
                            $("img." + Consts.PHONEIMGCLS).attr("src", "${servletURL}?op=resource&resource=/com/fr/fs/web/images/mobile/phone.jpg");
                        }
						if(data.padid) {
							var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + data.padid + '&isAdjust=false');
							$("img." + Consts.PADIMGCLS).attr("src", url);	
						} else {
                            $("img." + Consts.PADIMGCLS).attr("src", "${servletURL}?op=resource&resource=/com/fr/fs/web/images/mobile/pad.jpg");
                        }
					}
				}
			});
		},
		
		/**
		 * ݷƣַ̨ɶάͼƬǰչʾ
		 * @param serverName 
		 * @param serverUrl ַ
		 */
		createQRCode : function(serverName, serverUrl) {
			FR.ajax({
				url : "${servletURL}?op=fs_mobile_main&cmd=qrcode",
				data : {
					serverName : serverName,
					serverUrl : serverUrl
				},
				complete : function(res, status) {
					if(status == "success") {
						var attachid = res.responseText;
						var url = FR.servletURL + ('?op=fr_attach&cmd=ah_image&id=' + attachid + '&isAdjust=false');
						$("img." + Consts.QRIMGCLS).attr("src", url);
						FS.config.qrcodeServerName = serverName;
						FS.config.qrcodeServerUrl = serverUrl;
						FS.config.qrcodeImageID = attachid;
					}
				}
			})
		},
		
		/**
		 * 豸
		 */
		 openDevBind : function(afterbind) {
			var self = this;
			FR.ajax({
				url : FR.servletURL + '?op=fs_mobile_main&cmd=bindorunbind',
				type : 'POST',
				data : {
					'bind':'true'
				},
				complete : function(res, status) {
					if (res.responseText == null || res.responseText == "") {
						return;
					}
					self.devInfo = FR.jsonDecode(res.responseText);
					var passedtreedata = self._makeTreedata(true);
					FSMP.View.authTableTree.addNodes(null, passedtreedata, true);
					var unpassedtreedata = self._makeTreedata(false);
					FSMP.View.unauthTableTree.addNodes(null, unpassedtreedata, true);
					FS.config.ismobilebinddev = "true";
				}
			});
		},
		
		/**
		 * 豸
		 */
		closeDevBind : function() {
			FR.ajax({
				url : FR.servletURL + '?op=fs_mobile_main&cmd=bindorunbind',
				type : 'POST',
				data : {
					'bind':'false'
				},
				complete : function(res, status) {
					FS.config.ismobilebinddev = "false";
				}
			});
		},
		
		/**
		 * 豸
		 * @param username û
		 * @param devname 豸
		 * @param macaddress 豸MACַ
		 */
		bindDev : function(username, devname, macaddress) {
			FR.ajax({
                url : FR.servletURL + '?op=fs_mobile_main&cmd=binddev',
                type : 'POST',
                data : {
                    'username':username,
                    'devname':devname,
                    'macaddress':macaddress
                },
                complete : function() {
                    //δȨƳ
                    //Ȩ
                    //ȿȨбǲѾû
                    var authTableTree = FSMP.View.authTableTree;
                    var allAuthNodes = authTableTree.getNodes();
                    var hasFound = false;
                    for(var i = 0; i < allAuthNodes.length; i ++) {
                        var authNode = allAuthNodes[i];
                        if((authNode.name === username) && (authNode.pId === "-1")) {
                            //ڣֻҪӽڵ
                            var zitem = {};
                            zitem.name = devname + "("+ macaddress +")";
                            zitem.macaddress = macaddress;
                            zitem.open = true;
                            authTableTree.addNodes(authNode, zitem, true);
                            hasFound = true;
                            break;
                        }
                    }
                    if(!hasFound) {
                        //ûҵȼû
                        var zitem = {};
                        zitem.name = username;
                        zitem.open = true;
                        var usernode = authTableTree.addNodes(null, zitem, true)[0];
                        var zitem = {};
                        zitem.name = devname + "("+ macaddress +")";
                        zitem.macaddress = macaddress;
                        zitem.open = true;
                        authTableTree.addNodes(usernode, zitem, true);
                    }
                }
            });
		},
		
		/**
		 * Ϊûµ豸Ȩ
		 * @param selectNode : ѡеûڵ
		 */
		authorizeUser : function(selectNode) {
			var username = selectNode.name;
			FR.ajax({
				url : FR.servletURL + '?op=fs_mobile_main&cmd=binddev',
				type : 'POST',
				data : {
					'username':username
				},
				complete : function() {
					//δȨƳ
					FSMP.View.unauthTableTree.removeNode(selectNode);
					//Ȩ
					//ȿȨбǲѾû
					var allAuthNodes = FSMP.View.authTableTree.getNodes();
					var hasFound = false;
					var children = selectNode.children;
					for(var i = 0; i < allAuthNodes.length; i ++) {
						var authNode = allAuthNodes[i];
						if((authNode.name === username) && (authNode.pId === "-1")) {
							//ڣֻҪӽڵ
							for(var i = 0; i < children.length; i ++) {
								var node = children[i];
								var zitem = {};
								zitem.name = node.name;
								zitem.macaddress = node.macaddress;
					    		zitem.open = true;
								FSMP.View.authTableTree.addNodes(authNode, zitem, true);
							}
							hasFound = true;
							break;
						}
					}
					if(!hasFound) {
						//ûҵȼû
						var zitem = {};
						zitem.name = username;
			    		zitem.open = true;
			    		var usernode = FSMP.View.authTableTree.addNodes(null, zitem, true)[0];
			    		for(var i = 0; i < children.length; i ++) {
							var node = children[i];
							var zitem = {};
							zitem.name = node.name;
							zitem.macaddress = node.macaddress;
				    		zitem.open = true;
							FSMP.View.authTableTree.addNodes(authNode, zitem, true);
						}
					}
				}
			});	
		},
		
		/**
		 * Ϊ豸Ȩ
		 * @param selectNode : ѡе豸ڵ
		 */
		authorizeDevice : function(selectNode) {
			var macaddress = selectNode.macaddress;
        	var devname = selectNode.name;
        	var username = selectNode.getParentNode().name;
        	FR.ajax({
				url : FR.servletURL + '?op=fs_mobile_main&cmd=binddev',
				type : 'POST',
				data : {
					'username':username,
					'devname':devname,
					'macaddress':macaddress
				},
				complete : function() {
					//δȨƳ
					var parentNode = selectNode.getParentNode();
					if(parentNode.children.length <= 1) {
						//˵ɾ֮û¾û豸ˣֱӰûɾ
						FSMP.View.unauthTableTree.removeNode(parentNode);
					} else {
						FSMP.View.unauthTableTree.removeNode(selectNode);	
					}
					//Ȩ
					//ȿȨбǲѾû
					var allAuthNodes = FSMP.View.authTableTree.getNodes();
					var hasFound = false;
					for(var i = 0; i < allAuthNodes.length; i ++) {
						var authNode = allAuthNodes[i];
						if((authNode.name === username) && (authNode.pId === "-1")) {
							//ڣֻҪӽڵ
							var zitem = {};
							zitem.name = selectNode.name;
							zitem.macaddress = selectNode.macaddress;
				    		zitem.open = true;
							FSMP.View.authTableTree.addNodes(authNode, zitem, true);
							hasFound = true;
							break;
						}
					}
					if(!hasFound) {
						//ûҵȼû
						var zitem = {};
						zitem.name = username;
			    		zitem.open = true;
			    		var usernode = FSMP.View.authTableTree.addNodes(null, zitem, true)[0];
			    		var zitem = {};
			    		zitem.name = selectNode.name;
						zitem.macaddress = selectNode.macaddress;
			    		zitem.open = true;
			    		FSMP.View.authTableTree.addNodes(usernode, zitem, true);
					}
                    FSMP.View.tabPane.getWidgetByName(Consts.MOVEBTNWD).setEnable(false);
				}
			});
		},
		
		/**
		 * phonepad˵
		 * @param phoneid ֻͼƬID
		 * @param padid ƽͼƬID
		 */
		saveMobileLaunchImage : function(phoneid, padid) {
			if(!phoneid && !padid) {
				return ;
			}
			FR.ajax({
				url : FR.servletURL + '?op=fs_mobile_main&cmd=savelaunchimage',
				type : 'POST',
				data : {
					'phoneid':phoneid,
					'padid':padid
				},
				complete : function() {
					
				}
			});
		},
		
		/**
		 * ztreeҪ
		 * @param isPassed Ȩ/δȨ豸
		 * @private
		 */
		_makeTreedata : function(isPassed) {
			var passedTreedata = [];
			var unPassedTreedata = [];
			var userIndex = -1;
			$.each(this.devInfo, function(username, devinfos) {
				userIndex --;
				var hasPassedDev = false;
				var hasUnPassedDev = false;
				for(var i = 0; i < devinfos.length; i ++) {
					var devinfo = FR.jsonDecode(devinfos[i]);
					var zitem = {};
					zitem.name = devinfo.devname + "("+ devinfo.macaddress +")";
					zitem.id = i+""+userIndex;
	        		zitem.pId = userIndex;
	        		zitem.open = true;
	        		zitem.macaddress = devinfo.macaddress;
					if(devinfo.ispassed === true) {
						//ͨ
		        		hasPassedDev = true;
		        		passedTreedata.push(zitem);
					} else {
						hasUnPassedDev = true;
						unPassedTreedata.push(zitem);
					}
				}
				var zitem = {};
				zitem.name = username;
				zitem.id = userIndex;
	    		zitem.pId = "-1";
	    		zitem.open = true;
				if(hasPassedDev) {
					//ûӽȥ
	        		passedTreedata.push(zitem);
				}
				if(hasUnPassedDev) {
					unPassedTreedata.push(zitem);
				}
			});
			if(isPassed) {
				return passedTreedata;
			} else {
				return unPassedTreedata;
			}
		}
	},
	
	/**
	 * ʼƶƽ̨
	 * @param render : 
	 */
	init : function(render) {
		FR.$defaultImport('/com/fr/fs/web/css/manager/fs_mobileplate.css', 'css');
		this.View.createTabPane(render);
		this.Control.initData();
	}
}