/*
 * Copyright (c) 2001-2014,FineReport Inc, All Rights Reserved.
 */

/**
 * wei : һЩ߷
 */
;

if(FS.Tools == null) {
    FS.Tools = {};
}

$.extend(FS.Tools, {
    createUserOptPane: function(data){
        /**
         * ûѡdom
         * @param user user
         * @param isSelected ǷǱѡеû
         * @returns {*|jQuery}
         * @private
         */
        var createUserWrap = function(user, isSelected){
            var $user = $('<a href="#"/>').data('user', user);
            if(isSelected){
                $user.addClass("fs-usermgr-seluser");
            }else{
                $user.addClass("fs-usermgr-alluser");
            }
            var text = (user.realname||"")+'('+user.username+')';
            $('<span/>').text(text).attr('title', text).appendTo($user);
            return $user;
        };
        var selo = {index:0, list:[], need2Scroll:false, isSel:true};
        var unselo = {index:0, list:[], need2Scroll:false, isSel:false};
        var isLoadingData = false, max = 200;
        var dellist = [], addlist = [];
        var refreshUserOptPane = function(data, $seluser, $alluser, callback){
            data.dellist = dellist.join(',');
            data.addlist = addlist.join(',');
            FR.ajax({
                url: FR.servletURL + "?op=fs_set&cmd=auth_getfilterusers",
                type: 'POST',
                data: data,
                complete: function(res, status){
                    if(status == 'success'){
                        if($.isFunction(callback)) {
                            callback.call();
                        }
                        var result = FR.jsonDecode(res.responseText);
                        var len = result.length;
                        selo = {index:0, list:[], need2Scroll:false, isSel:true};
                        unselo = {index:0, list:[], need2Scroll:false, isSel:false};
                        for(var i = 0;i<len;i++){
                            var user = result[i];
                            if(user.inDepart){
                                selo.list.push(user);
                                if(selo.index < max){
                                    selo.index ++;
                                    createUserWrap(user, true).appendTo($seluser);
                                }else{
                                    selo.need2Scroll = true;
                                }
                            }else{
                                unselo.list.push(user);
                                if(unselo.index < max){
                                    unselo.index ++;
                                    createUserWrap(user, false).appendTo($alluser);
                                }else{
                                    unselo.need2Scroll = true;
                                }
                            }
                        }
                    }
                }
            });
        };

        var $userpane = $('<div class="fs-usermgr-userpane"/>');
        //غ,ÿι50
        var scrollEvt = function (target, o) {
            if (o.need2Scroll && $(target).scrollTop() + $(target).height() >= target.scrollHeight) {
                if (isLoadingData) {
                    return;
                }
                isLoadingData = true;
                var num = o.index + 50;
                if (num >= o.list.length) {
                    num = o.list.length;
                    o.need2Scroll = false;
                }
                for (var i = o.index; i < num; i++) {
                    createUserWrap(o.list[i], o.isSel).appendTo($(target));
                }
                o.index = num;
                isLoadingData = false;
            }
        };
        //ѡû
        var $seluser = $('<div class="fs-usermgr-selpane"/>').appendTo($userpane)
            .click(function (e) {
                if(data.viewOnly) {
                    return;
                }
                var target = e.target;
                var $delu = $(target).closest('.fs-usermgr-seluser');
                if ($delu.length) {
                    $delu.hide();
                    if ($delu.data('sel')) {
                        $delu.data('sel').removeClass('fs-usermgr-disabled').data('selected', false);
                    } else {
                        var user = $delu.data('user');
                        dellist.push(user.id);
                        addlist.remove(user.id);
                        var $unuser = createUserWrap(user, false).data('del', $delu).appendTo($alluser);
                        $delu.data('sel', $unuser);
                    }
                }
            }).scroll(function(){
                scrollEvt(this, selo);
            });
        //û
        var $alluser = $('<div class="fs-usermgr-allpane"/>').appendTo($userpane)
            .click(function (e) {
                if(data.viewOnly) {
                    return;
                }
                var target = e.target;
                var $selu = $(target).closest('.fs-usermgr-alluser');
                if ($selu.length) {
                    if ($selu.data('selected') === true) {
                        return;
                    } else {
                        var user = $selu.data('user');
                        addlist.push(user.id);
                        dellist.remove(user.id);
                        $selu.addClass('fs-usermgr-disabled');
                        if ($selu.data('del')) {
                            $selu.data('del').appendTo($seluser).show();
                        } else {
                            var $suser = createUserWrap(user, true)
                                .data('sel', $selu).appendTo($seluser);
                            $selu.data('del', $suser);
                        }
                        $selu.data('selected', true);
                    }
                }
            }).scroll(function(){
                scrollEvt(this, unselo);
            });
        $userpane.seluser = $seluser;
        $userpane.alluser = $alluser;
        $userpane.refresh = refreshUserOptPane;
        $userpane.getAddlist = addlist;
        $userpane.getDellist = dellist;
        $('<div/>').text(FR.i18nText("User_Unselected")).appendTo($alluser);
        refreshUserOptPane(data, $seluser, $alluser);
        return $userpane;
    },


    /**
     * ȡָݼ(ͬȡһοԱⷴȡݿ)
     * @param tabledataname ݼ
     * @returns {*}
     */
    getColsByTableDataName: function(tabledataname) {
        var cols = [];
        FR.ajax({
            url: FR.servletURL + '?op=fs_manager&cmd=get_tabledatacolname',
            type: 'POST',
            async : false,
            data: {
                name: tabledataname
            },
            complete : function(res, status) {
                if(status == 'success'){
                    cols = FR.jsonDecode(res.responseText);
                }
            }
        });
        return cols;
    }
});