// ADHOCANALYSIS.JS
FR.ADANALY = {};
$.extend(FS.Trans, {
	getFormatRegList : function(){
		return FS.Trans.ajax({
			url : FR.servletURL + "?op=fr_adhoc&cmd=ac_format_reg"
		})
	},
	
	getFormatPre : function(i, text){
		return FS.Trans.ajax({
			url : FR.servletURL + "?op=fr_adhoc&cmd=ac_preivew_format",
			data : {
				formatContents : i,
				formatText : text
			},
			returnString : true
		})
	},
	
	getChartIcons : function(content) {
		return FS.Trans.ajax({
			url : FR.servletURL + "?op=fr_adhoc&cmd=ac_chart_icon",
			data : {
				chartcontent : content
			},
			returnString : true
		})
	},
	
	getCellKey : function(data){
		return FS.Trans.ajax({
			url : FR.servletURL + "?op=fr_analysis&cmd=get_cal_colNames",
			data : data
		})
	},
	
	getCellCategory : function(data){
		return FS.Trans.ajax({
			url : FR.servletURL + "?op=fr_analysis&cmd=get_cell_category",
			data : data
		})
	},
	
	saveADHOCReport : function (data) {
		return FS.Trans.ajax({
			url : FR.servletURL + "?op=fs_main&cmd=module_addadhocreport",
			data : data
		})
	}
});

$.extend(FR.ADANALY, {
	_init : function(colNames, viewname, needTitle, popConfig) {
		this.colNames = colNames;
		this.viewname = viewname;
		var regions = [];
		this.$center = $('#fr-adanaly-center');
		this.$toolbar = $('#fr-adanaly-toolbar');
		this.$west = $('#fr-adanaly-west');
		var report= [];
		this.$iframe = $('#analyFrame');
		this.cellSettings = {};
		this.addedCells = [];
		this.groupSettings = [];
		report.push({region:"north", el:this.$toolbar, height:25, width:"100%"});
		report.push({region:"center", el:this.$iframe, width:"100%"});
		this.$center.asComponent({type:'border', items:report});
		this.$center.doLayout();
//		var centerDiv = $('#fr-adanaly-center-parent');
//		this.$center.appendTo(centerDiv)
		regions.push({region : "center", el : this.$center});
		if (needTitle != false) {
			regions.push({region : "north", el : $('#fr-adanaly-north')});
		} else {
			$('#fr-adanaly-north').hide();
		}
		regions.push({region : "west",
//					title:FR.i18nText("DashBoard-AdhocSetting"),
//					collapsible:true,
//					customExpand:true,					 
					el : this.$west
					});
		var bd = $('body');
		this.border = bd.asComponent({type:'border',items : regions});
		bd.doLayout();
		
		this.$iframe = $('#analyFrame');
		
		this._initColumnRowFieldPane(colNames);
		
		this._initInputs();
		
		this.titleValue ='˴޸ı';
		this.subTitleValue ='˴޸ĸ';
		//޸ʽ
		$('.fr-panel-header', bd).addClass('fr-adanaly-west-title');
		//ť
		$("#fr-analy-westtitle").append($("<div/>").addClass('fr-adanaly-showhide').css({
			'position':'absolute',
			'right':0
		}).attr('title', ''));
//		$('.fr-layout-border-button-left', bd).addClass('fr-adanaly-showhide').attr('title', '');
		var self = this;
		window.onresize = function() {
			bd.doLayout();
			self.$center.doLayout();
		};
		//$centerҲһborderlayoutҪ²
		$('.fr-adanaly-showhide').bind('click', function(e){
            var westWidth = self.border.regionField['west'].width;
            self.border.setRegionWH('west', 1);
            self.border.doLayout();
            //չť
//            self.border.regionField['west'].el.resizable({disabled: true});

//
//
//			self.border._collapsePanel({
//				"region":"west",
//				'customExpand':true
//			});
//			$($("div.fr-layout-border-panel-center")[0]).css("left","320px");
			if(self.showDesignButton){
				self.showDesignButton.show();
			}
//			$("div.fr-layout-border-panel-center:eq(0)").animate({left:"0px"}, {
// 						easing : 'swing',
// 						queue : false
// 			});
// 			self.$center.doLayout();
 			$.each(self.toolbars, function(idx, button){
 				if(button.pop){
 					button.pop.css("left", (parseInt(button.pop.css('left')) + 22)+"px");
 				}
 			});
// 			setTimeout(function(){
// 				$(window).resize();
// 			},410)
		})
		var columnRowExchangeButton = $('.fr-adanaly-td-columnRowExchange');
		columnRowExchangeButton.unbind('click').bind('click', function(e){
			if (self.rowBoard && self.columnBoard && self.col_tr_map) {
				var rows = self.rowBoard.getColumns();
				var columns = self.columnBoard.getColumns();
				self.rowBoard.clearColumn();
				self.columnBoard.clearColumn();
				 $.each(rows, function(idx, item){
				 	var $tr = self.col_tr_map[item.columnname];
				 	$tr.append($('<td><p class="fr-adanaly-fl-ff">'+ item.columnname +'</p></td>'));
					if ($tr != null) {
						self.columnBoard.popColumn($tr, item.groupStyle);
					}
				 });
				  $.each(columns, function(idx, item){
				  	var $tr = self.col_tr_map[item.columnname];
				  	$tr.append($('<td><p class="fr-adanaly-fl-ff">'+ item.columnname +'</p></td>'));
					if ($tr != null) {
						self.rowBoard.popColumn($tr, item.groupStyle);
					}
				 });
				FR.ADANALY.viewReport();
			}
		});
		this._createToolbar();
		// carl:populate
		if (popConfig) {
			this._populate(popConfig);
		}
	},
	
	pop : function (report) {
		var self = this;
		if (self.rowBoard && self.columnBoard && self.summaryBoard && self.col_tr_map) {
			var rows = report.rows;
			var columns = report.columns;
			var sumary = report.summaryColumn;
			var otherCol = [];
			$.each(self.colNames, function(idx, item){
				var hasValue = false;
				$.each([rows, columns, sumary], function(index, obj){
					$.each(obj, function(i, cr){
						if(cr.columnname == item.text){
							hasValue = true;
							return false;
						}
					})
					if(hasValue){
						return false;
					}
				})
				if (!hasValue) {
					otherCol.push(item);
				}
			})
			self.rowBoard.clearColumn();
			self.columnBoard.clearColumn();
			self.summaryBoard.clearColumn();
			$.each(rows, function(idx, item){
			 	var $tr = self.col_tr_map[item.columnname];
			 	$tr.append($('<td><p class="fr-adanaly-fl-ff">'+ item.columnname +'</p></td>'));
				if ($tr != null) {
					self.rowBoard.popColumn($tr, item.groupStyle);
				}
			 });
			 $.each(columns, function(idx, item){
			  	var $tr = self.col_tr_map[item.columnname];
			  	$tr.append($('<td><p class="fr-adanaly-fl-ff">'+ item.columnname +'</p></td>'));
				if ($tr != null) {
					self.columnBoard.popColumn($tr, item.groupStyle);
				}
			 });
			  $.each(sumary, function(idx, item){
			  	var $tr = self.col_tr_map[item.columnname];
			  	$tr.append($('<td><p class="fr-adanaly-fl-ff">'+ item.columnname +'</p></td>'));
				if ($tr != null) {
					self.summaryBoard.popColumn($tr, item.funname);
				}
			 });
			 self.fieldsListPane.popColumns(otherCol, this.$fl_table);
		}
	},
	
	_toolbarButtonHover : function(button){
		$.each([button.left, button.right], function(idx, item){
			if(item){
				item.getItem().hover(
					function(){
						if(!button.left.getItem().hasClass("ui-state-disabled"))
		    				button.left.getItem().addClass(button.left.getHover());
		    			if(button.right)
		    				if(!button.right.getItem().hasClass("ui-state-disabled"))
		    					button.right.getItem().addClass(button.right.getHover());
		    		},
					function(){
						$(this).removeClass(button.left.getClick());
						button.left.getItem().removeClass(button.left.getHover());
						if(button.right)
		    				button.right.getItem().removeClass(button.right.getHover());
					}	
				);
				item.getItem().bind("mousedown", function(e){
					if(!$(this).hasClass("ui-state-disabled"))
						$(this).addClass(button.left.getClick());
				});
				item.getItem().bind("mouseup", function(e){
					$(this).removeClass(button.left.getClick());
				});
			}
		})
	},
	
	_createToolbar : function(){		
		var self = this;
		self.toolbars= [];
		//չť
		self.showDesignButton = new ToolbarButton($(".fr-adanaly-toolbar-showhide"));
		self.toolbars.push(self.showDesignButton);
		self.showDesignButton.on('click', function(e){
			self.showDesignButton.hide();
            self.border.setRegionWH('west', 320);
            self.border.doLayout();
 			$.each(self.toolbars, function(idx, button){
 				if(button.pop){
 					button.pop.css("left", (parseInt(button.pop.css('left')) - 22)+"px");
 				}
 			});
		});
		this.undoRedoManager = new UndoRedoManager(8);
		//ť
		self.undoButton = new ToolbarButton($(".fr-adanaly-toolbar-undo"));
		self.toolbars.push(self.undoButton);
		self.undoButton.setEnabled(false);
		self.undoButton.on('click', function(){
			self.undoRedoManager.undo();
		})
		//ť
		self.redoButton = new ToolbarButton($(".fr-adanaly-toolbar-redo"));
		self.toolbars.push(self.redoButton);
		self.redoButton.setEnabled(false);
		self.redoButton.on('click', function(){
			self.undoRedoManager.redo();
		})
		//ɾť
		self.deleteButton = new ToolbarButton($('.fr-adanaly-toolbar-delete'));
		self.toolbars.push(self.deleteButton);
		self.deleteButton.setEnabled(false);
		self.deleteButton.on('click', function(){
			self.deleteAddedCell();
		});
		//水ť
		self.saveButton = new ToolbarPopButton($(".fr-adanaly-toolbar-save"), $("#fr-adanaly-pop-save"));
		self.toolbars.push(self.saveButton);
		self.saveButton.setEnabled(false);
		//ť
		self.exportButton = new ToolbarPopButton($(".fr-adanaly-toolbar-export"), $("#fr-adanaly-pop-export"));
		self.toolbars.push(self.exportButton);
		self.exportButton.setEnabled(false);
		//
		self.fontFamilyComp = new DropDownList($(".fr-adanaly-toolbar-font-text"),
								$(".fr-adanaly-toolbar-font-pop"), 
								$("#fr-adanaly-pop-fontfamily"));
		self.toolbars.push(self.fontFamilyComp);
		//С
		self.fontSizeComp = new DropDownList($(".fr-adanaly-toolbar-font-size-text"),
								$(".fr-adanaly-toolbar-font-size-pop"),
								$("#fr-adanaly-pop-font-size"));
		self.toolbars.push(self.fontSizeComp);
		//ɫ
		self.fontColorButton = new ToolbarClickAndPopButton($(".fr-adanaly-toolbar-font-color"),
														 	$(".fr-adanaly-toolbar-font-color-pop"), 
															$("#fr-adanaly-pop-font-color"),
															$(".fr-adanaly-toolbar-font-color-icon"));
		self.toolbars.push(self.fontColorButton);
		self.fontColorButton.on("click", function(e){
			self.setCellConfig({
				fontColor : self.fontColorButton.getValue()
			})
		})
		//ϸ
		self.fontWeightButton = new ToolbarButton($(".fr-adanaly-toolbar-font-weight"));
		self.toolbars.push(self.fontWeightButton);
		//0 -> Font.PLAIN 1-> Font.BLOD
		self.fontWeightButton.on('click', function(e){
			var key = self._buildFirstSelectKey();
			if(!key){
				return;
			}
			var cellSetting = self.getCellSetting(key);
			if(!cellSetting || !cellSetting['fontWeight'] || cellSetting['fontWeight'] === '0'){
				self.fontWeightButton.setValue("1");
			} else {
				self.fontWeightButton.setValue("0");
			}
			self.setCellConfig({
				fontWeight : self.fontWeightButton.getValue()
			})
		});
		//ĬֵFont.PLAIN
		self.fontWeightButton.setValue("0");
		//б
		self.fontItalicButton = new ToolbarButton($(".fr-adanaly-toolbar-font-italic"));
		self.toolbars.push(self.fontItalicButton);
		//0 -> Font.PLAIN 2-> Font.ITALIC
		self.fontItalicButton.on('click', function(e){
			var key = self._buildFirstSelectKey();
			if(!key){
				return;
			}
			var cellSetting = self.getCellSetting(key);
			if(!cellSetting || !cellSetting['fontItalic'] || cellSetting['fontItalic'] === '0') {
				self.fontItalicButton.setValue("2");
			} else {
				self.fontItalicButton.setValue("0");
			}
			self.setCellConfig({
				fontItalic : self.fontItalicButton.getValue()
			})
		});
		//ĬֵFont.PLAIN
		self.fontItalicButton.setValue("0");
 		//»
		self.fontUnderlineButton = new ToolbarButton($(".fr-adanaly-toolbar-font-underline"));
		self.toolbars.push(self.fontUnderlineButton);
		//Constants.LINE_NONE->0 Constants.LINE_THIN ->1
		self.fontUnderlineButton.on('click', function(e){
			var key = self._buildFirstSelectKey();
			if(!key){
				return;
			}
			var cellSetting = self.getCellSetting(key);
			if(!cellSetting || !cellSetting['underline'] || cellSetting['underline'] === '0') {
				self.fontUnderlineButton.setValue("1");
			} else {
				self.fontUnderlineButton.setValue("0");
			}
			self.setCellConfig({
				underline : self.fontUnderlineButton.getValue()
			})	
		});
		//Ĭֵ
		self.fontUnderlineButton.setValue('none');
		//ɾ
		self.fontDeletelineButton = new ToolbarButton($(".fr-adanaly-toolbar-font-deleteline"));
		self.toolbars.push(self.fontDeletelineButton);
		self.fontDeletelineButton.on('click', function(e){
			var key = self._buildFirstSelectKey();
			if(!key){
				return;
			}
			var cellSetting = self.getCellSetting(key);
			if(!cellSetting || !cellSetting['deleteline'] || cellSetting['deleteline'] === 'false') {
				self.fontDeletelineButton.setValue('true');
			} else {
				self.fontDeletelineButton.setValue('false');
			}
			self.setCellConfig({
				deleteline : self.fontDeletelineButton.getValue()
			})	
		});
		self.fontDeletelineButton.setValue('false');
		//
		self.fillButton = new ToolbarClickAndPopButton($(".fr-adanaly-toolbar-fill"),
														$(".fr-adanaly-toolbar-fill-pop"),
														$("#fr-adanaly-pop-fill"),
														$(".fr-adanaly-toolbar-fill-icon"));
		self.toolbars.push(self.fillButton);
		self.fillButton.on("click", function(e){
			self.setCellConfig({
				background : self.fillButton.getValue()
			})
		});
		//߿
		self.frameButton = new ToolbarClickAndPopButton($(".fr-adanaly-toolbar-frame"),
														$(".fr-adanaly-toolbar-frame-pop"),
														$("#fr-adanaly-pop-frame"),
														$(".fr-adanaly-toolbar-frame-icon"));
		self.toolbars.push(self.frameButton);
		self.frameButton.on("click", function(e){
			self.setCellConfig({
				border : self.frameButton.getValue()
			})
		});
		//뷽ʽ-ˮƽ
		self.alignButton = new ToolbarClickAndPopButton($(".fr-adanaly-toolbar-align"),
														$(".fr-adanaly-toolbar-align-pop"),
														$("#fr-adanaly-pop-align"),
														$(".fr-adanaly-toolbar-align-icon"));
		self.toolbars.push(self.alignButton);
		self.alignButton.on("click", function(e){
			self.setCellConfig({
				align : self.alignButton.getValue()
			})
		});
		//뷽ʽ-ˮƽ
		self.verticalAlignButton = new ToolbarClickAndPopButton($(".fr-adanaly-toolbar-align-vertical"),
														$(".fr-adanaly-toolbar-align-vertical-pop"),
														$("#fr-adanaly-pop-align-vertical"),
														$(".fr-adanaly-toolbar-align-vertical-icon"));
		self.toolbars.push(self.verticalAlignButton);
		self.verticalAlignButton.on("click", function(e){
			self.setCellConfig({
				'vertical-align' : self.verticalAlignButton.getValue()
			})
		});
		//styleɫ
		self.styleButton = new ToolbarPopButton($(".fr-adanaly-toolbar-style"), $("#fr-adanaly-pop-style"));
		self.toolbars.push(self.styleButton);
		//ݸʽ
		self.formatButton = new ToolbarButton($(".fr-adanaly-toolbar-format"));
		self.toolbars.push(self.formatButton);
		self.formatButton.on('click', function(e){
			self._showFormatDialog();
		});
		//
		self.conditionButton = new ToolbarButton($(".fr-adanaly-toolbar-condition"));
		self.toolbars.push(self.conditionButton);
		self.conditionButton.on('click', function(e){
			self._showConditionDialog();
		});
		//
		self.calculatorButton = new ToolbarButton($(".fr-adanaly-toolbar-calculator"));
		self.toolbars.push(self.calculatorButton);
		self.calculatorButton.on('click', function(e){
			self._showCalculatorDialog();
		});
		//ͼ
		self.chartButton = new ToolbarButton($(".fr-adanaly-toolbar-chart"));
		self.toolbars.push(self.chartButton);
		self.chartButton.on('click', function(e){
			var loading = {
					overlay_immediately : true,
					text : "..."
				};
			FR.showLoadingDialog(loading);
			self._showChartDialog();
			FR.hideLoadingDialog();
		});
		self.chartImages = [];
		//ҳ
		self.pageSetButton = new ToolbarButton($(".fr-adanaly-toolbar-pageset"));
		self.toolbars.push(self.pageSetButton);
		self.pageSetButton.setEnabled(false);
		self.pageSetButton.on('click', function(e){
			self._showPageSetDialog();
		});
		//ӡԤ
		self.printPreviewButton = new ToolbarButton($(".fr-adanaly-toolbar-print-preview"));
		self.toolbars.push(self.printPreviewButton);
		self.printPreviewButton.setEnabled(false);
		self.printPreviewButton.on('click', function(e){
			self._showPrintPreviewDialog();
		})
		//ӡ
		self.printButton = new ToolbarPopButton($(".fr-adanaly-toolbar-print"), $("#fr-adanaly-pop-print"));
		self.toolbars.push(self.printButton);
		self.printButton.setEnabled(false);
		//ʼ
		self.emailButton = new ToolbarButton($(".fr-adanaly-toolbar-email"));
		self.toolbars.push(self.emailButton);
		self.emailButton.setEnabled(false);
		self.emailButton.on('click', function(e){
			self._showEmailDialog();
		})
		$.each(self.toolbars, function(idx, items){
			self._toolbarButtonHover(items);	
		});
		self._initPopup();
	},
	
	_initPopup : function(){
		//save:
		this._initSavePop();
		this._initExportPop();
		this._initFontFamilyPop();
		this._initFontSizePop();
		this._initFontColorPop();
		this._initFillPop();
		this._initFramePop();
		this._initAlignPop();
		this._initVerticalAlignPop();
		this._initStylePop();
		this._initPrintPop();
	},
	
	_initSavePop : function(){
		var self = this;
		var saveAs = $('<li class="fr-adanaly-pop-saveas fr-adanaly-pop-li">Ϊ...</li>');
		saveAs.unbind('click').bind('click', function(e){
			self.saveButton.pop_hide(e);
			self._showSaveAsDialog();
		});
		var saveSnap= $('<li class="fr-adanaly-pop-snapshot fr-adanaly-pop-li">ݿ(snapshot)...</li>')
		saveSnap.unbind('click').bind('click', function(e){
			self.saveButton.pop_hide(e);
			self._showSaveSnapDialog();
		});
		self._eachPopMenu([saveAs, saveSnap], $('ul.fr-adanaly-pop-save-list'));
	},
	
	_initExportPop : function(){
		var self = this;
		var export_pdf = $('<li class="fr-adanaly-pop-export-pdf fr-adanaly-pop-li">PDF</li>');
		export_pdf.unbind('click').bind('click', function(e){
			self.exportReportToPDF('ori');
			self.exportButton.pop_hide(e);
		});
		var export_excel_page = $('<li class="fr-adanaly-pop-export-excel fr-adanaly-pop-li">Excel(ҳ)</li>');
		export_excel_page.unbind('click').bind('click', function(e){
			self.exportReportToExcel('page');
			self.exportButton.pop_hide(e);
		});
		var export_excel_simple = $('<li class="fr-adanaly-pop-export-excel fr-adanaly-pop-li">Excel(ԭ)</li>');
		export_excel_simple.unbind('click').bind('click', function(e){
			self.exportReportToExcel('simple');
			self.exportButton.pop_hide(e);
		});
		var export_word = $('<li class="fr-adanaly-pop-export-word fr-adanaly-pop-li">Word</li>');
		export_word.unbind('click').bind('click', function(e){
			self.exportReportToWord();
			self.exportButton.pop_hide(e);
		});
		self._eachPopMenu([export_pdf, export_excel_page, export_excel_simple, export_word], $('ul.fr-adanaly-pop-export-list'));
	},
	
	_eachPopMenu : function(menuArray, content){
		$.each(menuArray, function(idx, item){
			item.appendTo(content);
			item.hover(
			function(){
				$(this).addClass("fr-adanaly-pop-selected");
			}, 
			function(){
				$(this).removeClass("fr-adanaly-pop-selected");
			}
			);
		});
	},
	
	_initFontFamilyPop : function(){
		var self = this;
		var font_familylist = [];
		self.font_familys = [
			{fn : 'Arial', sfn : 'Arial', cls : 'fnar'}, 
			{fn : 'Courier New', sfn : 'Courier New', cls : 'fncn'},
			{fn : 'Comic Sans MS', sfn : 'Comic Sans MS', cls : 'fncs'},
			{fn : 'Georgia', sfn : 'Georgia', cls : 'fnga'},
			{fn : 'Garamond', sfn : 'Garamond', cls : 'fngd'},
			{fn : 'Lucida Console', sfn : 'Lucida Console', cls : 'fnlc'},
			{fn : 'MS Sans Serif', sfn : 'MS Sans Serif', cls : 'fnms'},
			{fn : 'Times New Roman', sfn : 'Times New Roman', cls : 'fntn'},
			{fn : 'Tahoma', sfn : 'Tahoma', cls : 'fnta'},
			{fn : 'Verdana', sfn : 'Verdana', cls : 'fnva'},
			{fn : 'SimHei', sfn : '', cls : 'fnsh'},
			{fn : 'Microsoft YaHei', sfn : '΢ź', cls : 'fnyh'},
			{fn : 'SimSun', sfn : '', cls : 'fnss'},
			{fn : 'KaiTi', sfn : '', cls : 'fnkt'}
			];
		$.each(self.font_familys, function(idx, item) {
		 	var li = $('<li class="fr-adanaly-pop-li ' + item.cls + '">' + item.sfn + '</li>');
			font_familylist.push(li);
			li.mousedown(function(e){
				self.fontFamilyComp.setValue(item.sfn);
				self.fontFamilyComp.pop_hide(e);
				self.setCellConfig({
					fontFamily : item.fn
				})
			});
		});	
		self._eachPopMenu(font_familylist, $('.fr-adanaly-pop-fontfamily-list'));
		//Ĭֵ
		self.fontFamilyComp.setValue(self.font_familys[12].sfn);
		
	},
	
	_initFontSizePop : function(){
		var self = this;
		self.font_sizes = [8,9,10,11,12,13,14,16,18,20,24,26];
		var font_sizeList = [];
		$.each(self.font_sizes, function(idx, item){
			var li = $('<li class="fr-adanaly-pop-li">' + item + '</li>');
			font_sizeList.push(li);
			li.mousedown(function(e){
				self.fontSizeComp.setValue(item);
				self.fontSizeComp.pop_hide(e);
				self.setCellConfig({
					fontSize : item
				})
			});
		});
		self._eachPopMenu(font_sizeList, $('.fr-adanaly-pop-font-size-list'));
		self.fontSizeComp.setValue(self.font_sizes[4]);
	},
	
	_initFontColorPop : function(){
		var self = this
		var colorbox = $('#fr-adanaly-pop-font-color:eq(0)');
		var colorinput = $('#fr-adanaly-color-input:eq(0)');
		self.fontColorButton.colorinput = colorinput;
		var colorpicker = $('#fr-adanaly-pop-colorpicker:eq(0)', colorbox).farbtastic(colorinput);
		colorpicker = colorpicker.data('fb');
		var colorbutton = $('#fr-adanaly-color-button:eq(0)', colorbox);
		colorbutton.click(function(e){
			if(colorinput.val() === "")
				colorinput.val('#3860e5');
			//self.setFontColor();
			self.fontColorButton.setValue(colorinput.val());
			self.fontColorButton.pop_hide(e);
			self.setCellConfig({
				fontColor : colorinput.val()
			})
		});
		self.fontColorButton.setValue(colorinput.val());
	},
	
	_initFillPop : function(){
		var self = this;
		var colorbox = $('#fr-adanaly-pop-fill:eq(0)');
		var colorinput = $('#fr-adanaly-fill-input:eq(0)');
		self.fillButton.colorinput = colorinput;
		var colorpicker = $('#fr-adanaly-pop-fillpicker:eq(0)', colorbox).farbtastic(colorinput);
		colorpicker = colorpicker.data('fb');
		var colorbutton = $('#fr-adanaly-fill-button:eq(0)', colorbox);

		colorbutton.click(function(e){
			if(colorinput.val() === "")
				colorinput.val('#3860e5');
			self.fillButton.setValue(colorinput.val());
			self.setCellConfig({
				background : colorinput.val()
			})
			self.fillButton.pop_hide(e);
		});
		self.fillButton.setValue(colorinput.val());
	},
	
	_initFramePop : function(){
		var self = this;
		self.borderValueGroup = [
			{position:"0px 0px", value:"top,right,bottom,left"},
			{position:"-15px 0px", value:"none"},
			{position:"-30px 0px", value:"center"},
			{position:"-45px 0px", value:"top,right,bottom,left,center"},
			{position:"0px -15px", value:"top"},
			{position:"-15px -15px", value:"bottom"},
			{position:"-30px -15px", value:"left"},
			{position:"-45px -15px", value:"right"}
		];
		$.each(self.borderValueGroup, function(idx, item){
			var button = $('<td><div class="fr-adanaly-toolbar-frame-icon" id=' + idx + ' style="background-position:' + self.borderValueGroup[idx].position + '"></div></td>');
			if(idx < 4) {
				button.appendTo($("#fr-adanaly-pop-frame-first"));
			} else {
				button.appendTo($("#fr-adanaly-pop-frame-second"));
			}
			button.hover(
				function(){
					$(this).addClass("fr-adanaly-pop-selected");
				}, 
				function(){
					$(this).removeClass("fr-adanaly-pop-selected");
				}
			);
			button.mousedown(function(e){
				self.frameButton.setValue(self.borderValueGroup[idx]);
				self.setCellConfig({
					border : self.borderValueGroup[idx].value
				})
				self.frameButton.pop_hide(e);
			});
		});	
		//Ĭֵ
		self.frameButton.setValue(self.borderValueGroup[0]);
	},
	
	_initAlignPop : function(){
		var self = this;
		self.alignValueGroup = [
			{position:"0px 0px", value:"left"},
			{position:"-15px 0px", value:"center"},
			{position:"-30px 0px", value:"right"}
		];
		var group = [];
		$.each(self.alignValueGroup, function(idx, item){
			var button = $('<td><div class="fr-adanaly-toolbar-align-icon" id=' + idx+ ' style="background-position:'+self.alignValueGroup[idx].position+';"></div></td>');
			group.push(button);
			button.mousedown(function(e){
				self.alignButton.setValue(self.alignValueGroup[idx]);
				self.setCellConfig({
					align : self.alignValueGroup[idx].value
				})
				self.alignButton.pop_hide(e);
			});
		});	
		self._eachPopMenu(group, $("#fr-adanaly-pop-align-first"));
		//Ĭֵ
		self.alignButton.setValue(self.alignValueGroup[0]);
	},
	
	_initVerticalAlignPop : function(){
		var self = this;
		self.verticalAlignValueGroup = [
			{position:"0px -15px", value:"top"},
			{position:"-15px -15px", value:"middle"},
			{position:"-30px -15px", value:"bottom"}
		];
		var group = []
		$.each(self.verticalAlignValueGroup, function(idx, item){
			var button = $('<td><div class="fr-adanaly-toolbar-align-icon" id=' + idx+ ' style="background-position:'+self.verticalAlignValueGroup[idx].position+';"></div></td>');
			group.push(button);
			button.mousedown(function(e){
				self.verticalAlignButton.setValue(self.verticalAlignValueGroup[idx]);
				self.setCellConfig({
					'vertical-align' : self.verticalAlignValueGroup[idx].value
				})
				self.verticalAlignButton.pop_hide(e);
			});
		});	
		self._eachPopMenu(group, $("#fr-adanaly-pop-align-vertical-first"));
		//Ĭֵ
		self.verticalAlignButton.setValue(self.verticalAlignValueGroup[1]);
	},
	
	_initStylePop : function(){
		var self = this;
		//ҪstyleֻҪstyleͿ
		self.styleGroup = [
			{border:"#959595",title:"#787B7A", titleBorder:"#636363", background:"#FFFFFF", text:"ɫͷ"},
			{border:"#959595",title:"#4C4E4E", titleBorder:"#636363", background:"#DDDDDD", text:"ɫ"},
			{border:"#EEE1BE",title:"#D3C296", titleBorder:"#B0A27C", background:"#FFFFFF", text:"׻ɫ"},
			{border:"#ACCCB1",title:"#66906D", titleBorder:"#556858", background:"#FFFFFF", text:"ɫ"},
			{border:"#C2DDF3",title:"#709BBF", titleBorder:"#657F95", background:"#FFFFFF", text:"ɫͷ"},
			{border:"#C2DDF3",title:"#709BBF", titleBorder:"#657F95", background:"#DAE9F5", text:"ɫ"}
		];
		var group = [];
		$.each(self.styleGroup, function(idx, item){
			var icon = $('<table cellpadding="0" cellspacing="0" border="0" style="border-spacing:0;font-size:1px;">' +
					'<colgroup><col style="width:10px;"><col style="width:22px;"></colgroup>' +
					'<tbody><tr style="height:5px;margin:0px;">' +
					'<td style="height:5px;margin:0px;"><div style="height: 5px;background: '+ item.title +';border-width: 1px 1px 1px 1px;border-style: solid;border-color:' + item.titleBorder + ';"></div></td>' +
					'<td style="height:5px;margin:0px;"><div style="height: 5px;background: ' + item.title + ';border-width: 1px 1px 1px 0px;border-style: solid;border-color:' + item.titleBorder + ';"></div></td>' +
					'</tr><tr style="height:10px;margin:0px;"><td style="height:10px;margin:0px;"><div style="height:10px;background: ' + item.title + ';border-width: 0px 1px 1px 1px;border-style: solid;border-color:' + item.titleBorder + ';"></div></td>' +
					'<td style="height:10px;margin:0px;"><div style="height:10px;background: ' + item.background + ';border-width: 0px 1px 1px 0px;border-style: solid;border-color:' + item.border + ';"></div></td></tr>' +
					'</tbody></table>')
			var li = $('<li class="fr-adanaly-pop-li"></li>');
			var table = $('<table></table>');
			var td = $('<td></td>');
			var tr = $('<tr></tr>');
			icon.appendTo(td);
			td.appendTo(tr);
			tr.appendTo(table);
			$('<td><div>'+ item.text +'<div></td>').appendTo(tr);
			li.val(item.text);
			table.appendTo(li);
			group.push(li);
			li.mousedown(function(e){
				self.styleButton.pop_hide(e);
				self.styleButton.setValue(idx);
				self.clearFill();
				self.viewReport();
			});
		});
		self._eachPopMenu(group, $('ul.fr-adanaly-pop-style-list'));
		//Ĭֵ
		self.styleButton.setValue(4);
	},
	
	_initPrintPop : function () {
		var self = this;
		var pdfPrint = $('<li class="fr-adanaly-pop-print-pdf fr-adanaly-pop-li">ӡ[ͻ]</li>');
		pdfPrint.unbind('click').bind('click', function(e){
			self._doPdfPrint();
			self.printButton.pop_hide(e);
		});
		var appletPrint = $('<li class="fr-adanaly-pop-print-applet fr-adanaly-pop-li">applet[ӡ]</li>');
		appletPrint.unbind('click').bind('click', function(e){
			self._doAppletPrint();
			self.printButton.pop_hide(e);
		});
		var flashPrint = $('<li class="fr-adanaly-pop-print-flash fr-adanaly-pop-li">ӡ[ͻ]</li>');
		flashPrint.unbind('click').bind('click', function(e){
			self._doFlashPrint();
			self.printButton.pop_hide(e);
		});
		self._eachPopMenu([pdfPrint, appletPrint, flashPrint], $('ul.fr-adanaly-pop-print-list'))
	},
	
	_doPdfPrint : function () {
		var self = this;
		if(self.getFramePage().fireEvent(FR.Events.BPDFPRINT) === false) {
    		return;
    	}
        if ($.browser.msie) {
            FR.doPDFPrint(self.getFrameSessionID(), true);
        } else {
        	// jamespdfPrintҪformat=pdfPrintʶΪǴӡ״̬
        	window.location = FR.servletURL + "?op=export&sessionID=" + self.getFrameSessionID() + "&format=pdf&isPDFPrint=true&extype=ori";
        	self.getFramePage().fireEvent(FR.Events.APDFPRINT);
	    }
	},
	
	_doAppletPrint : function () {
		var self = this;
		if(self.getFramePage().fireEvent("beforeappletprint") === false) {
            return;
        }
		FR.doURLAppletPrint(FR.servletURL + "?sessionID=" + self.getFrameSessionID());
	},
	
	_doFlashPrint : function () {
		var self = this;
		if(self.getFramePage().fireEvent("beforeflashprint") === false) {
    		return;
    	}
		FR.doPrintURL(FR.servletURL + "?sessionID=" + self.getFrameSessionID(), 0);
	},
	
	_showPageSetDialog : function () {
		var self = this;
		FR.showIframeDialog({
	  		title : FR.i18nText("PageSetup-Page_Setup"),
    		width : 540,
    		height : 415,
    		url : FR.servletURL + "?op=fr_dialog&cmd=page_setup_dialog&sessionID=" + self.getFrameSessionID() + "&reportIndex=" + 0
	  	});	
	},
	
	
	_showPrintPreviewDialog : function () {
		var self = this
		window.open(FR.servletURL + "?op=print_preview&cmd=pw_init_page&__pi__=false&__singlesheet__=true&reportIndex=" + 0 + "&sessionID=" + self.getFrameSessionID() ,"_blank", "Scrollbar=yes,Resizable=yes,fullscreean=yes");
	},
	
	_showEmailDialog : function (){
		var self = this;
		if (self.getFramePage().fireEvent(FR.Events.BEMAIL) === false) {
    		return;
    	}
		FR.showIframeDialog({
	  		title : FR.i18nText("Email"),
    		width : 400,
    		height : 400,
    		url : FR.servletURL + "?op=fr_dialog&cmd=write_email_dialog&sessionID=" + self.getFrameSessionID()
	  	});
	  	self.getFramePage().fireEvent(FR.Events.AEMAIL); 
	},
		
	_showSaveAsDialog : function () {
		var self = this;
		self._showAdanalySaveDialog('Ϊ', function(name){
			var data = {
				type : 1,
				reportName : name,
				reportConfig : self.getReportInfo()
			}
			self.saveReport(data);
		});
	},
	
	_showSaveSnapDialog : function () {
		var self = this;
		self._showAdanalySaveDialog('ݿ', function(name){
			var data = {
				type : 0,
				sessionID : self.getFrameSessionID(),
				reportName : name
			}
			self.saveReport(data);
		});
	},
	
	saveReport : function (data) {
		//reportNameȡ ᱣΪ(ֻǼʱʾ)
		var reportName = data.reportName;
		var id = FS.Trans.saveADHOCReport(data);
		if (id != -1) {
			alert("ɹ");
			if (parent.FS.favoriteList) {
				parent.FS.favoriteList.addSimpleData({
					entry : {
						id : id,
						url : "?op=fs_main&cmd=adhoc_report&id=" + id
					},
					type:"adhoc",
					text : reportName,
					titleText : parent.FS.getShowText(reportName, 90, 13, "Verdana,Arial,sans-serif"),
					icon : data.type == 0 ? "fr-adanaly-pop-snapshot" : "fr-adanaly-pop-saveas"
				});
			}
		} else {
			alert("ʧ");
		}
	},
	
	_showAdanalySaveDialog : function(title, fn) {
		var self = this;
		var content = $('<div style="padding-left:10px;padding-top:4px;"><table><tr>' +
				'<td><div>Ϊñ</div></td>' +
				'<td><div class="fr-adanaly-report-name"></div></td>' +
				'</tr></table></div>' +
				'<div style="padding-left:12px;padding-top:4px;">ϵͳղؼҵı</div>');	
		var box = $('.fr-adanaly-report-name', content);
		self.reportNameInput = $('<input/>').appendTo(box);
		var config = {
            confirm : true,
			title : title,
			width : 350,
			height : 128,
			contentHtml : content,
			onOK : function(e) {
				if(!self.reportNameInput.val() || self.reportNameInput.val() == '') 
					return false;
				else {
					var save = fn.call(this, self.reportNameInput.val());
					
					return true;
				}
			}
		}
		self.showAdanalySaveDialog(config);
		self.reportNameInput.focus();
	},
	
	_showFormatDialog : function() {
		var self = this;
		var keys = self._buildKey();
		if(!keys){
			return;
		}
		var content = $('<div style="width:440px;height:380px;padding-left:4px"></div>');
		var center = $('<div></div>');
		var list = $('<div></div>');
		var left = $('<div></div>');
		var preview =  $('<div></div>');
		var itemsReg = FS.Trans.getFormatRegList();
		var radioItem = [];
		var listItem = [];
		$.each(itemsReg, function(idx, item){
			radioItem.push({text:item.key, value:item.contents});
			var tempItem = [];
			$.each(item.value, function(i, value){
				tempItem.push({text:value});
			});
			listItem.push({id:item.contents, value:tempItem});
		})
		self.valueList =new FS.List({
			items : [],
			width : 350,
			height : 350,
			renderEl : list
		});
		self.valueList.on(FR.Events.CLICK, function(){
			self.formatInput.setValue(this.getSelectedData().text);
		});

		var inputField = $('<div/>');
		self.formatInput = new FR.TextEditor({
			renderEl : inputField,
			width:340
		});
		var fn = function (e){
			setTimeout( function(){
				var text = FS.Trans.getFormatPre(self.formatGroup.getValue(), self.formatInput.getValue());
				previewField.html(text);
			}, 50);
		};
		self.formatInput.on(FR.Events.AFTEREDIT, fn);
		self.formatInput.on(FR.Events.CHANGE, fn);

		var previewField = $('<div style="height:30px;width:440px;line-height:30px;text-align:center;"></div>');
		previewField.html('12345.6789');
		previewField.appendTo(preview);
		center.asComponent({type:'border', items:[
			{region:"north", el:inputField, height:24},
			{region:"center", el:list}
		]});
		self.formatGroup = new FR.RadioGroup({
			width : 60,
			height : 300,
			adaptive : false,
			columnsInRow : 1,
			renderEl : left,
			items : radioItem
		});
		var tempSelected;
		self.formatGroup.on(FR.Events.STATECHANGE, function(){
			var value = this.getValue();
			if(value != "" || value === 0)
				tempSelected = value;
			else {
				if(tempSelected || tempSelected === 0)
					this.setValue(tempSelected);
			}
			var item = listItem[id = value];
			if(item) {
				self.valueList.popData(item.value);
				if(item.value[0]) {
					self.formatInput.enable();
					self.valueList.setSelectedIndex(0);
				} else {
					self.formatInput.setValue("");
					self.formatInput.disable();
				}
			}
		});
		self.formatGroup.setValue(0);
		var formatContent = [];
		formatContent.push({region:"west", el:left, width:100});
		formatContent.push({region:"north", el:preview, height:30});
		formatContent.push({region:"center", el:center});
		var config = {
            confirm : true,
			title : 'ݸʽ',
			width : 450,
			height : 450,
            contentHtml : content,
			onOK : function() {
				self.setCellConfig({
					format : {
						type : self.formatGroup.getValue(),
						value : self.formatInput.getValue()
					}
				})
				return true;
			}
		};
		self.showAdanalyFormatDialog(config);
		content.asComponent({type:'border', items:formatContent});
		//ֻһ
		if (keys.length > 0) {
			var key = keys[0];
			var cellSetting = self.getCellSetting(key);
			if (cellSetting != null && cellSetting['format'] != null) {
				var format = cellSetting['format'];
				if (format.type || format.type === 0) self.formatGroup.setValue(format.type);
				if (format.value || format.value === 0) self.formatInput.setValue(format.value);
			}
		}
		center.doLayout();
		content.doLayout();
	},
	
	
	_showConditionDialog : function () {
		var self = this;
		var keys = this.$currentTDCell
		if(!keys){
			return;
		}
		var content = $('<div style="height:280px;width:515px;"></div>');
		var north =  $('<div style="overflow:hidden;padding-left:4px;padding-right:4px;padding-top:10px;"></div>');
		var center = $('<div style="padding-left:4px;padding-right:4px;"></div>');
		
		content.asComponent({type:'border', items:[
			{region:"north", el:north, height:150},
			{region:"center", el:center}
		]});
		var selectValue = '';
		$.each(keys, function(idx, item){
			selectValue += item;
			if (idx != keys.length -1) {
				selectValue +=',';
			}
		})
		var table = $('<table><tr><td class="fr-adanaly-condition-listname">ǰѡеֵ:</td><td class="fr-adanaly-condition-listvalue"><div ' +
				'title="'+ selectValue+'" style="padding-left:2px;overflow:hidden;width:326px;height:20px;">'+ selectValue +'</div></td></tr>' +
				'<tr><td class="fr-adanaly-condition-listname">:</td>' +
				'<td class="fr-adanaly-condition-listvalue">' +
				'<div style="float:left;padding-left:2px;">'+'ֵ' +'&nbsp;&nbsp;</div>' +
				'<div style="float:left;padding-left:2px;" class="fr-adanaly-condition-operation"></div>' +
				'<div style="float:left;padding-left:2px;" class="fr-adanaly-condition-type"></div>' +
				'<div style="float:left;padding-left:2px;" class="fr-adanaly-condition-value"></div></td></tr>' +
				'<tr><td class="fr-adanaly-condition-listname"><div style="background:white;width: 42px;left: 72px;position: absolute;text-align: center;">ʽ:</div></td>' +
				'<td class="fr-adanaly-condition-listvalue">' +
				'<table><tr><td colspan="2"><div style="background: white;width: 132px;"><div class="fr-adanaly-condition-style-combo"></div></div></td></tr>' +
				'<tr style="position: absolute;left: 65px;top: 92px;"><td class="fr-adanaly-condition-listvalue fr-adanaly-condition-listvalue-name" >:</td>' +
				'<td><div style="float:left;padding-left:2px;" class="fr-adanaly-condition-font-family"></div>' +
				'<div style="float:left;padding-left:2px;" class="fr-adanaly-condition-font-size"></div>' +
				'<div style="float:left;padding-left:2px;" class="fr-adanaly-condition-font-style"></div>' +
				'<div style="float:left;padding-left:2px;" class="fr-adanaly-condition-font-line"></div>' +
				'<div style="float:left;padding-left:2px;"><div class="fr-adanaly-condition-font-color" style="border:1px solid #aabbbb;">' +
				'<table cellpadding="0" cellspacing="0" border="0" style="border-spacing:0;">' +
				'<tr><td><div class="fr-adanaly-toolbaritem fr-adanaly-condition-font-color-value" title="ɫ"></td>' +
				'<td><div class="fr-adanaly-condition-fontcolor-pop">' +
				'<div class="fr-adanaly-toolbar-pop-icon" title="ɫ"></div></div></td></div></tr></table></div></div></td></tr>' +
				'<tr  style="position: absolute;left: 65px;top: 116px;"><td class="fr-adanaly-condition-listvalue fr-adanaly-condition-listvalue-name">ɫ:</td>' +
				'<td><div style="padding-left:2px;"><div class="fr-adanaly-condition-fill" style="border:1px solid #aabbbb;width:27px;">' +
				'<table cellpadding="0" cellspacing="0" border="0" style="border-spacing:0;">' +
				'<tr><td><div class="fr-adanaly-toolbaritem fr-adanaly-condition-fill-value" title="ɫ"></td>' +
				'<td><div class="fr-adanaly-condition-fill-pop">' +
				'<div class="fr-adanaly-toolbar-pop-icon" title="ɫ"></div></div></td></div></tr></table></div></div></td></tr></table></td></tr></table>');
		table.appendTo(north);
		$('<div style="height: 68px;width: 375px;border: 1px solid;position: absolute;top: 76px;z-index: -999;left: 60px;"></div>').appendTo(north);
		var popbox = $('<div class="fr-adanaly-condition-popbox">' +
				'<div id="fr-adanaly-pop-condition-font-color" class="fr-adanaly-pop-view" style="display:none">' +
				'<div id="fr-adanaly-pop-condition-colorpicker"></div>' +
				'<div class="fr-adanaly-condition-color-input-box">' +
				'<input type="text" id="fr-adanaly-condition-color-input" value="#000000"/>' +
				'<input type="button" id="fr-adanaly-condition-color-button" value="'+FR.i18nText("OK") +'"/></div></div>' +
				'<div id="fr-adanaly-pop-condition-fill" class="fr-adanaly-pop-view" style="display:none">' +
				'<div id="fr-adanaly-pop-condition-fillpicker"></div>' +
				'<div class="fr-adanaly-condition-fill-input-box">' +
				'<input type="text" id="fr-adanaly-condition-fill-input" value="#FFFFFF"/>' +
				'<input type="button" id="fr-adanaly-condition-fill-button" value="'+FR.i18nText("OK") +'"/></div></div></div>');
		var operationCombo = new FR.ComboBoxEditor({
			renderEl : $('.fr-adanaly-condition-operation', table),
			height:20,
			width :100,
			directEdit : false,
			allowBlank : false,
			items:self.filterFace.opData()
		});
		operationCombo.setValue(0);
		var typeCombo = new FR.ComboBoxEditor({
			renderEl : $('.fr-adanaly-condition-type', table),
			height:20,
			width :100,
			directEdit : false,
			allowBlank : false,
			items:self.filterFace.typeData()
		});
		var valueArea = $('.fr-adanaly-condition-value', table);
		var valueCombo;
		var typeComboFn = function(){
			valueArea.empty();
			var value = this.getValue();
			if (value === 'string') {
				valueCombo = new FR.TextEditor({
					renderEl : valueArea,
					height:20,
					width :100
				});
			} else if (value === 'date') {
				valueCombo = new FR.DateTimeEditor({
					renderEl : valueArea,
					height:20,
					width :100
				});
			} else if (value === 'number') {
				valueCombo = new FR.NumberEditor({
					renderEl : valueArea,
					height:20,
					width :100
				});
			}
		};
		typeCombo.on(FR.Events.AFTEREDIT, typeComboFn);
		typeCombo.on(FR.Events.CHANGE, typeComboFn);
		typeCombo.setValue('string');
		var itemTypes = self._getCellTypes();
		var styleCombo = new FR.ComboBoxEditor({
			renderEl:$('.fr-adanaly-condition-style-combo', table),
			height:20,
			width:125,
			allowBlank:false,
			items:itemTypes
		});
		var styleItems = $('.fr-combo-list-item', styleCombo.$view);
		$.each(styleItems, function(idx, item){
			var itemSelf = $(this);
			var styles = itemTypes[idx].style;
			if (styles.background) {
				itemSelf.css('border-color', styles.background);
			}
			itemSelf.css(styles)
		});
		var popValues = function(value){
			operationCombo.setValue(value.op);
			typeCombo.setValue(value.type);
			valueCombo.setValue(value.value)
		};
		var popStyles = function(styles){
			$.each(styles, function(index, style){
				if(index === 'font-size')
					style+='px';
				styleCombo.editComp.css(index, style);
			});
			if(styles['background']) {
				self.conditionFillButton.setValue(styles['background']);
			} else {
				self.conditionFillButton.setValue('#FFFFFF');
			}
			if(styles['font-size']){
				conditionFontSizeCombo.setValue(styles['font-size']);
			} else {
				conditionFontSizeCombo.setValue(self.font_sizes[4]);
			}
			if(styles['font-family']){
				conditionFontFamilyCombo.setValue(styles['font-family']);
			} else {
				conditionFontFamilyCombo.setValue(self.font_familys[12].fn);
			}
			if(styles['color']){
				self.conditionFontColorButton.setValue(styles['color']);
			} else {
				self.conditionFontColorButton.setValue('#000000');
			}
			conditionFontStyleCombo.setValue(self._getFontStyleValue(styles['font-weight'], styles['font-style']));
			fontLineCombo.setValue(self._getFontLineStyleValue(styles['text-decoration']));
		}
		
		styleCombo.on(FR.Events.AFTEREDIT, function(){
			var index = this.getValue();
			var styles = itemTypes[index].style;
			popStyles(styles)
		});
		var fontItems = [];
		 $.each(self.font_familys, function(idx, item){
		 	fontItems.push({text:item.sfn, value:item.fn, cls:item.cls})
		 });
		
		var conditionFontFamilyCombo = new FR.ComboBoxEditor({
			renderEl : $('.fr-adanaly-condition-font-family', table),
			height:20,
			width:80,
			items : fontItems,
			popupWidth:120,
			allowBlank:false,
			maxCount:fontItems.length
		});
		
		$.each($('.fr-combo-list-item', conditionFontFamilyCombo.$view), function(idx, item){
			$(this).css('font-family', fontItems[idx].value);
		});
		conditionFontFamilyCombo.setValue(self.font_familys[12].fn)
		var fontSetFn = function(){
			styleCombo.editComp.css('font-family', this.getValue());
		};
		conditionFontFamilyCombo.on(FR.Events.AFTEREDIT, fontSetFn);
		conditionFontFamilyCombo.on(FR.Events.CHANGE, fontSetFn);
		var fontSizes = [];
		$.each(self.font_sizes, function(idx, item){
			fontSizes.push({text:item, value:item});
		})
		var conditionFontSizeCombo = new FR.ComboBoxEditor({
			renderEl:$('.fr-adanaly-condition-font-size', table),
			height:20,
			width:40,
			allowBlank:false,
			items : fontSizes
		});
		conditionFontSizeCombo.setValue(self.font_sizes[4]);
		var fontSizeSetFn = function(){
			var value = this.getValue();
			styleCombo.editComp.css('font-size', value+'px');
		};
		conditionFontSizeCombo.on(FR.Events.AFTEREDIT, fontSizeSetFn);
		conditionFontSizeCombo.on(FR.Events.CHANGE, fontSizeSetFn);
		var fontStyles = self._getFontStyles();
		var conditionFontStyleCombo = new FR.ComboBoxEditor({
			renderEl:$('.fr-adanaly-condition-font-style', table),
			height:20,
			width:80,
			allowBlank:false,
			items : fontStyles
		}); 
		
		$.each($('.fr-combo-list-item', conditionFontStyleCombo.$view), function(idx, item){
			var selfItem = $(this)
			$.each(fontStyles[idx].style, function(index, style){
				selfItem.css(index, style);
			});
		});
		conditionFontStyleCombo.setValue(0);
		var fontStyleSetFn = function(){
			var item = self._getStyleItem(self._getFontStyles(), this.getValue());
			if(item) {
				styleCombo.editComp.css(item.style);
			}
		}
		conditionFontStyleCombo.on(FR.Events.AFTEREDIT, fontStyleSetFn);
		conditionFontStyleCombo.on(FR.Events.CHANGE, fontStyleSetFn);
		var fontLineStyles = self._getFontLineStyles()
		var fontLineCombo = new FR.ComboBoxEditor({
			renderEl:$('.fr-adanaly-condition-font-line', table),
			height:20,
			width:80,
			allowBlank:false,
			items :fontLineStyles
		});
		$.each($('.fr-combo-list-item', fontLineCombo.$view), function(idx, item){
			$(this).css(fontLineStyles[idx].style);
		});	
		fontLineCombo.setValue(0);
		var fontLineSetFn = function(){
			var item = self._getStyleItem(self._getFontLineStyles(), this.getValue());
			if(item){
				styleCombo.editComp.css(item.style);
			}
		}
		fontLineCombo.on(FR.Events.AFTEREDIT, fontLineSetFn);
		fontLineCombo.on(FR.Events.CHANGE, fontLineSetFn);
		self.conditionFontColorButton =  new ToolbarPopButton($(".fr-adanaly-condition-font-color", table)
		, $("#fr-adanaly-pop-condition-font-color", popbox));
		self._initConditionFontColorPop(table, popbox);
		self.conditionFontColorButton.on('change', function(){
			styleCombo.editComp.css('color', self.conditionFontColorButton.getValue());
		});
		self.conditionFillButton =  new ToolbarPopButton($(".fr-adanaly-condition-fill", table)
		, $("#fr-adanaly-pop-condition-fill", popbox));
		self._initConditionFillPop(table, popbox);
		self.conditionFillButton.on('change', function(){
			styleCombo.editComp.css('background', self.conditionFillButton.getValue());
		});
		$.each([self.conditionFontColorButton, self.conditionFillButton], function(idx, items){
			self._toolbarButtonHover(items);
		});
		
		styleCombo.setValue(0);
		styleCombo.fireEvent(FR.Events.AFTEREDIT);
		
		conditionButton = $('<table style="height:100%;width:100%;border-top:1px solid;border-bottom:1px solid white;"><tr><td style="padding-left:188px;"><div  class="fr-adanaly-condition-add"></div><div class="fr-adanaly-condition-edit"></div></td></tr></table>');
		var addConditionButton = new FR.Button({
			renderEl : $('.fr-adanaly-condition-add', conditionButton),
			icon : '${servletURL}?op=resource&resource=/com/fr/web/images/adhoc/add.gif',
			height:30,
			width:120
		})
		var editConditionButton = new FR.Button({
			renderEl : $('.fr-adanaly-condition-edit', conditionButton),
			text : FR.i18nText("OK"),
			height:30,
			width:120
		})
		editConditionButton.setVisible(false);
		var generateShowText = function (value) {
			var text = '';
			text += value.item;
			text += self.getOPString(value.op)+'"';
			text += value.value;
			text +='"ʱ,ʽΪ&nbsp';
			return text;
		};
		
		var conditionListFn = function(){
			var flag = self.conditionList.getSelectedIndex() > -1;
			editConditionButton.setVisible(flag);
			addConditionButton.setVisible(!flag);
		};
		
		var conditionListClickFn = function() {
			conditionListFn();
			var value = self.conditionList.getValue();
			popValues(value);
			popStyles(value.style);
		};
		
		var conditionButtonfn  = function(){
			var value = {
				item : selectValue,
				op : operationCombo.getValue(), 
				type: typeCombo.getValue(), 
				value : valueCombo.getValue(),
				style : {'font-family':conditionFontFamilyCombo.getValue(),
				  		'font-size':conditionFontSizeCombo.getValue(),
				  		'color':self.conditionFontColorButton.getValue(),
				  		'background':self.conditionFillButton.getValue()
				}
			 };
			$.extend(value.style, (self._getStyleItem(self._getFontStyles(), conditionFontStyleCombo.getValue())).style);
			$.extend(value.style, (self._getStyleItem(self._getFontLineStyles(), fontLineCombo.getValue())).style);
			var data = {
			 	text : self._generateLi(generateShowText(value), value),
			 	value : value
			};
			var conditionItems = self.conditionList.getAll();
			var hasValue = false;
			$.each(conditionItems, function(idx, item){
			 	if(item.value.op === data.value.op
			 	&& item.value.type === data.value.type
			 	&& item.value.value === data.value.value) {
			 		hasValue = true;
			 		return false;
			 	}
			 	
			});
			var oldValue = self.conditionList.getValue();
			if(oldValue) {
				if(oldValue.op === data.value.op
			 	&& oldValue.type === data.value.type
			 	&& oldValue.value === data.value.value)
			 	hasValue =false;
			}
			if (!hasValue)
				editConditionButton.isVisible() ? self.conditionList.editItem(data) : self.conditionList.addSimpleData(data);
			else
				alert('Ѵ');
			self.conditionList.clearSelected();
			conditionListFn();
		};	
		addConditionButton.on(FR.Events.CLICK, conditionButtonfn);
		editConditionButton.on(FR.Events.CLICK, conditionButtonfn);
		var conditionListDiv = $('<div style="width:100%;height:100px;"></div>')
		self.conditionList = new FS.RemoveList({
			showAsHtml: true,
			items:[],
			height:100,
			draggable : true,
			axis : 'y',
			renderEl:conditionListDiv
		});
		self.conditionList.on(FR.Events.CLICK, conditionListClickFn);
		self.conditionList.on(FR.Events.REMOVEDATA, conditionListFn);
		center.asComponent({type:'border', items:[
			{region:"north", el:conditionButton, height:40},
			{region:"center", el:conditionListDiv}
		]});
			
		var config = {
            confirm : true,
			title : '',
			width : 520,
			height : 358,
			contentHTML : content,
			onOK : function(e) {
				var array = self.conditionList.getSortedAll();
				var conditionResult = [];
				//domԪҪ
				$.each(array, function(idx, item){
					conditionResult.push(item.value);
				})
				self.setCellConfig({
					condition : self.reBuildConditionCSS2Para(conditionResult)
				})
				return true;
			},
			popbox : popbox		
		};
		self.showAdanalyConditionDialog(config);
		content.doLayout();
		center.doLayout();
		var mainOffset = content.offset();
		var popOffset = (self.conditionFontColorButton.left.getItem()).offset();
		self.conditionFontColorButton.pop.css('left', popOffset.left - mainOffset.left - self.conditionFontColorButton.pop.width() + 27 + 'px' )
		.css('top', popOffset.top - mainOffset.top + 20 + "px");
		var popOffset = (self.conditionFillButton.left.getItem()).offset();
		self.conditionFillButton.pop.css('left', popOffset.left - mainOffset.left + 'px' )
		.css('top', popOffset.top - mainOffset.top + 20 + "px");
		//һ
		if (keys.length > 0) {
			var key = keys[0];
			var cellSetting = self.getCellSetting(key);
			if (cellSetting != null && cellSetting['condition'] != null) {
				var condition = cellSetting['condition'];
				condition = self.rebuildParaCondition2CSS(condition);
				var data = [];
				$.each(condition, function(idx, item){
					data.push({
						text : self._generateLi(generateShowText(item), item),
						value: item
					})
				});
				self.conditionList.popData(data);
			}
		}
	},
	
	rebuildParaCondition2CSS : function (result) {
		$.each(result, function(idx, item){
			var tempStyle = {};
			var decoration = "";
			$.each(item.style, function(key, value){
				if (key == 'fontFamily'){
					tempStyle['font-family'] = value;
				} else if (key == 'fontSize'){
					tempStyle['font-size'] = value;
				} else if (key == 'fontItalic'){
					if(value == '0'){
						value = 'normal';
					} else {
						value = 'italic'
					}
					tempStyle['font-style'] = value;
				} else if (key == 'fontWeight'){
					if (value == 0){
						value = 400;
					} else {
						value = 600;
					}
					tempStyle['font-weight'] = value;
				} else if (key == 'underline'){
					if (value != 0)  {
						decoration += ' underline';
					}
				} else if (key == 'deleteline'){
					if (value == true) {
						decoration += ' line-through';
					} 
				} else if (key == 'fontColor'){
					tempStyle['color'] = value;
				}else {
					tempStyle[key] = value;
				}
			})
			if (decoration == ""){
				decoration = "none";
			}
			tempStyle['text-decoration'] = decoration;
			item.style = tempStyle;
		})
		return result;
	},
	
	reBuildConditionCSS2Para : function (result) {
		$.each(result, function(idx, item){
			var tempStyle = {};
			$.each(item.style, function(key, value){
				if (key == 'font-family'){
					tempStyle['fontFamily'] = value;
				} else if (key == 'font-size'){
					tempStyle['fontSize'] = value;
				} else if (key == 'font-style'){
					if(value == 'normal'){
						value = '0';
					} else {
						value = '2'
					}
					tempStyle['fontItalic'] = value;
				} else if (key == 'font-weight'){
					if (value == 400){
						value = 0;
					} else {
						value = 1;
					}
					tempStyle['fontWeight'] = value;
				} else if (key == 'text-decoration'){
					if (value == 'none'){
						tempStyle['underline'] = 0;
						tempStyle['deleteline'] = 'false';
					} else {
						if (value.indexOf('line-through') > -1){
							tempStyle['deleteline'] = 'true';
						} else {
							tempStyle['deleteline'] = 'false';
						}
						if (value.indexOf('underline') > -1){
							tempStyle['underline'] = 1;
						} else {
							tempStyle['underline'] = 0;
						}
					}
				} else if (key == 'color'){
					tempStyle['fontColor'] = value;
				}else {
					tempStyle[key] = value;
				}
			})
			item.style = tempStyle;
		})
		return result;
	},
	
	_generateLi : function (text, value) {
		var listValue = $('<div><div style="float:left">' + text + '</div><div class="fr-adanaly-show">AaBbCc</div></div>');
		$.each(value.style, function(index, item){
			if(index === 'font-size')
				item += 'px';
			$('.fr-adanaly-show', listValue).css(index, item)
		})
		return listValue[0];
	},
	
	_getStyleItem : function (items, value){
		var item;
		$.each(items, function(idx, style){
			if(style.value === value) {
				item = style;
				return false;
			}
		});
		return item;
	},
	
	_initConditionFontColorPop : function(table, popbox){				
		var self = this;
		var colorbox = $('#fr-adanaly-pop-condition-font-color:eq(0)', popbox);
		var colorinput = $('#fr-adanaly-condition-color-input:eq(0)', popbox);
		self.conditionFontColorButton.colorinput = colorinput;
		var colorpicker = $('#fr-adanaly-pop-condition-colorpicker:eq(0)', colorbox).farbtastic(colorinput);
		colorpicker = colorpicker.data('fb');
		var colorbutton = $('#fr-adanaly-condition-color-button:eq(0)', colorbox);
		self.conditionFontColorButton.valueField = $('.fr-adanaly-condition-font-color-value', table);
		colorbutton.click(function(e){
			if(colorinput.val() === "")
				colorinput.val('#000000');
			//self.setFontColor();
			self.conditionFontColorButton.setValue(colorinput.val());
			self.conditionFontColorButton.pop_hide(e);
		});
		self.conditionFontColorButton.setValue(colorinput.val());
		$('.fr-adanaly-condition-font-color-value', table).css('background', colorinput.val())
	},
	
	_initConditionFillPop : function(table, popbox){				
		var self = this;
		var colorbox = $('#fr-adanaly-pop-condition-fill:eq(0)', popbox);
		var colorinput = $('#fr-adanaly-condition-fill-input:eq(0)', popbox);
		self.conditionFillButton.colorinput = colorinput;
		var colorpicker = $('#fr-adanaly-pop-condition-fillpicker:eq(0)', colorbox).farbtastic(colorinput);
		colorpicker = colorpicker.data('fb');
		var colorbutton = $('#fr-adanaly-condition-fill-button:eq(0)', colorbox);
		self.conditionFillButton.valueField = $('.fr-adanaly-condition-fill-value', table);
		colorbutton.click(function(e){
			if(colorinput.val() === "") {
				colorinput.val('#000000');
			}
			//self.setFontColor();
			self.conditionFillButton.setValue(colorinput.val());
			self.conditionFillButton.pop_hide(e);
		});
		self.conditionFontColorButton.setValue(colorinput.val());
		$('.fr-adanaly-condition-fill-value', table).css('background', colorinput.val())
	},
	
	_getFontLineStyles : function(){
		return [{
			text:'()', value:0, style:{'text-decoration': 'none'}
		},{
			text:'»', value:1, style:{'text-decoration': 'underline'}
		},{
			text:'ɾ', value:2, style:{'text-decoration': 'line-through'}
		},{
			text:'» ɾ', value:3, style:{'text-decoration': 'underline line-through'}
		}]
	},
	
	_getFontLineStyleValue : function(style){
		var value = 0;
		$.each(this._getFontLineStyles(), function(idx, items){
			if(items.style['text-decoration'] == style) {
				value = items.value;
				return false;
			}
		});
		return value;
	},
	
	_getFontStyles : function() {
		return [{
			text:"", value:0, style:{'font-weight':'400', 'font-style':'normal'}
		}, {
			text:"б", value:1, style:{'font-weight':'400', 'font-style':'italic'}
		}, {
			text:"Ӵ", value:2, style:{'font-weight':'600', 'font-style':'normal'}
		}, {
			text:"Ӵ б", value:3, style:{'font-weight':'600', 'font-style':'italic'}
		}]
	},
	
	_getFontStyleValue : function(weight, style) {
		var value = 0;
		if(!weight) {
			weight='400';
		}
		if(!style){
			style='normal';
		}
		$.each(this._getFontStyles(), function(idx, items){
			if(items.style['font-weight'] == weight && items.style['font-style'] == style) {
				value = items.value;
				return false;
			}
		})
		return value;
	},
	
	_getCellTypes : function() {
		return [{
			text:'AaBbCc', value:0, style:{'background':"#FFF714", 'font-size':"13", 'color':'#000000', 'font-family':'SimSun'}
		},{
			text:'AaBbCc', value:1, style:{'background':"#11F0C1", 'font-size':"12", 'color':'#111111', 'font-family':'Arial'}
		},{
			text:'AaBbCc', value:2, style:{'background':"#dda051", 'font-size':"10", 'color':'#FF0000', 'font-family':'Microsoft YaHei'}
		},{
			text:'AaBbCc', value:3, style:{'background':"#ccfdFF", 'font-size':"9", 'color':'#119911', 'font-family':'SimSun'}
		},{
			text:'AaBbCc', value:4, style:{'background':"#FFFFFF", 'font-size':"11", 'color':'#555555', 'font-family':'SimHei'}
		}]
	},
	
	_showCalculatorDialog : function () {
		var self = this;
		var keys = this._buildCalKey();
		if (!keys){
			return;
		}
		$.each(keys, function(idx, item){
			if (item.value == 'A3' && self.chart && item.text == 'fr-chart') {
				keys.splice(idx, 1);
				return false;
			}
		})
		if (keys.length == 0) {
			FR.Msg.toast('ѡЧ!');
			return;
		}
		var colItems = keys;
		var content = $('<div style="height:360px;width:380px"></div>');
		var north = $('<div><table><tr><td><div style="padding-left:18px;padding-right:4px;">:</div></td><td class="fr-adanaly-cal-type"></td></tr></table></div>');
		var center = $('<div style="overflow:hidden;padding-left:4px;padding-right:4px;"></div>');
		var bottom = $('<div style="overflow:auto;padding-left:4px;padding-right:4px"></div>');
		self.calTypeComboBox = new FR.ComboBoxEditor({
			renderEl : $('.fr-adanaly-cal-type', north),
			height : 20,
			width : 60,
			allowBlank : false,
			items:[{
				text : '㷨',
				value: 0
			}, {
				text : 'ٷֱ',
				value : 1
			}, {
				text : '',
				value : 2
			}]
		});
		self.calTypeComboBox.setValue(0);
		var fn = function(e) {
			var value = self.calTypeComboBox.getValue();
			if(value === 1) {
				self.calTypeBox.rebuild(self._getPercentItems());			
			} else if (value === 2){
				self.calTypeBox.rebuild(self._getAnalyItems());
			} else {
				self.calTypeBox.rebuild(self._getMetricItems());
			}
			self.calTypeBox.setSelectedIndex(0);
		}
		
		self.calTypeComboBox.on(FR.Events.CHANGE, fn);
		self.calTypeComboBox.on(FR.Events.AFTEREDIT, fn);
		
		content.asComponent({type:'border', items:[
			{region:"north", el:north, height:24},
			{region:"center", el:center},
			{region:"south", el:bottom, height:160}
		]});
		
		var caldiv = $('<div style="overflow:hidden;height:165px;width:380px;padding-top:10px;"></div>');
		caldiv.appendTo(center);
		
		var table = $('<table><tr><td class="fr-adanaly-cal-listname">:</td>' +
				'<td class="fr-adanaly-cal-listvalue"><div class="fr-adanaly-cal-caltype"></div></td></tr>' +
				'<tr class="fr-adanaly-cal-tr-items"><td class="fr-adanaly-cal-listname">ѡ:</td>' +
				'<td class="fr-adanaly-cal-listvalue"><div class="fr-adanaly-cal-selected-items"></div></td></tr>'+
				'<tr class="fr-adanaly-cal-tr-exchange" style="display:none"><td class="fr-adanaly-cal-listname">˳:</td>' +
				'<td class="fr-adanaly-cal-listvalue">' +
				'<table cellpadding="0" cellspacing="0" border="0" style="border-spacing:0;">' +
				'<tr style="vertical-align:top"><td><input type="radio" checked class="fr-adanaly-cal-exchange-first" id="fr-adanaly-cal-exchange" name="fr-adanaly-cal-exchange"/></td>' +
				'<td><div class="fr-adanaly-cal-exchange-text fr-adanaly-cal-exchange-first-text"></div></td></tr>' +
				'<tr style="vertical-align:top"><td><input type="radio" class="fr-adanaly-cal-exchange-second" id="fr-adanaly-cal-exchange" name="fr-adanaly-cal-exchange"/></td>' +
				'<td><div class="fr-adanaly-cal-exchange-text fr-adanaly-cal-exchange-second-text"></div></td></tr></table>'+
				'</td></tr>'+
				'<tr><td class="fr-adanaly-cal-listname fr-adanaly-cal-isValue"></td>' +
				'<td class="fr-adanaly-cal-calvalue fr-adanaly-cal-listvalue"></td></tr></table>');
		table.appendTo(caldiv);
		var bottomTable = $('<table><tr><td class="fr-adanaly-cal-listname">ʽ:</td>' +
				'<td class="fr-adanaly-cal-experssion fr-adanaly-cal-listvalue"></td></tr>' +
				'<tr><td class="fr-adanaly-cal-listname">½Ŀ:</td>' +
				'<td class="fr-adanaly-cal-listvalue"><div style="height:30px;"><input type="radio" class="fr-adanaly-cal-default-colname" id="calname" name="calname" style="vertical-align:text-bottom;" checked>ʹĬ</input></div>' +
				'<div style="height:30px;"><input type="radio" id="calname" name="calname" class="fr-adanaly-cal-self-colname" style="float:left;vertical-align:text-bottom;"><div style="float:left;" class= "fr-adanaly-cal-name"></div></input></div></td></tr></table>');
		bottomTable.appendTo(bottom);
		var newColNameRadio_default = $('.fr-adanaly-cal-default-colname', bottomTable);
		var newColNameRadio_self = $('.fr-adanaly-cal-self-colname', bottomTable);
		var colNameSelectFn = function(){
			if(newColNameRadio_self[0].checked){;
				nameEditor.enable();
				nameEditor.editComp.focus();
				nameEditor.selectText()
			} else {
				nameEditor.disable();
				$('body').focus();
			}
		}
		newColNameRadio_default.unbind('click').bind('click', colNameSelectFn);
		newColNameRadio_self.unbind('click').bind('click', colNameSelectFn);
		self.calItemList = new FS.List({
			renderEl : $('.fr-adanaly-cal-selected-items', table),
			height:80,
			width:150,
			items : []
		});
		self.calItemList.popData(colItems);
		var isValueBox = new FR.CheckBox({
			renderEl : $('.fr-adanaly-cal-isValue', table),
			text : 'ֵ:',
			value : true
		});
		
		self.calTypeBox = new FR.ComboBoxEditor({
			renderEl : $('.fr-adanaly-cal-caltype', table),
			height : 20,
			width : 150,
			allowBlank : false,
			items : self._getMetricItems()
		});
		self.calTypeBox.setValue(0);
		var itemTR = $('tr.fr-adanaly-cal-tr-items', table);
		var exchangeTR = $('tr.fr-adanaly-cal-tr-exchange', table)
		var exchange_first = $('.fr-adanaly-cal-exchange-first', table);
		var exchange_second = $('.fr-adanaly-cal-exchange-second', table);
		var exchange_first_text = $('.fr-adanaly-cal-exchange-first-text', table);
		var exchange_second_text = $('.fr-adanaly-cal-exchange-second-text', table);
		var cal_normal = function(index, calSign){
			var expresstion = "";
			$.each(colItems, function(idx, item){
				expresstion += item.text;
				if (idx < colItems.length -1)
					expresstion += calSign;
				else {
					if (isValueBox.getValue()){
						var number = self.calValueEditor.getValue();
						number = number === ""?0 :number;
						expresstion += calSign+number;
					}
				}
			});
			return expresstion;
		};
		var cal_exchange = function (index, calSign) {
			var args;
			var expresstion = "";
			if(colItems.length === 1) {
				var number = self.calValueEditor.getValue();
				args = number === "" || number === 0?0:number;
			} else {
				args = colItems[1].text;
			}
			if (index === 10){
				expresstion = (exchange_first[0].checked?('(' +colItems[0].text+'-'+args+')' + calSign + 'ABS(' + args + ')'):('('+args+'-'+ colItems[0].text+')' + calSign + 'ABS(' + colItems[0].text + ')'));
			} else {
				expresstion = exchange_first[0].checked?(colItems[0].text + calSign + args):(args + calSign + colItems[0].text);
			}
			return expresstion;
		}
		var cal_function_select = function(index, calSign){
			if (!self.calItemList.getSelectedData())
				self.calItemList.setSelectedIndex(0);
			var expresstion = calSign +'(';
			expresstion += self.calItemList.getSelectedData().text;
			var number = self.calValueEditor.getValue();
			number = number === '' ? 0 : number;
			if (index === 4) {
				expresstion +=',' + number;
			}
			if (index === 8) {
				expresstion += ')';	
			}
			if (index === 6) {
				expresstion += ',0'
			}	
			expresstion += ')';
			return expresstion;
		};
		
		var cal_function_array = function(index, calSign) {
			var expresstion = calSign + '(';
			$.each(colItems, function(idx, item){
				expresstion += item.text;
				if (idx < colItems.length - 1)
					expresstion +=',';
			});
			if (isValueBox.getValue()){
				var number = self.calValueEditor.getValue();
				number = number === ""?0 :number;
				expresstion += ','+number;
			}
			expresstion +=')';
			return expresstion;
		}
		
		//ɼ㹫ʽ,ϵ߼е㸴
		var calFn = function() {
			var index = self.calTypeBox.getValue();
			var calSign = self._getCalSign(index);
			var expresstion = '';
			//߼
			//趨ʾitemTRexchangeTR
			if(index === 1 || index ===3 || index ===9 || index ===10) {
				itemTR.hide();
				exchangeTR.show();
				var args2 = colItems.length === 1 ? '<'+'ֵ'+'>':colItems[1].text;
				var cal = index ===9 || index === 10 ? ' as a percentage of ':calSign;
				var content = (index === 10 ?'('+colItems[0].text + '-'+args2+')':colItems[0].text) + cal + args2;
				exchange_first_text.text(content).attr('title', content);
				content = (index === 10 ?'('+args2 + '-'+colItems[0].text+')':args2)  + cal + colItems[0].text;
				exchange_second_text.text(content).attr('title', content);
			} else {
				itemTR.show();
				exchangeTR.hide();
			}
			//趨valueBoxʾ״̬
			if(index === 4) {
				isValueBox.setValue(true);
				isValueBox.disable();
			} else if (index === 0 || index=== 2 || index > 10){
				if(colItems.length === 1) {
					isValueBox.disable();
					isValueBox.setValue(true);
				} else {
					isValueBox.enable();
					//checkBoxĬֵ,
					if (this instanceof FR.ComboBoxEditor){
						isValueBox.setValue(false);
					}
				}			
			} else {
				if ((index === 1 || index === 3 || index ===9 || index === 10) && colItems.length === 1) {
					isValueBox.setValue(true);
				} else {
					isValueBox.setValue(false);
				}
				isValueBox.disable();
			}
			//趨ֵĿ״̬
			if (isValueBox.getValue()) {
				self.calValueEditor.enable();
			} else {
				self.calValueEditor.disable();
			}
			//趨ֵǷfocus
			if (this instanceof FR.CheckBox) {
				if (this.getValue()){
					self.calValueEditor.editComp.focus();
					self.calValueEditor.selectText();
				}
			}
			//expresstion,дɾ
			switch(index) {
				case 0:expresstion = cal_normal(index, calSign);break;
				case 1:expresstion = cal_exchange(index, calSign);break;
				case 2:expresstion = cal_normal(index, calSign);break;
				case 3:expresstion = cal_exchange(index, calSign);break;
				case 4:expresstion = cal_function_select(index, calSign);break;
				case 5:expresstion = cal_function_select(index, calSign);break;
				case 6:expresstion = cal_function_select(index, calSign);break;
				case 7:expresstion = cal_function_select(index, calSign);break;
				case 8:expresstion = cal_function_select(index, calSign);break;
				case 9:expresstion = cal_exchange(index, calSign);break;
				case 10:expresstion = cal_exchange(index, calSign);break;
				case 11:expresstion = cal_function_array(index, calSign);break;
				case 12:expresstion = cal_function_array(index, calSign);break;
				case 13:expresstion = cal_function_array(index, calSign);break;
				default:expresstion = cal_normal(index, calSign);break;
			}
			self.calExpresstion = expresstion;
			expressionEditor.setValue(expresstion);
		}
		
		self.calValueEditor = new FR.NumberEditor({
			renderEl : $('.fr-adanaly-cal-calvalue', table),
			height : 20,
			width : 150,
			value : 0
		});
		
		var expressionEditor = new FR.TextEditor({
			renderEl : $('.fr-adanaly-cal-experssion', bottomTable),
			height : 70,
			width : 240,
			multiline : true
		});
		expressionEditor.editComp.css('resize', 'none');
		expressionEditor.disable();
		
		self.calTypeBox.on(FR.Events.CHANGE, calFn);	
		self.calTypeBox.on(FR.Events.AFTEREDIT, calFn);
		self.calItemList.on(FR.Events.CLICK, calFn);
		self.calValueEditor.on(FR.Events.AFTEREDIT, function(e){
			calFn.call(self);
			self.calValueEditor.editComp.focus();
		});
		isValueBox.on(FR.Events.CLICK, calFn);
		exchange_first.unbind('click').bind('click', calFn);
		exchange_second.unbind('click').bind('click', calFn);
		self.calTypeBox.setValue(0);
		
		var nameEditor = new FR.TextEditor({
			renderEl : $('.fr-adanaly-cal-name', bottomTable),
			height : 20,
			width : 219
		});
		nameEditor.disable();
		var colnames = [];
		$.each(keys, function(idx, item){
			colnames.push(item.index);
		})		
		var config = {
            confirm : true,
			title : '',
			width : 420,
			height : 420,
			contentHTML : content,
			onOK : function(e) {
				self.addCell({
					keys : keys,
					type : self.calTypeComboBox.getValue(),
					value : {
						type : self.calTypeBox.getValue(),
						colnames : colnames,
						isUseNumber : isValueBox.getValue(),
						number : self.calValueEditor.getValue(),
						asc : exchange_first[0].checked,
						selected : self.calItemList.getSelectedIndex()
					},
					columnname : newColNameRadio_default[0].checked ? self.calExpresstion : nameEditor.getValue()
				})
				return true
			}
		};
		self.showAdanalyCalDialog(config);
		content.doLayout();
		
	},
	
	_getCalSign : function (index) {
		switch(index) {
			case 0 : return '+';
			case 1 : return '-';
			case 2 : return '*';
			case 3 : return '/';
			case 4 : return 'POWER';
			case 5 : return 'ABS';
			case 6 : return 'ROUND';
			case 7 : return 'ROUNDDOWN';
			case 8 : return 'SQRT(ABS';
			case 9 : return '/';
			case 10 : return '/';
			case 11 : return 'AVERAGE';
			case 12 : return 'MAX';
			case 13 : return 'MIN';
			default : return '+';
		}
	},
	
	_getMetricItems : function() {
		return [{text:'+()',value : 0},{
				text:'-()',value : 1
			},{
				text:'*(˷)',value : 2
			},{
				text:'/()',value : 3
			},{
				text:'^(η)',value : 4
			},{
				text:'ֵ', value : 5
			},{
				text:'', value : 6
			},{
				text:'ȡ', value : 7
			},{
				text:'ƽ', value : 8
			}];
	},
	
	_getPercentItems : function () {
		return [{
			text:'%', value : 9
		},{
			text:'% difference(growth)', value:10
		}]
	},
	
	_getAnalyItems : function () {
		return [{
			text:'ƽֵ', value : 11
		}, {
			text:'ֵ', value : 12
		}, {
			text:'Сֵ', value : 13
		}]
	},
	
	_showChartDialog : function () {
		var self = this;
		var content = $('<div style="height:365px;width:535px"></div>');
		var north = $('<div><table></tr><td><div style="padding-left:8px;padding-right:4px;">ѡһͼ:</div></td><td class="fr-adanaly-chart-combobox"></td></tr></table></div>');
		var center = $('<div style="overflow:auto;padding-left:4px;padding-right:4px"></div>');
		self.chartTypeCombobox = new FR.ComboBoxEditor({
			renderEl :  $('.fr-adanaly-chart-combobox', north),
			height : 20,
			width : 120,
			allowBlank : false,
			widgetUrl : FR.servletURL + "?op=fr_adhoc&cmd=ac_chart_type"
		});
		var fn =  function(e){
			var index = this.getValue()
			var tableValue = self.chartImages[index]
			if(!tableValue) {
				var tableValue = FS.Trans.getChartIcons(index);
				self.chartImages[index] = tableValue;
			}
			center.html(tableValue);
			self._hoverChartList(center);
			self.chartType = undefined;
		};
		self.chartTypeCombobox.on(FR.Events.CHANGE, fn);	
		self.chartTypeCombobox.on(FR.Events.AFTEREDIT, fn);
//		content.asComponent();
		var tr = $('<tr/>')

		var config = {
            confirm : true,
			title : 'ͼ',
			width : 540,
			height : 430,
			contentWidget : {type:'border', items:[
                {region:"north", el:north, height:24},
                {region:"center", el:center}
            ]},
			onOK : function(e) {
				if(self.chartType || self.chartType === 0) {
					if (!self.chart){
						var loc = {
							row : 14
						}
						self.updateCellConfigKey('A3', loc);
					}
					self.chart = {
						chartContent : self.chartTypeCombobox.getValue(),
						chartType : self.chartType
					}
					self.viewReport();
					return true;
				} else {
					alert("ûѡͼ")
					return false;
				}
			}
		};
		self.showAdanalyChartDialog(config);
        self.chartTypeCombobox.setValue(0);
//		content.doLayout();
	},
	
	_hoverChartList : function (center) {
		var self = this;
		var list = $(".fr-adanaly-chart-list", center);
			$.each(list, function(idx, item){
				$(item).hover(
					function(){
						$(this).addClass("fr-adanaly-chart-over");
					},
					function(){
						$(this).removeClass("fr-adanaly-chart-over");
					}	
				);
				$(item).unbind('click').bind('click', function(e){
					$.each($(".fr-adanaly-chart-list", center), function(i, value){
						$(value).removeClass("fr-adanaly-chart-selected");
					})			
					$(this).addClass("fr-adanaly-chart-selected");
					self.chartType = idx;
				})
			});
	},
	
	printPreview : function() {
		var self = this;
        window.open(FR.servletURL + "?op=print_preview&cmd=pw_init_page&__pi__=false&sessionID=" + self.getFrameSessionID() ,"_blank", "Scrollbar=yes,Resizable=yes,fullscreean=yes");
    },
    
    exportReportToPDF:function(extype) {
    	var self = this;
        window.location = FR.servletURL + "?op=export&sessionID=" + self.getFrameSessionID() + "&format=pdf&extype=" + extype;
    },
    
    exportReportToExcel:function(extype) {
    	var self = this;
        window.location = FR.servletURL + "?op=export&sessionID=" + self.getFrameSessionID() + "&format=excel&extype=" + extype;
    },
    
     exportReportToImage:function(extype) {
    	var self = this;
        window.location = FR.servletURL + "?op=export&sessionID=" + self.getFrameSessionID() + "&format=image&extype=" + extype;
    },
    
    exportReportToWord:function() {
    	var self = this;
        window.location = FR.servletURL + "?op=export&sessionID=" + self.getFrameSessionID() + "&format=word";
    },
	
	_refreshToolbarValue : function(cellValue){
		var self = this;
		self.fontFamilyComp.setValue(cellValue.fontFamily);
		self.fontSizeComp.setValue(cellValue.fontSize);
		self.fontColorButton.setValue(cellValue.fontColor);
		self.fontWeightButton.setValue(cellValue.fontWeight);
	},
	
	_populate : function(popConfig) {
		var self = this;
		if (popConfig.columns) {
			$.each(popConfig.columns, function(idx, item){
				var $tr = self.col_tr_map[item.columnname];
				if ($tr != null) {
					self.columnBoard.popColumn($tr, item.groupStyle);
				}
			});
		}
		if (popConfig.rows) {
			$.each(popConfig.rows, function(idx, item){
				var $tr = self.col_tr_map[item.columnname];
				if ($tr != null) {
					self.rowBoard.popColumn($tr, item.groupStyle);
				}
			});
		}
		if (popConfig.summaryColumn) {
			$.each(popConfig.summaryColumn, function(idx, item){
				var $tr = self.col_tr_map[item.columnname];
				if ($tr != null) {
					self.summaryBoard.popColumn($tr, item.funname);
				}
			});
		}
		self.styleButton.setValue(popConfig.crossedstyleValue);
		this.undoRedoManager.push(popConfig);
		this.viewReport(popConfig, false);
	},
	
	_initColumnRowFieldPane : function(colNames) {
		this.$fl_table = $('tbody:eq(0)', $('#fr-adanaly-fieldlist'));
		this.col_tr_map = {};
		this.fieldsListPane._init(colNames, this.$fl_table, this.col_tr_map);
		this.columnBoard = new Board();
		this.columnBoard._init(1, $('#fr-adanaly-columnbox'));
		this.rowBoard = new Board();
		this.rowBoard._init(2, $('#fr-adanaly-rowbox'));
		this.summaryBoard = new SummaryBoard();
		this.summaryBoard._init(3, $('#fr-adanaly-summarybox'));
		
		// carl:ϵɾ
		var self = this;
		$('body').droppable({
			accept: ".fr-adanaly-draggable",
			drop: function( event, ui ) {
				var $tr = $('<tr/>');
				
				if ($.browser.msie) {
					ui.draggable.attr('old', 0);
				}
				
				if (ui.draggable.children('td').length > 1) {
					$tr.append(ui.draggable.children('td:eq(1)'));
				} else {
					$tr.append(ui.draggable.children('td:eq(0)'));
				}
				self.createDraggableTR($tr, ui.draggable.attr('val'), ui.draggable.attr('text'), ui.draggable.attr('isNumber'));
				FR.ADANALY.$fl_table.append($tr);
				
				ui.draggable.remove();
			}
		});
	},
	
	fieldsListPane : {
		_init : function(colNames, $el, tr_map) {
			var ad = FR.ADANALY;
			$.each(colNames, function(idx, item) {
				var $tr = $('<tr><td><p class="fr-adanaly-fl-ff">' + colNames[idx].text + '</p></td></tr>').appendTo($el);
				ad.createDraggableTR($tr, colNames[idx].value, colNames[idx].text,  item.isNumber);
				tr_map[colNames[idx].value] = $tr;
			});
			
			$el.sortable({
				items : "tr.fr-adanaly-draggable",
				appendTo : 'body',
				helper : 'clone'
			}).disableSelection();
		},
		
		popColumns : function (colNames, $el){
			var ad = FR.ADANALY;
			$el.empty();
			$.each(colNames, function(idx, item) {
				var $tr = $('<tr><td><p class="fr-adanaly-fl-ff">' + colNames[idx].text + '</p></td></tr>').appendTo($el);
				ad.createDraggableTR($tr, colNames[idx].value, colNames[idx].text, item.isNumber);
			});		
			$el.sortable({
				items : "tr.fr-adanaly-draggable",
				appendTo : 'body',
				helper : 'clone'
			}).disableSelection();
		}
	},
	
	createDraggableTR : function($tr, value, text, isNumber) {
		$tr.mouseover(function(e){
			$tr.css('background-color', '#cccccc').css('cursor', 'move');
		});
		$tr.mouseout(function(e){
			$tr.css('background-color', '#FFFFFF').css('cursor', 'default');
		});
		
		$tr.attr('colIdx', 0)
			.attr('val', value)
			.attr('text', text)
			.attr('isNumber', isNumber)
			.addClass('fr-adanaly-draggable');
	},
	
	_initInputs : function() {
		var listener = {};		
		var $filtertd = $('<div>').appendTo($('#fr-adanaly-filterbuttontd'));
		var self = this;
		listener = {};
		listener.eventName = FR.Events.CLICK;
		listener.action = function() {
			self.addFilter();
		};
		var config = {
			type : 'button',
			name : 'adanalyfilter',
			tablable : true,
			text : FR.i18nText("Add"),
			width: 50,
			listeners : [listener]
		};
		$filtertd.asComponent(config);
		
		var $filtertd = $('<div>').appendTo($('#fr-adanaly-delbuttontd'));
		listener = {};
		listener.eventName = FR.Events.CLICK;
		listener.action = function() {
			self.removeNameCondition();
		};
		config = {
			type : "button",
			name : 'delfilter',
			tablable : true,
			text : FR.i18nText("Delete"),
			width: 50,
			listeners : [listener]
		};
		$filtertd.asComponent(config);
		
		var $filtertd = $('<div>').appendTo($('#fr-adanaly-editbuttontd'));
		listener = {};
		listener.eventName = FR.Events.CLICK;
		listener.action = function() {
			self.editFilter();
		};
		config = {
			type : "button",
			name : 'delfilter',
			tablable : true,
			text : FR.i18nText("Edit"),
			width: 50,
			listeners : [listener]
		};
		$filtertd.asComponent(config);
		
	 	this.$conditionlist = new FS.List({
	 		renderEl :  $('#fr-adanaly-filterbox'),
	 		items : [],
	 		height : 80,
	 		width : 305
	 	});	 	
	 	var button = new FR.Button({
	 		renderEl:'div#fr-adanaly-submit',
	 		text:FR.i18nText("Preview"),
	 		disabled:true,
	 		width:60
	 	});

		button.on(FR.Events.CLICK, function(){
			self._viewReport();
		});
		
		var checkBox = new FR.CheckBox({
	 		renderEl:"div#fr-adanaly-delaysubmit",
	 		text:'ƳԤ',
	 		value:false,
	 		height:22
	 	})
	 	checkBox.on(FR.Events.STATECHANGE, function() {
            self.delayview =  checkBox.isSelected();
            if (self.delayview) {
             	button.enable();
            } else{
            	button.disable();
            }
        });
		
	},
	
	getFrameSessionID : function() {
		var sessionID = null;
		var cp = this.getFramePage();
		if(cp){
			sessionID = cp.currentSessionID;
		}
		return sessionID;
	},
	
	getFramePage : function () {
		var fra = window.frames[0];
		var cp;
		if (fra) {
			var cp = fra.contentPane;
		}
		return cp;
	},

	viewReport : function(item, isDelay) {
		var self = this;
		var report = item;
		if (!report) {
			report = this.getReportInfo();
			this.undoRedoManager.push(report);
		} else {
			this.chart = report.chart;
			this.titleValue = report.title;
			this.subTitleValue = report.subtitle;
			if (report.cellSettings) {
				this.cellSettings = this.copyObject(report.cellSettings);
			}
			if (report.addedCells) {
				this.addedCells = this.copyObject(report.addedCells);
			}
			if (report.groupSettings) {
				this.groupSettings = this.copyObject(report.groupSettings);
			}
			self.clearCondition();
			if (report.condition.commonconditions) {
				var conditon = []
				$.each(report.condition.commonconditions, function(idx, value){
					var nc = {};
					nc.value = value;
					nc.text = value.columnname + self.getOPString(value.compare.op) + value.compare.value;
					conditon.push(nc);
				});
				self.popCondition(conditon);
			}
		}
		if(!this.delayview || isDelay){
			this.__viewReport(report);
		}
	},
	
	_viewReport : function(){
		this.viewReport(null, true);
	},
	
	__viewReport : function(report){	
		var needCR = report.rows.length == 0 && report.columns.length == 0;
		var needS = report.summaryColumn.length == 0;
		var $alert = $('#fr-adanaly-alert');
		var text = '';
		if (needCR) {
			text = FR.i18nText("Please_Drag");
			if (needS) {
				text += '';
			}
		} else if (needS) {
			text = FR.i18nText("Please_Drag")
		}
		
		if (text.length > 0) {
			$alert.text(text);
			FR.doHyperlinkByPost("about:blank", {}, "analyFrame");
		} else {
			$alert.text('');
			FR.doHyperlinkByPost(FR.buildServletUrl({op:'analysis', reportlet: 'adhocreport',__showtoolbar__:'false'}), {adhocconfig : report}, "analyFrame");
		}
		
		this._checkButtonState();
	},
	
	_checkButtonState : function(){
		var self = this;
		self.undoButton.setEnabled(self.undoRedoManager.canUndo());
		self.redoButton.setEnabled(self.undoRedoManager.canRedo());
		self.saveButton.setEnabled(true);
		self.deleteButton.setEnabled(true);
		self.exportButton.setEnabled(true);
		self.pageSetButton.setEnabled(true);
		self.printPreviewButton.setEnabled(true);
		self.printButton.setEnabled(true);
		self.emailButton.setEnabled(true);
	},
	
	getAddColumnsWithOutSum : function () {
		var self = this;
		var res = 0;
		$.each(this.addedCells, function(idx, item){
			res += self._getAddColumnsWithOutSum(item);
		})
		return res;
	},
	
	_getAddColumnsWithOutSum : function (item) {
		var res = 0;
		var self = this;
		if(item.columnname.endWith("-:-col")){
			res++;
		}
		/**
		 * ҪǸڵ㣬Ҫʹ˵
		 */
//		if(item.childColumn){
//			$.each(item.childColumn, function(index, childItem){
//				res += self._getAddColumnsWithOutSum(childItem);
//			})
//		}
		return res;
	},
	
	isAddCellNameExist : function(addName){
		var self = this;
		var isExist = false;
		$.each(this.addedCells, function(idx, item){
			isExist = self._isAddCellNameExist(item, addName);
			if (isExist){
				return false;
			}
		})
		return isExist;
	},
	
	_isAddCellNameExist : function(item, addName) {
		var isExist = false;
		var self = this;
		if(item.columnname != addName){
			if(item.childColumn){
				$.each(item.childColumn, function(index, childItem){
					isExist = self._isAddCellNameExist(childItem, addName);
					if(isExist){
						return false;
					}
				})
			}
		} else {
			isExist = true;
		}
		return isExist;
	},
	
	addCellElement : function(addName, column){
		var self = this;
		var isExist = false;
		$.each(this.addedCells, function(idx, item){
			isExist = self._addCellElement(item, addName, column);
			if (isExist){
				return false;
			}
		})
		if (!isExist){
			var child = [];
			child.unshift(column);
			this.addedCells.push({
				columnname : addName,
				childColumn : child
			});
		}
	},
	
	_addCellElement : function(item, addName, column) {
		var isExist = false;
		var self = this;
		if(item.columnname != addName){
			if(item.childColumn){
				$.each(item.childColumn, function(index, childItem){
					isExist = self._addCellElement(childItem, addName, column);
					if(isExist){
						return false;
					}
				})
			}
		} else {
			if (!item.childColumn){
				item.childColumn = [];
			}
			item.childColumn.unshift(column);
			isExist = true;
		}
		return isExist;
	},
	
	addCell : function (config) {
		//ڵһѡԪ֮
		if (config.keys && config.keys.length > 0){
			var addKey = config.keys[0];
			if(addKey){
				this._setAddedCells(addKey, config);
			}
		}
	},
	
	_getAddedCellLength : function (addCells){
		var i = 1;
		var self = this;
		if(addCells.childColumn){
			$.each(addCells.childColumn, function(idx, item){
				i += self._getAddedCellLength(item);
			})
		}
		return i;
	},
	
	deleteCalCell : function(delItem){
		this._deleteCalCell(this.addedCells, delItem);
	},
	
	_deleteCalCell : function(item, delItem, columnname) {
		var self = this;
		$.each(item, function(index, childItem){
			if(childItem.columnname != delItem.text) {
				if (childItem.childColumn) {
					self._deleteCalCell(childItem.childColumn, delItem, childItem.columnname);
				}
			} else {
				self.updateCellConfigKey(delItem.value, {
					col : -1 * self._getAddedCellLength(childItem)
				});
				if (columnname ||columnname === 0) {
					var offset = self.getOffset(columnname);
					if (offset) {
						self.updateCellConfigKey(delItem.value, {
							row : -1
						}, true)
					}
				}
				item.splice(index, 1);
				return false;
			}
		})
	},
	
	deleteAddedCell : function () {
		var keys = this._buildCalKey();
		var hasDelSth = false;
		var self = this;
		var isChart = false;
		$.each(keys, function(idx, item){
			var  loc = {};
			var del = false;
			if (self.isAddCellNameExist(item.index)){
				self.deleteCalCell(item);
				del = true
			} else if (self.chart && item.index == 'fr-chart' && item.value == 'A3') {
				delete self.chart;
				loc.row = -14;
				loc.col= 0;
				del = true;
				self.updateCellConfigKey('A3', loc);
			}
			if (del){
				hasDelSth = true;				
			}
		});
		if (hasDelSth){
			this._viewReport();
		}
	},
	
	_setAddedCells : function(addKey, config){	
		var column = {
			type : config.type,
			value : config.value,
			columnname : config.columnname
		}
		var i = 1;
		while (this.isAddCellNameExist(column.columnname)){
			column.columnname = column.columnname +'-'+ i;
			i++;
		}
		this.addCellElement(addKey.index, column);
		this.updateCellConfigKey(addKey.value, {
			col : 1
		})
		
		var offset = this.getOffset(addKey.index);
		if (offset) {
			this.updateCellConfigKey(addKey.value, {
				row : 1
			}, true)
		}
		this._viewReport();
	},
	
	getOffset : function (key) {
		return (this.columnBoard.getColumns().length > 0
			 && this.summaryBoard.getColumns().length == 1
			 && this.getAddColumnsWithOutSum() == 1
			 && key.endWith("-:-col")) ? 1 : 0
	},	
	/**
	 * set group = null can delete group setting
	 */
	_setGroupSettingFromFrame : function (config){
		var self = this;
		var hasDelete = false;
		var hasAdded = false;
		if (!(config.columnname || config.columnname === 0)){
			return;
		}
		$.each(this.groupSettings, function(idx, item){
			if (item.columnname == config.columnname){
				self.groupSettings.splice(idx, 1);
				hasDelete = true;
			}
		})
		if (config.group) {
			var groupSetting = {};
			groupSetting.columnname = config.columnname;
			groupSetting.group = config.group;
			self.groupSettings.push(groupSetting);
			hasAdded = true
		}
		if (hasDelete ^ hasAdded) {
			//groupʱӵԪ
//			//so hasDelete = false  hasAdded = true 
//			var change = hasDelete ? -1 : 1;
//			var isCol = (config.ast == 0);	
//			//groupΪǰ˲
//			self.updateCellConfigKey(config.cef, {
//				col : isCol ? change : 0,
//				row : isCol ? 0 : change
//			}, true);
		}
		this._viewReport();
	},
	
	_getGroupSettingFromFrame : function (columnname) {
		var res = null;
		$.each(this.groupSettings, function(idx, item){
			if (item.columnname == columnname){
				res = item;
				return false;
			}
		})
		return res;
	},
	
	_updateKeys : function(obj, key, cr, insertBefore) {
		var settings = {};
		var keyLoc = FR.cellStr2ColumnRow(key);
		var self = this;
		$.each(obj, function(idx, item){
			if(idx){
				idx = self._getNewKey(idx, keyLoc, cr, insertBefore);
 				settings[idx] = item;
			}
		})
		return settings;
	},
	
	_getNewKey : function (idx, keyLoc, cr, insertBefore) {
		var loc = FR.cellStr2ColumnRow(idx);
		//ǰ˲Ҫ1
		if (loc.row > keyLoc.row || (insertBefore && loc.row == keyLoc.row)) {
			loc.row += cr.row ? cr.row : 0;
		}
		if (loc.col > keyLoc.col || (insertBefore && loc.col == keyLoc.col)) {
			loc.col += cr.col ? cr.col : 0;
		}
		return FR.columnRow2CellStr(loc);
	},
	
	setCellConfig : function (config){
		this._setCellConfigFromFrame(config);
	},
	
	getCellSetting : function (idx) {
		return this.cellSettings[idx];
	},
	
	getCellIndex : function(cef){
		var keys= [];
		keys.push(cef);
		var indexs = this.__buildKey(keys);
		return indexs.length == 0? undefined : indexs[0];
	},
	
	_setCellConfigFromFrame : function (config){
		if (config.titleValue || config.titleValue == 0){
			this.setTitle(config.titleValue);
			return;
		}
		
		if (config.subTitleValue || config.subTitleValue == 0){
			this.setSubTitle(config.subTitleValue);
			return;
		}
		
		var keys = this._buildKey();
		if (config.sort) {
			if (config.sort.parentBox) {
				keys = []
				keys.push(config.sort.parentBox);
			}
		}	
		var self = this;
		if (keys) {
			$.each(keys, function(idx, key){
				if(self.cellSettings[key]){
					$.extend(self.cellSettings[key], config);
				} else {
					self.cellSettings[key] = config;
				}
			})			
			self._viewReport();
		} 
	},
	
	setTitle : function(value){
		if (this.titleValue != value){
	    	this.titleValue = value;
	    	this.viewReport();
		}
    },
    
    setSubTitle : function(value){
    	if (this.subTitleValue != value) {
	    	this.subTitleValue = value;
	    	this.viewReport();
    	}
    },
		
	_setCurrentTDCells : function (cell) {
		this.$currentTDCell = cell;
		this._checkButtonState();
	},
	
	_getCurrentTDCells : function () {
		return this.$currentTDCell;
	},
	
	updateCellConfigKey : function(key, cr, insertBefore){
		//this.cellSettings = this._updateKeys(this.cellSettings, key, cr, insertBefore);
	},
	
	_buildFirstSelectKey : function (){
		var keys = this._buildKey();
		return keys ? keys [0] : undefined;
    },
    
    _buildCalKey : function () {
    	var keys = this.$currentTDCell;
		if (!keys || keys.length == 0){
			keys = undefined;
			FR.Msg.toast('No cell selected!');
		}
    	if (keys) {
    		return FS.Trans.getCellKey({
    			cells : keys,
    			sessionID :this.getFrameSessionID()
    		});
    	}
    },
    
    _buildKey : function () {
    	return this.__buildKey(this.$currentTDCell);
    },
    
    __buildKey : function (keys) {
		if (!keys || keys.length == 0){
			keys = undefined;
			FR.Msg.toast('No cell selected!');
		} else {
			var cellCategory = FS.Trans.getCellCategory({
				cells : keys,
				sessionID :this.getFrameSessionID()
			});
			if (cellCategory && cellCategory.length > 0) {
				keys = cellCategory;
			} else {
				keys = undefined;
				FR.Msg.toast('Can not parse cell!');
			}
		}
		return keys;
    },
    
	getReportInfo : function() {
		var report = {};
		report.viewname = this.viewname;
		report.condition = {commonconditions: this.getConditions()};
		
		report.title = this.titleValue;
		report.subtitle = this.subTitleValue;
		
		report.summaryColumn = this.summaryBoard.getColumns();
		report.rows = this.rowBoard.getColumns();
		report.columns = this.columnBoard.getColumns();
		report.reporttype = 1;
		report.chart = this.chart
		report.cellSettings = this._getCellSettings();
		report.addedCells = this._getAddedCells();
		report.groupSettings = this._getGroupSettings();
		report.crossedstyle = this.styleGroup[this.styleButton.getValue()];
		//ڵ
		report.crossedstyleValue = this.styleButton.getValue();
		return report;
	},
	
	clearFill : function(){
		$.each(this.cellSettings, function(idx, item){
			if(item['background']){
				delete item['background'];
			}
			if(item['border']){
				delete item['border'];
			}
		});
	},
	
	_getAddedCells : function () {
		return this.copyObject(this.addedCells);
	},
	
	_getCellSettings : function(){
		return this.copyObject(this.cellSettings);
	},
	
	_getGroupSettings : function () {
		return this.copyObject(this.groupSettings);
	},
	
	//undefinednullֵ
	copyObject : function(obj){
		var self = this;
		if(obj != undefined && obj != null && typeof(obj) == 'object'){
			var newObj;
			if ($.isArray(obj)){
				newObj = [];
				$.each(obj, function(idx, item){
					var value = self.copyObject(item)
					if(value != undefined && value != null) {
						newObj.push(value);
					}
				})
			} else {
				newObj = {};
				$.each(obj, function(idx, item){
					var value = self.copyObject(item)
					if(value != undefined && value != null) {
						newObj[idx] = value;
					}
				})
			}
			return newObj;
		} else {
			return obj;
		}
	},
	
	addFilter : function() {
		this.filterFace.popNameCondition(null);
		this.popFilterPane(true);
	},
	
	editFilter : function() {
		var nc = this.$conditionlist.getSelectedData()
		this.filterFace.popNameCondition(nc);
		this.popFilterPane(false);
	},
	
	popFilterPane : function(add) {
		var self = this;
		
		var dlgConfig = {
			items : [
				{region : "center", el : {type : "panel", contentHtml : this.filterFace.getContent()}},
				{region : "south", height : 26, el : 
					{type : "horizontal", alignment : "right", items : [{el:{type : "button", text : FR.i18nText("OK"), width : 60, handler : function() {
						if (add) {
							self.filterFace.addNameCondition();
						} else {
							self.filterFace.editNameCondition();
						}
						self.filterFace.trash();
						FR.closeDialog();
					}}, width:60}, {el:{type : "button", text : FR.i18nText("Cancel"), width : 60, handler : function() {
						self.filterFace.trash();
						FR.closeDialog();
					}}, width:60}]}
				}
			]};
		var b = new FR.BorderLayout(dlgConfig);	
		FR.showDialog(FR.i18nText("Field_Filtration"), 560, 160, b.element);
		b.element.width(520).height(110);
		b.doLayout();
	},
	
	filterFace : {
		_init : function() {
			this.content = $('<div/>').addClass('fr-adanaly-fileterface');
			this.content.append(this.createDesignTable());
		},
		
		trash : function() {
			this.content.appendTo($('#fr-adanaly-trash'));
		},
	
		getContent : function() {
			if (!this.content) {
				this._init();
			}
			return this.content;
		},
		
		createDesignTable : function() {
			var table = $('<table/>').addClass('fr-adanaly-filterface-table');
			table.append(this.generateExplanTR());
			table.append(this.generateFilterTR());
			return table;
		},
		
		generateExplanTR : function() {
			return $('<tr/>')
				.append($('<td/>').text(FR.i18nText("Select_Fields") + ':' ))
				.append($('<td/>').text(FR.i18nText("FormulaD-Operations") + ':'))
				.append($('<td/>').text(FR.i18nText("Data_Type") + ':'))
				.append($('<td/>').text(FR.i18nText("ChartF-Values")))
				.append($('<td/>'));
		},
		
		generateFilterTR : function() {
			return $('<tr/>')
				.append($('<td/>').append(this.generateFieldCombo()))
				.append($('<td/>').append(this.generateOPCombo()))
				.append($('<td/>').append(this.generateTypeCombo()))
				.append($('<td/>').append(this.valuePane.getContent()))
		},
		
		generateFieldCombo : function() {
			var config = {
				type : "combo",
				directEdit : false,
				allowBlank : true,
				width : 120,
				height : 20,
				popupWidth : 120,
				mode: 'local',
				items : FR.ADANALY.colNames
			};	
			
			var combo = $('<div/>');
			this.fieldsCombo = combo.asComponent(config);	
			return combo;
		},
		
		generateOPCombo : function() {									
			var config = {
				type : "combo",
				width : 120,
				height : 20,
				popupWidth : 120,
				directEdit : false,
				allowBlank : true,
				mode: 'local'
			};	
			config.items = this.opData();
			var combo = $('<div/>');
			this.opCombo = combo.asComponent(config);
			return combo;
		},
		
		opData : function() {
			var item = [];
			item.push({text: FR.i18nText("ConditionB-equals"), value: 0});
			item.push({text: FR.i18nText("ConditionB-does_not_equal_to"), value: 1});
			item.push({text: FR.i18nText("ConditionB-is_greater_than"), value: 2});
			item.push({text: FR.i18nText("ConditionB-is_greater_than_or_equal_to"), value: 3});	
			item.push({text: FR.i18nText("ConditionB-is_less_than"), value: 4});
			item.push({text: FR.i18nText("ConditionB-is_less_than_or_equal_to"), value: 5});
			item.push({text: FR.i18nText("ConditionB-begins_with"), value: 6});
			item.push({text: FR.i18nText("ConditionB-does_not_begin_with"), value: 7});
			item.push({text: FR.i18nText("ConditionB-ends_with"), value: 8});
			item.push({text: FR.i18nText("ConditionB-does_not_end_with"), value: 9});
			item.push({text: FR.i18nText("ConditionB-contains"), value: 10});
			item.push({text: FR.i18nText("ConditionB-does_not_contain"), value: 11});
			item.push({text: FR.i18nText("ConditionB-in"), value: 12});
			item.push({text: FR.i18nText("ConditionB-does_not_in"), value: 13});
			return item;
		},
		
		generateTypeCombo : function() {
			var listener = {};
			var self = this;
			listener.eventName = FR.Events.AFTEREDIT;
			listener.action = function() {
				self.valuePane.showTypePane(self.typeCombo.getValue());
			};
			var config = {
				type : "combo",
				width : 120,
				height : 20,
				popupWidth : 120,
				directEdit : false,
				allowBlank : true,
				mode: 'local',
				listeners : [listener]
			};	
			config.items = this.typeData();
			var combo = $('<div/>');
			this.typeCombo = combo.asComponent(config);	
			return combo;
		},
											
		typeData : function() {
			var item = [];
			item.push({text: FR.i18nText("Parameter-String"), value: 'string'});
			item.push({text: FR.i18nText("Number"), value: 'number'});
			item.push({text: FR.i18nText("Date"), value: 'date'});
			return item;
		},
		
		valuePane : {
			_init : function() {
				this.content = $('<div/>');
				this.content.append(this.generateText())
					.append(this.generateNumber())
					.append(this.generateDate());
			},
			
			getContent : function() {
				if (!this.content) {
					this._init();
				}
				return this.content;
			},
			
			generateText : function() {
				var config = {type : "text"};
				var text = $('<div/>');
				this.text = text.asComponent(config);
				this.text.setVisible(false);
				return text;
			},
			
			generateNumber : function() {
				var config = {type : "number"};
				var number = $('<div/>');
				this.number = number.asComponent(config);
				this.number.setVisible(false);
				return number;
			},
			
			generateDate : function() {
				var config = {type : "datetime"};
				config.directEdit = true;
				var date = $('<div/>');
				this.date = date.asComponent(config);
				this.date.setVisible(false);
				return date;
			},
			
			showTypePane : function(type) {
				//b:0-string, 1-number, 2-date
				if (type == "string") {
					this.text.setVisible(true);
					this.number.setVisible(false);
					this.date.setVisible(false);
				} else if (type == "number") {
					this.text.setVisible(false);
					this.number.setVisible(true);
					this.date.setVisible(false);
				} else if (type == "date") {
					this.text.setVisible(false);
					this.number.setVisible(false);
					this.date.setVisible(true);
				}
			},
			
			getValue : function() {
				if (this.text.isVisible()) {
					return this.text.getValue();
				} else if (this.number.isVisible()) {
					return this.number.getValue();
				} else if (this.date.isVisible()) {
					return this.date.getValue();
				}
			},
			
			getType : function() {
				if (this.text.isVisible()) {
					return "string";
				} else if (this.number.isVisible()) {
					return "number";
				} else if (this.date.isVisible()) {
					return "date";
				}
			},
			
			setTypeAndValue : function(type, value) {
				this.showTypePane(type);
				this.text.setValue('');
				this.number.setValue('');
				if (type == "string") {
					this.text.setValue(value);
				} else if (type == "double") {
					this.number.setValue(value);
				} else if (type == "date") {
					this.date.setValue(value);
				}
			}
		},
									
		createNameCondition : function() {
			var nc = {};
			nc.text = this.fieldsCombo.getValue() + FR.ADANALY.getOPString(this.opCombo.getValue()) + this.valuePane.getValue();
			var ct = {};
			ct.columnname = this.fieldsCombo.getValue();
			var compare = {};
			compare.op = this.opCombo.getValue();
			compare.type = this.valuePane.getType();
			compare.value = this.valuePane.getValue();
			ct.compare = compare;
			nc.value = ct;
			return nc;
		},
		
		addNameCondition : function() {
			var nc = this.createNameCondition();
			FR.ADANALY.addNameCondition(nc);
		},
		
		editNameCondition : function() {
			var nc = this.createNameCondition();
			FR.ADANALY.editNameCondition(nc);
		},
		
		popNameCondition : function(nc) {
			if (!this.content) {
				this._init();
			}
			nc = nc == null ? null : nc.value;
			var columnname = nc == null ? null : nc.columnname;
			var compare = nc == null ? null : nc.compare;
			if (columnname != null) {
				this.fieldsCombo.setValue(columnname);
			} else {
				this.fieldsCombo.setValue('');
			}
			if (compare == null) {
				this.opCombo.setValue('');
				this.typeCombo.setValue('');
				this.valuePane.setTypeAndValue('', null);
			} else {
				if (compare.op != null) {
					this.opCombo.setValue(compare.op);
				} else {
					this.opCombo.setValue(-1);
				}
				this.typeCombo.setValue(compare.type);
				this.valuePane.setTypeAndValue(compare.type, compare.value);
			}
		},
		
		removeNameCondition : function() {
			FR.ADANALY.removeNameCondition();
		}
	},
	
	getOPString : function(op) {
		var items = this.filterFace.opData();
		var compare;
		$.each(items, function(idx, item){
			if(item.value === op) {
				compare = item.text;
				return false;
			}
		})
		return compare;
	},
	
	addNameCondition : function(nc) {
		this.$conditionlist.addSimpleData(nc);
		FR.ADANALY.viewReport();
	},
	
	popCondition : function (item) {
		this.$conditionlist.popData(item)
	},
	
	clearCondition : function () {
		this.$conditionlist.clear();
	},
	
	editNameCondition : function(nc) {
		this.$conditionlist.editItem(nc);
		FR.ADANALY.viewReport();
	},
	
	removeNameCondition : function() {
		this.$conditionlist.removeSelectedItem();
		FR.ADANALY.viewReport();
	},
	
	getConditions : function() {
		var data = this.$conditionlist.getAll();
		var cs = [];
		for (var i = 0, len = data.length; i < len; i++) {
			cs.push(data[i].value);
		}
		return cs;
	},
	
	showAdanalySaveDialog : function(config){
		this.adanalyDialog = this._initDialog(this.adanalyDialog, config);
	},
	
	showAdanalyFormatDialog : function(config){
		this.adanalyDialog_format = this._initDialog(this.adanalyDialog_format, config)
	},
	
	showAdanalyChartDialog : function(config){
		this.adanalyDialog_chart = this._initDialog(this.adanalyDialog_chart, config)
	},
	
	showAdanalyCalDialog : function(config){
		this.adanalyDialog_cal = this._initDialog(this.adanalyDialog_cal, config)
	},
	
	showAdanalyConditionDialog : function(config){
		this.adanalyDialog_condition = this._initDialog(this.adanalyDialog_condition, config)
	},
	
	_initDialog : function (dialog, config) {
        dialog = new FR.Dialog(config);
        dialog.setVisible(true);
		return dialog;
	}
	
	
});

function UndoRedoManager (times){
	this.reports = [];
	this.times = times;
	this.index = -1;
	this.push = function(item){
		while(this.canRedo()) {
			this.reports.pop();
		}
		this.reports.push(item);
		if (this.reports.length > this.times){
			this.reports.shift();
		}
		this.index = this.reports.length -1;
	}
	this.canRedo = function(){
		return this.index < this.times - 1 && this.index < this.reports.length - 1;
	}
	this.canUndo = function () {
		return this.index > 0;
	}
	this.undo = function(){
		if(this.canUndo()){
			this.index--;
			FR.ADANALY.pop(this.reports[this.index]);
			FR.ADANALY.viewReport(this.reports[this.index]);
		}
	}
	this.redo = function(){
		if(this.canRedo()){
			this.index++;
			FR.ADANALY.pop(this.reports[this.index]);
			FR.ADANALY.viewReport(this.reports[this.index]);
		}
	}
	var self = this;
	//ctrl-z && crtl-y
	//һ⣬ʱֵ֧ĺ
//	$(window).keydown(function(e){
//		if(e.ctrlKey){
//			//z-Z
//			if(e.keyCode == 90 ){
//				self.undo();
//			//y-Y
//			} else if(e.keyCode == 89) {
//				self.redo();
//			}
//		}
//	})
};
	
function _ToolbarButton (item, hover, click){
	this._item = item;
	this._hover = hover;
	this._click = click;
	this.getItem = function(){
		return this._item;
	}
	this.getHover = function(){
		return this._hover;
	}
	this.getClick = function(){
		return this._click;
	}
};
/**
 * Сť
 */
function ToolbarButton (item){
	this.left = new _ToolbarButton(item,
			"fr-adanaly-toolbar-button-box-bg-hover-small",
			"fr-adanaly-toolbar-button-click-small");
	var self = this;
	this.setEnabled = function(enabled) {
		item.addClass(enabled ? "ui-state-enabled" : "ui-state-disabled")
						.removeClass(enabled ? "ui-state-disabled" : "ui-state-enabled");
	};
	
	this.on = function (event, fn){
		item.unbind(event).bind(event, fn);
	};
	this.show = function () {
		item.show();
	};
	this.hide = function () {
		item.hide();
	};
	
	this.setValue = function (value) {
		if(value || value === 0) {
			item.val(value)
		}
	};
	
	this.getValue = function(){
		return item.val();
	};	
};
/**
 * ť(ͷ)
 */

function ToolbarPopButton(item, pop){
	this.left = new _ToolbarButton(item,
			"fr-adanaly-toolbar-button-box-bg-hover-big",
			"fr-adanaly-toolbar-button-click-big");
	this.pop = pop;
	this.pop.css('left', (item.offset().left - 320 -1)+"px");
	var self = this;
	this._popMenu = function(){
		if (!item.hasClass("ui-state-disabled")) {
			self.pop.show();
			item.addClass("fr-adanaly-toolbar-menu-popup");
			$(document).bind('mousedown', this.pop_mouse_hide);
			$($('iframe')[0].contentWindow.document).bind('mousedown', this.pop_mouse_hide);
		}
	};
	this.pop_hide = function (e){
		self.pop.hide();
		item.removeClass("fr-adanaly-toolbar-menu-popup");
		$(document).unbind('mousedown', self.pop_mouse_hide);
		$($('iframe')[0].contentWindow.document).unbind('mousedown', self.pop_mouse_hide);
		if(e)
			e.stopEvent();
	}
	this.pop_mouse_hide = function(e) {
				var src = $(e.target);
				if (src.parent(pop.selector).length <= 0
					&& src.parent().parent(pop.selector).length <= 0 
					&& !src.hasClass("fr-adanaly-showhide")
					&& !src.hasClass("fr-adanaly-toolbar-showhide-icon")) {
					self.pop_hide();
				}
	};

	this._setSelected = function (value) {
		var list = $(".fr-adanaly-pop-li", pop);
		$.each(list, function(idx, item){
			$(item).removeClass("fr-adanaly-pop-drop-selected");
			if (idx == value) {
				$(item).addClass("fr-adanaly-pop-drop-selected");
			}
		});
	}
	this.setEnabled = function(enabled) {
		item.addClass(enabled ? "ui-state-enabled" : "ui-state-disabled")
						.removeClass(enabled ? "ui-state-disabled" : "ui-state-enabled");
	};
	this.on = function (event, fn){
		item.unbind(event).bind(event, fn);
	};
	this.setValue = function(value) {
		if(value || value === 0) {
			item.val(value);
			if(this.valueField){
				this.valueField.css('background', value);
			}
			if(this.colorinput){
				this.colorinput.val(value);
				this.colorinput.trigger('keyup');
			}
			item.trigger('change');
			this._setSelected(value);
		}
	};
	this.getValue = function(){
		return item.val();
	};
	var self = this;
	this.on('click', function(e){
		self._popMenu();
	});
};

/**
 * ͷĵʽť
 */
function ToolbarClickAndPopButton (leftItem, rightItem, pop, leftIcon) {
	this.left  = new _ToolbarButton(leftItem, "fr-adanaly-toolbar-button-box-bg-hover-left",
					"fr-adanaly-toolbar-button-click-left");
	this.right = new _ToolbarButton(rightItem, "fr-adanaly-toolbar-button-box-bg-hover-right",
		 			"fr-adanaly-toolbar-button-click-right");
	this.pop = pop;
	this.leftIcon = leftIcon;
	this.pop.css('left', (rightItem.offset().left - 320 -1)+"px");
	var self = this;
	this._popMenu = function(){
		if (!rightItem.hasClass("ui-state-disabled")) {
			self.pop.show();
			rightItem.addClass("fr-adanaly-toolbar-menu-popup");
			$(document).bind('mousedown', this.pop_mouse_hide);
			$($('iframe')[0].contentWindow.document).bind('mousedown', this.pop_mouse_hide);
		}
	};
	this.pop_hide = function (e){
		self.pop.hide();
		rightItem.removeClass("fr-adanaly-toolbar-menu-popup");
		$(document).unbind('mousedown', self.pop_mouse_hide);
		$($('iframe')[0].contentWindow.document).unbind('mousedown', self.pop_mouse_hide);
		if(e)
			e.stopEvent();
	}
	this.pop_mouse_hide = function(e) {
				var src = $(e.target);
				if (src.parent(pop.selector).length <= 0 
					&& src.parent().parent(pop.selector).length <= 0 
					&& !src.hasClass("fr-adanaly-showhide")
					&& !src.hasClass("fr-adanaly-toolbar-showhide-icon")) {
					self.pop_hide();
				}
	};
	this.setEnabled = function(enabled) {
		leftItem.addClass(enabled ? "ui-state-enabled" : "ui-state-disabled")
						.removeClass(enabled? "ui-state-disabled" : "ui-state-enabled");
		rightItem.addClass(enabled ? "ui-state-enabled" : "ui-state-disabled")
						.removeClass(enabled? "ui-state-disabled" : "ui-state-enabled");
	};
	
	this.setValue = function(value){
		//color
		if (value  || value === 0)
			if(value.position) {
				leftIcon.css("background-position", value.position)
				leftIcon.val(value.value);			
			} else {
				leftIcon.css("border-color", value);
				leftIcon.val(value);
			}
			if(this.colorinput){
				this.colorinput.val(value);
				this.colorinput.trigger('keyup');
			}
	};
	
	this.getValue = function() {
		return leftIcon.val();
	};
	
	this.on = function (event, fn){
		leftItem.unbind(event).bind(event, fn);
	}
	this.onPopup = function (event, fn){
		rightItem.unbind(event).bind(event, fn);
	}
	
	var self = this;
	this.onPopup('click', function(e){
		self._popMenu();
	});
};
/**
 * 
 */
 function DropDownList(valueField, button, pop){
 	this.valueField = valueField;
 	this.button = button;
 	this.pop = pop;
 	this.pop.css('left', (valueField.offset().left - 320 - 2)+"px");
	var self = this;
	this._popMenu = function(){
		self.pop.show();
		$(document).bind('mousedown', this.pop_mouse_hide);
		$($('iframe')[0].contentWindow.document).bind('mousedown', this.pop_mouse_hide);
	};
	this.pop_hide = function (e){
		self.pop.hide();
		$(document).unbind('mousedown', self.pop_mouse_hide);
		$($('iframe')[0].contentWindow.document).unbind('mousedown', self.pop_mouse_hide);
		if(e)
			e.stopEvent();
	}
	this.pop_mouse_hide = function(e) {
				var src = $(e.target);
				if (src.parent(pop.selector).length <= 0
					&& src.parent().parent(pop.selector).length <= 0 
					&& !src.hasClass("fr-adanaly-showhide")
					&& !src.hasClass("fr-adanaly-toolbar-showhide-icon")) {
					self.pop_hide();
				}
	};
	this._setSelected = function(value){
		var list = $(".fr-adanaly-pop-li", pop);
		$.each(list, function(idx, item){
			$(item).removeClass("fr-adanaly-pop-drop-selected");
			if($(item).html() == value) {
				$(item).addClass("fr-adanaly-pop-drop-selected");
			}
		});
	};
 	this.setValue = function (value) {
 		if (value) {
	 		valueField.html(value);
	 		valueField.val(value);
	 		this._setSelected(value);
 		}
 	};
 	this.getValue = function() {
 		valueFiled.val();
 	};
 	this.on = function(event, fn){
 		button.unbind(event).bind(event, fn);
 	}
 	var self = this;
	this.on('click', function(e){
		self._popMenu();
	});
 	
 };

function Board() {
	var P = {
		colIdx : -1,
		$table : null,
		
		_init : function(idx, $el) {
			this.colIdx = idx;
			this.$table = $('tbody:eq(0)', $el);
			var self = this;
			$el.droppable({
				accept: ".fr-adanaly-draggable",
				drop: function( event, ui ) {
					var colIdx = ui.draggable.attr('colIdx');

					if (colIdx != self.colIdx + '') {
						if ($.browser.msie) {
							ui.draggable.attr('old', 0);
//							self.clearOldColumnData();
						}
						
						var text = ui.draggable.attr('text');
						
						self.addColumn(ui.draggable);
						ui.draggable.remove();
						
						if (colIdx == '0') {
							FR.ADANALY.viewReport();
						}
					}
				}
			}).sortable({
				items: "tr.fr-adanaly-draggable",
				appendTo : 'body',
				helper : 'clone',
				stop : function() {
					self.clearOldColumnData();
					FR.ADANALY.viewReport();
				}
			}).disableSelection();
		},
		
		clearOldColumnData : function() {
			if ($.browser.msie) {
				$.each($('tr[old]', this.$table), function(idx, item){
					$(item).remove();
				});
			}
		},
		
		popColumn : function($tr, par) {
			this.addColumn($tr, par);
			$tr.remove();
		},
		
		addColumn : function($col, par) {
			if ($col == null || $col.length == 0) return;
//			$col.attr('colIdx', this.colIdx);
//			if (this.isExist($col.attr('text'))) {
//				return;
//			}
			
			var tr = this.generateColumnTR($col, par);
			this.$table.append(tr);
		},
		
		isExist : function(colName) {
			$.each(this.$table.children('tr'), function(idx, item){
				if ($(item).attr('text') == colName) return true;
			});
			return false;
		},
		
//		removeColumn : function(colName) {
//			var i = 0;
//			for (var len = this.columns.length; i < len; i++) {
//				if (colName == this.columns[i].columnname) {
//					break;
//				}
//			}
//			this.columns.splice(i, 1);
//			this.columnTRs.splice(i, 1);
//			this.$table.empty();
//			for (var d = 0, len = this.columnTRs.length; d < len; d++) {
//				this.$table.append(this.columnTRs[d]);
//			}
//		},

		clearColumn : function(){
			this.$table.empty();
		},
		
		generateColumnTR : function($col, par) {
			var $td;
			if ($col.children('td').length > 1) {
				$td = $col.children('td:eq(1)');
			} else {
				$td = $col.children('td:eq(0)');
			}
			var $tr = $('<tr/>');
			var groupCombo = $('<div/>');
			var combobox = null;
			var listener = {};
			listener.eventName = FR.Events.AFTEREDIT;
			listener.action = function() {
				var sval = combobox.getValue();
				if ($tr.attr('sval') != sval + "") {
					$tr.attr('sval', combobox.getValue());
					FR.ADANALY.viewReport();
				}
			};
			var config = {
				type : "combo",
				width : 80,
				height : 20,
				popupWidth : 60,
				editable : false,
				allowBlank : false,
				mode: 'local',
				listeners : [listener]
			};	
			var isNumber = ($col.attr("isNumber") == 'true')
			config.items = this.createData(isNumber);
			combobox = groupCombo.asComponent(config);
			
			var ctd = $('<td/>').append(groupCombo);
			
			this.initCombobox(combobox, $tr, par, isNumber);
			
			FR.ADANALY.createDraggableTR($tr, $col.attr('val'), $col.attr('text'), $col.attr('isNumber'));
			$tr.attr('colIdx', this.colIdx);
			return $tr.append(ctd).append($td);
		},
		
		initCombobox : function(combobox, $tr, par, isNumber) {
			if (par != null) {
				combobox.setValue(par);
				$tr.attr('sval', par);
			} else {
				combobox.setValue(0);
			}
		},
		
		createData : function() {
			var data = [];
			data.push({text: '', value: 0});
			//ʱûз鲻
//			data.push({text: '鲻', value: 1});
			data.push({text: 'б', value: 2});
			return data;
		},
		
		getColumns : function() {
			var columns = [];
			$.each($('tr[text]', this.$table), function(idx, item){
				var $item = $(item);
				if ($item.attr('old') == null) {
					var sval = $item.attr('sval');
					columns.push({columnname : $item.attr("text"), groupStyle : (sval == null ? 0 : parseInt(sval))});
				}
			});
			
			return columns;
		}
	}
	
	return P;
}

function SummaryBoard() {
	this.initCombobox = function(combobox, $tr, par, isNumber) {
		if (par == null) {
			if (isNumber) {
				par = "sum";
			} else {
				par = "count"
			}
		}
		combobox.setValue(par);
		$tr.attr('sval', par);
	};
		
	this.createData = function(isNumber) {
		var data = [];
		if (isNumber) {
			data.push({text: FR.i18nText("DataFunction-Sum"), value: 'sum'});
			data.push({text: FR.i18nText("DataFunction-Average"), value: 'ave'});
			data.push({text: FR.i18nText("DataFunction-Max"), value: 'max'});
			data.push({text: FR.i18nText("DataFunction-Min"), value: 'min'});
		}
		data.push({text: FR.i18nText("DataFunction-Count"), value: 'count'});
		return data;
	};
	
	this.getColumns =  function() {
		var columns = [];
		$.each($('tr[text]', this.$table), function(idx, item){
			var $item = $(item);
			if ($item.attr('old') == null) {
				var sval = $item.attr('sval');
				columns.push({columnname : $item.attr("text"), funname : (sval == null ? 'sum' : sval)});
			}
		});
		
		return columns;
	}
}
SummaryBoard.prototype = new Board();
