/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write.web.excel;

import com.fr.base.ExcelUtils;
import com.fr.base.Utils;
import com.fr.io.importer.ExcelReportImporter;
import com.fr.main.TemplateWorkBook;
import com.fr.stable.StringUtils;
import com.fr.web.core.upload.SmartFile;
import com.fr.web.core.upload.SmartFiles;
import com.fr.web.core.upload.SmartUpload;
import com.fr.web.utils.WebUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebExcelUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemplateWorkBook dealWithUploadExcel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) throws Exception {
        int n2;
        ServletContext servletContext = httpServletRequest.getSession().getServletContext();
        SmartUpload smartUpload = new SmartUpload();
        smartUpload.initialize(servletContext, httpServletRequest, httpServletResponse);
        smartUpload.upload();
        SmartFiles smartFiles = smartUpload.getFiles();
        if (smartFiles.getSize() == 0L) {
            return null;
        }
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "fileIndex");
        int n3 = n2 = string == null ? 0 : Integer.parseInt(Utils.objectToString(string));
        if (n2 < 0 || (long)n2 >= smartFiles.getSize()) {
            n2 = 0;
        }
        SmartFile smartFile = smartFiles.getFile(n2);
        String string2 = smartFile.getContentType();
        ByteArrayInputStream byteArrayInputStream = null;
        TemplateWorkBook templateWorkBook = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(smartFile.getBytes());
            if (StringUtils.isBlank(string2)) {
                throw new ExcelUploadException("typewrong");
            }
            String string3 = smartFile.getFileName().toLowerCase();
            if (string3.endsWith(".xls") || string3.endsWith(".et")) {
                templateWorkBook = new ExcelReportImporter().generateWorkBookByStream(byteArrayInputStream, map);
            } else if (string3.endsWith(".xlsx")) {
                ExcelUtils.checkPOI();
                Class<?> clazz = Class.forName("com.fr.io.importer.Excel2007ReportImporter");
                templateWorkBook = (TemplateWorkBook)clazz.getMethod("generateWorkBookByStream", InputStream.class, Map.class).invoke(clazz.newInstance(), byteArrayInputStream, map);
            }
        }
        finally {
            if (byteArrayInputStream != null) {
                ((InputStream)byteArrayInputStream).close();
            }
        }
        return templateWorkBook;
    }

    public static TemplateWorkBook dealWithUploadExcel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        return WebExcelUtils.dealWithUploadExcel(httpServletRequest, httpServletResponse, new HashMap());
    }

    public static class ExcelUploadException
    extends Exception {
        private ExcelUploadException(String string) {
            super(string);
        }
    }
}

