/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write.web.chwriter;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.present.Present;
import com.fr.form.ui.NameWidget;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetManager;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.WriteCellElement;
import com.fr.report.worksheet.CalculatableReport;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.web.Repository;
import com.fr.web.core.chwriter.EditableCellWriter;
import com.fr.web.core.chwriter.HtmlWriteCellBox;

public class WriteCellWriter
extends EditableCellWriter {
    public WriteCellWriter(Repository repository, int n2, CalculatableReport calculatableReport) {
        super(repository, n2, calculatableReport);
    }

    private static String generateTdPositionAttr(ColumnRow[] columnRowArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < columnRowArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append('-');
            }
            stringBuffer.append(columnRowArray[i2] + "-" + n2);
        }
        return stringBuffer.toString();
    }

    protected boolean isVisible(HtmlWriteCellBox htmlWriteCellBox) {
        WriteCellElement writeCellElement = (WriteCellElement)htmlWriteCellBox.getCell();
        if (writeCellElement.isDel()) {
            this.resTag.cls("del");
            return false;
        }
        return super.isVisible(htmlWriteCellBox);
    }

    protected boolean shouldDrawBackground(HtmlWriteCellBox htmlWriteCellBox) {
        return this.isVisible(htmlWriteCellBox);
    }

    protected Object getDisplayValue(CellElement cellElement, Object object) {
        if (this.cellGUIAttr.isPreviewContent() && ((WriteCellElement)cellElement).getPresent() != null) {
            return ((WriteCellElement)cellElement).getShowValue();
        }
        return super.getDisplayValue(cellElement, object);
    }

    protected Widget getWidgetOfCell(CellElement cellElement) {
        return ((WriteCellElement)cellElement).getWidget();
    }

    protected void processWidget(CellElement cellElement, Widget widget, Object object, ColumnRow columnRow, Calculator calculator) {
        if (this.repo.getBrowser().isMobile() && !widget.supportMobile()) {
            return;
        }
        this.resTag.attr("widgetWidth", this.cellWidth + "");
        this.resTag.attr("widgetHeight", this.cellHeight + "");
        this.resTag.css("padding-left", "0").css("padding-right", "0");
        try {
            JSONObject jSONObject = this.widget2ConfigWithJSONStyle(widget, object, columnRow, (WriteCellElement)cellElement, this.reportIndex, null, calculator);
            String string = jSONObject.toString();
            if (widget instanceof NameWidget) {
                widget = WidgetManager.getInstance().getWidgetConfig(((NameWidget)widget).getName()).toWidget();
            }
            if (widget.isEditor()) {
                this.resTag.attr("editor", string);
            } else {
                this.resTag.attr("widget", string);
            }
            this.addHasAttr(jSONObject);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
    }

    private void addHasAttr(JSONObject jSONObject) {
        if (jSONObject.has("dependenceMap") || jSONObject.has("dependence")) {
            this.resTag.attr("hasDependece", "true");
        }
        if (jSONObject.has("watermark")) {
            this.resTag.attr("hasWatermark", "true");
        }
        if (jSONObject.has("attachment")) {
            this.resTag.attr("hasAttachment", "true");
        }
    }

    protected void processOtherAttributes(HtmlWriteCellBox htmlWriteCellBox) {
        Present present;
        super.processOtherAttributes(htmlWriteCellBox);
        WriteCellElement writeCellElement = (WriteCellElement)htmlWriteCellBox.getCell();
        ColumnRow[] columnRowArray = htmlWriteCellBox.getHtmlID();
        if (columnRowArray != null) {
            this.resTag.attr("position", WriteCellWriter.generateTdPositionAttr(columnRowArray, this.reportIndex));
        }
        if ((present = writeCellElement.getPresent()) != null) {
            this.resTag.cls("presentable");
        }
    }

    public boolean skipValueWrapper(CellElement cellElement) {
        return this.getWidgetOfCell(cellElement) != null && !this.getWidgetOfCell(cellElement).isEditor();
    }

    public int getHeightOfValueWrapper(HtmlWriteCellBox htmlWriteCellBox) {
        return this.cellHeight - (BaseUtils.getBorderWidth(htmlWriteCellBox.getCell().getStyle().getBorderTop()) + BaseUtils.getBorderWidth(htmlWriteCellBox.getCell().getStyle().getBorderBottom()) + 1) / 2;
    }
}

