/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.platform.dataModel;

import com.fr.general.DateUtils;
import com.fr.general.Inter;
import com.fr.general.VT4FR;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.web.platform.dataModel.PlatFormData;
import com.fr.web.platform.dataModel.ServerDataModel;
import java.io.ByteArrayOutputStream;
import java.util.Date;

public class RegInforDataModel
extends ServerDataModel {
    protected void loadData(PlatFormData platFormData) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        byte[] byArray = StableUtils.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            StableUtils.decode(byArray, byteArrayOutputStream);
            jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jSONObject.has("DEADLINE")) {
            platFormData.put("Registered", Inter.getLocText("Yes"));
            if (jSONObject.has("VERSION")) {
                platFormData.put("LicVersion", jSONObject.get("VERSION"));
            } else {
                platFormData.put("LicVersion", Inter.getLocText("DataFunction-None"));
            }
            platFormData.put("Concurrency", jSONObject.get("CONCURRENCY"));
            String string = "Temporary License";
            if (!jSONObject.has("MACADDRESS")) {
                string = "Mac Address Bindless";
            } else if (jSONObject.has("MACADDRESS")) {
                string = jSONObject.getString("MACADDRESS");
            }
            platFormData.put("MACAddress", string);
            if (jSONObject.has("SERIALNUMBER")) {
                platFormData.put("LockSerial", jSONObject.get("SERIALNUMBER"));
            } else {
                platFormData.put("LockSerial", Inter.getLocText("DataFunction-None"));
            }
            Date date = new Date(jSONObject.getLong("DEADLINE"));
            if (DateUtils.subtractDate(date, new Date(), "d") < 365L) {
                platFormData.put("OverdueDate", date);
                platFormData.put("FormalRegistered", "false");
            } else {
                platFormData.put("FormalRegistered", Inter.getLocText("Yes"));
                platFormData.put("OverdueDate", Inter.getLocText("DataFunction-None"));
            }
            platFormData.put("edition", VT4FR.getEditionByFunc());
        } else {
            platFormData.put("Registered", Inter.getLocText("No"));
            platFormData.put("LicVersion", Inter.getLocText("DataFunction-None"));
            platFormData.put("FormalRegistered", Inter.getLocText("No"));
            platFormData.put("OverdueDate", Inter.getLocText("DataFunction-None"));
            platFormData.put("MACAddress", Inter.getLocText("DataFunction-None"));
            platFormData.put("LockSerial", Inter.getLocText("DataFunction-None"));
            platFormData.put("Concurrency", "5");
            platFormData.put("edition", Inter.getLocText("DataFunction-None"));
        }
    }

    protected void store(PlatFormData platFormData) throws Exception {
    }
}

