/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.platform.dataModel;

import com.fr.base.FRContext;
import com.fr.general.ComparatorUtils;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.providers.AuthenticationProvider;
import com.fr.privilege.providers.dao.ClassPasswordValidator;
import com.fr.privilege.providers.dao.DaoAuthenticationProvider;
import com.fr.privilege.providers.dao.MessageDigestPasswordValidator;
import com.fr.privilege.providers.dao.PasswordValidator;
import com.fr.stable.StringUtils;
import com.fr.web.platform.dataModel.PlatFormData;
import com.fr.web.platform.dataModel.ProviderDataModel;
import java.util.logging.Level;

public class ProviderDaoDataModel
extends ProviderDataModel {
    protected void loadProviderData(PlatFormData platFormData, AuthenticationProvider authenticationProvider) {
        DaoAuthenticationProvider daoAuthenticationProvider = null;
        if (authenticationProvider instanceof DaoAuthenticationProvider) {
            daoAuthenticationProvider = (DaoAuthenticationProvider)authenticationProvider;
        }
        platFormData.put("ptabledata", daoAuthenticationProvider == null ? null : daoAuthenticationProvider.getUserConfig().tableDataName);
        platFormData.put("pname", daoAuthenticationProvider == null ? null : daoAuthenticationProvider.getUserConfig().usernameField);
        platFormData.put("password", daoAuthenticationProvider == null ? null : daoAuthenticationProvider.getUserConfig().authenticationField);
        if (daoAuthenticationProvider == null || daoAuthenticationProvider.getRoleConfig() == null) {
            platFormData.put("rtabledata", null);
            platFormData.put("rname", null);
            platFormData.put("role", null);
        } else {
            platFormData.put("rtabledata", daoAuthenticationProvider.getRoleConfig().tableDataName);
            platFormData.put("rname", daoAuthenticationProvider.getRoleConfig().usernameField);
            platFormData.put("role", daoAuthenticationProvider.getRoleConfig().authenticationField);
        }
        if (daoAuthenticationProvider == null) {
            platFormData.put("pwValidator", null);
            platFormData.put("pwvclassname", null);
        } else if (daoAuthenticationProvider.getPasswordValidator() instanceof ClassPasswordValidator) {
            ClassPasswordValidator classPasswordValidator = (ClassPasswordValidator)daoAuthenticationProvider.getPasswordValidator();
            platFormData.put("pwvclassname", classPasswordValidator.getClassName());
            platFormData.put("pwValidator", 1);
        } else if (daoAuthenticationProvider.getPasswordValidator() instanceof MessageDigestPasswordValidator) {
            platFormData.put("pwValidator", 2);
            platFormData.put("pwvclassname", null);
        } else {
            platFormData.put("pwValidator", 0);
            platFormData.put("pwvclassname", null);
        }
    }

    protected void store(PlatFormData platFormData) throws Exception {
        PasswordValidator passwordValidator;
        PrivilegeManager privilegeManager = PrivilegeManager.getInstance();
        DaoAuthenticationProvider daoAuthenticationProvider = new DaoAuthenticationProvider();
        if (this.isValidPassAndUser(platFormData)) {
            FRContext.getLogger().log(Level.INFO, "Username And Password are both needed.");
            daoAuthenticationProvider.setUserConfig(null);
        } else {
            daoAuthenticationProvider.setUserConfig(new DaoAuthenticationProvider.UserConfig(platFormData.getString("ptabledata"), platFormData.getString("pname"), platFormData.getString("password")));
        }
        if (this.isValidRoleAndUser(platFormData)) {
            FRContext.getLogger().log(Level.INFO, "Username And Rolename are both needed.");
            daoAuthenticationProvider.setRoleConfig(null);
        } else {
            daoAuthenticationProvider.setRoleConfig(new DaoAuthenticationProvider.RoleConfig(platFormData.getString("rtabledata"), platFormData.getString("rname"), platFormData.getString("role")));
        }
        switch (ComparatorUtils.equals(platFormData.getData("pwValidator"), "") ? 0 : platFormData.getInt("pwValidator")) {
            case 1: {
                passwordValidator = new ClassPasswordValidator();
                ((ClassPasswordValidator)passwordValidator).setClassName(platFormData.getString("pwvclassname"));
                break;
            }
            case 2: {
                passwordValidator = MessageDigestPasswordValidator.MD5_PASSWORD_VALIDATOR;
                break;
            }
            default: {
                passwordValidator = PasswordValidator.EMPTY_PASSWORD_VALIDATOR;
            }
        }
        daoAuthenticationProvider.setPasswordValidator(passwordValidator);
        privilegeManager.setAuthenticationProvider(daoAuthenticationProvider);
        FRContext.getCurrentEnv().writeResource(PrivilegeManager.getInstance());
    }

    private boolean isValidPassAndUser(PlatFormData platFormData) throws Exception {
        return StringUtils.isEmpty(platFormData.getString("ptabledata")) || StringUtils.isEmpty(platFormData.getString("pname")) || StringUtils.isEmpty(platFormData.getString("password"));
    }

    private boolean isValidRoleAndUser(PlatFormData platFormData) throws Exception {
        return StringUtils.isEmpty(platFormData.getString("rtabledata")) || StringUtils.isEmpty(platFormData.getString("rname")) || StringUtils.isEmpty(platFormData.getString("role"));
    }
}

