/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.platform.dataModel;

import com.fr.base.FRContext;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONException;
import com.fr.web.platform.dataModel.FormSubmitJob;
import com.fr.web.platform.dataModel.PlatFormData;

public abstract class AbstractPlatformDataModel
implements DataModel,
FormSubmitJob {
    private PlatFormData formdata = new PlatFormData();

    public AbstractPlatformDataModel() {
        try {
            this.loadData(this.formdata);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
    }

    protected abstract void loadData(PlatFormData var1) throws JSONException;

    public void release() throws Exception {
    }

    public int getRowCount() throws TableDataException {
        return 1;
    }

    public boolean hasRow(int n2) throws TableDataException {
        return n2 == 0;
    }

    public int getColumnCount() throws TableDataException {
        return this.formdata.size();
    }

    public String getColumnName(int n2) throws TableDataException {
        return this.formdata.getNameIndex(n2);
    }

    public Object getValueAt(int n2, int n3) throws TableDataException {
        if (n2 != 0) {
            return null;
        }
        try {
            return this.formdata.getDataIndex(n3);
        }
        catch (Exception exception) {
            throw new TableDataException(exception.getMessage(), exception.getCause());
        }
    }

    public void setValueAt(int n2, int n3, Object object) throws TableDataException {
        if (n2 != 0) {
            return;
        }
        this.formdata.setValueIndex(n3, object);
    }

    public void store() throws Exception {
        this.store(this.formdata);
    }

    protected abstract void store(PlatFormData var1) throws Exception;
}

