/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.upload;

import com.fr.web.core.upload.SmartUpload;
import com.fr.web.core.upload.SmartUploadException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.servlet.ServletException;

public class SmartFile {
    private SmartUpload m_parent;
    private int m_startData = 0;
    private int m_endData = 0;
    private int m_size = 0;
    private String m_fieldname = "";
    private String m_filename = "";
    private String m_fileExt = "";
    private String m_filePathName = "";
    private String m_contentType = "";
    private String m_contentDisp = "";
    private String m_typeMime = "";
    private String m_subTypeMime = "";
    private boolean m_isMissing = true;
    public static final int SAVEAS_AUTO = 0;
    public static final int SAVEAS_VIRTUAL = 1;
    public static final int SAVEAS_PHYSICAL = 2;

    SmartFile() {
    }

    public void saveAs(String string) throws IOException, SmartUploadException {
        this.saveAs(string, 0);
    }

    public void saveAs(String string, int n2) throws IOException, SmartUploadException {
        String string2 = "";
        string2 = this.m_parent.getPhysicalPath(string, n2);
        if (string2 == null) {
            throw new IllegalArgumentException("There is no specified destination file (1140).");
        }
        try {
            File file = new File(string2);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.m_parent.m_binArray, this.m_startData, this.m_size);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new SmartUploadException("File can't be saved (1120).");
        }
    }

    public void fileToField(ResultSet resultSet, String string) throws ServletException, IOException, SmartUploadException, SQLException {
        long l2 = 0L;
        int n2 = 65536;
        int n3 = 0;
        int n4 = this.m_startData;
        if (resultSet == null) {
            throw new IllegalArgumentException("The RecordSet cannot be null (1145).");
        }
        if (string == null) {
            throw new IllegalArgumentException("The columnName cannot be null (1150).");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The columnName cannot be empty (1155).");
        }
        l2 = BigInteger.valueOf(this.m_size).divide(BigInteger.valueOf(n2)).longValue();
        n3 = BigInteger.valueOf(this.m_size).mod(BigInteger.valueOf(n2)).intValue();
        try {
            int n5 = 1;
            while ((long)n5 < l2) {
                resultSet.updateBinaryStream(string, (InputStream)new ByteArrayInputStream(this.m_parent.m_binArray, n4, n2), n2);
                n4 = n4 != 0 ? n4 : 1;
                n4 = n5 * n2 + this.m_startData;
                ++n5;
            }
            if (n3 > 0) {
                resultSet.updateBinaryStream(string, (InputStream)new ByteArrayInputStream(this.m_parent.m_binArray, n4, n3), n3);
            }
        }
        catch (SQLException sQLException) {
            byte[] byArray = new byte[this.m_size];
            System.arraycopy(this.m_parent.m_binArray, this.m_startData, byArray, 0, this.m_size);
            resultSet.updateBytes(string, byArray);
        }
        catch (Exception exception) {
            throw new SmartUploadException("Unable to save file in the DataBase (1130).");
        }
    }

    public boolean isMissing() {
        return this.m_isMissing;
    }

    public String getFieldName() {
        return this.m_fieldname;
    }

    public String getFileName() {
        return this.m_filename;
    }

    public String getFilePathName() {
        return this.m_filePathName;
    }

    public String getFileExt() {
        return this.m_fileExt;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public String getContentDisp() {
        return this.m_contentDisp;
    }

    public String getContentString() {
        String string = new String(this.m_parent.m_binArray, this.m_startData, this.m_size);
        return string;
    }

    public String getTypeMIME() throws IOException {
        return this.m_typeMime;
    }

    public String getSubTypeMIME() {
        return this.m_subTypeMime;
    }

    public int getSize() {
        return this.m_size;
    }

    protected int getStartData() {
        return this.m_startData;
    }

    protected int getEndData() {
        return this.m_endData;
    }

    protected void setParent(SmartUpload smartUpload) {
        this.m_parent = smartUpload;
    }

    protected void setStartData(int n2) {
        this.m_startData = n2;
    }

    protected void setEndData(int n2) {
        this.m_endData = n2;
    }

    protected void setSize(int n2) {
        this.m_size = n2;
    }

    protected void setIsMissing(boolean bl) {
        this.m_isMissing = bl;
    }

    protected void setFieldName(String string) {
        this.m_fieldname = string;
    }

    protected void setFileName(String string) {
        this.m_filename = string;
    }

    protected void setFilePathName(String string) {
        this.m_filePathName = string;
    }

    protected void setFileExt(String string) {
        this.m_fileExt = string;
    }

    protected void setContentType(String string) {
        this.m_contentType = string;
    }

    protected void setContentDisp(String string) {
        this.m_contentDisp = string;
    }

    protected void setTypeMIME(String string) {
        this.m_typeMime = string;
    }

    protected void setSubTypeMIME(String string) {
        this.m_subTypeMime = string;
    }

    public byte getBinaryData(int n2) {
        if (this.m_startData + n2 > this.m_endData) {
            throw new ArrayIndexOutOfBoundsException("Index Out of range (1115).");
        }
        if (this.m_startData + n2 <= this.m_endData) {
            return this.m_parent.m_binArray[this.m_startData + n2];
        }
        return 0;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.m_endData - this.m_startData + 1];
        System.arraycopy(this.m_parent.m_binArray, this.m_startData, byArray, 0, byArray.length);
        return byArray;
    }
}

