/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.reserve;

import com.fr.base.ChartPreStyleServerManager;
import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.data.TableDataSource;
import com.fr.form.main.Form;
import com.fr.general.DeclareRecordType;
import com.fr.general.FRLogManager;
import com.fr.general.FRLogger;
import com.fr.script.Calculator;
import com.fr.stable.web.Weblet;
import com.fr.web.RepositoryDeal;
import com.fr.web.core.FormSessionIDInfor;
import com.fr.web.core.SessionDealWith;
import com.fr.web.utils.WebUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FormletDealWith {
    private static long TEN = 10L;

    private FormletDealWith() {
    }

    public static void dealWithFormlet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Weblet weblet) throws Exception {
        String string = SessionDealWith.generateSessionID(httpServletRequest, httpServletResponse, weblet);
        if (string == null || !SessionDealWith.hasSessionID(string)) {
            return;
        }
        FormletDealWith.dealWithFormHtml(httpServletRequest, httpServletResponse, string);
    }

    private static void dealWithFormHtml(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        long l2 = System.currentTimeMillis();
        FormSessionIDInfor formSessionIDInfor = (FormSessionIDInfor)SessionDealWith.getSessionIDInfor(string);
        if (formSessionIDInfor == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Form form = formSessionIDInfor.getForm2Show();
        Calculator calculator = Calculator.createCalculator();
        calculator.setAttribute(TableDataSource.class, form);
        httpServletResponse.setHeader("Pragma", "No-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store");
        httpServletResponse.setDateHeader("Expires", -TEN);
        RepositoryDeal repositoryDeal = new RepositoryDeal(httpServletRequest, formSessionIDInfor, 96);
        hashMap.put("charset", ConfigManager.getInstance().getServerCharset());
        hashMap.put("formlet_title", formSessionIDInfor.getWebTitle());
        hashMap.put("config", form.createJSONConfig(repositoryDeal, calculator));
        hashMap.put("Baidu", ChartPreStyleServerManager.getInstance().getBaiduSource());
        hashMap.put("Google", ChartPreStyleServerManager.getInstance().getGoogleSource());
        WebUtils.writeOutTemplate("/com/fr/web/core/form.html", httpServletResponse, hashMap);
        long l3 = System.currentTimeMillis();
        if (ConfigManager.getInstance().getLogConfig().isRecordExe4form()) {
            FormletDealWith.formExecuteLogRecord(formSessionIDInfor, l2, l3, hashMap, FRLogManager.getDeclareSQLContent());
        }
    }

    private static void formExecuteLogRecord(FormSessionIDInfor formSessionIDInfor, long l2, long l3, Map map, String string) {
        FRLogManager.setSession(formSessionIDInfor);
        try {
            FRContext.getLogger().getRecordManager().recordExecuteInfo(formSessionIDInfor.getFormPath(), DeclareRecordType.EXECUTE_TYPE_FORM, FRLogger.createParamString(map), l3 - l2, string);
        }
        catch (Throwable throwable) {
            FRContext.getLogger().log(Level.WARNING, throwable.getMessage(), throwable);
            FRContext.getLogger().log(Level.WARNING, "RecordManager error. Record is close.");
        }
    }
}

