/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.reportcase;

import com.fr.base.DynamicPixList;
import com.fr.base.DynamicUnitList;
import com.fr.report.ReportHelper;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.worksheet.AnalysisRWorkSheet;
import com.fr.stable.web.Repository;
import com.fr.web.core.reportcase.AbstractWebReportCase;

public class WebElementReportCase
extends AbstractWebReportCase {
    private DynamicPixList colPixList;
    private DynamicPixList rowPixList;
    private int resolution;
    private int columnWidth;
    private int rowHeight;

    public WebElementReportCase(ElementCase elementCase, Repository repository) {
        super(elementCase);
        DynamicUnitList dynamicUnitList;
        DynamicUnitList dynamicUnitList2;
        if (elementCase instanceof AnalysisRWorkSheet) {
            dynamicUnitList2 = ReportHelper.createColumnWidthList(elementCase);
            dynamicUnitList = ReportHelper.createRowHeightList(elementCase);
            this.colPixList = dynamicUnitList2.toDynamicPixList();
            this.rowPixList = dynamicUnitList.toDynamicPixList();
        } else {
            dynamicUnitList2 = ReportHelper.getColumnWidthList(elementCase);
            dynamicUnitList = ReportHelper.getRowHeightList(elementCase);
            this.colPixList = dynamicUnitList2.toDynamicPixList();
            this.rowPixList = dynamicUnitList.toDynamicPixList();
        }
        this.resolution = repository.getResolution();
        this.columnWidth = dynamicUnitList2.getRangeValue(0, elementCase.getColumnCount()).toPixI(this.resolution);
        this.rowHeight = dynamicUnitList.getRangeValue(0, elementCase.getRowCount()).toPixI(this.resolution);
    }

    public int getColumnPixWidth(int n2) {
        return this.colPixList.get(n2, this.resolution);
    }

    public int getRowPixHeight(int n2) {
        return this.rowPixList.get(n2, this.resolution);
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getColWidth() {
        return this.columnWidth;
    }
}

