/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess;

import com.fr.base.ConfigManager;
import com.fr.base.EmailManager;
import com.fr.base.FRContext;
import com.fr.base.ResultFormula;
import com.fr.base.Style;
import com.fr.base.Utils;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.FArray;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.main.workbook.WriteWorkBook;
import com.fr.report.cell.CellElement;
import com.fr.report.core.A.H;
import com.fr.report.report.WriteECReport;
import com.fr.report.worksheet.CalculatableResWorkSheet;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.web.Browser;
import com.fr.web.core.A.sB;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.core.SessionDealWith;
import com.fr.web.core.process.ProcessUtils;
import com.fr.web.core.process.reportprocess.AlertControl;
import com.fr.web.core.process.reportprocess.AlertToast;
import com.fr.web.core.process.reportprocess.ProcessManager;
import com.fr.web.core.process.reportprocess.ProcessNode;
import com.fr.web.core.process.reportprocess.ProcessOperator;
import com.fr.web.core.process.reportprocess.ProcessTask;
import com.fr.web.core.process.reportprocess.RemindControl;
import com.fr.web.core.process.reportprocess.RemindToast;
import com.fr.web.core.process.reportprocess.ReportControl;
import com.fr.web.core.process.reportprocess.ReportProcess;
import com.fr.web.core.process.reportprocess.dao.AlertToastDAO;
import com.fr.web.core.process.reportprocess.dao.ProcessNodeDAO;
import com.fr.web.core.process.reportprocess.dao.ProcessTaskDAO;
import com.fr.web.core.process.reportprocess.dao.ProcessTaskImplDAO;
import com.fr.web.core.process.reportprocess.dao.RemindToastDAO;
import com.fr.web.core.process.reportprocess.dao.ReportProcessDAO;
import com.fr.web.core.process.reportprocess.dao.StashDataDAO;
import com.fr.web.core.utils.ExportUtils;
import com.fr.web.platform.SystemToast;
import com.fr.write.core.cal.BCE_WRITE;
import com.fr.write.io.exporter.WriteHTMLExporter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessTaskImpl {
    public static final String TASK_ID = "taskId";
    public static final String PROCESS_ID = "processId";
    public static final String CURRENT_NODE_IDX = "currentNodeIdx";
    public static final String OPERATOR_JSON = "operatorJSON";
    public static final String REPORT_OFFSET = "reportOffset";
    public static final String OPERATOR_OFFSET = "operatorOffset";
    public static final String OPERATOR_OFFSET_NAME = "operatorOffsetName";
    public static final String NEED_ALL_COMPLETE = "needAllComplete";
    public static final String COMPLETE_STATE = "completeState";
    public static final String STATE = "state";
    public static final String STATE_NAME = "stateName";
    public static final String SENDER_ID = "senderId";
    public static final String SENDER = "sender";
    public static final String SEND_TIME = "sendTime";
    public static final String CREATE_TIME = "createTime";
    public static final String NOTE = "note";
    public static final String NODE_ROUTE = "nodeRoute";
    public static final String CUTPAGE = "cutpage";
    public static final String SON_TASK_IDS = "sonTaskId";
    public static final String PARENT_ID = "parentId";
    public static final String SON_TAG_NODE_IDX = "nodeIdx";
    public static final String SON_TAG_USER_ID = "userId";
    public static final String SON_TAG_ID = "taskId";
    public static final String ALERTED = "alerted";
    public static final String DEADLINE = "deadLine";
    public static final String OPERATOR_DELIMITER = ":";
    public static final int CURRENT_OPERATOR = 1;
    public static final int DATA_SOURCE = 3;
    public static final String OPERATOR = "operator";
    public static int COMPLETE = 1;
    public static int NOT_COMPLETE = 0;
    public static final String ADMIN = "admin";
    private Date deadLine;
    private static final int WEEKDAY = 7;
    private long id = -1L;
    private String name;
    private long taskId = -1L;
    private ProcessTask task;
    private long processId = -1L;
    private ReportProcess process;
    private int currentNodeIdx = -1;
    private String operatorJSON = "{}";
    private boolean dataSource = true;
    private String completeState = "{}";
    private boolean needAllComplete = true;
    private int reportOffset = -1;
    private long operatorOffset = -1L;
    private String operatorOffsetName = "";
    private int state = -1;
    private long senderId = -1L;
    private String sender = "";
    private Date sendTime = new Date();
    private Date createTime = new Date();
    private String note;
    private long parentId = -1L;
    private String sonTaskId;
    private Timer alertTimer = null;
    private Timer overTimer = null;
    private String nodeRoute;
    private boolean alerted = false;
    public static final ObjectTableMapper TABLE_MAPPER = new ObjectTableMapper(ProcessTaskImpl.class, new Table("FR_PROCESS_TASK_IMPL"), new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", -5, new ColumnSize(8)), new CommonFieldColumnMapper("taskId", -5, new ColumnSize(8), false), new CommonFieldColumnMapper("processId", -5, new ColumnSize(8), false), new CommonFieldColumnMapper("operatorJSON", 12, new ColumnSize(1024), false), new CommonFieldColumnMapper("reportOffset", -6, new ColumnSize(1), false), new CommonFieldColumnMapper("operatorOffset", -5, new ColumnSize(8), false), new CommonFieldColumnMapper("needAllComplete", 16, new ColumnSize(1), false), new CommonFieldColumnMapper("currentNodeIdx", -6, new ColumnSize(1), false), new CommonFieldColumnMapper("createTime", 93, new ColumnSize(10), false), new CommonFieldColumnMapper("note", 12, new ColumnSize(10240), true), new CommonFieldColumnMapper("state", -6, new ColumnSize(1), false), new CommonFieldColumnMapper("sonTaskId", 12, new ColumnSize(255), true), new CommonFieldColumnMapper("sendTime", 93, new ColumnSize(10), false), new CommonFieldColumnMapper("senderId", -5, new ColumnSize(8), false), new CommonFieldColumnMapper("completeState", 12, new ColumnSize(1024), false), new CommonFieldColumnMapper("parentId", -5, new ColumnSize(8), true), new CommonFieldColumnMapper("nodeRoute", 12, new ColumnSize(50), true), new CommonFieldColumnMapper("alerted", 16, new ColumnSize(1), false), new CommonFieldColumnMapper("deadLine", 93, new ColumnSize(10), true), new CommonFieldColumnMapper("sender", 12, new ColumnSize(50), false), new CommonFieldColumnMapper("operatorOffsetName", 12, new ColumnSize(50), false)}, (String[][])new String[][]{{"id"}}, null);

    public boolean isNeedAllComplete() {
        return this.needAllComplete;
    }

    public ProcessTaskImpl() {
    }

    public ProcessTaskImpl(ProcessTask processTask, String string, int n2, int n3, boolean bl) {
        this.task = processTask;
        this.taskId = processTask.getId();
        this.processId = processTask.getProcessId();
        this.parentId = processTask.getParentId();
        this.currentNodeIdx = 0;
        this.nodeRoute = this.initNodeRoute();
        this.operatorJSON = string;
        this.reportOffset = n2;
        this.operatorOffset = n3;
        this.operatorOffsetName = ProcessUtils.getUserNameById(n3);
        this.needAllComplete = bl;
        this.state = this.getDefaultState();
        this.senderId = processTask.getCreatorId();
        this.sender = ProcessUtils.getUserNameById(processTask.getCreatorId());
        this.deadLine = this.getDeadLineDate(processTask.getDeadLineDate(), processTask.getDeadLineType());
        try {
            this.process = ReportProcessDAO.getInstance().findByID(processTask.getProcessId());
        }
        catch (Exception exception) {
            FRContext.getLogger().error("error on init processTaskImpl");
        }
    }

    public void setId(long l2) {
        this.id = l2;
    }

    public long getId() {
        return this.id;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long l2) {
        this.taskId = l2;
    }

    public long getProcessId() {
        return this.processId;
    }

    public ProcessTask getTask() {
        return this.task;
    }

    public void setTask(ProcessTask processTask) {
        this.task = processTask;
    }

    public int getCurrentNodeIdx() {
        return this.currentNodeIdx;
    }

    public void setCurrentNodeIdx(int n2) {
        this.currentNodeIdx = n2;
    }

    public int getReportOffset() {
        return this.reportOffset;
    }

    public void setOperatorOffset(long l2) {
        this.operatorOffset = l2;
    }

    public void setOperatorOffsetName(String string) {
        this.operatorOffsetName = string;
    }

    public long getOperatorOffset() {
        return this.operatorOffset;
    }

    public String getOperatorOffsetName() {
        return this.operatorOffsetName;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String string) {
        this.note = string;
    }

    public void setNodeRoute(String string) {
        this.nodeRoute = string;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setOperateJSON(String string) {
        this.operatorJSON = string;
    }

    public void setParentId(long l2) {
        this.parentId = l2;
    }

    public ProcessNode getNode(int n2) {
        this.initReportProcess();
        return this.process.getNode(n2);
    }

    public ProcessNode getCurrentNode() {
        return this.getNode(this.currentNodeIdx);
    }

    public String getNodeRoute() {
        return this.nodeRoute;
    }

    public int getCurrentRouteIdx() {
        try {
            return new JSONArray(this.nodeRoute).length() - 1;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getMaxRoutePoint() {
        try {
            int n2 = 0;
            JSONArray jSONArray = new JSONArray(this.nodeRoute);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                if (jSONArray.getInt(i2) <= n2) continue;
                n2 = jSONArray.getInt(i2);
            }
            return n2;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private String initNodeRoute() {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put(0);
        return jSONArray.toString();
    }

    public void initCompleteState(String string) {
        this.completeState = string;
    }

    public String getCompleteState() {
        return this.completeState;
    }

    public void setUseDataSource(boolean bl) {
        this.dataSource = bl;
    }

    public boolean isUseDataSource() {
        return this.dataSource;
    }

    public void resetCompleteState() {
        if (this.completeState == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(this.completeState);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = Utils.objectToString(iterator.next());
                JSONObject jSONObject2 = jSONObject.getJSONObject(string);
                Iterator iterator2 = jSONObject2.keys();
                while (iterator2.hasNext()) {
                    String string2 = Utils.objectToString(iterator2.next());
                    jSONObject2.put(string2, NOT_COMPLETE);
                }
            }
            this.completeState = jSONObject.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean checkAllComplete() {
        try {
            JSONObject jSONObject = new JSONObject(this.completeState);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = Utils.objectToString(iterator.next());
                JSONObject jSONObject2 = jSONObject.getJSONObject(string);
                Iterator iterator2 = jSONObject2.keys();
                while (iterator2.hasNext()) {
                    String string2 = Utils.objectToString(iterator2.next());
                    if (jSONObject2.getInt(string2) != NOT_COMPLETE) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n2) {
        this.state = n2;
    }

    public String getName() {
        if (this.name == null) {
            this.initProcessTask();
            this.name = this.task.getName();
        }
        return this.name;
    }

    public long getSenderId() {
        if (ComparatorUtils.equals(this.sender, ADMIN)) {
            return -999L;
        }
        return ProcessUtils.getIdFromStr(this.sender);
    }

    public void setSenderId(long l2) {
        this.senderId = l2;
    }

    public void setSender(String string) {
        this.sender = string;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(Date date) {
        this.sendTime = date;
    }

    public String getSender() {
        return this.sender;
    }

    public String getSender(boolean bl) {
        return ProcessUtils.getUserName(this.getSenderId(), bl);
    }

    public Object getAllSender(boolean bl) {
        return this.getAllSender(false, bl);
    }

    public String getAllSenderStr(boolean bl) {
        return Utils.objectToString(this.getAllSender(true, bl));
    }

    public Object getAllSender(boolean bl, boolean bl2) {
        if (this.currentNodeIdx > 0) {
            Object object;
            Object object2;
            this.initReportProcess();
            ProcessNode processNode = this.process.getNode(this.currentNodeIdx - 1);
            long[] lArray = null;
            String string = this.getCompleteState();
            try {
                object2 = new JSONObject(string);
                object = ((JSONObject)object2).keys();
                ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
                while (object.hasNext()) {
                    JSONObject jSONObject = ((JSONObject)object2).getJSONObject(object.next().toString());
                    arrayList.add(jSONObject);
                }
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    String[] stringArray = JSONObject.getNames((JSONObject)arrayList.get(i2));
                    for (int i3 = 0; i3 < stringArray.length; ++i3) {
                        String string2 = stringArray[i2];
                        lArray = processNode.getAllRelatedUsers(string2);
                    }
                }
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage());
            }
            if (processNode.isNeedAllComplete() && lArray.length > 1) {
                object2 = new FArray();
                object = "";
                for (ArrayList arrayList : lArray) {
                    String string3 = ProcessUtils.getUserName(arrayList, bl2);
                    ((FArray)object2).simpleAdd(string3);
                    object = (String)object + string3 + " ";
                }
                return bl ? object : object2;
            }
        }
        return this.getSender(bl2);
    }

    public long getCreatorId() {
        this.initProcessTask();
        return this.task.getCreatorId();
    }

    public Date getDeadLine() {
        return this.deadLine;
    }

    public String getStateName() {
        return ProcessManager.getTaskStateName(this.state);
    }

    private int getDefaultState() {
        this.initReportProcess();
        String string = this.process.getNodesArr()[this.currentNodeIdx];
        long l2 = ProcessUtils.getIdFromStr(string);
        try {
            ProcessNode processNode = ProcessNodeDAO.getInstance().findByID(l2);
            return ProcessManager.getStateByAuthority(processNode.getAuthority());
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public JSONObject createJSONObject() throws JSONException {
        return this.createJSONObject(-1L);
    }

    public JSONObject createJSONObject(long l2) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        try {
            this.initProcessTask();
            long l3 = this.task.getCreatorId();
            jSONObject.put("name", this.task.getName());
            jSONObject.put("creatorId", l3);
            jSONObject.put("creatorName", ProcessUtils.getUserName(l3));
            if (this.deadLine != null) {
                jSONObject.put(DEADLINE, DateUtils.getDate2Str("yyyy-MM-dd HH:mm", this.deadLine));
            }
            this.initReportProcess();
            ProcessNode processNode = this.process.getNode(this.currentNodeIdx);
            jSONObject.put("authority", this.isClosed() ? "00000000000" : processNode.getAuthority());
            if (l2 != -1L) {
                String string = processNode.getReportControl();
                jSONObject.put("reportControl", processNode.getReportControl());
                JSONArray jSONArray = new JSONArray(string);
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                    ProcessOperator processOperator = new ProcessOperator(jSONObject2.optString(OPERATOR));
                    if (!processOperator.isUnderTakeBy(l2)) continue;
                    jSONObject.put("reportPath", jSONObject2.optString("reportPath"));
                    this.getCutpageAndPutInParameters(processNode, jSONObject);
                    jSONObject.put("parameters", "parameters");
                    break;
                }
            }
            jSONObject.put("needOfflineReport", processNode.isNeedOfflineReport());
            jSONObject.put("id", this.id);
            jSONObject.put("taskId", this.taskId);
            jSONObject.put(STATE, this.state);
            jSONObject.put(STATE_NAME, this.getStateName());
            jSONObject.put(SENDER, this.getAllSenderStr(true));
            jSONObject.put(SEND_TIME, DateUtils.getDate2Str("yyyy-MM-dd HH:mm", this.sendTime));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return jSONObject;
    }

    public JSONObject createDetailedJSONObject() throws Exception {
        JSONObject jSONObject = this.createJSONObject();
        jSONObject.put(CURRENT_NODE_IDX, this.currentNodeIdx);
        jSONObject.put(NODE_ROUTE, new JSONArray(this.nodeRoute));
        JSONArray jSONArray = new JSONArray();
        if (this.note != null && this.note.length() > 0) {
            jSONArray = new JSONArray(this.note);
        }
        jSONObject.put(NOTE, jSONArray);
        this.initReportProcess();
        jSONObject.put("process", this.process.createDetailedJSONObject());
        return jSONObject;
    }

    public String getCurrentOperator() {
        this.initReportProcess();
        ProcessNode processNode = this.process.getNode(this.currentNodeIdx);
        return processNode.getAuthority();
    }

    public String getCurrentOperatorName() {
        this.initReportProcess();
        ProcessNode processNode = this.process.getNode(this.currentNodeIdx);
        return ProcessManager.getTaskAuthorityName(processNode.getAuthority(), processNode.isNeedOfflineReport());
    }

    public boolean isUnderTakeBy(long l2) {
        ProcessOperator[] processOperatorArray = this.getCurrentUnderTaker();
        for (int i2 = 0; i2 < processOperatorArray.length; ++i2) {
            ProcessOperator processOperator = processOperatorArray[i2];
            if (!processOperator.isUnderTakeBy(l2)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompletedBy(long l2) throws Exception {
        if (!this.isClosed() && this.isUnderTakeBy(l2)) {
            return false;
        }
        if (this.isClosed() && this.isUnderTakeBy(l2)) {
            return true;
        }
        this.initReportProcess();
        int n2 = this.currentNodeIdx;
        int n3 = this.getMaxRoutePoint();
        if (n3 > this.currentNodeIdx) {
            n2 = n3 + 1;
        }
        for (int i2 = 0; i2 <= n2; ++i2) {
            JSONObject jSONObject = new JSONObject(this.completeState);
            Iterator iterator = jSONObject.keys();
            if (!this.isReportCompletedByUser(l2, iterator, jSONObject)) continue;
            return true;
        }
        return false;
    }

    public boolean isRelatedWith(long l2) {
        return ArrayUtils.contains(this.getAllRelatedUsers(), l2);
    }

    private boolean isReportCompletedByUser(long l2, Iterator iterator, JSONObject jSONObject) throws JSONException {
        while (iterator.hasNext()) {
            String string = Utils.objectToString(iterator.next());
            JSONObject jSONObject2 = jSONObject.getJSONObject(string);
            Iterator iterator2 = jSONObject2.keys();
            while (iterator2.hasNext()) {
                String string2 = Utils.objectToString(iterator2.next());
                if (Integer.parseInt(jSONObject2.getString(string2)) == NOT_COMPLETE || !ArrayUtils.contains(ProcessOperator.getAllUserId(string2), l2)) continue;
                return true;
            }
        }
        return false;
    }

    public long[] getCurrentUnderTakerIds() {
        ProcessOperator[] processOperatorArray = this.getCurrentUnderTaker();
        long[] lArray = new long[]{};
        for (int i2 = 0; i2 < processOperatorArray.length; ++i2) {
            lArray = ArrayUtils.addAll(lArray, processOperatorArray[i2].getAllUserId());
        }
        return ProcessUtils.unique(lArray);
    }

    public long[] getAllRelatedUsers() {
        this.initReportProcess();
        Object[] objectArray = new ProcessOperator[]{};
        int n2 = this.process.getNodeCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                objectArray = (ProcessOperator[])ArrayUtils.addAll(objectArray, this.getNodeUnderTaker(i2, true));
                continue;
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage());
            }
        }
        long[] lArray = new long[]{};
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (objectArray[n2] == null) continue;
            lArray = ArrayUtils.addAll(lArray, ((ProcessOperator)objectArray[n2]).getAllUserId());
        }
        return ProcessUtils.unique(lArray);
    }

    public ProcessOperator[] getCurrentUnderTaker() {
        try {
            return this.getNodeUnderTaker(this.currentNodeIdx);
        }
        catch (Exception exception) {
            return new ProcessOperator[0];
        }
    }

    public ProcessOperator[] getNodeUnderTaker(int n2) throws Exception {
        return this.getNodeUnderTaker(n2, false);
    }

    public ProcessOperator[] getNodeUnderTaker(int n2, boolean bl) throws Exception {
        this.initReportProcess();
        if (this.process == null) {
            return new ProcessOperator[0];
        }
        if (n2 < 0 || n2 >= this.process.getNodeCount()) {
            return new ProcessOperator[0];
        }
        ProcessNode processNode = this.process.getNode(n2);
        String string = processNode.getReportControl();
        JSONArray jSONArray = new JSONArray(string);
        if (jSONArray.length() == 0) {
            return new ProcessOperator[0];
        }
        if (bl) {
            return processNode.getAllProcessOperator();
        }
        JSONObject jSONObject = new JSONObject(this.completeState);
        Iterator iterator = jSONObject.keys();
        List<ProcessOperator> list = this.makeOperatorList(jSONObject, iterator);
        return list.toArray(new ProcessOperator[list.size()]);
    }

    private void getCutpageAndPutInParameters(ProcessNode processNode, JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray(processNode.getReportControl());
        JSONObject jSONObject2 = (JSONObject)jSONArray.get(0);
        JSONArray jSONArray2 = (JSONArray)jSONObject2.get("parameters");
        for (int i2 = 0; i2 < jSONArray2.length(); ++i2) {
            JSONObject jSONObject3 = (JSONObject)jSONArray2.get(i2);
            if (!ComparatorUtils.equals(jSONObject3.get("name"), "__cutpage__")) continue;
            jSONObject.put(CUTPAGE, jSONObject3.optString("value"));
            break;
        }
    }

    private List<ProcessOperator> makeOperatorList(JSONObject jSONObject, Iterator iterator) throws Exception {
        ArrayList<ProcessOperator> arrayList = new ArrayList<ProcessOperator>();
        while (iterator.hasNext()) {
            String string = Utils.objectToString(iterator.next());
            JSONObject jSONObject2 = jSONObject.getJSONObject(string);
            Iterator iterator2 = jSONObject2.keys();
            int n2 = -1;
            String string2 = "";
            while (iterator2.hasNext()) {
                String string3 = Utils.objectToString(iterator2.next());
                if (Integer.parseInt(jSONObject2.getString(string3)) != NOT_COMPLETE) continue;
                if (n2 < 0) {
                    n2 = ProcessOperator.getOperatorType(string3);
                }
                string2 = string2 + string3 + "##";
            }
            if (string2.endsWith("##")) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            if (n2 < 0 || string2.length() <= 0) continue;
            String string4 = n2 + "##";
            string2 = string4 + string4 + string2;
            arrayList.add(new ProcessOperator(string2));
        }
        return arrayList;
    }

    public String getUserReportPath(long l2) {
        ProcessNode processNode = this.getCurrentNode();
        try {
            JSONArray jSONArray = new JSONArray(processNode.getReportControl());
            if (jSONArray.length() == 0) {
                return null;
            }
            if (jSONArray.length() > 1) {
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    ReportControl reportControl = new ReportControl(jSONArray.getString(i2));
                    if (!reportControl.isUnderTakeBy(l2)) continue;
                    return reportControl.getReportPath();
                }
            }
            return new ReportControl(jSONArray.getString(0)).getReportPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void makeOfflineReportData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long l2, ByteArrayOutputStream byteArrayOutputStream) {
        String string = this.getUserReportPath(l2);
        try {
            httpServletRequest.setAttribute("__processtaskid__", (Object)this.id);
            String string2 = this.getName();
            string2 = Browser.resolve(httpServletRequest).getEncodedFileName4Download(string2);
            ExportUtils.setZipContext(httpServletResponse, string2, true);
            new WriteHTMLExporter().export(byteArrayOutputStream, httpServletRequest, string, this.id, l2);
            ProcessManager.log(l2, this, Inter.getLocText("RP_Send_Offline_Report"));
        }
        catch (Exception exception) {
            ProcessManager.error(l2, ProcessManager.getProcessName(this.task.getProcessId()), ProcessManager.getTaskName(this.getTaskId()), "Failed to send offline Report");
        }
    }

    public void checkAndSendOfflineEmail(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        long[] lArray;
        if (httpServletRequest == null || httpServletResponse == null) {
            return;
        }
        ProcessNode processNode = this.getCurrentNode();
        if (!processNode.isNeedOfflineReport()) {
            return;
        }
        for (long l2 : lArray = this.getCurrentUnderTakerIds()) {
            this.sendOfflineEmail(httpServletRequest, httpServletResponse, l2);
        }
    }

    private void sendOfflineEmail(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long l2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.makeOfflineReportData(httpServletRequest, httpServletResponse, l2, byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string = this.getName();
        String string2 = this.getName();
        try {
            File file = new File(FRContext.getCurrentEnv().getWebReportPath() + "/" + string + ".zip");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(byArray);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            boolean bl = true;
            String string3 = null;
            if (ProcessUtils.invalidUser(l2)) {
                bl = false;
            } else {
                string3 = ProcessUtils.getUserEmail(l2);
                if (string3 == null) {
                    bl = false;
                }
            }
            if (bl) {
                String string4 = string2;
                String string5 = string2;
                ConfigManager.getInstance().getEmailManager().send(string3, null, null, string4, string5, file);
            }
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isValidOfflineOperator(long l2, int n2) {
        return n2 == this.currentNodeIdx && this.isUnderTakeBy(l2) && this.getCurrentNode().isNeedOfflineReport();
    }

    public boolean addNote(int n2, String string, String string2) {
        return this.addNote(n2, string, string2, DateUtils.getDate2Str("yyyy-MM-dd HH:mm:ss", new Date()));
    }

    public boolean addNote(int n2, String string, String string2, String string3) {
        try {
            JSONArray jSONArray = this.note == null ? new JSONArray() : new JSONArray(this.note);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(SON_TAG_NODE_IDX, n2);
            jSONObject.put("user", string);
            jSONObject.put("message", string2);
            jSONObject.put("time", string3);
            jSONArray.put(jSONObject);
            String string4 = jSONArray.toString();
            this.setNote(string4);
            return ProcessTaskImplDAO.getInstance().updateNote(this.id, string4);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public JSONObject getBackTarget() throws Exception {
        this.initReportProcess();
        int n2 = this.currentNodeIdx;
        JSONObject jSONObject = new JSONObject();
        while (n2-- > 0) {
            ProcessNode processNode = this.process.getNode(n2);
            String string = processNode.getReportControl();
            JSONArray jSONArray = new JSONArray(string);
            JSONObject jSONObject2 = this.getOperateJSON();
            if (jSONObject2.length() == 0 && this.lastNodeUseDataSource()) {
                jSONObject2 = this.getNewOperateJSON();
            }
            boolean bl = processNode.isNeedAllComplete();
            long l2 = this.getSenderId();
            if (jSONArray.length() == 0) continue;
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                ReportControl reportControl = new ReportControl(jSONArray.getJSONObject(i2));
                JSONArray jSONArray2 = jSONObject.has(reportControl.getReportPath()) ? (JSONArray)jSONObject.get(reportControl.getReportPath()) : new JSONArray();
                jSONObject.put(reportControl.getReportPath(), reportControl.getOperator().toJSONArray(jSONObject2, bl, l2, jSONArray2));
            }
            if (!this.process.getNode(n2--).isNeedAllComplete() && bl) continue;
            break;
        }
        return jSONObject;
    }

    private JSONObject getNewOperateJSON() throws JSONException {
        String string = this.getAllSender(true).toString();
        String[] stringArray = string.split(",");
        JSONObject jSONObject = new JSONObject();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Pattern pattern = Pattern.compile("[()]");
            String[] stringArray2 = pattern.split(stringArray[i2]);
            jSONObject.put(stringArray2[0], "0");
        }
        return jSONObject;
    }

    private boolean lastNodeUseDataSource() throws JSONException {
        boolean bl = true;
        int n2 = this.currentNodeIdx;
        ProcessNode processNode = this.process.getNode(n2 - 1);
        String string = processNode.getReportControl();
        JSONArray jSONArray = new JSONArray(string);
        String string2 = "";
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            String[] stringArray;
            String[] stringArray2;
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            string2 = jSONObject.getString(OPERATOR);
            if (string2 == null || Integer.parseInt((stringArray2 = (stringArray = string2.split(OPERATOR_DELIMITER))[1].split("##"))[1]) == 3) continue;
            bl = false;
        }
        return bl;
    }

    public void taskBack(long l2, String string, String string2) throws Exception {
        this.updateSendInfo(l2);
        if (string2 == null) {
            this.resetCompleteState();
        } else {
            ProcessTask processTask = this.getTask();
            int n2 = this.getCurrentNodeIdx();
            while (n2-- > 0) {
                List<ProcessTaskImpl> list = processTask.getAllProcessTaskImpl(n2);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    ProcessTaskImpl processTaskImpl = list.get(i2);
                    String string3 = processTaskImpl.getCompleteState();
                    JSONObject jSONObject = new JSONObject(string3);
                    JSONObject jSONObject2 = new JSONObject(string2);
                    Iterator iterator = jSONObject2.keys();
                    while (iterator.hasNext()) {
                        String string4 = Utils.objectToString(iterator.next());
                        if (!jSONObject.has(string4)) continue;
                        JSONObject jSONObject3 = jSONObject.getJSONObject(string4);
                        JSONArray jSONArray = jSONObject2.getJSONArray(string4);
                        for (int i3 = 0; i3 < jSONArray.length(); ++i3) {
                            JSONObject jSONObject4 = jSONArray.getJSONObject(i3);
                            String string5 = jSONObject4.optString("value");
                            if (!jSONObject3.has(string5)) continue;
                            this.fireNodeChange(l2, string, this.currentNodeIdx - 1);
                            processTaskImpl.setNodeRoute(this.nodeRoute);
                            jSONObject3.put(string5, NOT_COMPLETE);
                            processTaskImpl.setNote(this.getNote());
                            processTaskImpl.initCompleteState(jSONObject.toString());
                            processTaskImpl.setCurrentNodeIdx(this.currentNodeIdx - 1);
                            processTaskImpl.setOperatorOffset(l2);
                            processTaskImpl.setOperatorOffsetName(ProcessUtils.getUserNameById(l2));
                            processTaskImpl.setState(3);
                            ProcessTaskImplDAO.getInstance().saveOrUpdate(processTaskImpl);
                        }
                    }
                }
            }
            ProcessTaskImplDAO.getInstance().delete(this);
            this.clear();
        }
    }

    public void taskForward(long l2, String string, int n2) throws Exception {
        JSONObject jSONObject = new JSONObject(this.completeState);
        List<String> list = ProcessManager.getUserOps(l2);
        if (string != null && jSONObject.has(string)) {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string);
            for (String string2 : list) {
                if (!jSONObject2.has(string2)) continue;
                jSONObject2.put(string2, COMPLETE);
            }
        }
        this.completeState = jSONObject.toString();
        ProcessTaskImplDAO.getInstance().saveOrUpdate(this);
        if (!this.needAllComplete && this.state != 3) {
            this.checkLastAndToNext(l2, string, n2);
        } else if (this.checkAllComplete()) {
            this.checkLastAndToNext(l2, string, n2);
        }
    }

    public void initOperateJSON(JSONObject jSONObject) {
        this.operatorJSON = jSONObject.toString();
    }

    public JSONObject getOperateJSON() throws JSONException {
        return new JSONObject(this.operatorJSON);
    }

    private void checkLastAndToNext(long l2, String string, int n2) throws Exception {
        this.updateSendInfo(l2);
        if (this.isLastNode()) {
            if (this.lastNodeAllComplete(l2, string, n2)) {
                if (this.needAllComplete) {
                    this.dealLastNodeNeedAllComplete(l2);
                }
                this.taskClose(l2, false);
            }
        } else {
            this.nodeToNext(l2, string, n2);
        }
    }

    private void dealLastNodeNeedAllComplete(long l2) throws Exception {
        ProcessTask processTask = ProcessTaskDAO.getInstance().findByID(this.taskId);
        List<ProcessTaskImpl> list = processTask.getAllProcessTaskImpl(this.taskId);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ProcessTaskImpl processTaskImpl = list.get(i2);
            if (!processTaskImpl.isLastNode()) continue;
            String string = processTaskImpl.getCompleteState();
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(iterator.next().toString());
                if (jSONObject2.has(ProcessUtils.getUserNameById(l2))) continue;
                ProcessTaskImplDAO.getInstance().delete(processTaskImpl);
                ProcessManager.removeTask(processTaskImpl.getId());
            }
        }
    }

    private boolean lastNodeAllComplete(long l2, String string, int n2) throws Exception {
        boolean bl = true;
        if (this.needAllComplete) {
            Object object;
            ProcessTask processTask = ProcessTaskDAO.getInstance().findByID(this.taskId);
            List<ProcessTaskImpl> list = processTask.getAllProcessTaskImpl(this.taskId);
            Iterator<ProcessTaskImpl> iterator = list.iterator();
            while (iterator.hasNext()) {
                ProcessTaskImpl processTaskImpl = iterator.next();
                String string2 = processTaskImpl.getCompleteState();
                object = new JSONObject(string2);
                Iterator iterator2 = ((JSONObject)object).keys();
                ArrayList arrayList = new ArrayList();
                while (iterator2.hasNext()) {
                    JSONObject jSONObject = ((JSONObject)object).getJSONObject(iterator2.next().toString());
                    if (!jSONObject.has(ProcessUtils.getUserNameById(l2))) continue;
                    iterator.remove();
                }
            }
            int n3 = list.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                object = list.get(i2);
                bl = this.taskCompleted(l2, (ProcessTaskImpl)object);
            }
        }
        return bl;
    }

    private boolean taskCompleted(long l2, ProcessTaskImpl processTaskImpl) throws JSONException {
        boolean bl = true;
        String string = processTaskImpl.getCompleteState();
        JSONObject jSONObject = new JSONObject(string);
        Iterator iterator = jSONObject.keys();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            JSONObject jSONObject2 = jSONObject.getJSONObject(iterator.next().toString());
            if (jSONObject2.has(ProcessUtils.getUserNameById(l2))) continue;
            Iterator iterator2 = jSONObject2.keys();
            while (iterator2.hasNext()) {
                int n2 = jSONObject2.getInt(iterator2.next().toString());
                if (0 != n2) continue;
                return false;
            }
        }
        return bl;
    }

    private void nodeToNext(long l2, String string, int n2) throws Exception {
        ProcessTask processTask = ProcessTaskDAO.getInstance().findByID(this.taskId);
        List<ProcessTaskImpl> list = processTask.getAllProcessTaskImpl(this.getCurrentNodeIdx() + 1);
        if (this.state == 3) {
            this.backTaskToNext(processTask, list, l2, n2, string);
        } else {
            int n3 = list.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4;
                ProcessTaskImpl processTaskImpl = list.get(i2);
                ProcessOperator[] processOperatorArray = processTaskImpl.getNodeUnderTaker(this.getCurrentNodeIdx() + 1);
                JSONObject jSONObject = processTaskImpl.getOperateJSON();
                for (n4 = i2 + 1; n4 < n3; ++n4) {
                    ProcessTaskImpl processTaskImpl2 = list.get(n4);
                    JSONObject jSONObject2 = processTaskImpl2.getOperateJSON();
                    Iterator iterator = jSONObject.keys();
                    while (iterator.hasNext()) {
                        String string2 = iterator.next().toString();
                        if (!jSONObject2.has(string2.toString())) continue;
                        iterator.remove();
                    }
                }
                n4 = processTaskImpl.isUseDataSource() ? 1 : 0;
                for (int i3 = 0; i3 < processOperatorArray.length; ++i3) {
                    ProcessTaskImpl processTaskImpl3 = n4 != 0 ? this.dataSourceTaskToNext(processTask, processTaskImpl, jSONObject, l2, string) : (this.needAllComplete ? this.allCompleteTaskToNext(processTask, i2, processTaskImpl, n3, l2, string) : this.notAllCompleteTaskToNext(processTask, i2, n3, processTaskImpl, l2, string));
                    if (n2 != -1) {
                        processTaskImpl3.setState(n2);
                    } else {
                        processTaskImpl3.setState(processTaskImpl3.getDefaultState());
                    }
                    ProcessTaskImplDAO.getInstance().saveOrUpdate(processTaskImpl3);
                }
            }
        }
    }

    private void backTaskToNext(ProcessTask processTask, List<ProcessTaskImpl> list, long l2, int n2, String string) {
        try {
            List<ProcessTaskImpl> list2 = processTask.getAllTaskImpl();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ArrayList<ProcessTaskImpl> arrayList;
                boolean bl;
                if (!list.get(i2).isUnderTakeBy(ProcessUtils.getIdFromStr(this.operatorOffsetName)) || !(bl = this.isAllComplete(list2, arrayList = new ArrayList<ProcessTaskImpl>()))) continue;
                this.deleteTaskImpl(arrayList, true, false);
                ProcessTaskImpl processTaskImpl = list.get(i2);
                this.taskToIssue(processTask, processTaskImpl, l2, string);
                if (n2 != -1) {
                    processTaskImpl.setState(n2);
                } else {
                    processTaskImpl.setState(processTaskImpl.getDefaultState());
                }
                ProcessTaskImplDAO.getInstance().saveOrUpdate(processTaskImpl);
                break;
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private boolean isAllComplete(List<ProcessTaskImpl> list, List<ProcessTaskImpl> list2) throws Exception {
        boolean bl = false;
        for (ProcessTaskImpl processTaskImpl : list) {
            if (processTaskImpl.getOperatorOffset() != this.operatorOffset && !ComparatorUtils.equals(processTaskImpl.getOperatorOffsetName(), this.operatorOffsetName)) continue;
            bl = processTaskImpl.isCompleted();
            if (!bl) break;
            list2.add(processTaskImpl);
        }
        return bl;
    }

    private ProcessTaskImpl allCompleteTaskToNext(ProcessTask processTask, int n2, ProcessTaskImpl processTaskImpl, int n3, long l2, String string) throws Exception {
        int n4;
        ProcessTaskImpl processTaskImpl2 = this;
        ProcessOperator processOperator = processTask.getAllProcessOperator(this.getCurrentNodeIdx());
        String[] stringArray = processOperator.getIds();
        int n5 = processOperator.getOperatorCount();
        boolean bl = true;
        ArrayList<ProcessTaskImpl> arrayList = new ArrayList<ProcessTaskImpl>();
        block0: for (n4 = 0; n4 < n5; ++n4) {
            List<ProcessTaskImpl> list = processOperator.isRole() ? processTask.getProcessTaskImplByRole(stringArray[n4], this.currentNodeIdx) : processTask.getProcessTaskImplByUsername(stringArray[n4], this.currentNodeIdx);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (list.get(i2) == null) {
                    bl = false;
                    continue block0;
                }
                arrayList.add(list.get(i2));
            }
        }
        if (bl) {
            n4 = n2 == n3 - 1 ? 1 : 0;
            this.deleteTaskImpl(arrayList, n4 != 0, false);
            processTaskImpl2 = processTaskImpl;
            this.taskToIssue(processTask, processTaskImpl2, l2, string);
        }
        return processTaskImpl2;
    }

    private void taskToIssue(ProcessTask processTask, ProcessTaskImpl processTaskImpl, long l2, String string) throws Exception {
        this.fireNodeChange(l2, string, this.currentNodeIdx + 1);
        processTaskImpl.setNodeRoute(this.nodeRoute);
        processTaskImpl.setNote(this.getNote());
        processTaskImpl.setSenderId(l2);
        processTaskImpl.setSender(ProcessUtils.getUserNameById(l2));
        processTaskImpl.setSendTime(new Date());
        processTaskImpl.setCurrentNodeIdx(this.currentNodeIdx + 1);
        processTask.issueTask(processTaskImpl);
    }

    private ProcessTaskImpl notAllCompleteTaskToNext(ProcessTask processTask, int n2, int n3, ProcessTaskImpl processTaskImpl, long l2, String string) throws Exception {
        if (n2 == n3 - 1) {
            ProcessTaskImplDAO.getInstance().delete(this);
            this.clear();
        }
        ProcessTaskImpl processTaskImpl2 = processTaskImpl;
        this.taskToIssue(processTask, processTaskImpl2, l2, string);
        return processTaskImpl2;
    }

    private boolean isCompleted() throws Exception {
        boolean bl = true;
        String string = this.getCompleteState();
        JSONObject jSONObject = new JSONObject(string);
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = Utils.objectToString(iterator.next());
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            Iterator iterator2 = jSONObject2.keys();
            while (iterator2.hasNext()) {
                if (jSONObject2.getInt(Utils.objectToString(iterator2.next())) != NOT_COMPLETE) continue;
                bl = false;
            }
        }
        return bl;
    }

    private ProcessTaskImpl dataSourceTaskToNext(ProcessTask processTask, ProcessTaskImpl processTaskImpl, JSONObject jSONObject, long l2, String string) throws Exception {
        ProcessTaskImpl processTaskImpl2 = this;
        String string2 = ProcessUtils.getUserNameById(l2);
        if (jSONObject.length() > 0 && jSONObject.has(string2)) {
            Iterator iterator = jSONObject.keys();
            boolean bl = true;
            ArrayList<ProcessTaskImpl> arrayList = new ArrayList<ProcessTaskImpl>();
            block0: while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                List<ProcessTaskImpl> list = string3.contains("_") ? processTask.getProcessTaskImplByRole(string3, this.currentNodeIdx) : processTask.getProcessTaskImplByUsername(string3, this.currentNodeIdx);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    if (list.get(i2) == null) {
                        if (!this.needAllComplete) continue;
                        bl = false;
                        continue block0;
                    }
                    arrayList.add(list.get(i2));
                }
            }
            if (bl) {
                this.deleteTaskImpl(arrayList, true, true);
                processTaskImpl2 = processTaskImpl;
                processTaskImpl.setOperateJSON(jSONObject.toString());
                this.taskToIssue(processTask, processTaskImpl2, l2, string);
            }
        }
        return processTaskImpl2;
    }

    private void deleteTaskImpl(List<ProcessTaskImpl> list, boolean bl, boolean bl2) throws Exception {
        JSONArray jSONArray = new JSONArray();
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ProcessTaskImpl processTaskImpl = list.get(i2);
            String string = processTaskImpl.getNote();
            int n4 = processTaskImpl.getCurrentRouteIdx();
            if (n4 > n2) {
                n2 = n4;
                n3 = i2;
            }
            JSONArray jSONArray2 = string == null ? new JSONArray() : new JSONArray(string);
            for (int i3 = 0; i3 < jSONArray2.length(); ++i3) {
                JSONObject jSONObject = jSONArray2.getJSONObject(i3);
                if (jSONObject.getInt(SON_TAG_NODE_IDX) < n4 && i2 != 0 && !bl2) continue;
                jSONArray.put(jSONObject);
            }
            if (!bl) continue;
            ProcessTaskImplDAO.getInstance().delete(processTaskImpl);
            processTaskImpl.clear();
        }
        this.setNote(jSONArray.toString());
        if (list.size() > n3) {
            this.setNodeRoute(list.get(n3).getNodeRoute());
        }
    }

    private void updateSendInfo(long l2) {
        this.senderId = l2;
        this.sender = ProcessUtils.getUserNameById(l2);
        this.sendTime = new Date();
    }

    public void taskClose(long l2) throws Exception {
        this.taskClose(l2, true);
    }

    private void taskClose(long l2, boolean bl) throws Exception {
        if (bl) {
            this.checkValidBeforeMove(l2, -1);
        }
        this.updateSendInfo(l2);
        this.setState(4);
        ProcessTaskImplDAO.getInstance().saveOrUpdate(this);
        this.fireTaskClose();
    }

    public void taskDistribute(long l2, long l3) throws Exception {
        this.checkValidBeforeOperate(l2);
        JSONArray jSONArray = this.sonTaskId == null ? new JSONArray() : new JSONArray(this.sonTaskId);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(SON_TAG_NODE_IDX, this.currentNodeIdx);
        jSONObject.put(SON_TAG_USER_ID, l2);
        jSONObject.put("taskId", l3);
        jSONArray.put(jSONObject);
        this.sonTaskId = jSONArray.toString();
        ProcessTaskImplDAO.getInstance().updateSonTask(this.id, this.sonTaskId);
    }

    public void taskStash(long l2, String string) throws Exception {
        this.checkValidBeforeOperate(l2);
        JSONArray jSONArray = new JSONArray();
        ReportSessionIDInfor reportSessionIDInfor = (ReportSessionIDInfor)SessionDealWith.getSessionIDInfor(string);
        WriteWorkBook writeWorkBook = (WriteWorkBook)reportSessionIDInfor.getWorkBook2Show();
        int n2 = reportSessionIDInfor.getReportCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray2 = new JSONArray();
            JSONArray jSONArray3 = new JSONArray();
            WriteECReport writeECReport = writeWorkBook.getWriteReport(i2);
            H h2 = ((CalculatableResWorkSheet)((Object)writeECReport)).getSE();
            Iterator iterator = writeECReport.cellIterator();
            while (iterator.hasNext()) {
                object = (CellElement)iterator.next();
                if (!(object instanceof BCE_WRITE)) continue;
                BCE_WRITE bCE_WRITE = (BCE_WRITE)object;
                ColumnRow columnRow = ColumnRow.valueOf(object.getColumn(), object.getRow());
                Object object2 = object.getValue();
                if (object2 instanceof ResultFormula) {
                    object2 = ((ResultFormula)object2).getResult();
                }
                Style style = object.getStyle();
                jSONObject.put(columnRow.toString(), Style.valueToText(object2, style.getFormat()));
                if (jSONArray2.length() > 0 && object.getRow() <= jSONArray2.getInt(jSONArray2.length() - 1)) continue;
                if (bCE_WRITE.isNewInsert()) {
                    jSONArray2.put(object.getRow());
                }
                if (!bCE_WRITE.isDel()) continue;
                jSONArray3.put(object.getRow());
            }
            object = new JSONObject();
            ((JSONObject)object).put("cvs", jSONObject);
            ((JSONObject)object).put("irs", jSONArray2);
            ((JSONObject)object).put("drs", jSONArray3);
            ((JSONObject)object).put("rs", h2.W().\u00aa());
            jSONArray.put(object);
        }
        StashDataDAO.getInstance().saveOrUpdate(l2, this.id, reportSessionIDInfor.getBookPath(), jSONArray.toString());
    }

    public void taskPass(long l2, String string, int n2) throws Exception {
        this.checkValidBeforeMove(l2, n2);
        this.taskForward(l2, string, 2);
    }

    public void taskReport(long l2, String string, int n2) throws Exception {
        this.checkValidBeforeMove(l2, n2);
        this.taskForward(l2, string, -1);
    }

    private void checkValidBeforeOperate(long l2) throws Exception {
        if (!ArrayUtils.contains(this.getCurrentUnderTakerIds(), l2)) {
            throw new Exception("no property");
        }
    }

    public void checkValidBeforeMove(long l2) throws Exception {
        this.checkValidBeforeMove(l2, -1);
    }

    public void checkValidBeforeMove(long l2, int n2) throws Exception {
        if (n2 >= 0 && n2 > this.currentNodeIdx) {
            throw new Exception("invalid node");
        }
        if (n2 >= 0 && n2 < this.currentNodeIdx) {
            throw new Exception("completed node");
        }
        if (!this.isUnderTakeBy(l2)) {
            throw new Exception(Inter.getLocText("RP_NO_Privilege"));
        }
        if (!this.sonTaskComplete(l2)) {
            throw new Exception(Inter.getLocText("RP_Son_Task_Not_Complete"));
        }
    }

    private boolean sonTaskComplete(long l2) {
        if (this.sonTaskId == null) {
            return true;
        }
        try {
            JSONArray jSONArray = new JSONArray(this.sonTaskId);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                if (jSONObject.getInt(SON_TAG_NODE_IDX) != this.currentNodeIdx || (long)jSONObject.getInt(SON_TAG_USER_ID) != l2) continue;
                long l3 = jSONObject.getLong("taskId");
                ProcessTask processTask = ProcessTaskDAO.getInstance().findByID(l3);
                if (processTask == null) continue;
                if (!processTask.isIssueOver()) {
                    return false;
                }
                List<ProcessTaskImpl> list = processTask.getAllTaskImpl();
                for (ProcessTaskImpl processTaskImpl : list) {
                    if (processTaskImpl.isClosed()) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return true;
    }

    private void fireNodeChange(long l2, String string, int n2) {
        try {
            JSONArray jSONArray = new JSONArray(this.nodeRoute);
            if (jSONArray.length() > 0) {
                if (jSONArray.getInt(jSONArray.length() - 1) != n2) {
                    jSONArray.put(n2);
                }
            } else {
                jSONArray.put(n2);
            }
            this.nodeRoute = jSONArray.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            StashDataDAO.getInstance().delete(l2, this.id, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateAlerted(false);
        this.startAlertSchedule();
    }

    private void fireTaskClose() {
        try {
            AlertToast alertToast;
            Object object2;
            List list = AlertToastDAO.getInstance().findAll();
            for (Object object2 : list) {
                alertToast = (AlertToast)object2;
                if (alertToast.getTaskImplId() != this.id) continue;
                try {
                    AlertToastDAO.getInstance().deleteByID(alertToast.getId());
                }
                catch (Exception exception) {
                    FRContext.getLogger().error("error on delete alert");
                }
            }
            List list2 = RemindToastDAO.getInstance().findAll();
            object2 = list2.iterator();
            while (object2.hasNext()) {
                alertToast = object2.next();
                RemindToast remindToast = (RemindToast)((Object)alertToast);
                if (remindToast.getTaskImplId() != this.id) continue;
                try {
                    RemindToastDAO.getInstance().deleteByID(remindToast.getId());
                }
                catch (Exception exception) {
                    FRContext.getLogger().error("error on delete remind");
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error("error on clear toast");
        }
        if (this.overTimer != null) {
            this.overTimer.cancel();
        }
        if (this.alertTimer != null) {
            this.alertTimer.cancel();
        }
    }

    public void startOverTimeSchedule() {
        try {
            this.initProcessTask();
            Date date = this.deadLine;
            if (date == null) {
                return;
            }
            if (date.before(new Date())) {
                this.dealTaskOverTime();
                return;
            }
            this.overTimer = new Timer();
            this.overTimer.schedule(new TimerTask(){

                public void run() {
                    ProcessTaskImpl.this.dealTaskOverTime();
                }
            }, date);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("error on overTimeSchedule");
        }
    }

    private void dealTaskOverTime() {
        try {
            this.state = 5;
            ProcessTaskImplDAO.getInstance().updateState(this.id, this.state);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void dealTaskAlert(AlertControl alertControl) {
        try {
            long[] lArray = this.getCurrentUnderTakerIds();
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                Object object;
                long l2 = lArray[i2];
                if (alertControl.isEmail() || alertControl.isAll()) {
                    object = ProcessUtils.getUserEmail(l2);
                    String string = this.getName();
                    String string2 = this.getName() + Inter.getLocText("RP_Have_Come_To_You_For");
                    String string3 = string2 = string2 + alertControl.getTimeString() + "," + Inter.getLocText("RP_Deal_With_It_As_Soon_As_Possible");
                    new Thread((String)object, string, string3){
                        final /* synthetic */ String val$to;
                        final /* synthetic */ String val$title;
                        final /* synthetic */ String val$message;
                        {
                            this.val$to = string;
                            this.val$title = string2;
                            this.val$message = string3;
                        }

                        public void run() {
                            try {
                                ConfigManager.getInstance().getEmailManager().send(this.val$to, this.val$title, this.val$message);
                            }
                            catch (Exception exception) {
                                FRContext.getLogger().error("error on create alert email");
                            }
                        }
                    }.start();
                }
                if (!alertControl.isToast() && !alertControl.isAll()) continue;
                object = new AlertToast(this.id, this.taskId, l2, this.getName(), this.getUserReportPath(l2));
                AlertToastDAO.getInstance().save((SystemToast)object);
                ProcessManager.checkAlert(l2);
            }
            this.updateAlerted(true);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("error on create alert");
        }
    }

    public void startAlertSchedule() {
        try {
            this.initReportProcess();
            long l2 = ProcessUtils.getIdFromStr(this.process.getNodesArr()[this.currentNodeIdx]);
            ProcessNode processNode = ProcessNodeDAO.getInstance().findByID(l2);
            String string = processNode.getAlertControl();
            if (this.alertTimer != null) {
                this.alertTimer.cancel();
            }
            if (string == null) {
                return;
            }
            final AlertControl alertControl = new AlertControl(string);
            if (!alertControl.isValid()) {
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(this.sendTime.getTime() + alertControl.getTimeMil());
            Date date = calendar.getTime();
            if (!date.after(new Date())) {
                if (this.alerted) {
                    return;
                }
                this.dealTaskAlert(alertControl);
                return;
            }
            this.alertTimer = new Timer();
            this.alertTimer.schedule(new TimerTask(){

                public void run() {
                    ProcessTaskImpl.this.dealTaskAlert(alertControl);
                }
            }, date);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("error on alertSchedule");
        }
    }

    private void makeRemind() {
        String string = this.task.getRemindControl();
        if (string == null) {
            return;
        }
        try {
            RemindControl remindControl = new RemindControl(string);
            long[] lArray = this.getCurrentUnderTakerIds();
            if (remindControl.isUseEmail()) {
                this.makeEmailRemind(remindControl, lArray);
            }
            if (remindControl.isUseToast()) {
                this.makeToastRemind(remindControl, lArray);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error("error on make remind");
        }
    }

    private void makeEmailRemind(RemindControl remindControl, long[] lArray) throws Exception {
        EmailManager emailManager = ConfigManager.getInstance().getEmailManager();
        JSONArray jSONArray = new JSONArray(remindControl.getEmail_to());
        String string = remindControl.getEmail_title();
        String string2 = remindControl.getEmail_context();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            String string3;
            String string4 = String.valueOf(ProcessUtils.getIdFromStr(jSONArray.getString(i2)));
            if (string4.matches(string3 = "[\\d_]+")) {
                long[] lArray2 = ProcessOperator.getAllUserId(string4);
                for (int i3 = 0; i3 < lArray2.length; ++i3) {
                    if (!ArrayUtils.contains(lArray, lArray2[i3])) continue;
                    String string5 = ProcessUtils.getUserEmail(lArray2[i3]);
                    emailManager.send(string5, string, string2);
                }
                continue;
            }
            if (!string4.contains("@")) continue;
            emailManager.send(string4, string, string2);
        }
    }

    private void makeToastRemind(RemindControl remindControl, long[] lArray) throws Exception {
        JSONArray jSONArray = new JSONArray(remindControl.getToast_to());
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = ProcessUtils.getIdFromStr(jSONArray.getString(i2));
            if (!ArrayUtils.contains(lArray, l2)) continue;
            RemindToast remindToast = new RemindToast(this.id, this.taskId, l2, remindControl.getToast_context(), this.getUserReportPath(l2));
            RemindToastDAO.getInstance().save(remindToast);
            ProcessManager.checkRemind(l2);
        }
    }

    public void onIssue() {
        this.makeRemind();
        this.checkAndSendOfflineEmail(sB.Y, sB.Z);
        this.startAlertSchedule();
        this.startOverTimeSchedule();
    }

    public void onResume() {
        this.startOverTimeSchedule();
        this.startAlertSchedule();
    }

    public boolean isClosed() {
        return this.state == 4;
    }

    private boolean isLastNode() {
        this.initReportProcess();
        return this.currentNodeIdx >= this.process.getNodeCount() - 1;
    }

    private void initProcessTask() {
        try {
            if (this.task == null) {
                this.task = ProcessTaskDAO.getInstance().findByID(this.taskId);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error("error on init task");
        }
    }

    private void initReportProcess() {
        try {
            if (this.process == null) {
                this.process = ReportProcessDAO.getInstance().findByID(this.processId);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error("error on init process");
        }
    }

    private void updateAlerted(boolean bl) {
        this.alerted = bl;
        try {
            ProcessTaskImplDAO.getInstance().updateAlerted(this.id, bl);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    public List<ProcessTask> getAllSonTask() {
        ArrayList<ProcessTask> arrayList = new ArrayList<ProcessTask>();
        if (this.sonTaskId == null) {
            return arrayList;
        }
        try {
            JSONArray jSONArray = new JSONArray(this.sonTaskId);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject = new JSONObject();
                long l2 = jSONObject.getLong("taskId");
                arrayList.add(ProcessTaskDAO.getInstance().findByID(l2));
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return arrayList;
    }

    public void clear() {
        List<ProcessTask> list;
        ProcessManager.removeTask(this.id);
        try {
            ProcessTaskImplDAO.getInstance().deleteByID(this.id);
            list = AlertToastDAO.getInstance().listByFieldValue("taskId", this.id);
            for (SystemToast iterator2 : list) {
                AlertToastDAO.getInstance().deleteByID(iterator2.getId());
            }
            List list2 = RemindToastDAO.getInstance().listByFieldValue("taskId", this.id);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                SystemToast systemToast = (SystemToast)iterator.next();
                RemindToastDAO.getInstance().deleteByID(systemToast.getId());
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        if (this.sonTaskId == null) {
            return;
        }
        list = this.getAllSonTask();
        for (ProcessTask processTask : list) {
            processTask.clear();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return null;
    }

    private Date getDeadLineDate(int n2, String string) {
        if (n2 == -1) {
            return null;
        }
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (ComparatorUtils.equals(string, "d")) {
            calendar.add(5, n2);
        } else if (ComparatorUtils.equals(string, "w")) {
            calendar.add(5, n2 * 7);
        } else if (ComparatorUtils.equals(string, "m")) {
            calendar.add(2, n2);
        }
        return calendar.getTime();
    }
}

